/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.english;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.DefaultParse;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CorefParse {
    private Map<Parse, Integer> parseMap;
    private List<Parse> parses;

    public CorefParse(List<Parse> parses, DiscourseEntity[] entities) {
        this.parses = parses;
        this.parseMap = new HashMap<Parse, Integer>();
        int en = entities.length;
        for (int ei = 0; ei < en; ++ei) {
            if (entities[ei].getNumMentions() <= 1) continue;
            Iterator<MentionContext> mi = entities[ei].getMentions();
            while (mi.hasNext()) {
                MentionContext mc = mi.next();
                Parse mentionParse = ((DefaultParse)mc.getParse()).getParse();
                this.parseMap.put(mentionParse, ei + 1);
            }
        }
    }

    public void show() {
        int pn = this.parses.size();
        for (int pi = 0; pi < pn; ++pi) {
            Parse p = this.parses.get(pi);
            this.show(p);
            System.out.println();
        }
    }

    private void show(Parse p) {
        int start = p.getSpan().getStart();
        if (!p.getType().equals("TK")) {
            System.out.print("(");
            System.out.print(p.getType());
            if (this.parseMap.containsKey(p)) {
                System.out.print("#" + this.parseMap.get(p));
            }
            System.out.print(" ");
        }
        for (Parse c : p.getChildren()) {
            Span s = c.getSpan();
            if (start < s.getStart()) {
                System.out.print(p.getText().substring(start, s.getStart()));
            }
            this.show(c);
            start = s.getEnd();
        }
        System.out.print(p.getText().substring(start, p.getSpan().getEnd()));
        if (!p.getType().equals("TK")) {
            System.out.print(")");
        }
    }
}

