/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref;

import java.io.IOException;
import opennlp.tools.coref.AbstractLinker;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.LinkerMode;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.mention.PTBHeadFinder;
import opennlp.tools.coref.mention.ShallowParseMentionFinder;
import opennlp.tools.coref.resolver.AbstractResolver;
import opennlp.tools.coref.resolver.CommonNounResolver;
import opennlp.tools.coref.resolver.DefiniteNounResolver;
import opennlp.tools.coref.resolver.FixedNonReferentialResolver;
import opennlp.tools.coref.resolver.IsAResolver;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.resolver.PerfectResolver;
import opennlp.tools.coref.resolver.PluralNounResolver;
import opennlp.tools.coref.resolver.PluralPronounResolver;
import opennlp.tools.coref.resolver.ProperNounResolver;
import opennlp.tools.coref.resolver.ResolverMode;
import opennlp.tools.coref.resolver.SingularPronounResolver;
import opennlp.tools.coref.resolver.SpeechPronounResolver;
import opennlp.tools.coref.sim.Gender;
import opennlp.tools.coref.sim.MaxentCompatibilityModel;
import opennlp.tools.coref.sim.Number;
import opennlp.tools.coref.sim.SimilarityModel;

public class DefaultLinker
extends AbstractLinker {
    protected MaxentCompatibilityModel mcm;

    public DefaultLinker(String modelDirectory, LinkerMode mode) throws IOException {
        this(modelDirectory, mode, true, -1.0);
    }

    public DefaultLinker(String modelDirectory, LinkerMode mode, boolean useDiscourseModel) throws IOException {
        this(modelDirectory, mode, useDiscourseModel, -1.0);
    }

    public DefaultLinker(String modelDirectory, LinkerMode mode, boolean useDiscourseModel, double fixedNonReferentialProbability) throws IOException {
        super(modelDirectory, mode, useDiscourseModel);
        if (mode != LinkerMode.SIM) {
            this.mcm = new MaxentCompatibilityModel(this.corefProject);
        }
        this.initHeadFinder();
        this.initMentionFinder();
        if (mode != LinkerMode.SIM) {
            this.initResolvers(mode, fixedNonReferentialProbability);
            this.entities = new DiscourseEntity[this.resolvers.length];
        }
    }

    protected void initResolvers(LinkerMode mode, double fixedNonReferentialProbability) throws IOException {
        if (mode == LinkerMode.TRAIN) {
            this.mentionFinder.setPrenominalNamedEntityCollection(false);
            this.mentionFinder.setCoordinatedNounPhraseCollection(false);
        }
        this.SINGULAR_PRONOUN = 0;
        if (LinkerMode.TEST == mode || LinkerMode.EVAL == mode) {
            if (fixedNonReferentialProbability < 0.0) {
                this.resolvers = new MaxentResolver[]{new SingularPronounResolver(this.corefProject, ResolverMode.TEST), new ProperNounResolver(this.corefProject, ResolverMode.TEST), new DefiniteNounResolver(this.corefProject, ResolverMode.TEST), new IsAResolver(this.corefProject, ResolverMode.TEST), new PluralPronounResolver(this.corefProject, ResolverMode.TEST), new PluralNounResolver(this.corefProject, ResolverMode.TEST), new CommonNounResolver(this.corefProject, ResolverMode.TEST), new SpeechPronounResolver(this.corefProject, ResolverMode.TEST)};
            } else {
                FixedNonReferentialResolver nrr = new FixedNonReferentialResolver(fixedNonReferentialProbability);
                this.resolvers = new MaxentResolver[]{new SingularPronounResolver(this.corefProject, ResolverMode.TEST, nrr), new ProperNounResolver(this.corefProject, ResolverMode.TEST, nrr), new DefiniteNounResolver(this.corefProject, ResolverMode.TEST, nrr), new IsAResolver(this.corefProject, ResolverMode.TEST, nrr), new PluralPronounResolver(this.corefProject, ResolverMode.TEST, nrr), new PluralNounResolver(this.corefProject, ResolverMode.TEST, nrr), new CommonNounResolver(this.corefProject, ResolverMode.TEST, nrr), new SpeechPronounResolver(this.corefProject, ResolverMode.TEST, nrr)};
            }
            if (LinkerMode.EVAL == mode) {
                // empty if block
            }
            MaxentResolver.setSimilarityModel(SimilarityModel.testModel(this.corefProject + "/sim"));
        } else if (LinkerMode.TRAIN == mode) {
            this.resolvers = new AbstractResolver[9];
            this.resolvers[0] = new SingularPronounResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[1] = new ProperNounResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[2] = new DefiniteNounResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[3] = new IsAResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[4] = new PluralPronounResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[5] = new PluralNounResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[6] = new CommonNounResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[7] = new SpeechPronounResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[8] = new PerfectResolver();
        } else {
            System.err.println("DefaultLinker: Invalid Mode");
        }
    }

    protected void initHeadFinder() {
        this.headFinder = PTBHeadFinder.getInstance();
    }

    protected void initMentionFinder() {
        this.mentionFinder = ShallowParseMentionFinder.getInstance(this.headFinder);
    }

    protected Gender computeGender(MentionContext mention) {
        return this.mcm.computeGender(mention);
    }

    protected Number computeNumber(MentionContext mention) {
        return this.mcm.computeNumber(mention);
    }
}

