/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.opres.heuristics;

import choco.kernel.common.TimeCacheThread;
import choco.kernel.common.opres.heuristics.IHeuristic;
import choco.kernel.solver.SolverException;
import gnu.trove.TIntArrayList;
import java.util.Random;
import java.util.logging.Level;

public abstract class AbstractRandomizedHeuristic
implements IHeuristic {
    private int bestsol = Integer.MAX_VALUE;
    private long starth;
    private double timeCount;
    private double timeLimit = 2.147483647E9;
    private int iterationCount;
    protected int iterationLimit;
    private TIntArrayList solutionLogs = new TIntArrayList();

    private int retrieveIteration() {
        return this.solutionLogs.getQuick(this.solutionLogs.size() - 3);
    }

    private int retrieveSeed() {
        return this.solutionLogs.getQuick(this.solutionLogs.size() - 1);
    }

    @Override
    public void reset() {
        this.bestsol = Integer.MAX_VALUE;
        this.solutionLogs.clear();
        this.timeCount = 0.0;
        this.iterationCount = 0;
        TimeCacheThread.currentTimeMillis = this.starth = System.currentTimeMillis();
    }

    protected final void forceStoreSolution(int obj) {
        this.bestsol = obj;
        this.iterationCount = 1;
        this.storeSolution(Integer.MIN_VALUE);
    }

    protected final void storeSolution(int seed) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "heuristics...[obj:{0}][iter:{1}]", new Object[]{this.bestsol, this.iterationCount});
        }
        this.solutionLogs.add(this.iterationCount);
        this.solutionLogs.add(this.bestsol);
        this.solutionLogs.add(seed);
    }

    public abstract int getLowerBound();

    protected abstract int apply(int var1, int var2, int var3);

    protected final int applySingleIteration(int iteration, int seed) {
        this.setIterationLimit(1);
        this.reset();
        this.bestsol = this.apply(iteration, Integer.MAX_VALUE, seed);
        this.iterationCount = 1;
        this.storeSolution(seed);
        this.timeCount = System.currentTimeMillis() - this.starth;
        return this.bestsol;
    }

    public final int apply(Random random) {
        this.reset();
        while (this.iterationCount < this.iterationLimit && this.timeCount < this.timeLimit) {
            int seed = random.nextInt();
            int obj = this.apply(this.iterationCount, this.bestsol, seed);
            if (obj < this.bestsol) {
                this.bestsol = obj;
                this.storeSolution(seed);
                if (obj == this.getLowerBound()) {
                    return this.bestsol;
                }
            }
            ++this.iterationCount;
            this.timeCount = TimeCacheThread.currentTimeMillis - this.starth;
        }
        if (this.existsSolution() && this.bestsol != this.apply(this.retrieveIteration(), Integer.MAX_VALUE, this.retrieveSeed())) {
            throw new SolverException("heuristics...[restore_solution][FAIL]");
        }
        this.timeCount = System.currentTimeMillis() - this.starth;
        return this.bestsol;
    }

    @Override
    public boolean isObjectiveOptimal() {
        return this.bestsol == this.getLowerBound();
    }

    public final void setTimeLimit(int timeLimit) {
        if (timeLimit > 0) {
            this.timeLimit = timeLimit * 1000;
        }
    }

    public final void setIterationLimit(int iterationLimit) {
        if (iterationLimit > 0) {
            this.iterationLimit = iterationLimit;
        }
    }

    @Override
    public final int getIterationCount() {
        return this.iterationCount;
    }

    public int getBestIteration() {
        return this.existsSolution() ? this.retrieveIteration() : -1;
    }

    @Override
    public final double getTimeCount() {
        return this.timeCount / 1000.0;
    }

    @Override
    public final boolean hasSearched() {
        return this.iterationCount > 0;
    }

    @Override
    public final boolean existsSolution() {
        return this.bestsol != Integer.MAX_VALUE;
    }

    @Override
    public final Number getObjectiveValue() {
        return this.bestsol;
    }

    @Override
    public int getSolutionCount() {
        return this.solutionLogs.size() / 3;
    }

    @Override
    public String solutionToString() {
        return null;
    }
}

