library("shiny")
library("shinyAce")
library("psych")
library("lavaan")
library("semPlot")


shinyUI(navbarPage(title="lavaan.shiny: latent variable analysis",windowTitle="lavaan.shiny v1.0",
                   tabPanel("Confirmatory Factor Analysis", icon = icon("bar-chart", lib = "font-awesome"),
                            sidebarPanel(

                              submitButton(text = "Update View", icon = icon("refresh", lib = "font-awesome"), width = NULL),
                              helpText("Click here to update your results, you need to do this after you change the data, model, or any of the settings"),
                              br(),
                              actionButton("quit", "Quit", icon("sign-out")),
                              helpText("Press Quit to exit the application")

                            ),

                            p('Estimation may take a few seconds to minutes depending on the dataset.'),
                            h3("Specifying the model"),
                            p('See',
                              a("lavaan", href="http://lavaan.ugent.be/", target="_blank"),
                              'for the syntax.'),

                            aceEditor("cfamodel", mode="r", value="# three factor model
visual =~ x1 + x2 + x3
textual =~ x4 + x5 + x6
speed =~ x7 + x8 + x9"),

                            h3("Data Entry"),
                            p('Note: Input values must be separated by tabs. Copy and paste from Excel.'),
                            p("Your data needs to have exactly the same header (variable names) in the first row."),

                            aceEditor("textcfa", value="id\tsex\tageyr\tagemo\tschool\tgrade\tx1\tx2\tx3\tx4\tx5\tx6\tx7\tx8\tx9
1\t1\t13\t1\t1\t7\t3.3333333\t7.75\t0.375\t2.3333333\t5.75\t1.2857143\t3.391304\t5.75\t6.361111
2\t2\t13\t7\t1\t7\t5.3333333\t5.25\t2.125\t1.6666667\t3\t1.2857143\t3.782609\t6.25\t7.916667
3\t2\t13\t1\t1\t7\t4.5\t5.25\t1.875\t1\t1.75\t0.4285714\t3.26087\t3.9\t4.416667
4\t1\t13\t2\t1\t7\t5.3333333\t7.75\t3\t2.6666667\t4.5\t2.4285714\t3\t5.3\t4.861111
5\t2\t12\t2\t1\t7\t4.8333333\t4.75\t0.875\t2.6666667\t4\t2.5714286\t3.695652\t6.3\t5.916667
6\t2\t14\t1\t1\t7\t5.3333333\t5\t2.25\t1\t3\t0.8571429\t4.347826\t6.65\t7.5
7\t1\t12\t1\t1\t7\t2.8333333\t6\t1\t3.3333333\t6\t2.8571429\t4.695652\t6.2\t4.861111
8\t2\t12\t2\t1\t7\t5.6666667\t6.25\t1.875\t3.6666667\t4.25\t1.2857143\t3.391304\t5.15\t3.666667
9\t2\t13\t0\t1\t7\t4.5\t5.75\t1.5\t2.6666667\t5.75\t2.7142857\t4.521739\t4.65\t7.361111
11\t2\t12\t5\t1\t7\t3.5\t5.25\t0.75\t2.6666667\t5\t2.5714286\t4.130435\t4.55\t4.361111
12\t1\t12\t2\t1\t7\t3.6666667\t5.75\t2\t2\t3.5\t1.5714286\t3.73913\t5.7\t4.305556
13\t1\t12\t11\t1\t7\t5.8333333\t6\t2.875\t2.6666667\t4.5\t2.7142857\t3.695652\t5.15\t4.138889
14\t2\t12\t7\t1\t7\t5.6666667\t4.5\t4.125\t2.6666667\t4\t2.2857143\t5.869565\t5.2\t5.861111
15\t2\t12\t8\t1\t7\t6\t5.5\t1.75\t4.6666667\t4\t1.5714286\t5.130435\t4.7\t4.444444
16\t1\t12\t6\t1\t7\t5.8333333\t5.75\t3.625\t5\t5.5\t3\t4\t4.35\t5.861111
17\t2\t12\t1\t1\t7\t4.6666667\t4.75\t2.375\t2.6666667\t4.25\t0.7142857\t4.086957\t3.8\t5.138889
18\t2\t14\t11\t1\t7\t4.3333333\t4.75\t1.5\t2\t4\t1.2857143\t3.695652\t6.65\t5.25
19\t1\t13\t5\t1\t7\t5\t6.75\t2.25\t2\t2.5\t1.7142857\t4\t5.25\t5.444444
20\t2\t12\t8\t1\t7\t5.6666667\t5.25\t4\t4.3333333\t5.25\t3.7142857\t3.913044\t4.85\t5.75
21\t2\t12\t3\t1\t7\t6.3333333\t8.75\t3\t3.6666667\t3.75\t2.5714286\t3.478261\t5.35\t4.916667
22\t1\t14\t10\t1\t7\t5.8333333\t8\t2\t1.6666667\t2.5\t0.5714286\t2.608696\t4.6\t5.388889
23\t1\t12\t9\t1\t7\t6.6666667\t8.5\t4.125\t2\t3.25\t2.1428571\t4.478261\t5.45\t7
24\t1\t12\t11\t1\t7\t5\t6.25\t1.875\t3.3333333\t5.75\t3.1428571\t3.478261\t4.6\t5
25\t2\t12\t8\t1\t7\t3.8333333\t5.5\t1.625\t2.6666667\t3\t1\t5.826087\t5.3\t6.777778
26\t1\t12\t3\t1\t7\t5.6666667\t5.5\t1.25\t2.3333333\t3.75\t1.2857143\t4.695652\t4.6\t4.138889
27\t1\t12\t7\t1\t7\t5.3333333\t4\t3.375\t1.6666667\t3.5\t1.4285714\t5.73913\t6.25\t4.333333
28\t1\t12\t8\t1\t7\t5.5\t5.25\t4.5\t2.6666667\t2.25\t0.7142857\t4.130435\t5.1\t4.527778
29\t2\t13\t2\t1\t7\t6\t5\t2.125\t1.6666667\t3\t1.1428571\t2.826087\t5.55\t4.416667
30\t2\t12\t5\t1\t7\t4.6666667\t6\t4.25\t2\t3\t2\t5.130435\t5.85\t8.611111
31\t2\t12\t2\t1\t7\t5\t4.5\t0.75\t2.6666667\t3.25\t1.8571429\t4.652174\t4.85\t5.444444
33\t2\t12\t7\t1\t7\t3.5\t5.75\t1.375\t2\t3.5\t1.8571429\t4.826087\t6.95\t5.972222
34\t1\t16\t0\t1\t7\t3\t6\t0.25\t1.6666667\t3\t1\t2.043478\t3.65\t3.361111
35\t2\t12\t2\t1\t7\t5\t5.25\t1.75\t2.6666667\t5.25\t2\t2.695652\t4.3\t4.805556
36\t2\t12\t3\t1\t7\t4.1666667\t6\t2.375\t3.3333333\t4.25\t1.8571429\t5.391304\t4.35\t5.638889
38\t2\t13\t3\t1\t7\t3.3333333\t3.75\t1.5\t1.3333333\t3\t0.8571429\t2.782609\t5.2\t4.833333
39\t1\t13\t10\t1\t7\t4.8333333\t5.25\t0.5\t1.6666667\t4.75\t1.4285714\t3.130435\t3.75\t4.916667
40\t1\t12\t9\t1\t7\t5.5\t7\t3.5\t2.6666667\t4\t2\t3.826087\t4\t5.305556
41\t2\t12\t8\t1\t7\t3.8333333\t4.5\t2.25\t3\t3\t1.7142857\t4.086957\t3.5\t5.083333
42\t2\t12\t6\t1\t7\t6.3333333\t4\t3.875\t4\t5.25\t3.2857143\t5.521739\t5.45\t5.111111
43\t1\t12\t5\t1\t7\t5.8333333\t7.75\t2.5\t3\t5.25\t3.1428571\t3.217391\t4.5\t4.888889
44\t2\t12\t1\t1\t7\t3.8333333\t5.75\t1.625\t2.6666667\t4.25\t2.1428571\t4.913043\t5.1\t4.638889
45\t2\t13\t6\t1\t7\t3.1666667\t5\t1.25\t1.6666667\t4.25\t1.5714286\t2.826087\t5.3\t4.777778
46\t2\t13\t8\t1\t7\t1.8333333\t5.25\t1\t1.6666667\t3.75\t0.5714286\t3.956522\t4.75\t2.777778
47\t1\t14\t8\t1\t7\t4.1666667\t5.25\t1.875\t2\t3\t1.4285714\t3.956522\t5.6\t6.666667
48\t1\t14\t2\t1\t7\t6.3333333\t5.5\t2.75\t4.6666667\t5.5\t2\t5.391304\t5\t6.861111
49\t1\t13\t7\t1\t7\t6\t5.5\t4.5\t3\t4.25\t1.2857143\t4.826087\t5\t5
50\t1\t13\t5\t1\t7\t7.1666667\t8.5\t4\t0.6666667\t1\t1\t3.347826\t6.35\t6.277778
51\t2\t13\t6\t1\t7\t3.1666667\t4.75\t1.375\t2.6666667\t3.25\t1.2857143\t6.130435\t8\t5.444444
52\t1\t12\t11\t1\t7\t4.3333333\t5.5\t2.75\t2\t2.25\t1\t5.652174\t5.9\t6.055556
54\t2\t13\t2\t1\t7\t4.5\t6.25\t1.125\t3.6666667\t5.5\t2.1428571\t2.565217\t4.8\t5.527778
55\t1\t13\t7\t1\t7\t5.5\t5.75\t3.75\t1.6666667\t2.25\t0.1428571\t2.347826\t5.05\t5.5
56\t1\t12\t4\t1\t7\t7\t6\t2.125\t2.3333333\t4.5\t1.4285714\t3.652174\t5.15\t4.777778
57\t1\t15\t7\t1\t7\t3.8333333\t7.5\t3.25\t0.6666667\t1.5\t0.1428571\t3.26087\t4.2\t5.388889
58\t1\t13\t4\t1\t7\t5.1666667\t4.75\t1.75\t3.3333333\t3.5\t2.1428571\t3.478261\t5.1\t4.194444
60\t1\t12\t8\t1\t7\t5\t6\t4.125\t2\t4.5\t2.1428571\t4.173913\t4.8\t4.416667
62\t1\t14\t4\t1\t7\t5.6666667\t5.25\t2.125\t2.6666667\t4.5\t1.4285714\t4.043478\t5.7\t5.555556
63\t1\t16\t2\t1\t7\t4\t4.75\t3.25\t1.6666667\t3\t1.7142857\t4.173913\t5.25\t5.638889
64\t1\t13\t3\t1\t7\t5.8333333\t5.25\t3.875\t2.6666667\t5.5\t2.4285714\t3.434783\t5.8\t4.75
65\t2\t14\t0\t1\t7\t3.8333333\t6.5\t2\t1\t2.5\t1.2857143\t3.391304\t4.55\t4.833333
66\t1\t15\t3\t1\t7\t4.1666667\t5.75\t1.75\t1.3333333\t3\t1\t3.521739\t6.15\t3.944444
67\t2\t12\t5\t1\t7\t5.3333333\t5.75\t3.375\t4\t5.5\t2.5714286\t5.26087\t6.2\t6.138889
68\t2\t12\t9\t1\t7\t4\t6\t3.625\t2.6666667\t5\t2.1428571\t4.913043\t5.35\t4.777778
69\t2\t12\t10\t1\t7\t5.3333333\t6.75\t1.375\t1.6666667\t2.5\t0.7142857\t2.652174\t3.85\t5.333333
70\t2\t13\t11\t1\t7\t5.3333333\t5\t1.25\t3.3333333\t4.5\t2.4285714\t5.521739\t5.45\t5.833333
71\t2\t13\t1\t1\t7\t3.6666667\t5.75\t3.625\t2.6666667\t5\t1.4285714\t3.304348\t4.5\t5.027778
72\t2\t12\t11\t1\t7\t6.5\t6\t2.5\t3.6666667\t4.5\t3\t5.695652\t5.4\t6.305556
73\t1\t14\t11\t1\t7\t4\t9.25\t4\t3\t3.75\t1\t3.608696\t5.75\t6.194444
74\t2\t13\t0\t1\t7\t4.6666667\t5.75\t3.625\t2.6666667\t2.75\t1.8571429\t3.869565\t6.1\t4.25
75\t2\t13\t9\t1\t7\t2.8333333\t5\t0.875\t3\t2.5\t1.5714286\t6.826087\t5.7\t3.916667
76\t1\t12\t8\t1\t7\t4.6666667\t5\t0.75\t4.3333333\t4\t2.7142857\t4.73913\t5.95\t5.416667
77\t2\t14\t2\t1\t7\t0.6666667\t4.5\t0.75\t2\t3\t1\t3.608696\t5.5\t4.611111
78\t1\t13\t3\t1\t7\t4.3333333\t9.25\t3.375\t1.3333333\t2.25\t1.1428571\t3.73913\t5.75\t5.166667
79\t1\t13\t1\t1\t7\t5\t4.5\t2.625\t1.6666667\t2.75\t1.5714286\t5.26087\t7.35\t5.972222
80\t1\t13\t7\t1\t7\t5\t6\t3.25\t3.3333333\t5.75\t2.7142857\t3.478261\t4.6\t4.277778
81\t2\t12\t9\t1\t7\t4.1666667\t5.25\t2.125\t3\t3.25\t0.7142857\t3.478261\t5.7\t4.583333
82\t2\t13\t9\t1\t7\t3.8333333\t5.25\t2.375\t1.6666667\t2.25\t1\t3.130435\t5.75\t4.666667
83\t1\t12\t6\t1\t7\t5.6666667\t7\t2.125\t4\t4.75\t2.2857143\t5.652174\t5.7\t6.472222
85\t1\t16\t7\t1\t7\t1.6666667\t5.75\t1.375\t0\t1.5\t1.1428571\t5.695652\t4\t5.638889
86\t2\t14\t7\t1\t8\t6.3333333\t5.5\t4.125\t4\t3.25\t1.8571429\t5.565217\t7.35\t5.75
87\t1\t14\t1\t1\t8\t4\t5.25\t2.5\t1\t1.5\t1.8571429\t4.695652\t5.15\t5.333333
88\t1\t14\t11\t1\t8\t4.5\t6\t1.75\t1.6666667\t2\t1.5714286\t5.869565\t6.45\t6.027778
89\t1\t13\t7\t1\t8\t4.6666667\t8\t4.25\t3\t4.75\t2.4285714\t5.130435\t5.75\t5.305556
90\t1\t14\t5\t1\t8\t4.8333333\t8.25\t2.25\t0.3333333\t2.25\t0.5714286\t5.347826\t5.2\t5.777778
91\t2\t13\t2\t1\t8\t4.8333333\t6.5\t1.75\t2.3333333\t3.5\t0.7142857\t5.782609\t5.75\t4.972222
93\t2\t14\t7\t1\t8\t3\t5.25\t0.625\t1\t1.5\t1\t4.956522\t4.85\t4.583333
94\t2\t12\t11\t1\t8\t6.3333333\t6.25\t2.5\t3.3333333\t5.75\t3.7142857\t4.608696\t6.85\t5.472222
95\t2\t13\t8\t1\t8\t5.5\t7\t2.875\t2.6666667\t4\t0.8571429\t4.086957\t5.4\t5.972222
96\t2\t13\t3\t1\t8\t5.3333333\t6\t2.75\t4\t5\t2.1428571\t5.521739\t4.55\t5.138889
97\t2\t13\t11\t1\t8\t3.3333333\t7.25\t3.25\t1.3333333\t1.25\t0.5714286\t3.565217\t5.55\t4.888889
98\t2\t13\t10\t1\t8\t5.5\t5\t2.25\t3.6666667\t4.5\t1.7142857\t4.173913\t5.95\t6.666667
99\t1\t13\t10\t1\t8\t4\t6.5\t2.625\t2.6666667\t2.75\t1.8571429\t6.652174\t7.5\t5.444444
100\t2\t14\t0\t1\t8\t3.8333333\t6.25\t3.375\t2\t3.75\t0.4285714\t5.391304\t7.8\t6.111111
101\t1\t15\t4\t1\t8\t5.1666667\t4.75\t2.125\t1\t2\t1.5714286\t3.565217\t6.4\t5.722222
102\t1\t13\t8\t1\t8\t4.3333333\t3.5\t0.875\t2.6666667\t3.25\t1.1428571\t3.608696\t4.8\t3.944444
103\t1\t14\t10\t1\t8\t4.1666667\t5.5\t0.875\t4.6666667\t4.75\t2.1428571\t4.130435\t5.35\t3.777778
104\t1\t13\t8\t1\t8\t5\t5.75\t4.25\t4\t4.25\t2.4285714\t3.565217\t3.6\t5.444444
105\t1\t13\t4\t1\t8\t4.3333333\t4.75\t0.5\t3.3333333\t5.75\t2.8571429\t5.521739\t5.85\t4.222222
106\t2\t13\t2\t1\t8\t7.5\t7.5\t2.125\t5.3333333\t6.75\t2.7142857\t5.130435\t5.55\t7.222222
108\t2\t13\t11\t1\t8\t5\t3.75\t1.375\t1.6666667\t2.75\t1.4285714\t5.565217\t6.1\t4.611111
109\t1\t13\t4\t1\t8\t5.5\t6.25\t2.75\t3.6666667\t4.5\t3.2857143\t4.913043\t5.15\t5.75
110\t1\t15\t3\t1\t8\t6.1666667\t3.75\t4.375\t2.6666667\t3.25\t1\t4.26087\t5.3\t6.25
111\t2\t13\t10\t1\t8\t6.5\t6.5\t1.875\t3.6666667\t3.75\t1.7142857\t4.521739\t4.4\t6.583333
112\t1\t13\t3\t1\t8\t4.3333333\t7.75\t1.875\t4.3333333\t4.5\t1.8571429\t5.869565\t6.25\t4.111111
113\t1\t13\t4\t1\t8\t4.6666667\t5.25\t1.625\t3.3333333\t4.5\t2.8571429\t3.826087\t4.85\t4.833333
114\t1\t15\t3\t1\t8\t6.8333333\t9\t4.375\t2.6666667\t5.75\t5\t3\t6.2\t6.027778
115\t2\t12\t10\t1\t8\t4.5\t6.5\t3.125\t2.6666667\t5.5\t2.1428571\t6.347826\t6.5\t6.166667
116\t2\t13\t5\t1\t8\t6.8333333\t6.5\t0.75\t5.3333333\t5.75\t3.1428571\t7.434783\t5.7\t5.194444
117\t2\t13\t10\t1\t8\t5.5\t6.75\t3.75\t2.6666667\t2.75\t2\t4.173913\t6.8\t7
118\t2\t14\t5\t1\t8\t6.3333333\t5.5\t1.625\t5.6666667\t5.5\t4\t5.695652\t6.4\t7.527778
119\t2\t13\t3\t1\t8\t4.1666667\t4.25\t2.25\t3.3333333\t3.5\t1.4285714\t4.478261\t4.15\t3.361111
120\t1\t13\t4\t1\t8\t5.6666667\t9.25\t4.375\t3.6666667\t4.75\t3\t3.26087\t3.9\t4.861111
121\t2\t13\t1\t1\t8\t6.3333333\t5.25\t2.625\t4.3333333\t4.25\t1.5714286\t2.869565\t6\t5.444444
122\t1\t13\t4\t1\t8\t6.1666667\t6.25\t4.25\t5\t3.5\t1.8571429\t4.565217\t5.35\t5.444444
123\t2\t14\t0\t1\t8\t5.1666667\t6.5\t1.75\t4\t5.25\t1.8571429\t4.695652\t4.3\t6
124\t1\t14\t5\t1\t8\t4.1666667\t7.5\t3.875\t1\t2\t0.8571429\t3.565217\t3.95\t6.333333
125\t2\t13\t1\t1\t8\t4.1666667\t5.75\t1\t3.6666667\t4.75\t1.8571429\t4.826087\t5.85\t5.416667
126\t1\t16\t0\t1\t8\t5.1666667\t5.75\t2.5\t2.6666667\t4.75\t2.7142857\t5.304348\t6.85\t5
127\t1\t13\t10\t1\t8\t4.3333333\t5.25\t4\t3\t2.75\t1\t5.565217\t6.6\t6.444444
129\t1\t13\t4\t1\t8\t3.5\t7.25\t3.375\t2.3333333\t2.25\t1.1428571\t3.695652\t5.2\t5.166667
130\t1\t16\t5\t1\t8\t4.6666667\t4.75\t1.625\t2.6666667\t3.25\t2\t4.086957\t5.55\t5.444444
131\t2\t14\t4\t1\t8\t4.8333333\t6\t1.5\t2.6666667\t4.25\t1.2857143\t5.826087\t6.4\t6.861111
132\t1\t15\t1\t1\t8\t5\t5.5\t2.375\t3.3333333\t3\t2\t4.608696\t6.4\t3.305556
133\t2\t14\t4\t1\t8\t7.5\t7\t4.25\t4\t6.5\t3.5714286\t3.73913\t7.6\t6.5
134\t2\t15\t8\t1\t8\t5.3333333\t5.25\t4.125\t2.3333333\t3.75\t1.5714286\t3.652174\t5.35\t4.777778
135\t1\t14\t5\t1\t8\t6.1666667\t6.75\t4.125\t3.3333333\t5\t2.8571429\t5\t6.9\t6.388889
136\t2\t15\t4\t1\t8\t5.3333333\t8.75\t3.125\t4.3333333\t4\t1.1428571\t4\t6.95\t5.666667
137\t2\t13\t11\t1\t8\t4.3333333\t7\t1\t4.3333333\t5.5\t3\t5.130435\t5.65\t4.916667
138\t2\t13\t11\t1\t8\t4.8333333\t7\t1.125\t3.3333333\t5\t2.2857143\t4.913043\t5.25\t4.972222
139\t2\t13\t4\t1\t8\t6\t7.5\t3.25\t3\t6\t2.4285714\t3.304348\t5.1\t5.777778
140\t1\t14\t1\t1\t8\t5\t4.5\t1.625\t2\t2.75\t0.5714286\t4.521739\t6.25\t6.305556
142\t1\t13\t11\t1\t8\t4.1666667\t8\t4.375\t4.3333333\t6.25\t3.1428571\t4.565217\t7.8\t7
143\t2\t14\t1\t1\t8\t5.6666667\t5.5\t3.5\t4\t4.25\t2.2857143\t7.26087\t6.35\t7.194444
144\t2\t15\t3\t1\t8\t5\t6.25\t1.75\t1.3333333\t2\t0.5714286\t4.913043\t6\t4.805556
145\t2\t13\t6\t1\t8\t3.5\t5.25\t2.25\t2\t3.75\t1.8571429\t4.695652\t5.25\t3.722222
146\t1\t14\t7\t1\t8\t7.3333333\t8\t2.625\t2.6666667\t5\t2.4285714\t3.434783\t6\t6.166667
147\t1\t13\t4\t1\t8\t6.1666667\t7.5\t3.625\t4\t6.25\t2.5714286\t4.391304\t5.85\t6.111111
148\t1\t13\t10\t1\t8\t4.8333333\t5.25\t4.5\t4.3333333\t5.75\t2.8571429\t3.347826\t5.1\t5.444444
149\t1\t13\t2\t1\t8\t5.6666667\t6.25\t2.75\t3.3333333\t5.25\t2.1428571\t4.434783\t5.15\t4.555556
150\t2\t14\t2\t1\t8\t5.5\t6.75\t4.5\t2.3333333\t4.5\t2.5714286\t6.26087\t6.55\t6.888889
151\t2\t14\t7\t1\t8\t5.1666667\t5\t2.5\t3.3333333\t5.75\t3\t6.434783\t8.3\t7.083333
152\t2\t14\t0\t1\t8\t3.1666667\t3.75\t1.5\t3.3333333\t5.75\t2.2857143\t6.043478\t5.25\t6.222222
153\t2\t14\t9\t1\t8\t5\t7.5\t4.5\t2\t1.5\t0.4285714\t3.304348\t5.25\t5.722222
154\t1\t15\t0\t1\t8\t7.1666667\t9\t3.875\t3.6666667\t5.25\t4.7142857\t3.826087\t7.1\t5.777778
155\t2\t12\t9\t1\t8\t7.3333333\t6.75\t4\t6\t6.5\t6.1428571\t5.347826\t5.75\t6.611111
156\t2\t15\t8\t1\t8\t2\t5.5\t0.625\t2.6666667\t5\t0.8571429\t2.391304\t5.6\t5.972222
157\t2\t13\t6\t1\t8\t3.8333333\t5.5\t1.875\t3.6666667\t5\t3\t5.608696\t4.9\t3.861111
158\t2\t13\t8\t1\t8\t4.1666667\t6\t1.25\t4\t5\t2.5714286\t6.956522\t6.25\t6.305556
159\t2\t15\t8\t1\t8\t4.6666667\t5.75\t1.625\t0.6666667\t2.5\t1.4285714\t4.521739\t5\t4.75
160\t1\t14\t4\t1\t8\t5.8333333\t4.75\t2.625\t5.6666667\t5.5\t4.1428571\t3.565217\t6.3\t5.472222
162\t1\t15\t1\t1\t8\t6.6666667\t5.5\t4.375\t2.6666667\t3.75\t1\t5.130435\t4.75\t5.222222
163\t1\t13\t11\t1\t8\t6.8333333\t7.25\t4.25\t5\t5.75\t4.8571429\t5.652174\t7.55\t6.166667
164\t1\t15\t5\t1\t8\t5.3333333\t4.75\t2.625\t3\t5.5\t2.1428571\t5.782609\t7.9\t6.944444
165\t1\t14\t1\t1\t8\t4.8333333\t5\t2.375\t3\t4.25\t2.4285714\t5.391304\t7.5\t5.416667
166\t2\t15\t1\t1\t8\t5.1666667\t6\t2.375\t1.3333333\t2.25\t1.1428571\t5.391304\t6.15\t5.194444
167\t2\t15\t7\t1\t8\t6.3333333\t6.75\t1.125\t3\t2.5\t1.4285714\t4.695652\t5.6\t4.138889
168\t2\t15\t6\t1\t8\t4.8333333\t5.75\t1.25\t3\t4.75\t2.1428571\t3.608696\t6.15\t4.694444
201\t1\t13\t0\t2\t7\t3.8333333\t4.75\t0.5\t3.3333333\t4.25\t1.4285714\t3\t4.1\t4.333333
202\t2\t11\t10\t2\t7\t5.5\t5.5\t2.125\t2.6666667\t4.25\t1.4285714\t2.826087\t4.9\t5.416667
203\t1\t12\t6\t2\t7\t5.6666667\t6\t2.75\t3.6666667\t4.75\t2.7142857\t2.173913\t4.3\t6.333333
204\t1\t11\t11\t2\t7\t4.8333333\t5.75\t1.125\t3\t4.75\t1.5714286\t4.956522\t5.15\t4
205\t1\t12\t5\t2\t7\t2.6666667\t6.25\t1.25\t2.6666667\t6.25\t3.4285714\t4.869565\t6.1\t4.444444
206\t2\t12\t6\t2\t7\t5\t6.25\t2.5\t3.3333333\t5.75\t2.5714286\t4.086957\t5.65\t5.583333
208\t2\t12\t8\t2\t7\t6\t8.25\t4.5\t5.6666667\t6.25\t5.8571429\t5.608696\t6.95\t9.25
209\t2\t11\t11\t2\t7\t4.6666667\t6.25\t1.125\t3.3333333\t4.5\t1.5714286\t4.173913\t4.75\t4.833333
210\t2\t12\t5\t2\t7\t5\t6.25\t1.375\t3.6666667\t5.25\t1.1428571\t4.478261\t5.7\t5.472222
211\t2\t12\t5\t2\t7\t3.3333333\t6.25\t0.75\t3\t5.25\t2.2857143\t3.869565\t5.05\t4.944444
212\t1\t12\t0\t2\t7\t4.5\t6.5\t0.75\t3.3333333\t4\t1.8571429\t3.826087\t5.35\t3.805556
213\t1\t12\t10\t2\t7\t5.3333333\t5.25\t1\t0.3333333\t1.75\t1.5714286\t4.478261\t6.8\t4.277778
214\t1\t12\t9\t2\t7\t6.3333333\t7.75\t1.5\t3.3333333\t2.75\t2\t3.608696\t5.4\t5.583333
215\t2\t12\t8\t2\t7\t2.8333333\t5.25\t0.75\t1.6666667\t2.5\t1.4285714\t4.304348\t4.35\t4.083333
216\t1\t12\t9\t2\t7\t5.6666667\t7\t3\t4.6666667\t5.5\t3.7142857\t2.130435\t4.2\t4.75
217\t1\t13\t1\t2\t7\t4.1666667\t7.75\t2.25\t2.3333333\t3\t1.5714286\t2.826087\t4\t3.472222
218\t2\t12\t1\t2\t7\t5.5\t7.75\t3.75\t3.6666667\t5.75\t2.5714286\t2.869565\t5.65\t5.166667
219\t1\t13\t1\t2\t7\t6.6666667\t5.75\t2.5\t3.3333333\t5.75\t5\t3.130435\t5.2\t6.166667
220\t2\t12\t7\t2\t7\t5\t5.5\t2.5\t2.6666667\t4.25\t2.8571429\t4.130435\t5.5\t4.472222
221\t2\t12\t1\t2\t7\t6\t7\t2.75\t4.3333333\t6\t5.1428571\t3.565217\t5.15\t5.694444
222\t1\t12\t9\t2\t7\t4\t4\t1.75\t1.6666667\t4.25\t1.5714286\t4.608696\t4\t3.277778
223\t1\t12\t8\t2\t7\t6.6666667\t6.5\t3.25\t4.3333333\t6\t3.5714286\t3.826087\t6.05\t6.25
224\t2\t12\t6\t2\t7\t5\t6\t2.375\t4.6666667\t6.5\t3.4285714\t4.869565\t5.75\t5.138889
225\t1\t14\t0\t2\t7\t7\t6.75\t3.375\t2.3333333\t3.25\t0.5714286\t5.478261\t10\t6.555556
226\t2\t12\t3\t2\t7\t5.5\t6.75\t2\t2.6666667\t4.25\t1.8571429\t2.956522\t5.8\t6.083333
227\t2\t12\t4\t2\t7\t5.3333333\t5.5\t1.875\t3\t5\t2.4285714\t3.217391\t5.9\t5.305556
228\t1\t12\t9\t2\t7\t5.1666667\t5.25\t0.625\t4.3333333\t4.75\t2.7142857\t4.173913\t6.05\t5
229\t2\t14\t7\t2\t7\t4.5\t5.75\t0.5\t3\t2.75\t1\t2.391304\t5.9\t4.944444
230\t1\t13\t2\t2\t7\t5.1666667\t5.75\t1.375\t1.3333333\t4\t2.2857143\t3.521739\t6.4\t5.25
231\t1\t12\t5\t2\t7\t5.1666667\t8.5\t0.375\t3\t4.75\t2.4285714\t2.217391\t4.6\t5.055556
232\t2\t12\t0\t2\t7\t2.8333333\t7.5\t1.625\t3\t4.25\t1.8571429\t2.26087\t4.7\t3.972222
233\t1\t12\t0\t2\t7\t5\t5\t1.625\t3\t5\t3\t4.695652\t5.65\t5
234\t1\t12\t6\t2\t7\t4.6666667\t4.75\t1\t3\t3.5\t2.8571429\t3.521739\t5.8\t4.416667
235\t1\t13\t2\t2\t7\t3.1666667\t5.5\t1\t1.6666667\t3\t0.5714286\t2.173913\t3.6\t4.5
236\t1\t12\t0\t2\t7\t4.6666667\t5\t1.75\t2.6666667\t3.75\t1.1428571\t4.347826\t7.2\t5.694444
237\t2\t12\t10\t2\t7\t6.3333333\t6.25\t1.625\t3\t5.75\t2.1428571\t2.434783\t6.5\t5.5
238\t2\t11\t11\t2\t7\t5.6666667\t7\t1.25\t3\t5.5\t2.8571429\t3.521739\t4.8\t5.527778
239\t2\t13\t8\t2\t7\t3\t5.5\t0.625\t0.6666667\t1\t0.2857143\t1.304348\t3.05\t3.111111
240\t2\t12\t7\t2\t7\t2.6666667\t5\t1\t2\t4.5\t1.8571429\t4.043478\t5.55\t5.138889
241\t2\t12\t4\t2\t7\t3\t7.5\t2.125\t6.3333333\t6\t4.7142857\t4\t5.4\t4.111111
242\t2\t12\t6\t2\t7\t5.3333333\t5.25\t1.125\t5\t5\t3.5714286\t4.130435\t4.6\t4.944444
243\t1\t12\t6\t2\t7\t5.6666667\t5.25\t1.125\t3\t5.75\t3.4285714\t2.521739\t4.55\t4.805556
244\t1\t12\t1\t2\t7\t3.5\t5.5\t1\t3\t3\t1.1428571\t2.826087\t4.2\t3.805556
245\t2\t12\t9\t2\t7\t4.6666667\t5\t1.75\t2.6666667\t4.5\t1.4285714\t2.652174\t5\t5.944444
246\t2\t12\t3\t2\t7\t6.5\t6\t3.125\t4.6666667\t4.25\t1.5714286\t3.565217\t5.2\t6.777778
247\t2\t12\t4\t2\t7\t5.3333333\t6.5\t1.25\t3.6666667\t5.75\t3.2857143\t2.695652\t4.15\t3.972222
248\t2\t12\t10\t2\t7\t4.6666667\t6\t1\t2\t2.5\t1.4285714\t2.652174\t3.85\t4.416667
249\t1\t12\t5\t2\t7\t4\t5\t2.75\t3.6666667\t4.75\t2.5714286\t3.086956\t4.7\t4.277778
250\t2\t11\t11\t2\t7\t5.1666667\t4.75\t1.625\t2.6666667\t5.5\t2.4285714\t2.652174\t3.5\t3.333333
251\t2\t12\t8\t2\t7\t4.8333333\t6.5\t3.125\t3.3333333\t5.5\t2.5714286\t3.695652\t6.4\t5.611111
252\t1\t11\t11\t2\t7\t4.8333333\t7.5\t1.875\t2.3333333\t4\t1.7142857\t2.782609\t3.7\t4.583333
253\t1\t14\t1\t2\t7\t2.6666667\t5.75\t0.625\t2.3333333\t5\t1.8571429\t4.130435\t6.4\t3.805556
254\t2\t12\t4\t2\t7\t4.1666667\t6.25\t3.25\t1.6666667\t1.75\t0.7142857\t2\t3.6\t3.361111
256\t1\t13\t2\t2\t7\t4.1666667\t6.75\t1.875\t2\t4\t1.8571429\t3.73913\t4.95\t5.944444
257\t2\t12\t3\t2\t7\t6.1666667\t7.75\t2\t4.6666667\t7\t2.8571429\t3.826087\t5.7\t6.194444
258\t2\t12\t11\t2\t7\t5\t6.5\t2.375\t2.3333333\t5.25\t2\t3.869565\t6.05\t6.166667
259\t1\t11\t5\t2\t7\t4.8333333\t6\t1.25\t3\t5.25\t2.4285714\t4.347826\t6.05\t5.722222
260\t2\t12\t4\t2\t7\t6.1666667\t8.5\t2.125\t6\t6\t3.8571429\t3.478261\t5.6\t6.361111
261\t2\t12\t0\t2\t7\t4.6666667\t5\t0.5\t2.6666667\t4.5\t0.8571429\t3.173913\t4.2\t4.472222
262\t1\t13\t11\t2\t7\t3.6666667\t8.5\t2.375\t3.3333333\t4.25\t2.1428571\t3.478261\t5.05\t5.138889
263\t2\t12\t4\t2\t7\t6.3333333\t5.25\t2.25\t6\t6.5\t4.4285714\t5.217391\t5.45\t5.694444
264\t1\t12\t9\t2\t7\t4.8333333\t5.25\t2.25\t2.3333333\t4\t1\t2.913044\t4.4\t5
265\t1\t12\t10\t2\t7\t4.1666667\t6.25\t3.75\t3\t4\t2.2857143\t4.608696\t6.35\t4.861111
266\t2\t13\t7\t2\t7\t4.6666667\t6.75\t1.625\t1.6666667\t1.5\t0.5714286\t4.391304\t5.3\t4.777778
267\t1\t13\t2\t2\t7\t3.8333333\t5\t2.25\t2\t3\t0.8571429\t1.869565\t5\t4.027778
268\t2\t14\t0\t2\t7\t1.8333333\t5\t1.125\t4.3333333\t4\t2.1428571\t3.173913\t3.65\t3.611111
269\t2\t12\t11\t2\t7\t7.5\t9.25\t3.625\t3.3333333\t4\t2.2857143\t3.173913\t5.05\t6.111111
270\t2\t13\t0\t2\t7\t3.1666667\t3.75\t0.875\t5\t4.75\t2.7142857\t4.391304\t5.6\t3.222222
271\t2\t12\t8\t2\t7\t6.8333333\t5.25\t1.375\t3\t4\t2\t5.391304\t5.95\t6.111111
272\t1\t12\t3\t2\t7\t5.8333333\t7.5\t4.125\t2.6666667\t3.75\t1.7142857\t3.913044\t6.3\t6.722222
273\t2\t12\t0\t2\t7\t5.6666667\t6\t2\t3\t3.5\t1.4285714\t3.869565\t5.8\t6.555556
274\t1\t13\t2\t2\t7\t3.1666667\t5.5\t1.5\t3.3333333\t4\t2.4285714\t5.130435\t5.8\t7
275\t1\t12\t7\t2\t7\t4.1666667\t5.25\t1.875\t2.6666667\t4.25\t2.4285714\t2.956522\t4.1\t4.722222
276\t1\t11\t4\t2\t7\t6\t7\t4.125\t5\t6\t5.5714286\t3.521739\t5.2\t5.833333
277\t2\t14\t0\t2\t7\t3.1666667\t5.75\t0.75\t2.3333333\t3.25\t2.7142857\t2.956522\t4.85\t4.138889
278\t2\t12\t9\t2\t7\t4.5\t5.25\t0.875\t3\t4.75\t3.1428571\t3.826087\t5.45\t5.305556
279\t2\t12\t5\t2\t7\t3.5\t2.25\t1.75\t5\t6.25\t4.2857143\t2.956522\t4.55\t5.027778
280\t1\t12\t9\t2\t7\t4.5\t5.5\t4\t2.6666667\t3.25\t1.8571429\t2.434783\t3.75\t4.916667
281\t2\t12\t7\t2\t7\t4.3333333\t5.5\t1\t1.6666667\t2.75\t1.5714286\t3.304348\t5.7\t4.333333
282\t1\t14\t2\t2\t8\t3.3333333\t6.75\t1.875\t3\t4.75\t1.5714286\t5.652174\t5.25\t6.694444
283\t2\t13\t1\t2\t8\t5.5\t5.5\t1.75\t4.3333333\t6.25\t3.7142857\t3.652174\t6.35\t6.388889
284\t2\t12\t11\t2\t8\t6.3333333\t6.5\t0.875\t5.3333333\t6.25\t2.1428571\t4.73913\t5.55\t5.555556
285\t2\t13\t2\t2\t8\t5.5\t6.25\t4.25\t5\t5.75\t3\t4.73913\t7.15\t6.833333
286\t1\t13\t6\t2\t8\t6\t7.25\t2\t3\t5.75\t3.2857143\t6.478261\t7.8\t6.861111
287\t1\t13\t9\t2\t8\t6.3333333\t7.25\t4.375\t4.3333333\t5.5\t2.4285714\t4.869565\t6.3\t6.305556
288\t2\t13\t2\t2\t8\t5.1666667\t6.25\t3.5\t3.3333333\t6.25\t3.8571429\t4.478261\t4.9\t4.666667
289\t2\t13\t1\t2\t8\t6\t7\t1.625\t3.6666667\t5.75\t2.5714286\t5.826087\t5.1\t6.222222
290\t1\t13\t8\t2\t8\t5.1666667\t6.5\t3.625\t3.6666667\t6.5\t1.7142857\t3.695652\t4.95\t5.25
291\t2\t14\t2\t2\t8\t4.6666667\t6\t0.75\t2.6666667\t4.25\t2.1428571\t4\t4.75\t5.972222
292\t1\t13\t8\t2\t8\t6.3333333\t9.25\t3.5\t3.3333333\t4.75\t2.7142857\t4.782609\t6.75\t5.527778
293\t1\t13\t6\t2\t8\t4.8333333\t8.5\t2.75\t3.3333333\t5\t2.7142857\t3.652174\t6.6\t4.083333
294\t1\t13\t7\t2\t8\t5.8333333\t6\t1.875\t4\t5\t3.2857143\t4\t6.25\t6.444444
295\t2\t13\t3\t2\t8\t5.8333333\t6.25\t3.125\t3.6666667\t6\t2.7142857\t5.73913\t5.9\t5.194444
296\t2\t12\t10\t2\t8\t3.8333333\t5.25\t0.375\t3\t5.25\t1.7142857\t5.782609\t5.55\t6.527778
297\t2\t13\t5\t2\t8\t5.1666667\t7\t3.125\t4\t5.75\t2.1428571\t6.043478\t5.5\t5.527778
298\t1\t14\t6\t2\t8\t8.5\t6.5\t4.25\t6\t6.5\t5.4285714\t5.782609\t8.05\t6.916667
299\t2\t14\t9\t2\t8\t5.5\t7\t2.25\t5\t5.75\t4.2857143\t4.173913\t6.1\t5.888889
300\t2\t15\t11\t2\t8\t3.5\t6.5\t2.125\t4\t4\t4.7142857\t5.130435\t5.6\t3.666667
302\t2\t13\t9\t2\t8\t6.1666667\t8\t1.375\t5.3333333\t6.25\t4.5714286\t3.478261\t4.75\t4.75
303\t1\t13\t1\t2\t8\t6.1666667\t5\t2.625\t2.6666667\t4.75\t2.7142857\t3.391304\t5.05\t4.972222
304\t1\t13\t9\t2\t8\t6.1666667\t6.5\t3.625\t2.3333333\t4.75\t2.7142857\t4.434783\t5.65\t5.833333
305\t1\t13\t7\t2\t8\t6.5\t6.5\t3\t5.6666667\t6.5\t4.2857143\t5\t6.8\t7.388889
306\t2\t13\t0\t2\t8\t6.5\t8.5\t4.125\t3.3333333\t4.75\t2.2857143\t4.130435\t5.95\t6.666667
307\t2\t13\t8\t2\t8\t3\t4\t0.5\t3.3333333\t5.25\t2.7142857\t2.956522\t4\t3.472222
308\t2\t12\t9\t2\t8\t4.6666667\t7\t2.25\t3.3333333\t6.25\t3.2857143\t3.782609\t4.65\t4.722222
309\t1\t14\t10\t2\t8\t4.8333333\t5.75\t1.125\t2\t6\t1.2857143\t4.347826\t9.1\t6.305556
310\t2\t13\t5\t2\t8\t4.1666667\t5\t1.375\t4\t4.75\t2.4285714\t4.826087\t6.25\t5.722222
311\t1\t13\t4\t2\t8\t4.8333333\t8.25\t1.375\t4.3333333\t5.75\t3.7142857\t3.391304\t5.15\t5.5
312\t2\t13\t6\t2\t8\t5.3333333\t5.25\t1.875\t4.6666667\t5\t4.1428571\t5.086957\t5.4\t6.583333
313\t1\t13\t6\t2\t8\t5\t5.25\t2.625\t4\t6\t3.8571429\t4.173913\t5.65\t5.722222
314\t2\t13\t5\t2\t8\t5.8333333\t7\t2.375\t6\t6.75\t4.7142857\t6.304348\t5.85\t6.277778
315\t1\t12\t1\t2\t8\t2.6666667\t8.5\t4\t4.6666667\t5.5\t3.4285714\t4.304348\t5.4\t5.972222
316\t2\t13\t5\t2\t8\t6.3333333\t7.5\t4.125\t4.6666667\t5.5\t4.1428571\t4.217391\t6\t7
317\t2\t13\t2\t2\t8\t4.3333333\t6.25\t0.875\t3.3333333\t3.75\t1.8571429\t5\t6.45\t5.083333
318\t2\t13\t7\t2\t8\t5.5\t7\t1.5\t4.6666667\t5.25\t2\t4.608696\t5.3\t5.194444
320\t1\t15\t3\t2\t8\t4.6666667\t6.75\t4\t3.3333333\t4.75\t2.4285714\t3\t6.5\t5.5
321\t2\t13\t3\t2\t8\t4.5\t5.5\t2\t2.6666667\t4.75\t2.1428571\t5.869565\t7.1\t6.25
322\t2\t14\t4\t2\t8\t4.3333333\t7.25\t1.25\t2.6666667\t4.75\t1.8571429\t3.695652\t5.45\t6.111111
323\t1\t14\t7\t2\t8\t5\t8\t3.25\t2.3333333\t3.75\t1.4285714\t4.73913\t7\t4.944444
324\t1\t13\t3\t2\t8\t3.6666667\t5.75\t1\t1.3333333\t3.25\t2.4285714\t4\t4.05\t4.166667
325\t1\t13\t8\t2\t8\t5.3333333\t6\t1\t3\t4.75\t2\t3.391304\t4.45\t5.305556
326\t1\t14\t6\t2\t8\t5.1666667\t5.75\t1.625\t4\t4.75\t2.1428571\t3.565217\t5.4\t5.055556
327\t1\t14\t9\t2\t8\t5.3333333\t6.25\t2.125\t1.6666667\t2.75\t2.2857143\t4.608696\t7.15\t5.555556
328\t1\t16\t4\t2\t8\t6.6666667\t5.25\t1.875\t2.6666667\t4.5\t1.8571429\t3.652174\t6.3\t5.972222
329\t1\t12\t11\t2\t8\t3.5\t5\t1.375\t2.3333333\t4.75\t1.1428571\t3.478261\t5.85\t6.527778
330\t1\t13\t1\t2\t8\t5.1666667\t6.25\t3.25\t5\t6\t3.2857143\t2.391304\t4\t4.277778
331\t2\t14\t1\t2\t8\t4\t6\t2\t2.6666667\t4.5\t1.7142857\t3.347826\t4.7\t3.75
333\t1\t14\t3\t2\t8\t6.8333333\t6.25\t1.875\t4\t5.25\t2.7142857\t2.782609\t4.7\t5.25
334\t2\t14\t9\t2\t8\t5\t5.75\t1.25\t2.6666667\t3.5\t1.7142857\t4.26087\t6.6\t6.666667
335\t1\t16\t1\t2\t8\t5.8333333\t5\t2\t3.3333333\t4\t1.4285714\t3.478261\t5.25\t5.694444
336\t1\t13\t5\t2\t8\t5.6666667\t6.75\t2.125\t4.3333333\t6.25\t4.5714286\t3.347826\t5.95\t5.416667
337\t1\t14\t3\t2\t8\t4.1666667\t5.5\t1.625\t2.3333333\t4\t1.5714286\t5.869565\t6.3\t5.666667
338\t2\t13\t1\t2\t8\t4\t6.25\t0.75\t3\t4.75\t3.2857143\t5.217391\t6.55\t5.722222
339\t1\t14\t4\t2\t8\t6\t6.5\t2.125\t3.3333333\t4.75\t1.4285714\t2.434783\t5.75\t5
340\t1\t15\t6\t2\t8\t3.3333333\t4.75\t0.875\t2.6666667\t5\t0.8571429\t5.826087\t5.5\t6.777778
341\t1\t14\t11\t2\t8\t4.6666667\t6\t1.125\t1.3333333\t3\t1.5714286\t4.173913\t5.75\t4.833333
342\t2\t12\t11\t2\t8\t5.6666667\t5.5\t1.625\t3.3333333\t4.25\t2\t5.478261\t6\t4.5
343\t1\t14\t3\t2\t8\t5.6666667\t5.25\t2.375\t3.3333333\t4.5\t2\t3.391304\t5.15\t6.333333
344\t2\t13\t0\t2\t8\t5.8333333\t7\t1.25\t3\t3.25\t1.5714286\t4.173913\t4.85\t5.777778
345\t1\t13\t3\t2\t8\t6.1666667\t6.5\t3\t3\t4.25\t2.8571429\t3.043478\t4.25\t5.666667
346\t1\t13\t5\t2\t8\t4\t7\t1.375\t2.6666667\t4.25\t1\t5.086957\t5.6\t5.25
347\t2\t14\t10\t2\t8\t3\t6\t1.625\t2.3333333\t4\t1\t4.608696\t6.05\t6.083333
348\t2\t14\t3\t2\t8\t4.6666667\t5.5\t1.875\t3.6666667\t5.75\t4.2857143\t4\t6\t7.611111
349\t1\t14\t2\t2\t8\t4.3333333\t6.75\t0.5\t3.6666667\t4.5\t2\t5.086957\t6.2\t4.388889
351\t1\t13\t5\t2\tNA\t4.3333333\t6\t3.375\t3.6666667\t5.75\t3.1428571\t4.086957\t6.95\t5.166667",  mode="r"),

                            br(),

                            h3("Basic statistics"),
                            verbatimTextOutput("textareacfa"),

                            br(),

                            h3("Correlation"),
                            verbatimTextOutput("correl.cfa"),

                            br(),

                            strong("Scatter plot matrices"),
                            br(),

                            plotOutput("corPlot.cfa"),

                            br(),

                            h3("CFA result"),

                            verbatimTextOutput("result.cfa"),

                            br(),

                            h3("Path diagram (Unstandardized estimates)"),

                            plotOutput("cfaplot1"),

                            br(),

                            h3("Path diagram (Standardized estimates)"),

                            plotOutput("cfaplot2"),

                            br(),
                            br(),


                            strong('R session info'),
                            verbatimTextOutput("info.cfa")

                            ),
tabPanel("Growth Curve Modeling", icon = icon("stats", lib = "glyphicon"),
         sidebarPanel(

           submitButton(text = "Update View", icon = icon("refresh", lib = "font-awesome"), width = NULL),
           helpText("Click here to update your results, you need to do this after you change the data, model, or any of the settings"),
           br(),
           actionButton("quit", "Quit", icon("sign-out")),
           helpText("Press Quit to exit the application")


         ),

            p('Estimation may take a few seconds to minutes depending on the dataset.'),
         h3("Specifying the model"),
         p('See',
           a("lavaan", href="http://lavaan.ugent.be/", target="_blank"),
           'for the syntax.'),

aceEditor("gcmmodel", mode="r", value="# linear growth model with 4 timepoints
# intercept and slope with fixed coefficients
i =~ 1*t1 + 1*t2 + 1*t3 + 1*t4
s =~ 0*t1 + 1*t2 + 2*t3 + 3*t4
# regressions
i ~ x1 + x2
s ~ x1 + x2
# time-varying covariates
t1 ~ c1
t2 ~ c2
t3 ~ c3
t4 ~ c4"),

            h3("Data Entry"),
            p('Note: Input values must be separated by tabs. Copy and paste from Excel.'),
            p("Your data needs to have exactly the same header (variable names) in the first row."),

            aceEditor("textgcm", value="t1\tt2\tt3\tt4\tx1\tx2\tc1\tc2\tc3\tc4
1.7256450000\t2.1424005190\t2.7731716700\t2.5159558600\t-1.1641025657\t0.1742293170\t-0.0276776520\t0.5549233660\t0.2544784333\t-1.0063954130
-1.9841600000\t-4.4006027420\t-6.0165562600\t-7.0296180100\t-1.7454024863\t-1.5768602200\t-2.0319672390\t0.1253347740\t-1.5642322745\t1.2292687530
0.3195183000\t-1.2691171270\t1.5600160300\t2.8685295800\t0.9202111995\t-0.1418180200\t0.0523749590\t-1.2577407550\t-1.8033908950\t-0.3272576100
0.7769485000\t3.5313706560\t3.1382114000\t5.3637413900\t2.3595235875\t0.7079681280\t0.0191142870\t0.6473829990\t-0.4323795095\t-1.0323977870
0.4489440000\t-0.7727747040\t-1.5035150400\t0.0784674200\t-1.0887076999\t-1.0099977240\t0.6524327370\t0.7309147580\t-0.7537815734\t-0.0274559850
-1.7469950000\t-0.9963400060\t-0.8242173600\t0.5669248000\t-0.5135168826\t-0.1440428230\t-0.0445290630\t-0.4168022490\t-1.2411669585\t0.5171976310
1.8555610000\t1.9422201700\t2.1295573200\t4.5050497700\t0.4692602485\t-0.2277886590\t1.5168247260\t1.6587148810\t-0.9482261306\t1.1773882590
-2.1490630000\t-1.2595263220\t-1.2121854700\t-3.0238535200\t0.5030222822\t-1.8997418160\t-1.0362259620\t-0.2912703840\t0.2247443939\t-0.5185418670
0.5719917000\t1.9052133750\t3.3846054700\t4.0143623600\t1.7004706646\t-1.5992515380\t1.7406208240\t-0.0323597830\t0.4072783237\t-0.7252111210
0.3171380000\t1.3583334720\t1.9417031000\t3.3221208000\t-1.1497779030\t0.9428161990\t1.0693734860\t-1.6243441040\t0.9530711021\t0.4590808470
-1.9452010000\t-1.1699568580\t-2.5134394400\t-0.6918194000\t-0.6521759622\t-0.6644460510\t0.1910901500\t-0.3883023280\t0.2219581842\t1.0402884460
-2.6102480000\t-2.8086361400\t-3.8109128000\t-4.4644200100\t-1.3990986660\t-1.7759960640\t0.6899703030\t0.2894933400\t0.4095923918\t0.2133583700
1.8291390000\t4.7241052050\t6.5189762700\t9.2335660200\t1.2883287125\t1.0441050270\t0.5128588790\t-0.6372001660\t-1.3956844631\t-1.9169477160
1.8192150000\t2.6286261060\t4.4292789600\t6.5908226900\t0.8009710404\t0.7666835400\t-0.2725830980\t-0.1248404430\t0.7014438345\t0.9545366790
-0.9956247000\t0.1457578120\t1.6250697500\t4.1101270700\t0.6371925378\t-0.3408627400\t1.8292695620\t-0.9332919310\t0.1181860917\t0.4954834770
2.5485260000\t2.4730297010\t5.4493067400\t5.3381733400\t-0.6758957023\t0.4215269390\t0.3594588470\t2.0354239330\t0.0503599008\t1.1187420450
1.2515820000\t3.6236716680\t4.1844863000\t5.7129774700\t0.4918548084\t-0.3381404210\t0.2791369130\t2.3820521190\t0.5880885553\t-1.2032745150
2.4547750000\t3.9635593390\t4.9236216800\t8.2150899000\t1.1075558535\t0.5993647570\t1.9483808180\t0.8524087220\t-2.3901730332\t1.0791690540
-2.0508190000\t-0.1528486110\t2.2798305500\t1.7462949400\t-0.9721825918\t0.0809639570\t0.3449983610\t0.1244678660\t-0.0070060314\t0.3924850430
-0.3075051000\t-0.7735390570\t0.3732803100\t2.1575486500\t0.5752084479\t-0.9751000520\t-0.1102798710\t-0.4413302120\t-0.1481460745\t1.3885448080
-0.8906196000\t-0.2331007190\t0.0949848800\t-0.4435859200\t-0.9610503094\t-0.0648280490\t-1.2014841570\t-0.4700456550\t1.2711296474\t-0.3463737450
-0.6849389000\t0.3852932150\t2.2250449200\t3.8867705700\t-1.3448301645\t0.6997723520\t-1.9701887190\t-0.6170945250\t1.2244453650\t0.0590503330
-1.1451570000\t-0.9261448930\t1.3814475900\t2.5661229900\t-1.5243259555\t0.2188982670\t0.5890204680\t-0.4698217400\t0.3709094966\t0.6316282720
0.4560856000\t-1.1920665440\t-0.2877047800\t-0.1532464900\t0.1863548973\t-0.8508369880\t-0.6637147890\t0.3774088400\t1.0135418055\t-1.3466954020
0.4154869000\t1.6044432640\t1.6296812200\t3.1326736100\t-1.2417642031\t-0.0387844640\t-1.3488608040\t1.0372058680\t-0.8144884044\t1.1663765370
0.9786608000\t-0.2541620910\t0.7949717600\t-1.3647733600\t-1.1501952210\t-0.6085673980\t0.6532135040\t-0.2436302030\t0.6664694614\t0.7718593270
0.7903997000\t0.7564019720\t0.3864976000\t0.5674204100\t1.5817913025\t-0.1444010450\t-0.4206434400\t-0.3042240180\t-0.8147195323\t1.5094316150
-0.2900660000\t3.3820775620\t4.9777121200\t4.5685457100\t0.3745175821\t0.0267224030\t-0.7156777170\t1.1895843320\t-0.5160208023\t-0.7215997810
-0.2491274000\t0.4584373430\t1.1660311800\t1.1156266100\t-0.8098301013\t1.0129125460\t-0.3818280090\t0.5239023870\t0.4203983558\t-0.8495300580
2.9324300000\t3.8169339630\t4.4831463800\t7.6574838400\t0.9023027883\t0.1207072460\t0.3718898060\t1.2843518540\t0.0109795360\t1.0710185940
-0.6639489000\t0.4396428340\t1.3542275300\t0.0926446500\t0.1243287052\t-2.4891922930\t-0.5744160880\t0.1731805850\t0.6090552692\t-0.0822052260
2.6558690000\t4.3018081440\t5.7866611600\t7.1784640300\t0.7153077064\t-0.0021297260\t0.7870576320\t-0.0935907530\t0.8923276218\t0.2888731660
0.1788431000\t-0.6269287870\t1.4167730200\t1.8054540200\t-0.6753810503\t0.2296922360\t-0.1915854010\t-0.2966910610\t-0.3392167011\t0.2413479930
1.2325450000\t2.8532216030\t2.4266087000\t5.2919618800\t-0.1785029673\t-0.5214262450\t-2.0879270690\t-0.5901844770\t0.3458236038\t-1.2880314490
1.3902840000\t2.3380979870\t2.8123528200\t3.4205465900\t1.1114824797\t1.1178018220\t-1.5777147170\t0.1341568070\t0.0701179006\t-0.4447485970
1.9569480000\t1.5120569860\t1.9438039800\t4.3685001000\t0.4763878436\t1.6394343580\t-0.7632407090\t-0.9612675480\t0.0134090721\t-0.5177895070
-1.6588450000\t-1.5217277390\t-2.0825253200\t-1.5804172700\t-1.7329505473\t-0.8660591260\t2.0679182160\t1.8701967850\t0.1291449344\t0.5104062740
1.5677470000\t2.1602233470\t2.6602361200\t3.4444463800\t-1.0414656098\t0.5001721360\t0.7553562780\t-0.5638047700\t-0.3433392825\t-0.3259225210
2.2036870000\t1.4010006060\t1.6857158900\t2.6000420800\t0.0238198817\t-0.5078200930\t2.3229831350\t-0.9860323370\t0.1929769860\t-0.6131559290
-2.5467480000\t-1.8076015500\t-0.5178258300\t-1.8275074200\t-1.2149521666\t0.3557512060\t-0.4063899260\t0.2718856800\t1.4602070988\t0.1861159730
1.8917580000\t3.7393758110\t5.4097672700\t7.5085113100\t1.8952122481\t0.2711607240\t-0.8256261040\t0.1060265500\t1.3959974683\t0.4251217870
-3.5339310000\t-3.0221130810\t-3.0805130900\t-3.5884780600\t-0.6299002506\t-1.7900759450\t2.0385905580\t-1.3204253620\t-1.3242958300\t1.2140977850
-0.3423780000\t3.8143018080\t4.5350287100\t6.9631875300\t0.2194507911\t1.5331406980\t1.6143748830\t0.6722694840\t0.0675679786\t-0.0653961220
-0.4808894000\t1.6725406480\t1.4755076500\t0.0129132600\t1.1700278522\t-0.6235768240\t1.2820441790\t1.7109129830\t0.5858517851\t-0.5186162270
2.9184120000\t4.3602805150\t5.6816839400\t6.6416461000\t0.0561476697\t-0.4155224500\t1.5664872050\t-0.5238031680\t0.2478549061\t-0.9251498350
-0.3664112000\t2.2242185010\t2.9325741000\t3.3656540800\t0.7845508033\t-1.2342838680\t-1.4933817510\t-0.7815683050\t0.9022459262\t-0.9728146770
-3.0813510000\t-1.4827612770\t-1.2253775400\t-1.6857147700\t-1.6680061106\t-0.6986262050\t-2.2256448120\t-0.2878521800\t2.1264610062\t0.4274440090
2.5510660000\t4.5654450580\t5.7016611900\t5.9483952800\t1.5885079838\t1.0212026220\t-1.9482475100\t-1.0646245440\t0.7917782460\t-0.7439020820
1.6304590000\t2.2963361950\t4.6634067500\t5.4815277800\t0.5828999702\t0.6544260820\t-0.0013722550\t-0.4798639000\t0.6615112820\t-0.0418393870
-0.3021982000\t0.1608140260\t0.4042617000\t1.4397484000\t-0.8849347777\t-0.5694245340\t-0.3180758830\t2.3555973600\t-0.0870620503\t-0.8136607720
2.4407990000\t5.5290911610\t8.2191575800\t10.8869048300\t0.9430312737\t1.0403581580\t-0.5656798720\t0.1689226520\t0.9611849777\t-1.0272388030
3.3181720000\t6.7061457590\t4.6130828300\t7.8040190200\t2.3009251508\t0.8112100050\t1.2032109930\t0.5308603460\t-1.0453879637\t0.6354980660
3.0886810000\t2.0379018250\t3.7113433600\t5.0839405000\t-0.6024162505\t0.3988014450\t0.4500036200\t0.4752038710\t-0.0910713877\t1.5854995830
1.7833540000\t0.7157618550\t2.1810182400\t2.4020634900\t-0.0369292579\t-0.0675265720\t0.4221474620\t-0.4307271140\t-0.0040951479\t-0.2572396150
0.2555841000\t1.0660778980\t0.2052419400\t1.4528231300\t-0.8695483727\t-0.5709485130\t-0.4341176040\t-0.1538647880\t0.2830309681\t0.2528367070
2.5669500000\t2.6965133940\t3.0438934800\t4.5379573000\t-0.5034773684\t0.4879893830\t0.7371451350\t-0.1906346730\t-0.3925604758\t0.7137639180
1.6114210000\t2.2814835980\t2.2205214000\t1.8641713300\t-1.2518203595\t-0.1170507750\t0.6256067520\t-0.3617085280\t2.1106797435\t-0.8646137500
-2.5767560000\t1.5615254310\t2.7822901400\t3.2436423300\t-1.9616030265\t1.2620941750\t-0.2120844570\t0.1615128030\t-0.8805066939\t-1.9413646020
-1.2287560000\t-2.9090948040\t-0.3360082100\t-1.1063586200\t-1.8738100408\t0.4337532430\t-1.4647247430\t-1.0592457490\t0.7293377827\t0.3548953280
2.4482700000\t0.2945060430\t1.8518494600\t2.1545632200\t0.7810657941\t-1.0449588690\t0.6305430590\t0.3250432000\t0.2872564237\t-0.7043612910
-2.1708950000\t-2.1615920120\t-0.5673782800\t2.0494860800\t-0.4240392125\t-0.9515553720\t0.4408890880\t0.4600862390\t0.0716863592\t1.9579029300
0.1449588000\t2.6465777970\t4.9451407900\t7.7529312300\t1.0160123076\t0.2882816890\t-1.1276083300\t-1.1843158170\t0.0935144611\t1.0321666680
1.4273660000\t3.4941102990\t5.2344490100\t6.6296994600\t-1.3657292399\t1.4954911150\t-0.3885518250\t0.0774596440\t1.8657319713\t0.4562836010
0.0603390400\t-1.2074309840\t-0.4769696300\t-1.8081540300\t0.1143542041\t-0.3407666320\t-0.3962191700\t-0.3979917300\t0.2849464147\t0.2059336480
0.9046286000\t1.4906794380\t3.5069001200\t2.1644528000\t-0.0081393531\t0.0088772290\t-0.5336170710\t0.3353671410\t0.8789797815\t0.0677271390
0.3470517000\t1.8378259570\t2.6131385100\t4.6891490700\t-0.3189513188\t0.0884328400\t1.2601209410\t-0.5041109160\t-0.3828215777\t-0.5963432280
0.6262972000\t2.8296014420\t3.7243387900\t4.5863029700\t2.0729104002\t0.0463766590\t-0.1159347860\t-0.6863989530\t-0.5814740135\t-1.0655760180
2.1863470000\t2.2845493240\t0.8719031000\t1.8793065500\t-1.5169811845\t-0.2557987230\t1.6828712630\t-1.0371667340\t-0.5525939775\t1.0033734820
0.9287493000\t1.4099183100\t4.6474211200\t6.1815701700\t0.2671185660\t0.5906769870\t-0.8886406840\t-1.4456797970\t-0.7511754644\t-0.6331404910
-0.0977990500\t2.5988403980\t2.0072158700\t4.2212218300\t0.8009228280\t0.4601449320\t0.0021198830\t0.6897393760\t0.3864426595\t2.0031700890
2.9683890000\t3.0127559510\t4.5725832800\t5.9838955100\t1.1663945854\t0.6076684910\t-0.2004838100\t1.1398978030\t-0.2688966547\t0.6365007880
1.6904930000\t2.5722558120\t3.3740636500\t5.0251334200\t0.5226890717\t-0.2261901280\t0.2168650770\t0.7324291730\t0.4572816753\t2.5876760630
1.2912810000\t2.1222168090\t3.0681284600\t3.0244526500\t-0.0486607785\t-1.2594874930\t-0.3507584220\t-0.8019897630\t0.4157538564\t1.6944043580
1.1113650000\t2.4529960700\t2.9564049200\t3.7768423500\t-1.5870509442\t0.3243774230\t-0.5814960570\t-0.8181262210\t-0.6144055705\t0.6815087910
1.3530750000\t3.8119238460\t6.2782785400\t8.1881014200\t0.2413969466\t1.4387586620\t1.3148745410\t-0.8053804120\t1.0996413327\t0.7957633890
1.0941420000\t1.2818359770\t0.5356088800\t1.9207835300\t-0.7464625145\t-0.0026055500\t1.4984507290\t0.8939824410\t-2.2527755751\t0.7329182420
0.9964565000\t2.7172008540\t6.4700642300\t7.0812491300\t0.0187437980\t1.1304631110\t-0.3641043740\t0.9020360860\t-0.4457392482\t-0.2599724950
-0.1923494000\t0.4990737350\t-0.4144303900\t-0.1317085200\t-0.5705993605\t-0.7050609020\t-1.5821690030\t-0.0849177580\t0.6359949537\t-0.5068771400
1.4743290000\t3.8931503330\t4.9254542800\t7.0254036500\t0.7711528002\t0.8616286050\t-1.1076043820\t0.1687510080\t-0.1956394660\t0.9889699820
-1.0998510000\t-1.1945915930\t1.0792335100\t3.1061696700\t0.0100741504\t-0.5639611670\t0.9098395790\t-0.4781473010\t0.2527603055\t2.0047656090
2.6238960000\t2.7605323490\t5.9006725600\t5.3793021600\t0.9006688960\t0.2409641520\t-1.2156741230\t-1.4725525660\t1.2019179590\t-0.3466704470
-0.9253426000\t-1.2612594820\t0.5910969500\t2.7182586000\t-1.2912701304\t-0.2133205250\t-0.7432509280\t-0.1326862920\t1.9424004823\t0.8090764790
0.2108719000\t3.2941857050\t4.7861033500\t8.4687474300\t-0.6755684198\t1.1699429530\t0.6392807560\t-0.4540601570\t1.2530971478\t0.3445323200
0.2931046000\t2.2675807220\t2.5278889500\t3.5058310400\t-0.7399501764\t-0.5225858020\t-0.2838877590\t0.1417426660\t-0.9254987356\t1.3034020940
2.0702660000\t3.1128326400\t4.3687723000\t6.5316729700\t0.8126536631\t0.3860191700\t1.9091284870\t0.9892202670\t1.3781013034\t2.4443158630
1.4267220000\t1.1468622950\t0.9153845400\t1.1410375100\t-0.2030347328\t-0.7555620000\t0.5863605910\t2.7105355570\t-0.1126917605\t0.1044779390
-0.2552579000\t1.2236103640\t0.5574997200\t1.5380394000\t-1.5288969243\t-1.3862520670\t-1.5907462610\t-0.2106144430\t-0.5873157611\t-0.0734052990
0.0312035400\t1.3845354970\t3.4460387200\t3.8778898300\t0.0495092705\t-0.7834807540\t1.5021074960\t-0.4442242420\t0.0535581273\t0.6634976690
1.2309610000\t2.9576093110\t4.6185320600\t5.4400843200\t-1.7875057828\t1.7357914150\t-0.8176489990\t0.0203906020\t0.0900747910\t1.3565770500
-3.3459840000\t-0.8284976210\t-0.5650195900\t0.4935834000\t0.0815382264\t1.0701321180\t-0.4973734500\t-0.2495568050\t-1.2015815207\t0.1278391110
1.3492210000\t2.3962078550\t4.1215278900\t5.2017993300\t-0.6304998303\t-0.7887487020\t-0.0048769760\t-0.7772941360\t-0.8884549535\t0.2496930950
0.3645875000\t-1.1157473860\t2.1624318600\t3.4164854300\t-2.6285324691\t0.7360478940\t1.1610650670\t-1.4805004220\t0.3250137983\t0.7518642170
-0.2743927000\t2.0858461330\t3.5240302100\t5.2657926200\t-0.9331065199\t1.4463103500\t0.0085722960\t1.4119951810\t-0.1906836092\t0.2904190020
1.3723490000\t1.8359806030\t3.4899549200\t4.4923045000\t-0.9699839309\t-0.7193368730\t-0.0364889850\t-1.5872902680\t-0.7988993932\t0.2684708600
2.3473480000\t4.5453845430\t4.6901779500\t5.0154408800\t1.1426374172\t1.1864543190\t-0.5793202060\t0.4139970830\t0.2846104212\t0.7712567860
1.4352750000\t3.6403568150\t4.4541923700\t5.5779985300\t1.4621907404\t1.0361645090\t-1.2804770870\t0.2176680810\t0.3194343130\t0.4161580230
-0.6054804000\t-0.9767897220\t-2.6736942400\t-2.2407572700\t-1.4690567971\t-0.9840850690\t-0.4427497350\t1.6213895190\t-1.4385851723\t-0.6678561100
1.2302070000\t2.9377804280\t0.9496251200\t2.4844079700\t0.5035565375\t-1.2494533110\t-2.5773426000\t0.0512649500\t0.9099064663\t0.3275331520
1.1623620000\t1.5488198520\t2.9161551800\t2.8574029200\t0.4499280826\t0.2041474650\t0.4424403080\t0.4551107510\t-1.2918985100\t-0.0814043790
-0.8150825000\t0.6225632620\t0.6984091200\t2.8394507700\t0.1677115784\t1.1098662750\t-0.2713657430\t-0.5731013220\t0.4447375724\t-0.4681307970
0.9604845000\t3.5674755330\t4.3471731300\t5.3640820900\t0.5603480952\t-0.5507540450\t1.3123798080\t2.1359323650\t-1.6018012919\t-0.5587934380
1.3531070000\t2.3251521380\t2.6905190600\t1.7524749700\t-1.3003608878\t0.7134660460\t-0.1820615970\t0.7642824020\t1.1064956435\t-1.5181125740
-0.3216741000\t-0.8484974820\t-1.7947741000\t-0.9186866300\t0.2213364911\t-1.4421081490\t0.6773249420\t-1.1987880430\t-0.8770716101\t1.0147037920
2.4271390000\t1.7476860270\t4.5746458200\t5.3267354900\t-0.1733960518\t0.6998637560\t-0.7939144520\t-0.3712598780\t0.0363257037\t-1.7958934270
1.0766920000\t2.5967312070\t3.5965122000\t5.0836312600\t0.7026345977\t0.3067352400\t1.2129134960\t1.1459289370\t-0.7690686152\t0.3093499170
2.5063780000\t3.9362299010\t6.0424358500\t7.4523129800\t1.9506239631\t0.5537769690\t-0.3548238730\t0.1760469140\t1.7958267597\t1.0517190330
1.4808380000\t4.7102523580\t7.2502229000\t8.2144876400\t0.0137911236\t1.5644724250\t-0.3599899060\t1.0995098170\t0.2630354346\t-1.7250712870
0.5118640000\t1.0516193840\t2.9715131600\t6.6356285200\t-0.9388536381\t0.9181004360\t-0.7532024780\t1.3708983580\t-0.6445339231\t1.0648300460
-0.2623814000\t2.4659420380\t3.7177389800\t3.4088004400\t0.8312535287\t0.1280076030\t-0.3419057910\t-2.1581831600\t0.1745642257\t0.7291693770
-0.2234558000\t1.5762281960\t3.7760038700\t4.5806580800\t0.3106822680\t0.6194242390\t0.4345473930\t-0.2469268400\t0.0257579069\t-0.9574161830
0.4061403000\t2.4126326880\t1.7979764000\t4.0799431100\t-0.9740964325\t0.8784544580\t2.4379637030\t0.2265948050\t1.4624699552\t-0.6471167570
-1.8647040000\t-0.7392630660\t-0.7031981200\t-1.4563517000\t-0.3772268662\t-0.6575589700\t-0.4658911680\t0.4343287970\t-0.4340727545\t-0.4694284020
-0.9905616000\t0.5658639080\t-2.7533307400\t-3.5855604400\t-0.4960718215\t-2.0655698940\t0.5305961680\t-0.1248927250\t0.4956155842\t-0.1089900440
2.1692130000\t2.6869392200\t3.6976494000\t5.9532259400\t-0.1301800905\t1.4432683780\t0.3762705990\t0.1730938240\t0.0441489615\t-1.7502870480
0.0107250600\t1.5491677780\t1.5317733300\t2.1106002500\t0.0481439357\t-1.0158331850\t-1.3418583700\t-2.1625415020\t0.9181880781\t-0.9374077740
1.2344220000\t3.7087882630\t6.0469648300\t5.1262840300\t-0.1763190856\t0.1565576380\t-1.3705538200\t0.4050724010\t0.7322655127\t-0.4083758530
1.3912490000\t1.8771648410\t3.7127975000\t5.2855578600\t0.3348382140\t0.1549450980\t0.1466312410\t0.8618851800\t-0.2164948740\t-0.1354217500
-0.7691002000\t-0.2777874620\t0.8819550200\t2.5228421400\t0.8371655667\t-0.1046042910\t0.2146956630\t-1.6132848870\t-1.2302983793\t0.9902940230
-0.2010110000\t2.3486759050\t4.0727453500\t3.6582034900\t-0.4293504685\t0.1261696580\t0.8951135420\t0.7429321730\t0.7265117965\t-2.1479861890
-0.6857367000\t-0.3253599820\t1.9217355000\t0.9964713600\t-0.4323586290\t-0.5680036780\t0.6214182900\t-0.6721599290\t0.6347838879\t-1.6169857220
-2.4124130000\t-1.3400619610\t-2.0318245800\t-1.8392120100\t-0.2991436317\t-1.2272990550\t0.5306636930\t0.7375949450\t0.9814778294\t1.5140221550
1.7920970000\t2.7787566380\t4.2701852600\t6.3921558900\t0.4508207636\t0.5486349260\t1.0283528360\t1.3413716650\t1.6616664520\t-0.1797208660
1.6230980000\t2.5268630480\t6.7981565600\t7.4195568900\t0.7974747696\t1.3801601600\t-1.1048853490\t-1.8092445140\t0.4706612623\t-1.3664844940
1.6849900000\t0.9360097750\t2.2313649300\t3.3862683300\t0.4988113328\t-1.0055488600\t0.2348189800\t1.1590538870\t0.2455854515\t0.5067286860
-0.5146901000\t-1.2289488050\t-0.0862441100\t0.2347498400\t-1.6536325081\t0.1975800670\t-1.1786801200\t-0.5505169870\t-1.8013291095\t0.1526585980
0.7520052000\t1.8837184810\t3.0789770200\t3.4050453000\t-1.4255002381\t0.5295100180\t0.2200200630\t-0.2882470130\t-0.9280692905\t-0.4004076980
0.2319110000\t-0.2926818150\t0.0659591800\t4.0642723700\t-2.2594567120\t0.7421284620\t1.0594273730\t-1.2868447130\t-0.2704461534\t-0.4144523080
-0.6576760000\t-0.6177935670\t-0.5380232800\t-0.7949121500\t-0.5927125232\t-1.5042673190\t-1.0527810520\t0.5919643600\t-0.0356771922\t-0.8958263820
1.2618540000\t1.0792376080\t5.1666898900\t4.3526942900\t0.2145237201\t0.7783016430\t-0.5401552290\t-2.5363189780\t0.8013624739\t-1.6057454620
-2.0057180000\t-2.0194186460\t-6.0024798600\t-5.1534239400\t-0.9905823648\t-1.2541529080\t1.8419491100\t-0.8224958180\t-3.3965049560\t-2.0815666470
-4.1401880000\t-0.4906624070\t-0.9064603200\t-1.3553999600\t-0.7478984620\t-1.0713678330\t0.6564833560\t1.8903041570\t-0.4911830712\t0.4143849020
2.1387430000\t2.8975281320\t2.3527349900\t4.8038238000\t0.5683127926\t-0.1661961600\t0.1712861490\t-1.6228322570\t-1.7368075570\t-0.8432358970
2.0157520000\t0.0730347590\t1.2874666800\t2.4842443000\t-0.8272780281\t-0.5294844380\t-0.9165936940\t0.6585613480\t0.5436429991\t-0.2580059760
2.7186740000\t3.0032635270\t2.3992555900\t3.2785239400\t0.2157996294\t0.1891600680\t0.2054084240\t0.7983831250\t1.1967412158\t0.5986145720
1.0730320000\t2.9128039530\t3.7747197900\t6.6202584400\t0.1833003458\t1.2136924860\t-0.0779824870\t0.3105591940\t-0.9116562969\t1.1352266200
0.1683652000\t0.0034845350\t2.1120596200\t3.1012862500\t-0.4327078402\t0.6794342980\t-0.8138170340\t-0.9449740710\t-1.1623818713\t0.0820722620
0.7047459000\t1.1856092650\t3.6310880000\t3.4218725600\t-0.7440562895\t0.4658962500\t-1.3174715080\t0.5767761650\t-0.3589227823\t0.0443339190
0.3095433000\t-0.9765043980\t-0.3170558000\t-0.4504876100\t-2.8237828098\t0.6276860190\t-0.7419029380\t-0.3544021610\t0.1554243693\t-0.6622635330
-0.3782134000\t-0.5825139090\t0.7510487600\t2.4491655100\t-0.1865162742\t-0.9422566630\t-0.1461399900\t0.1190547300\t-0.6035068567\t-0.6146997620
2.4887710000\t2.1139558830\t4.4564929400\t4.7469560000\t-0.0515993126\t-0.5965091390\t-0.5838166190\t-0.5805290740\t1.0611141650\t-0.0687763320
-0.9120269000\t-0.9161171850\t0.2161424200\t1.5194576700\t0.6372560897\t0.5433951840\t-0.2052900230\t-0.4273651930\t-0.5917414685\t0.0187309180
-1.5353060000\t0.1010832050\t-0.8342222000\t-0.1895247200\t-0.6359612495\t-1.4978582860\t-0.0640401300\t0.2892014260\t-0.0878410206\t-1.2668769780
0.6960798000\t4.1302419630\t2.3501742300\t2.1707208700\t-1.0337428583\t0.3677770900\t-1.1778286500\t1.4385700890\t1.1117822886\t1.4071022580
0.6657816000\t2.9711700810\t2.5795308800\t4.2603048000\t-0.0941329760\t-0.2726918560\t-0.6395469320\t0.1907969580\t-1.4844625343\t-0.2489797890
0.2630299000\t1.2654366110\t3.2760567000\t3.9040626000\t0.2173317702\t1.5403749110\t0.6584331180\t-0.0520969340\t-0.8146922227\t-1.1736989290
0.0111247100\t0.9529576300\t0.9756547600\t3.2284261800\t1.3479362888\t-0.4887020840\t-0.3967481850\t1.1442291970\t-0.4071177916\t-0.4118658710
0.4183278000\t0.6643649060\t2.7194766600\t4.8285389100\t0.6734382001\t0.0139002710\t1.4027070620\t0.4605784460\t2.5791505259\t1.4787576790
1.8676130000\t3.6817690850\t7.1085660600\t8.0862799200\t-0.5302912588\t0.2251984460\t-0.8321113000\t-0.2595950060\t2.2129821789\t0.6344509990
0.8840519000\t1.4367030370\t3.1542904100\t4.0746733200\t0.6506624319\t0.3748118870\t0.7827689470\t-1.5970397320\t0.5093534121\t-1.3337888780
1.9235230000\t3.5330690510\t6.4031878200\t7.8261198100\t2.1154240068\t1.2085378830\t-0.8692047850\t0.0166988700\t0.6048197548\t-0.4057887670
-2.2818490000\t-2.3741000940\t-1.3229721600\t-3.1917867200\t-1.9187640180\t-0.2782410180\t-1.6483705800\t-0.5491313700\t0.6268104672\t-1.0556882920
2.7973190000\t3.8973596910\t3.1321292600\t6.1987766900\t0.0910765744\t-0.0995303680\t2.5665574840\t1.4185323970\t-0.0948059779\t1.4342708310
1.3331420000\t2.0652274370\t4.2441868500\t3.3143842200\t-0.5603273690\t0.7839185630\t-0.4429231040\t0.4739478070\t1.4776300743\t-1.5269912990
2.5870960000\t4.1770316600\t7.9162329000\t8.0605026300\t-0.0566318206\t1.2799178280\t-1.1056159880\t-0.3349282460\t1.2786170320\t-0.1985318500
0.9936210000\t2.0271975020\t1.6161012100\t2.2564627400\t-0.3559400592\t1.1244544640\t0.6178608250\t0.1975535650\t0.3862042677\t-0.7765610790
5.0178220000\t5.7588303700\t7.0938619200\t10.0397670000\t0.5833429683\t1.1014381660\t1.3051682940\t-0.3279180730\t-0.4315447565\t0.1508033120
-0.7968669000\t-0.0802208590\t0.4109692600\t0.3364633400\t-1.0248323232\t-0.7628871600\t0.3519102910\t0.1191524610\t0.6322878815\t2.0514120790
0.6632791000\t1.1580540380\t1.3792926700\t1.5598322400\t1.5032973810\t-1.1477305410\t0.3418920390\t1.1090679000\t1.2605276927\t-0.1252545500
-0.2198548000\t2.5359086660\t6.0991536000\t6.2174736600\t1.0427720145\t0.9578073510\t-0.6852608950\t0.0974251050\t0.2169319739\t-0.8896911030
0.8568791000\t3.9261256360\t4.1053789200\t4.7104780800\t-1.0165274513\t1.5550798400\t-1.0064834910\t-2.2256269670\t-0.3966858643\t0.1071086030
-0.3934788000\t0.5227218850\t2.0029807000\t3.5768771100\t-1.9981453465\t0.4519504190\t0.2681532600\t-1.0126263900\t0.5907425897\t1.0471946990
-2.0512600000\t0.3282204600\t0.1572090500\t0.4269951600\t0.5725231966\t-0.2672254890\t-0.0093481210\t1.3972358600\t-0.9739311140\t-0.0625979730
1.4772520000\t3.0281002410\t4.1552093300\t4.9133917000\t0.1049594615\t0.2979588160\t-0.5137652580\t-0.0808079870\t0.4449578770\t0.7731641250
1.2919570000\t3.1667182930\t3.6745393000\t3.9586243800\t-1.5333907547\t0.4550385580\t-0.7391082120\t1.0328181740\t-0.6725524486\t-0.4771089880
0.4067297000\t1.6485367380\t2.8940550900\t3.1379912300\t-1.0435812665\t0.6806365110\t-0.4421975150\t0.1928433710\t-0.0491617704\t-0.3349958790
-0.2395998000\t0.4398754590\t2.2507359800\t2.2196669800\t0.0126246867\t-0.8458444960\t-0.1102486390\t-0.1477509490\t2.2049655386\t-0.4352811100
-0.8705649000\t0.6525245040\t2.9429330200\t3.1214045700\t0.6585484143\t-0.1435882670\t-0.5901627260\t0.5682472470\t1.8025844923\t0.1260465220
0.7173195000\t0.7933649610\t3.4700919100\t1.1774731300\t-1.0989678628\t-1.1917707380\t-0.1007728310\t-0.8573328960\t1.3887215307\t-0.2193210290
-1.2236070000\t0.6503849830\t0.8886990000\t1.8906578600\t-1.4226460692\t-0.5632838790\t0.3572094900\t-0.0079727630\t-0.1411900788\t-0.1059524370
2.9627470000\t2.2843642750\t2.4512608900\t4.3203252200\t-1.0511713950\t0.4258973420\t1.4588540840\t-0.5272332450\t1.1075313608\t0.7874307360
1.1231120000\t3.8960225610\t4.6607378000\t5.0655361300\t1.0456478013\t0.6695295160\t-0.4112548550\t-0.3483259440\t1.4356293048\t0.4020842640
1.5699670000\t4.9166784930\t4.7271848100\t7.0022741600\t-0.1707901967\t1.0131785710\t1.6886884050\t0.4381332620\t0.3157644215\t-0.5159729860
-0.2315994000\t-1.4414328790\t-1.6245931300\t-0.4801249600\t-1.7839098063\t-1.2178432300\t1.1713443740\t-1.6766465840\t-1.3494545993\t0.9555388730
1.3063320000\t1.7787041000\t2.4207860500\t3.8165191200\t0.6499308825\t-0.8241623700\t0.6867528570\t0.4283382630\t0.0817393433\t0.6659090190
1.2354950000\t3.2686192920\t4.0627635400\t5.5514335400\t-0.1648128705\t0.7344125720\t0.2785536830\t0.5248397400\t0.9187694710\t-0.4719163560
0.3998851000\t0.4386274300\t2.0408561200\t1.0013165100\t0.3673539161\t-0.0078233910\t-0.3177191840\t-0.3825983950\t-0.2791466526\t0.3123094410
0.7781823000\t1.4876628310\t2.6952382700\t3.9274846200\t1.1826478077\t-1.3315370850\t0.1426251430\t1.3872478570\t0.3478895172\t0.9031548750
1.6863090000\t2.1142266080\t2.4042083400\t1.1948588900\t0.4630825505\t0.1510927210\t-0.9635028070\t-0.2561350600\t0.0291706808\t1.5582762360
-1.2709620000\t-1.1832168740\t-0.3556727600\t-1.5796898000\t-0.4559435192\t-0.8621583960\t-0.9737265020\t0.6265796920\t0.3843264218\t-0.0263006040
1.6679430000\t3.6550010140\t6.6356471800\t8.5423558100\t1.0219233804\t2.0226297800\t-1.3511026450\t-0.0882637170\t1.9235374521\t-0.9845910800
-1.0303250000\t0.2211508570\t1.7095257200\t3.6640406600\t0.0692000947\t1.1756564980\t0.7451017560\t0.2279987370\t0.2541133733\t-0.1156923420
-2.5310830000\t-4.1950375760\t-4.2206074000\t-1.9968405400\t-1.0183018061\t-0.7928693750\t0.6020117880\t-0.7195612050\t-0.8953975851\t-0.4997923800
-0.3642003000\t1.1522954220\t-0.2570751200\t1.7973908600\t-0.7501133218\t-0.2891091840\t1.7121756570\t0.0396149440\t-0.6379404994\t-0.1237281940
0.5667099000\t3.9709157840\t5.2475155000\t6.9501380500\t-1.0705007629\t1.4738808740\t-0.7508923120\t0.7044576310\t1.0406773514\t-0.4825541180
-4.3533670000\t-4.8583094260\t-5.8729858800\t-7.3379421100\t-1.4271574159\t-0.8457044000\t-0.7265862870\t0.0924477230\t-0.2270872828\t-1.0018302780
-0.3406735000\t-0.5452118250\t0.1093645700\t1.5397436300\t-1.1845961733\t-0.0724834940\t-0.8371143080\t-0.1567901410\t0.2158166445\t-0.4485184770
2.6874340000\t3.2811821180\t3.3265202400\t6.1189011200\t0.2264820359\t0.7830005580\t-0.1194348220\t1.9427598310\t-0.5924321067\t0.7135367180
1.1200610000\t0.2892947130\t2.7239280700\t3.7836590000\t-1.2099457986\t0.7171656990\t0.3496308500\t0.0835577430\t0.2419124277\t0.6304182920
0.7964127000\t0.5524198860\t1.3905099000\t3.8670152900\t-0.9632726109\t0.0865213500\t0.0067289020\t1.0805854850\t0.8059185430\t1.1006209780
2.8631090000\t5.6774314290\t8.4233631600\t9.5680112400\t0.7400254674\t1.0231982920\t1.3416254200\t-1.2440761150\t-0.2571613879\t-1.9964348280
0.3069031000\t2.7087431650\t4.8325324900\t4.7056383500\t0.1379289287\t0.1319144630\t-0.7252025610\t-0.2430365010\t-0.4297976175\t1.0322173490
2.1317760000\t5.4949698800\t5.4695997300\t7.1279635600\t0.2931677230\t1.3889324030\t2.3577197190\t0.9547336620\t-0.6155306382\t0.9378397080
2.0468150000\t-0.4053081130\t2.2005018900\t1.9868132800\t-0.1900744105\t-0.2249564680\t0.8622424560\t-0.8009144900\t0.2512238583\t-0.0605031320
0.0842503900\t-0.9516379130\t0.2017603100\t-1.0202087700\t-2.2660761905\t-0.5315492950\t-0.5100846090\t-0.6431275830\t1.1986971098\t-0.8311877810
-0.1643415000\t2.8506766470\t4.5762194200\t6.2478106100\t-0.4338903706\t1.7408670450\t-1.5212451520\t-0.3266357600\t0.1540630817\t0.7692408870
-0.2930752000\t0.2074249170\t0.2903713000\t2.2771879500\t-0.8794701417\t0.0371300160\t-0.1502185980\t-0.9229907860\t-0.1830081183\t-1.0940424050
0.2328695000\t1.5468523480\t3.5503670400\t4.9157851600\t-0.2732223097\t1.1391359830\t0.5771396700\t-0.7961934030\t-0.5120876099\t0.1237368060
2.1484360000\t3.8769080900\t7.0495275300\t8.9815227700\t2.3289086340\t1.1609492230\t-0.1925222030\t-1.2639735460\t-1.0924753623\t-0.6216497360
-1.2652300000\t-0.9532705690\t1.9762341400\t0.9591899800\t-1.0402918398\t1.0096420730\t-0.2015019240\t-1.0693966340\t1.5549957062\t-0.5303305300
0.6723837000\t3.3944421890\t4.5610887000\t4.7104398600\t-1.3138831007\t0.8202892900\t-1.3697673380\t2.1368176480\t0.3749257957\t-1.3273179610
0.8534629000\t3.8421003250\t5.2626977800\t8.4488677500\t1.0017431677\t0.0216662040\t0.5410576300\t-0.7237417480\t-0.5149404243\t-0.1840410040
-0.3591883000\t-0.3657638280\t-2.2366505100\t-0.0620283400\t-0.8781884444\t-0.6456970670\t0.2047982980\t-0.7938161190\t-1.6076366310\t0.4239353740
-0.5063107000\t-0.0958139430\t2.2366312700\t2.6169107400\t-0.7048117845\t1.7388530500\t0.3780786190\t0.5373074880\t-1.3421773484\t-1.8551649190
2.6543440000\t3.6226400990\t4.7792328900\t6.9342704900\t1.8463664729\t-0.0326295340\t0.1968398910\t-1.0570742100\t-0.0702038361\t-0.3310768120
1.1628460000\t3.0273594760\t3.9076687600\t7.1923919500\t0.3129499806\t0.2513797110\t-0.5584590280\t-2.1633602470\t-0.9329005183\t-1.0195709270
0.3274386000\t2.6821297340\t5.3254170600\t7.7838040400\t0.8612511480\t1.1999458460\t-1.6901948330\t-0.1869845650\t-1.2648140108\t-1.1139152490
1.4087290000\t2.3081685210\t2.7841566200\t4.8357576300\t-2.4653432398\t2.0509930240\t0.3744792320\t0.2003359840\t0.4466844033\t0.0664648760
3.3134800000\t4.4538011530\t6.9646331000\t8.2912565300\t2.3319424601\t1.0015283130\t-0.3955228830\t-0.6067194530\t2.3629067061\t0.4020328350
2.1348670000\t4.8232558450\t5.3096538800\t7.5427874000\t1.0058001258\t0.1891150380\t-0.6641817820\t1.3105818650\t-2.1450294112\t0.0575577970
-3.0576360000\t-1.2573884230\t-3.1528475700\t-3.7046393000\t0.0004835047\t-2.7940477980\t-0.8495553640\t-0.5689714380\t-2.7056106597\t0.1226094390
0.9461776000\t2.5446048570\t3.9298722100\t2.1460130800\t1.4048746707\t-0.5075772260\t-1.3498974500\t-0.3049488770\t-0.1303903442\t0.4683663170
-0.1405998000\t0.6052364220\t2.0327031400\t3.0661531700\t-0.4868421338\t0.6363747010\t0.6236824350\t-1.3008165890\t-0.8277466188\t0.9964471300
0.8850371000\t1.1666635670\t-2.0077547300\t-0.8989274100\t0.8622258542\t-1.7452200630\t2.0777399300\t1.0201050700\t-1.1946580832\t0.7698797530
0.3973377000\t-0.0585717490\t3.3837094300\t4.5674625900\t1.1921544095\t-0.3763796740\t-0.5383460120\t-1.1646247040\t-0.4202680220\t0.2455288900
1.1804730000\t0.3371136650\t1.4153902400\t2.0876145100\t-0.4930444991\t-0.7462615730\t-0.3996415510\t-0.4992699190\t0.8600174168\t1.2958980680
3.3421380000\t5.3130792260\t8.2734833500\t12.1469795400\t1.5824041830\t1.3766187850\t-0.5698285810\t-0.3897809150\t-0.0808214861\t-0.2983491950
0.8951922000\t1.1454949790\t-0.4351726200\t-0.1043857000\t-1.2582185047\t-0.5936800200\t-0.8974050450\t-1.2726521460\t-1.0907369341\t0.5862778340
2.2363900000\t4.6419429220\t6.8664471200\t10.1981740500\t-0.6216983650\t1.5701457680\t2.0375166990\t-1.1235091960\t-0.4252938349\t0.9366158740
0.0874460600\t1.2968342900\t1.7159588000\t4.1456512400\t-0.1735806137\t0.5132879560\t-0.3052760840\t0.6406748990\t0.8914551651\t0.8539945240
-2.3296250000\t0.7670788470\t1.6292904500\t1.3746694600\t-1.2785418732\t-0.2620719810\t-0.9994746150\t-0.0842464870\t-0.5748152545\t-1.6147176980
1.0220960000\t2.2528260040\t3.8205630000\t6.4188246900\t0.8747849283\t1.0990512220\t0.7670100320\t1.3976629920\t0.0768478631\t0.0469798830
0.0825841200\t0.0293678840\t3.4191161800\t2.8272624200\t-0.6671835869\t0.1199208740\t-0.3946195350\t-1.5541697550\t0.5706851895\t1.3318595780
0.6604443000\t-0.1143124280\t-0.1730270900\t1.6163134400\t-0.6624776856\t-0.3260250750\t0.3952078820\t0.3070711260\t-1.3057786033\t0.0150510450
0.2437603000\t0.6047797680\t-0.1766156300\t0.0584638500\t-0.0724265063\t-0.7327464300\t-0.3937807740\t0.2631915490\t-0.5534007619\t-1.9623047180
2.3317670000\t2.9147865600\t3.8996838800\t5.4761027500\t-1.4144757740\t0.2387893990\t0.7045859170\t0.8508765430\t0.8211263898\t1.3209795330
-0.5379380000\t-0.4898312510\t1.7094596200\t1.3481402000\t-1.2436367385\t-0.5202923450\t-0.0407345060\t-1.1732457310\t0.6202969424\t-0.4106974440
0.7707206000\t2.8050503950\t2.5188482400\t2.9198805200\t-1.4050969707\t-0.3573718790\t-0.1686618490\t-0.5405186630\t0.2911036971\t0.2147159480
0.3427677000\t2.4342688320\t1.2889857000\t2.2779185500\t0.0617021029\t-0.3879349580\t0.2332321180\t1.0793427640\t0.2120933944\t-1.4670128310
-0.6154964000\t2.6680609470\t1.4738291500\t1.8538160700\t0.0601643633\t-0.9970292690\t-0.8010847100\t0.1346600380\t-1.1638879647\t0.1691225070
1.6489120000\t4.0829304210\t4.4523130900\t6.1187481900\t0.3386708956\t0.9784773860\t-2.0360265830\t0.3272580550\t0.2738564896\t1.9412711410
2.0602050000\t3.6742761110\t4.4097041800\t2.6729473900\t1.3756228615\t0.4111516660\t0.3918166880\t-0.8769144050\t0.3461709235\t-1.3173429970
2.5058540000\t2.5773433600\t2.7793279600\t5.3541531000\t0.1605329661\t1.4790971640\t0.5555726740\t0.0096625080\t-0.3143027002\t1.3054387430
2.1519270000\t2.2353032710\t2.7152676900\t3.8288394600\t1.3607792634\t-0.6970100620\t0.2081507130\t0.5011856900\t-2.1327568960\t-0.2777716750
-0.7781960000\t0.2782775060\t1.2369770800\t1.1015647900\t-0.9243081649\t0.0157749390\t0.5883198900\t-1.2864289500\t-1.5596086237\t-1.7548252350
-2.2461160000\t-0.4837306190\t-1.8213315400\t-2.8280311600\t-2.3199796342\t-0.7643094690\t-1.7026860010\t-0.4237130310\t-1.4185674565\t-1.1187553060
1.1683660000\t5.0880290250\t6.6441766400\t7.7653539500\t0.5363848319\t-0.0105060430\t0.2789941520\t1.7590074460\t0.9703120090\t0.5765493290
0.3861544000\t1.5966829560\t1.9336822400\t4.9519486400\t1.3394851276\t0.5254623700\t0.8026554210\t-0.5877567430\t2.2381693470\t0.3738822950
1.3309950000\t1.1156700150\t2.9867227300\t2.9864491800\t0.3188981913\t-1.1554039800\t-0.2377106170\t-0.7194058620\t-0.2327140408\t-1.6125367860
-1.1066620000\t1.4285026450\t2.1823607000\t4.8856602100\t1.4378576233\t1.1721803680\t1.0306828990\t0.0447833560\t0.9068580223\t0.5057593980
3.5296400000\t3.6380758250\t6.2769469400\t7.4942243600\t0.4854192083\t0.5726292090\t1.8964809380\t-0.7479442870\t0.9163565131\t1.3894135210
-0.7877395000\t1.5183124090\t-0.0911903300\t1.2132167900\t-0.2911008131\t-0.4220686980\t-0.6670512990\t0.5192962190\t-0.7300802893\t0.5021294660
2.0295440000\t1.5980204630\t4.4842984200\t5.3029629700\t0.2223582130\t1.3841590690\t0.3938713430\t-1.8234064510\t0.3850781669\t-0.9577293180
1.2957910000\t3.7209498120\t3.6996795200\t4.5964595100\t1.3862607858\t-0.1460559420\t0.9440840870\t2.1274992050\t1.3886711065\t1.1525997820
-0.8592366000\t3.1007860240\t4.0562898100\t3.4336435500\t0.6906863662\t0.4307807040\t-0.1360010120\t0.3729988190\t-0.0256997918\t0.6647192020
2.5310160000\t6.5149254160\t7.1847004000\t8.6689228800\t0.5029975487\t1.1930000880\t0.7305108830\t0.8842554860\t0.0007102238\t-0.1262087220
2.6189580000\t4.1954946310\t7.1117803900\t9.3505814100\t1.6700821937\t0.7253258190\t-0.9148183160\t-1.5030989980\t1.2520350576\t0.8365221430
1.4914910000\t3.6125461070\t4.5754257100\t5.6275064600\t-0.4981685924\t0.2703969910\t-1.9279459660\t0.4172560870\t-0.8372201013\t-0.5286777210
0.5574957000\t2.5510224710\t6.3423312600\t7.0264350200\t-0.3285612289\t1.0322329200\t-0.9493024780\t-0.2060176830\t-1.1393994594\t0.6431808840
-1.4673470000\t1.0289680860\t1.7849905200\t4.3916720500\t-0.3667032842\t-0.1542770700\t-0.9969656580\t0.0658308020\t-0.6876793393\t-0.5986204340
1.4391600000\t1.8535447540\t-0.1930225800\t-0.9914089900\t-2.1519851981\t0.1347600580\t0.9688370690\t-0.3732185950\t0.2413517536\t-0.6576698660
-0.1520312000\t3.4416494700\t5.4006657600\t7.7011758200\t0.2268679058\t0.8304908380\t0.0608212270\t1.3015750650\t-1.1719612534\t-1.0338096580
1.6865830000\t3.0607175410\t5.3520311000\t7.4079064200\t1.5448652494\t-0.4560332970\t-0.6574377080\t0.5779035200\t0.4840285213\t-0.1568344660
-0.9857225000\t-1.4705363310\t0.3770918100\t0.9787753900\t-1.0295966107\t0.1199653130\t1.1570926700\t-0.0291813820\t-0.8806620575\t-0.9853618560
1.7367610000\t0.2522253630\t1.9221961600\t2.8066403300\t0.8387682732\t-1.3993600120\t-0.8098840850\t-2.2483723890\t-0.2528528181\t-0.2387037910
0.3552546000\t2.1125868920\t1.9880003000\t2.3945143400\t-0.8443242625\t0.7490511550\t-1.0880813810\t1.1531479850\t-0.2497527670\t-0.7777185840
1.8590110000\t2.4762128840\t2.8816975200\t2.0841458900\t-0.6169578313\t-0.5222506490\t0.5215725270\t-0.3623792730\t-0.6512485177\t0.0859267020
-2.0430010000\t-1.5912091600\t-1.8678982000\t-0.7549177800\t-1.6454160007\t-1.2844366040\t-1.3176214500\t-0.7967534350\t-0.7630962970\t0.5193329450
-2.5787010000\t-1.3326868280\t-1.5470965600\t-1.0431106400\t-0.6909078495\t-1.6720476530\t1.1138031970\t-0.3327262000\t-0.6614010593\t0.7563628720
0.8630956000\t3.3435592640\t6.0595472400\t7.6665342600\t-0.2923207975\t1.8495000460\t-1.0426692530\t1.1561834020\t0.5853503828\t-0.5999912370
1.8318930000\t2.5022103060\t4.9555742200\t5.4136216200\t0.1503773933\t1.6938360680\t-1.5524337600\t1.3923719870\t1.0803475534\t-0.2958078570
1.8396040000\t2.2419041320\t3.4584912100\t3.9444262300\t1.2934910574\t-0.8474690910\t1.2307852870\t0.5833618890\t0.0546537610\t0.5836051740
1.9558740000\t4.3354430520\t5.2387259900\t5.8936842200\t-0.1834645618\t0.6453183000\t-0.9775250820\t0.1514329000\t0.5435734161\t0.0678325640
3.2391700000\t2.4193094970\t6.7118647900\t5.8181578800\t1.7204544240\t0.1903176480\t1.4642706740\t-1.7119692310\t0.2631921746\t-2.2972649100
-1.1220610000\t1.5230616290\t3.1505835200\t4.8360419800\t0.5634183262\t1.5874364860\t0.4274861420\t1.4844969070\t-0.5648029305\t-0.3409840110
1.8506080000\t2.1136745800\t4.1620425600\t4.1035467400\t-1.2133960971\t1.0994839500\t0.5867881680\t-0.1617861850\t-0.4038364537\t0.2762938110
-1.0326680000\t-0.4174624840\t-0.0383704800\t0.6658282700\t0.6956687892\t-0.4863683280\t-0.1105052110\t0.4604913530\t-0.3888006755\t0.2373328330
1.4317800000\t4.1276735590\t2.5557424600\t6.3814895300\t-0.3972118326\t0.8724706840\t1.0244580360\t0.4673240100\t-1.6122273643\t1.4630712110
-2.9241550000\t-1.6761485520\t-0.8706207400\t-2.2045376200\t-0.3949106232\t-1.4445871530\t0.0256526800\t-0.6967800830\t1.3666393166\t-0.1646251140
-0.9381121000\t-1.5630916840\t-1.0434057300\t-3.5673820300\t-1.3965939556\t-1.2480492230\t0.5054348940\t0.1868335330\t0.9583893851\t0.1905922930
0.2836542000\t2.2635839070\t2.8933100300\t3.9168533400\t0.4560972452\t-0.1718275500\t-0.8859583970\t0.1923262530\t0.3924050843\t-1.2666668190
-0.0882376200\t0.5076406500\t2.9272966800\t2.8084370600\t-0.6539131497\t1.4136763570\t1.5268733560\t0.4777693890\t0.3396107306\t-1.3863338640
0.1687442000\t1.2400450880\t3.3673640100\t2.8323969900\t0.9888043683\t0.0609625360\t0.0816834240\t-0.1532040730\t0.8993090058\t1.0240235080
1.8104020000\t2.5353778600\t4.9443476100\t5.7234653100\t1.5206305108\t-1.6386853930\t-0.5005560590\t0.6489594270\t0.1456451447\t0.9063262560
-3.4344720000\t-4.0590054980\t-4.6602141900\t-3.0279244400\t-1.7935733380\t-1.6433362510\t1.7726447440\t-0.3244350810\t-0.8815563650\t0.8513465370
0.3127509000\t1.2560646050\t2.2519840900\t3.4534262300\t0.0286616878\t-0.1531984440\t1.4175974360\t0.7958198240\t0.2318512347\t-1.2426616850
-0.0979553000\t3.0580932380\t6.3158596700\t5.8228846600\t0.4089942635\t0.5775561520\t0.1149866500\t0.4509121230\t1.2262560185\t0.3179056860
0.8078320000\t1.1477469790\t2.8049185300\t5.5246532300\t1.2988261114\t1.3482245670\t-1.9103164000\t-0.7630277110\t-0.0793758664\t0.2293785720
-0.0756385500\t-0.6727535010\t1.0060765000\t0.9806856000\t-0.9110618204\t0.0770470480\t0.2271348300\t-1.2740235930\t-0.2912110848\t0.4225092580
5.1753180000\t8.1132124210\t10.1594586600\t12.9721618500\t1.3685913728\t1.3953889190\t-0.7542127850\t0.7666451450\t0.5989864144\t0.1901867640
1.9007430000\t4.0478322010\t7.9698660800\t9.0867302900\t0.2560581750\t1.7031584140\t1.8373915280\t-0.9877771220\t2.6093485933\t0.5262832070
3.5162840000\t9.9471515910\t11.5304985900\t14.7195597700\t1.9416139198\t2.5506686630\t-0.9139441760\t-0.7792736810\t-0.0077271026\t-0.4432128650
-1.4441310000\t0.2720887950\t1.6551463800\t2.5088395000\t-1.2206850052\t0.8173668530\t-0.4006417880\t0.1132588620\t0.8325137705\t-0.2726161640
0.7724259000\t3.0280342040\t2.4035486300\t3.8014511900\t1.1053817132\t0.3990972190\t0.4434559350\t0.8129328350\t-0.8605998819\t-1.1783886320
1.6412940000\t3.3368604580\t2.7590898600\t3.6698127800\t-0.0106380918\t0.7697391000\t0.1439240840\t-0.0667414930\t0.3670593835\t0.5330703700
2.4217700000\t2.3750438910\t2.8302238200\t6.3277069500\t2.0521310119\t-1.2166078430\t0.5742059360\t0.2653546590\t-1.0380124714\t-0.1658273060
3.1227810000\t3.9009661330\t6.3126008400\t9.4474716700\t0.2735053174\t1.1291378030\t0.7745990830\t-1.1451212900\t0.7832944018\t-0.5629187420
1.5691670000\t3.2896530380\t2.7883792800\t6.0629791400\t-0.3644050805\t0.1861793380\t0.3085842280\t0.2141418020\t-0.9174612919\t-0.2426064360
-1.0566340000\t0.6103470710\t-0.6178064900\t0.9622741800\t-0.4325229279\t-1.1257020040\t0.5952444870\t-0.5226093770\t-0.2547070732\t0.4333859810
1.9012900000\t1.8836742210\t3.1649532200\t4.1508024800\t0.6452239870\t0.8161793700\t-0.4812537470\t1.3445199120\t-0.6030196273\t-0.4274483730
0.5043092000\t-0.1017175160\t2.9170556100\t2.2198404900\t0.1783234338\t0.7987836090\t-0.0231008910\t-1.6479402580\t0.9122796630\t0.6022791520
2.9100530000\t3.9010163730\t5.2965126800\t6.5754273500\t1.0366280928\t0.2857863870\t0.2157050200\t1.1875558190\t1.0074119793\t0.8281965500
2.9205250000\t3.8069625830\t5.8887646000\t6.8187197800\t0.1141239431\t1.3868600870\t0.1256582280\t-1.2913215640\t-0.9620967558\t0.8969163940
-0.8156098000\t0.1330483820\t2.0910655500\t3.4678032600\t-1.2577857672\t1.2999783490\t0.8219218100\t-1.1945436110\t1.2160836007\t0.1366363620
0.0000162875\t3.0689658680\t5.4132258900\t6.3837534200\t-0.2520353687\t2.1997186360\t0.7743823920\t0.5688859480\t2.4605109288\t0.7852161340
-0.4260615000\t1.1996774000\t1.3937188300\t3.3479119300\t0.0599100433\t0.3012351830\t-0.8533178140\t0.4294276640\t0.8835477407\t-1.5811189930
1.6650750000\t5.4012672460\t7.3457403200\t9.4450246700\t-0.8210783891\t2.8280650010\t-0.0691185440\t1.2911738830\t1.4986439124\t-0.9923509240
0.4053527000\t1.7900109440\t2.7341358100\t2.3380867700\t-0.1752941338\t-0.2738211600\t0.2108013920\t-1.4027930860\t1.0941556927\t-0.2099462110
2.4288650000\t2.9521059400\t5.7448128500\t7.2851872800\t-0.2896303608\t2.0272994600\t0.0033494710\t0.1067835420\t1.3118299907\t-1.2759743990
0.1153942000\t2.6622652940\t1.0904500500\t2.6537312100\t0.7336121343\t0.0224966690\t-0.7339358770\t1.0693241140\t1.0451702754\t-0.5089416640
2.5032830000\t4.3803071140\t7.1835187700\t9.4073793300\t-0.2790388950\t1.7778226490\t0.4086033600\t-0.3938980440\t-0.5412344668\t0.4086192970
-1.8656700000\t-3.3059235810\t-0.3700510300\t0.0044243800\t0.0556005818\t-2.3715052840\t-0.9286436710\t0.7763680690\t0.4812250266\t0.8891695980
1.4895420000\t3.9252964570\t5.1619857200\t7.6136512500\t0.8699978808\t1.4034136550\t-0.4309986820\t-0.6517674390\t-0.0102519356\t-0.7689823980
-0.3029207000\t-0.1101394990\t-0.9089509200\t0.2557682100\t0.4828259300\t-1.1028514870\t-1.2523308680\t-1.8580080140\t-0.3414779602\t0.0736978560
1.6651860000\t3.6130681840\t6.1526175300\t7.2845862900\t1.1638835070\t1.4358061390\t-0.4881956170\t-0.8710580110\t-0.6783979503\t-0.4918435960
-0.9403946000\t-1.9028857920\t-2.9649705300\t-3.7751354300\t-1.2095441339\t-0.1928198910\t-0.6158660480\t-1.2497566370\t-0.3847357157\t0.0392907470
-0.1924281000\t-0.0270914070\t1.4236757600\t2.5048094600\t-0.8322751617\t-0.7505222050\t0.4552885770\t-0.1524141850\t0.1748347440\t-0.1019432430
1.4937940000\t4.8491898620\t7.3472704100\t9.2177931000\t-0.5210560383\t1.6208830880\t-2.3703600250\t0.3098024490\t-0.7496810937\t-0.0017693440
0.4682266000\t2.6044320310\t4.2881458200\t6.4974007100\t0.9375684819\t0.4319801700\t0.2461229460\t-0.6904712420\t0.8533620125\t0.6013937130
0.2986236000\t1.1149525220\t1.5861795700\t1.2310082600\t-0.8839934551\t-0.6128501360\t1.4521313600\t0.5823477530\t-0.3245269138\t-1.3187863720
-1.7421880000\t-1.5582720030\t-0.2247911600\t1.5897723900\t-1.6754847144\t-0.2627043550\t0.9103979310\t-0.2202280760\t-0.1333417461\t-0.1192025230
-0.5136378000\t1.3182625060\t2.8482775500\t6.2881027000\t0.9146001421\t0.4870131860\t0.4531281180\t-1.5289204970\t-0.7879682165\t0.1173297330
2.5888420000\t4.4318754380\t4.5028695800\t5.5128730500\t-0.0718254618\t1.1275750150\t1.1860077540\t0.2954704040\t1.1384129338\t-0.2803241260
-0.7902834000\t-1.4201890690\t-2.6312482700\t-3.7220575700\t-0.5162706752\t0.0747836510\t-0.1726170800\t1.9523533940\t0.0088099966\t-0.1131437860
1.5267140000\t3.2390175390\t4.1494645400\t6.6414109300\t0.9414654439\t0.6661743650\t1.8400402200\t0.3009455900\t0.6148479807\t-0.1668924810
1.3629410000\t1.2168703380\t0.8633483100\t0.5376356400\t-2.1953752937\t0.5122200130\t1.8923950970\t-0.7276146040\t1.2282863180\t1.1317214990
0.4904859000\t4.3056583460\t3.6171782200\t4.9738182500\t0.1848246848\t0.5929992430\t0.1333954250\t0.8432837830\t0.4706631384\t0.2341990890
-0.8689774000\t-1.6438580750\t-1.2447533100\t-1.3048946800\t0.5120745887\t-0.8008298380\t-1.0461442850\t-1.2524512310\t-1.1063387177\t-0.0270028220
-0.3378283000\t-1.2496641680\t-3.7696942000\t-5.8993956200\t-0.4252801482\t-2.2103809390\t-2.3536551530\t-0.6787643660\t-0.1437318234\t-0.8587368500
-0.1265472000\t1.1257821760\t0.3206916800\t1.7571319200\t-0.5778509559\t-0.2527690050\t-1.5944724780\t0.0047795950\t2.0141256900\t1.6989291360
1.5513400000\t2.4552078460\t2.8977252400\t2.8015856600\t0.4737090629\t-0.8894156090\t1.2212123320\t2.4876771260\t0.3381224531\t-1.5499267620
3.4344650000\t1.6061061080\t2.0721243000\t3.3999129600\t0.0987898041\t-0.2255528490\t0.4941938990\t0.1052461000\t-0.3585120627\t0.8551541430
3.1407560000\t4.7022007680\t4.5777707400\t7.4708891100\t-0.6607297357\t-0.0058311770\t0.5853399330\t1.2078547400\t-0.6732120201\t0.5122457180
-2.2885170000\t-1.0612275220\t-0.4226842300\t-0.3735586900\t-0.2957362810\t-0.7383888170\t0.1391118000\t1.5756178610\t1.0115733766\t1.0892116420
1.5910230000\t2.4468694530\t0.4200435600\t0.0231322300\t-0.9275433159\t0.0949050050\t-0.4057422520\t1.2630891660\t-0.5676420030\t-1.4606798820
0.1855872000\t2.7999915650\t4.3435053700\t7.3437900500\t-1.1430835709\t0.5066454490\t0.6269791650\t-0.3129633700\t0.0101339352\t0.3043359250
2.3594690000\t5.7947939300\t9.0533189300\t11.8457521500\t1.6337879829\t2.8845254290\t-0.1171314970\t-1.8203288690\t0.3253059832\t-0.9020427800
0.0361153800\t0.5593483320\t0.7172047100\t2.2225033300\t-0.8785408062\t-0.1518483170\t-0.1637018770\t-0.9439629080\t0.9395663739\t0.6248294020
-2.5942400000\t-1.5959028830\t-0.6814012600\t-1.2401152700\t-0.4028043683\t-1.0833796710\t-1.4172398360\t0.2645983090\t-0.5491390775\t0.5203723470
-1.1866240000\t-1.6371238440\t-1.3022953600\t-0.7140172500\t-1.1133780807\t-1.3587710480\t-1.1386848570\t0.5153296010\t-0.4281139532\t-1.0878609150
-0.8333969000\t-1.7356433340\t-2.6894622300\t-0.3196411400\t-0.3051565411\t-1.1800459890\t1.7757989560\t-0.4974316160\t-0.9163146547\t2.6506382100
2.0280630000\t2.4897711410\t3.6566360200\t6.6907457700\t0.8906968852\t-0.3066558170\t1.4461912410\t0.0074987520\t0.1712027119\t-0.0291828960
-2.7545590000\t-2.6913252570\t-2.6069650700\t-3.0983455900\t-0.8906204081\t-0.8088308920\t-1.0909723150\t-0.1799857180\t0.1761276787\t-2.4549944020
3.0496210000\t4.2872596920\t4.0898447800\t5.7238714800\t0.8336745701\t0.0325240950\t-0.6825149430\t1.7245720710\t-0.5381351638\t0.6467618890
-1.2935530000\t1.6097309520\t2.5584007200\t3.5264432100\t-1.7012545835\t0.1696905470\t0.8336151430\t0.0093394490\t0.2818453003\t0.7965484240
0.8541269000\t1.6806063270\t3.4857669200\t4.5665549400\t0.1260359623\t-0.0998460680\t-2.1241680320\t-0.3917771990\t0.2659918097\t0.0443688990
-0.7102188000\t2.5268842700\t2.6504302700\t2.8729934200\t-0.9816743867\t1.5526354030\t-0.3501848040\t2.1964349420\t-0.5257609273\t-1.0993356890
3.3867500000\t3.4780581110\t4.8602604000\t8.8467523500\t1.4044054550\t1.0714877130\t-0.4531439800\t1.2598491340\t-0.8012408651\t-0.5341148870
-0.2374715000\t0.7702341080\t2.6266863300\t2.0724884000\t1.7997193689\t-0.0370901310\t0.2193213760\t0.9182648720\t0.0339286167\t-0.6306841950
2.2517440000\t2.0612621980\t3.2322424000\t5.8321648000\t0.6465016100\t-0.7097905180\t-0.5435847520\t-0.4928292180\t-0.6025397945\t-1.3811082150
-1.3474500000\t-0.5035179480\t2.8968982400\t4.3541707200\t0.0404671133\t-0.7876899810\t0.4469297180\t-1.7287358770\t0.6774319264\t1.6121272470
3.1854450000\t2.1659215710\t0.7969894000\t2.8101832900\t-0.4324622177\t0.9207307170\t-0.3128135670\t0.0850146530\t-1.1983647162\t-1.6690047590
-0.3301921000\t0.0503985150\t0.8009962900\t2.3107163800\t-0.3115710960\t-0.7244757360\t1.4522571540\t-0.4112123000\t-0.6841928851\t-0.5001763170
0.9687332000\t0.5382097470\t-0.3960561000\t1.2070755000\t-0.2419685476\t-1.6407381790\t0.4212367200\t0.0970626720\t0.7955882772\t2.2001564830
5.2112940000\t6.9487835610\t8.8608740300\t10.4181443700\t2.7183231140\t1.1129646050\t-0.7009051990\t1.0735416730\t0.9570018701\t-1.2932405960
0.0000162875\t3.0689658680\t5.4132258900\t6.3837534200\t-0.2520353687\t2.1997186360\t0.7743823920\t0.5688859480\t2.4605109288\t0.7852161340
0.8652608000\t1.4803125470\t1.6893639600\t3.6436633500\t0.0084655354\t0.1064416870\t1.2737290930\t-0.0998890500\t-0.6041995287\t-0.0637511130
-0.1199112000\t2.3018928480\t1.0714082500\t2.3803763200\t-1.2175111785\t0.8103817470\t0.5017292490\t0.0985759970\t-0.2900748521\t-0.0383133750
-0.0090684190\t1.6809294180\t1.9157993900\t3.2910481700\t-1.2492798068\t-0.7166341040\t2.0723744410\t-0.2777495930\t-0.2185980361\t0.8166792540
1.7343890000\t3.9850751880\t3.5306827100\t7.7189581700\t1.3083530775\t-0.1482916230\t-0.8988657450\t1.4713006380\t-1.2421010506\t1.3015172620
0.0527809400\t1.7790291890\t1.2773399600\t4.4522740900\t-0.6624488810\t0.2047553320\t2.1684265730\t1.1272141780\t-0.3593393112\t1.2355839820
-1.3401530000\t-0.7242919910\t0.5730475700\t2.2375897100\t0.4110196899\t-0.1559183390\t-0.5872542120\t-0.4554808850\t-0.4535699008\t0.0964235690
-0.1836602000\t2.4397991650\t3.5989947000\t6.6109765600\t1.0481415274\t1.1961391070\t0.2405076170\t-0.3108148780\t0.1093025707\t0.4525107130
-1.5977210000\t-1.0620218100\t1.1812533200\t2.4139640000\t-1.3958633769\t1.3163906460\t-1.6392266430\t0.2687446620\t0.2595205953\t-0.7205337040
0.4218010000\t2.2792693990\t4.9912277300\t3.7213529800\t1.1265381424\t0.8181947650\t0.6209452440\t1.3778047370\t-1.0582218864\t-1.1745904070
0.0928161900\t2.1270982660\t1.5906928500\t4.0821579700\t0.0621972866\t0.0259215730\t0.1811103140\t0.3372507450\t-1.0107837165\t-0.0500964250
0.8343650000\t1.6975069770\t0.1378053800\t-0.7681891800\t-1.3480057240\t-0.1060685910\t1.2359138800\t0.8462988660\t-0.4902129976\t-1.2944942730
1.2714430000\t2.7871212020\t3.7985664400\t4.9784352300\t-0.5577535580\t0.0082768430\t-0.3143218580\t-0.7116449790\t-0.5077018136\t0.7293002430
1.0650000000\t2.9372719130\t3.1376549100\t4.1501800000\t-0.3443023321\t-0.7792911900\t-1.4255276590\t-0.5254856950\t-0.9673625975\t-0.4028839080
-0.4740518000\t-0.0351731810\t0.8873291500\t1.4725181300\t-1.1216161942\t-0.3624956800\t0.8365545340\t-0.0012869310\t1.3590290038\t0.1481106620
1.3932630000\t2.4120006740\t4.7565957500\t5.7745583000\t-0.0797416999\t0.9759431420\t-0.3323108030\t0.7676047930\t0.4028422832\t-0.5185979740
0.9318387000\t3.4341548180\t5.4362951300\t9.1086464700\t2.1579295849\t0.6225163940\t-0.6056691510\t0.5986481950\t-0.1845259111\t0.4985535870
1.5093750000\t3.6427057100\t3.4684215000\t3.2632741300\t-0.2171792630\t0.2692740510\t-1.7085192730\t1.0056999570\t-0.1509754765\t0.5201181370
1.6766570000\t2.7833647440\t3.5337952100\t6.0274161500\t-0.1091275433\t1.1059522490\t0.9325734660\t-0.7345240610\t-0.2091135093\t-0.4414641790
1.0884050000\t2.5669479170\t3.3192981200\t3.5319879700\t0.5817008186\t0.3639241950\t-0.1169248620\t2.3293863800\t-0.1916161806\t0.5850766970
0.2327152000\t-0.4628424860\t-0.7582836100\t-1.0215921700\t-0.7150275146\t-0.1589706740\t-0.8059638490\t1.3305222500\t-2.2199653779\t-0.4834259060
0.0039068820\t2.5807022570\t3.3966566600\t7.3096247000\t-0.5054109982\t-0.1001255760\t-0.1261522110\t0.8280320020\t1.0195326507\t-0.3104538430
-1.4052640000\t-1.7962506470\t-0.6095612500\t-0.7849016800\t-0.5839101969\t-2.8262126260\t-0.9156248250\t0.5146269890\t-0.2838101108\t-0.9228834590
-0.2452247000\t-0.0351788960\t-1.8088870500\t-0.5576685900\t-1.0447038832\t-1.3661035570\t-0.8709582340\t-0.2648032510\t-1.1562601176\t-0.4414197580
2.4386580000\t5.3025787430\t6.4104028500\t9.2683553100\t0.8380452132\t1.7890317250\t0.2044202050\t0.6196440820\t0.1588127072\t-0.2643485520
2.0132190000\t7.7533157130\t9.1485315800\t13.8325938100\t0.9892925185\t2.8647338130\t-0.1569232660\t-0.9121340750\t-1.0453573967\t-0.5790048900
1.5061270000\t3.0624456910\t6.0598503100\t7.5580176000\t0.0981950358\t1.2094758850\t0.7799156180\t-0.9411462010\t1.3177077464\t-0.4760104470
2.0678370000\t2.0591956950\t0.7944741000\t3.7203558100\t1.0161604055\t-1.1606595780\t0.7561538320\t-0.1814200840\t-0.5407596143\t-0.5458034270
-0.3241391000\t0.8798676220\t1.1175860500\t3.3420883400\t0.0433693558\t1.5640014370\t-1.2900019120\t-0.0784116580\t0.3497778296\t-1.1790464900
-0.7175617000\t-2.0827587390\t-2.5597487200\t-1.1058388700\t-2.7005007172\t-1.4931844880\t0.7556092120\t1.7929882560\t0.0936145458\t0.7295268380
-1.8828250000\t-0.8149435450\t1.0196609800\t2.6451510200\t-1.3660675679\t0.4489177970\t1.6802928020\t2.3821606020\t0.1231949007\t0.1933067490
1.4410190000\t2.6075632670\t4.8809999000\t7.2205644700\t0.0653527430\t-0.0532906050\t-0.7615367810\t-0.0847565980\t0.9139586682\t1.2610235860
0.9703786000\t1.6021408760\t2.9464906000\t5.7476371300\t-0.2832002831\t0.6890807910\t0.3119749700\t0.6880775150\t0.4602114805\t0.3446898970
-0.6678811000\t-0.3292544620\t2.7590038200\t4.0770421600\t-0.5744834708\t-0.2837480500\t0.5757869870\t-0.0489361600\t0.2901682827\t-2.0363514330
0.6719431000\t0.1532275110\t0.5466172600\t1.5962291700\t-2.1747458572\t-0.7214842190\t1.0893137460\t1.2456720070\t-0.9391875464\t0.7160798530
1.8870260000\t4.5133184190\t7.4841618300\t9.2992811900\t1.0639997478\t-0.1184952420\t0.7884337300\t1.1539053040\t1.5731206776\t0.0371702980
1.2505590000\t4.6465786070\t4.6124413900\t7.2208453400\t1.0120774646\t1.0914625690\t-0.1827526250\t0.5721315650\t0.4159998938\t0.0612010210
0.9347474000\t1.9785008310\t1.5346822500\t3.4113332000\t-1.0006408705\t0.7727066530\t1.7343748580\t1.0592304990\t-0.5556761498\t2.0557460630
4.8554730000\t6.9095451870\t9.1898461600\t9.4300984900\t2.0318176605\t1.4551706640\t0.4402129070\t0.5423355840\t0.0304340176\t-0.5805170810
1.5922900000\t4.0402786340\t2.5512249300\t4.2540130700\t0.5317719944\t-0.4894624090\t-0.5789298330\t-0.1107815540\t-0.1690723366\t-1.3603733270
1.8718680000\t1.5043760590\t2.6446244900\t5.0949371100\t-0.0257312108\t0.5178776640\t-0.2149428600\t-1.0294462700\t0.6580783197\t-1.0830527970
-0.6418998000\t0.5320009570\t2.7027404100\t0.6249157600\t0.0220142051\t0.5010175270\t0.0488084380\t1.8280976610\t0.7125085418\t-1.0583638710
-0.5166400000\t2.9817438940\t3.7575291200\t4.8978160400\t-0.3269773633\t0.1973299240\t-1.2289889190\t0.9141629570\t0.5670360149\t-1.2278994410
-1.2107160000\t-1.3064220360\t-1.2688298200\t-0.3593090000\t-0.6858033216\t-0.4940252520\t1.3176271310\t0.0186281230\t-0.1548486750\t1.0439965310
-2.0002600000\t0.0185536130\t1.4196487000\t0.9649936200\t-1.1876107396\t1.0592523530\t0.3879728180\t-0.0956458420\t0.9034074922\t-0.8796031130
-0.5732463000\t-1.8418698100\t0.0903979700\t-0.8052868600\t-1.0651891146\t-0.2958207080\t0.8785910530\t-0.1696066130\t-0.9151577459\t0.3792814620
2.0890520000\t2.1523471890\t3.1870033600\t4.8916594700\t0.5896909416\t0.1111541800\t-0.9313601720\t-1.0032685630\t1.0215253119\t-0.9631581360
1.4227490000\t1.6191955880\t4.0071954800\t3.8387153900\t-0.4316118160\t-0.6853186760\t1.9401591550\t-0.4332776210\t2.2257669413\t-0.8121922750
2.3425990000\t3.0308144980\t2.8105762500\t4.6236628300\t-0.1573619401\t-0.1820908950\t-1.7686720650\t-0.4679651450\t-0.7189050344\t0.4373498640
-1.0267330000\t-1.1618756700\t0.7038413300\t-0.0537081100\t-1.2192310603\t-1.1755532100\t0.4392836910\t0.0511690170\t0.8616772613\t-0.9643733760
4.6698760000\t2.4392697140\t4.6930795000\t5.0053073800\t1.8286461005\t1.1453105710\t-0.2724958110\t0.3964128460\t2.4676290682\t-1.3247910330
3.4205810000\t3.4353065050\t4.0506411200\t7.1798619700\t-0.2129990308\t1.1048460810\t-0.4093487670\t-1.3914285280\t0.5746619091\t-0.1808851940
-0.1452934000\t2.7880826490\t3.3587706900\t4.8158058600\t1.6877660705\t-0.3098594910\t-0.3220681330\t-0.1691995890\t-0.7004162386\t1.0568578550
0.2290236000\t1.7028218030\t3.1682010000\t3.9991429400\t-0.0153925842\t0.1072232130\t-1.4445953930\t-1.4996606180\t-1.5477944588\t0.6530319900
0.8337352000\t4.2871220520\t5.1007197000\t7.1595714100\t0.4612561630\t1.1147444290\t-0.8654030040\t-0.7138977350\t0.3139803208\t0.2100241580
-0.6935070000\t2.2739768170\t0.4308600300\t0.4846602700\t-1.6767104399\t0.4686931670\t-0.3434069990\t0.5689795580\t0.5963680172\t-0.5743125390",
                mode="r"),

            br(),

            h3("Basic statistics"),
            verbatimTextOutput("textareagcm"),

            br(),

            h3("Correlation"),
            verbatimTextOutput("correl.gcm"),

            br(),

            strong("Scatter plot matrices"),
            br(),

            plotOutput("corPlot.gcm"),

            br(),

            h3("GCM result"),

            verbatimTextOutput("result.gcm"),

br(),

h3("Path diagram (Unstandardized estimates)"),

plotOutput("gcmplot1"),

br(),

h3("Path diagram (Standardized estimates)"),

plotOutput("gcmplot2"),

br(),
br(),


            strong('R session info'),
            verbatimTextOutput("info.gcm")

            ),
tabPanel("Structural Equation Modeling", icon = icon("table", lib = "font-awesome"),
         sidebarPanel(

           submitButton(text = "Update View", icon = icon("refresh", lib = "font-awesome"), width = NULL),
           helpText("Click here to update your results, you need to do this after you change the data, model, or any of the settings"),
           br(),
           actionButton("quit", "Quit", icon("sign-out")),
           helpText("Press Quit to exit the application")

         ),

         p('Estimation may take a few seconds to minutes depending on the dataset.'),
         h3("Specifying the model"),
         p('See',
           a("lavaan", href="http://lavaan.ugent.be/", target="_blank"),
           'for the syntax.'),

         aceEditor("semmodel", mode="r", value="# measurement model
ind60 =~ x1 + x2 + x3
dem60 =~ y1 + y2 + y3 + y4
dem65 =~ y5 + y6 + y7 + y8
# regressions
dem60 ~ ind60
dem65 ~ ind60 + dem60
# residual correlations
y1 ~~ y5
y2 ~~ y4 + y6
y3 ~~ y7
y4 ~~ y8
y6 ~~ y8"),

         h3("Data Entry"),
         p('Note: Input values must be separated by tabs. Copy and paste from Excel.'),
         p("Your data needs to have exactly the same header (variable names) in the first row."),

         aceEditor("textsem", value="y1\ty2\ty3\ty4\ty5\ty6\ty7\ty8\tx1\tx2\tx3
2.5\t0\t3.333333\t0\t1.25\t0\t3.72636\t3.333333\t4.442651\t3.637586\t2.557615
1.25\t0\t3.333333\t0\t6.25\t1.1\t6.666666\t0.736999\t5.384495\t5.062595\t3.568079
7.5\t8.8\t9.999998\t9.199991\t8.75\t8.094061\t9.999998\t8.211809\t5.961005\t6.25575\t5.224433
8.9\t8.8\t9.999998\t9.199991\t8.907948\t8.127979\t9.999998\t4.615086\t6.285998\t7.567863\t6.267495
10\t3.333333\t9.999998\t6.666666\t7.5\t3.333333\t9.999998\t6.666666\t5.863631\t6.818924\t4.573679
7.5\t3.333333\t6.666666\t6.666666\t6.25\t1.1\t6.666666\t0.3685\t5.533389\t5.135798\t3.89227
7.5\t3.333333\t6.666666\t6.666666\t5\t2.233333\t8.271257\t1.485166\t5.308268\t5.075174\t3.316213
7.5\t2.233333\t9.999998\t1.496333\t6.25\t3.333333\t9.999998\t6.666666\t5.347108\t4.85203\t4.263183
2.5\t3.333333\t3.333333\t3.333333\t6.25\t3.333333\t3.333333\t3.333333\t5.521461\t5.241747\t4.115168
10\t6.666666\t9.999998\t8.899991\t8.75\t6.666666\t9.999998\t10\t5.828946\t5.370638\t4.446216
7.5\t3.333333\t9.999998\t6.666666\t8.75\t3.333333\t9.999998\t6.666666\t5.916202\t6.423247\t3.791545
7.5\t3.333333\t6.666666\t6.666666\t8.75\t3.333333\t6.666666\t6.666666\t5.398163\t6.246107\t4.535708
7.5\t3.333333\t9.999998\t6.666666\t7.5\t3.333333\t6.666666\t10\t6.622736\t7.872074\t4.906154
7.5\t7.766664\t9.999998\t6.666666\t7.5\t0\t9.999998\t0\t5.204007\t5.225747\t4.561047
7.5\t9.999998\t3.333333\t10\t7.5\t6.666666\t9.999998\t10\t5.509388\t6.202536\t4.586286
7.5\t9.999998\t9.999998\t7.766666\t7.5\t1.1\t6.666666\t6.666666\t5.26269\t5.820083\t3.948911
2.5\t3.333333\t6.666666\t6.666666\t5\t1.1\t6.666666\t0.3685\t4.70048\t5.023881\t4.394491
1.25\t0\t3.333333\t3.333333\t1.25\t3.333333\t3.333333\t3.333333\t5.209486\t4.465908\t4.510268
10\t9.999998\t9.999998\t10\t8.75\t9.999998\t9.999998\t10\t5.916202\t6.732211\t5.829084
7.5\t3.333299\t3.333333\t6.666666\t7.5\t2.233299\t6.666666\t2.948164\t6.523562\t6.992096\t6.424591
10\t9.999998\t9.999998\t10\t10\t9.999998\t9.999998\t10\t6.238325\t6.746412\t5.741711
1.25\t0\t0\t0\t2.5\t0\t0\t0\t5.976351\t6.712956\t5.948168
2.5\t0\t3.333333\t3.333333\t2.5\t0\t3.333333\t3.333333\t5.631212\t5.937536\t5.686755
7.5\t6.666666\t9.999998\t10\t7.5\t6.666666\t9.999998\t7.766666\t6.033086\t6.09357\t4.611429
8.5\t9.999998\t6.666666\t6.666666\t8.75\t9.999998\t7.351018\t6.666666\t6.196444\t6.704414\t5.475261
6.1\t0\t5.4\t3.333333\t0\t0\t4.696028\t3.333333\t4.248495\t2.70805\t1.74083
3.3\t0\t6.666666\t3.333333\t6.25\t0\t6.666666\t3.333333\t5.141664\t4.564348\t2.255134
2.9\t3.333333\t6.666666\t3.333333\t2.385559\t0\t3.177568\t1.116666\t4.174387\t3.688879\t3.046927
9.2\t0\t9.9\t3.333333\t7.60966\t0\t8.118828\t3.333333\t4.382027\t2.890372\t1.711279
6.9\t0\t6.666666\t3.333333\t4.226033\t0\t0\t0\t4.290459\t1.609438\t1.001674
2.9\t0\t3.333333\t3.333333\t5\t0\t3.333333\t3.333333\t4.934474\t4.234107\t1.418971
2\t0\t0\t0\t0\t0\t0\t0\t3.850148\t1.94591\t2.345229
5\t0\t3.333333\t3.333333\t5\t0\t3.333333\t3.333333\t5.181784\t4.394449\t3.167167
5\t0\t9.999998\t3.333333\t0\t0\t3.333333\t0.74437\t5.062595\t4.59512\t3.83497
4.1\t9.999998\t4.7\t6.666666\t3.75\t0\t7.827667\t6.666666\t4.691348\t4.143135\t2.255134
6.3\t9.999998\t9.999998\t6.666666\t6.25\t2.233333\t6.666666\t2.955702\t4.248495\t3.367296\t3.217506
5.2\t4.999998\t6.6\t3.333333\t3.633403\t1.1\t3.314128\t3.333333\t5.56452\t5.236442\t2.677633
5\t3.333333\t6.4\t6.666666\t2.844997\t0\t4.429657\t1.485166\t4.727388\t3.610918\t1.418971
3.1\t4.999998\t4.2\t5\t3.75\t0\t6.164304\t3.333333\t4.143135\t2.302585\t1.418971
4.1\t9.999998\t6.666666\t3.333333\t5\t0\t4.938089\t2.233333\t4.317488\t4.955827\t4.249888
5\t9.999998\t6.666666\t1.666666\t5\t0\t6.666666\t0.3685\t5.141664\t4.430817\t3.046927
5\t7.7\t6.666666\t8.399997\t6.25\t4.358243\t9.999998\t4.141377\t4.488636\t3.465736\t2.013579
5\t6.2\t9.999998\t6.060997\t5\t2.782771\t6.666666\t4.974739\t4.615121\t4.941642\t2.255134
5.6\t4.9\t0\t0\t6.555647\t4.055463\t6.666666\t3.821796\t3.850148\t2.397895\t1.74083
5.7\t4.8\t0\t0\t6.555647\t4.055463\t0\t0\t3.970292\t2.397895\t1.050741
7.5\t9.999998\t7.9\t6.666666\t3.75\t9.999998\t7.631891\t6.666666\t3.78419\t3.091042\t2.113313
2.5\t0\t6.666666\t3.333333\t2.5\t0\t0\t0\t3.806662\t2.079442\t2.137561
8.9\t9.999998\t9.7\t6.666666\t5\t9.999998\t9.556024\t6.666666\t4.532599\t3.610918\t1.587802
7.6\t0\t10\t0\t5\t1.1\t6.666666\t1.099999\t5.117994\t4.934474\t3.83497
7.8\t9.999998\t6.666666\t6.666666\t5\t3.333333\t6.666666\t6.666666\t5.049856\t5.111988\t4.38149
2.5\t0\t6.666666\t3.333333\t5\t0\t6.666666\t3.333333\t5.393628\t5.638355\t4.169451
3.8\t0\t5.1\t0\t3.75\t0\t6.666666\t1.485166\t4.477337\t3.931826\t2.474671
5\t3.333333\t3.333333\t2.233333\t5\t3.333333\t6.666666\t5.566663\t5.257495\t5.840642\t5.001796
6.25\t3.333333\t9.999998\t2.955702\t6.25\t5.566663\t9.999998\t6.666666\t5.379897\t5.505332\t3.299937
1.25\t0\t3.333333\t0\t2.5\t0\t0\t0\t5.298317\t6.274762\t4.38149
1.25\t0\t4.7\t0.736999\t2.5\t0\t3.333333\t3.333333\t4.859812\t5.669881\t3.537416
1.25\t0\t6.666666\t0\t2.5\t0\t5.228375\t0\t4.969813\t5.56452\t4.510268
7.5\t7.766664\t9.999998\t6.666666\t7.5\t3.333333\t9.999998\t6.666666\t6.011267\t6.253829\t5.001796
2.5\t0\t6.666666\t4.433333\t5\t0\t6.666666\t1.485166\t5.075174\t5.252273\t5.350708
7.5\t9.999998\t9.999998\t10\t8.75\t9.999998\t9.999998\t10\t6.736967\t7.125283\t6.330518
1.25\t0\t0\t0\t1.25\t0\t0\t0\t5.225747\t5.451038\t3.167167
1.25\t0\t0\t0\t0\t0\t0\t0\t4.025352\t1.791759\t2.657972
2.5\t0\t0\t0\t0\t0\t6.666666\t2.948164\t4.234107\t2.70805\t2.474671
6.25\t2.233299\t6.666666\t2.970332\t3.75\t3.333299\t6.666666\t3.333333\t4.644391\t5.56452\t3.046927
7.5\t9.999998\t9.999998\t10\t7.5\t9.999998\t9.999998\t10\t4.418841\t4.941642\t3.380653
5\t0\t6.1\t0\t5\t3.333333\t9.999998\t3.333333\t4.26268\t4.219508\t4.368462
7.5\t9.999998\t9.999998\t10\t3.75\t9.999998\t9.999998\t10\t4.875197\t4.70048\t3.83497
4.9\t2.233333\t9.999998\t0\t5\t0\t3.621989\t3.333333\t4.189655\t1.386294\t1.418971
5\t0\t8.2\t0\t5\t0\t0\t0\t4.521789\t4.127134\t2.113313
2.9\t3.333333\t6.666666\t3.333333\t2.5\t3.333333\t6.666666\t3.333333\t4.65396\t3.555348\t1.881917
5.4\t9.999998\t6.666666\t3.333333\t3.75\t6.666666\t6.666666\t1.485166\t4.477337\t3.091042\t1.987909
7.5\t8.8\t9.999998\t6.066666\t7.5\t6.666666\t9.999998\t6.666666\t5.337538\t5.631212\t3.491004
7.5\t7\t9.999998\t6.852998\t7.5\t6.34834\t6.666666\t7.508044\t6.12905\t6.403574\t5.001796
10\t6.666666\t9.999998\t10\t10\t6.666666\t9.999998\t10\t5.003946\t4.962845\t3.976994
3.75\t3.333333\t0\t0\t1.25\t3.333333\t0\t0\t4.488636\t4.89784\t2.867566",  mode="r"),

         br(),

         h3("Basic statistics"),
         verbatimTextOutput("textareasem"),

         br(),

         h3("Correlation"),
         verbatimTextOutput("correl.sem"),

         br(),

         strong("Scatter plot matrices"),
         br(),

         plotOutput("corPlot.sem"),

         br(),

         h3("SEM result"),

         verbatimTextOutput("result.sem"),

         br(),

         h3("Path diagram (Unstandardized estimates)"),

         plotOutput("semplot1"),

         br(),

         h3("Path diagram (Standardized estimates)"),

         plotOutput("semplot2"),

         br(),
         br(),


         strong('R session info'),
         verbatimTextOutput("info.sem")

),
navbarMenu("Model Options and Settings", icon = icon("wrench", lib = "font-awesome"),
tabPanel("Estimator Options", icon = icon("table", lib = "font-awesome"),

                 radioButtons("estimatoroptions", strong("Estimator Options"),
                              c("Maximum likelihood" = "ML",
                                "Generalized least squares" = "GLS",
                                "Weighted least squares (sometimes called ADF estimation)" = "WLS",
                                "Unweighted least squares" = "ULS",
                                "Diagonally weighted least squares" = "DWLS"
                              ), selected = "ML"),

                 br()

        ),
 tabPanel("Graphic Options", icon = icon("line-chart", lib = "font-awesome"),
         radioButtons("lay", strong("Plot Layout"),
                       c("Circle" = "circle",
                         "Circle2" = "circles",
                         "Tree" = "tree",
                         "Tree2" = "tree2",
                         "Spring" = "spring",
                         "Spring2" = "spring2"
                       ), selected = "tree", inline = TRUE),
         p("Tree"),
         p("The integrated tree-like layout. Places exogenous variables at the top and endogenous variables at the bottom. See 'details' for more details."),
         p("Tree2"),
         p("Calls the layout.reingold.tilford function from the igraph package (Csardi & Nepusz, 2006), which uses the Reingold-Tilford algorithm (Reingold & Tilford, 1981). Before calling the algorithm roots are chosen and a slightly modified version of the graph is used to produce consistent results. See 'details'."),
         p("Circle"),
         p("The same layout as tree, except that afterwards the horizontal levels of the layout are placed in circles. Especially useful for models with a large number of manifest variables and a relatively small number of latent variables."),
         p("Circle2"),
         p("The same layout as tree2, except that afterwards the horizontal levels of the layout are placed in circles"),
         p("Spring"),
         p("Calls the spring layout in qgraph, which uses the Fruchterman-reingold algorithm (Fruchterman & Reingold, 1991)."),

#         br(),
#         radioButtons("fitmeasures", strong("Fit Measures"),
#                       c("True" = TRUE,
#                         "False" = FALSE
#                       ), selected = "FALSE"),
#         br(),
#         radioButtons("standardized", strong("Show Standardized Solution"),
#                      c("True" = TRUE,
#                        "False" = FALSE
#                      ), selected = "FALSE"),
#         br(),
#         radioButtons("rsq", strong("Show R-Square values for the dependent variables in the model"),
#                      c("True" = TRUE,
#                        "False" = FALSE
#                      ), selected = "FALSE"),
#         br(),
#         radioButtons("modindices", strong("Print Modification Indices"),
#                      c("True" = TRUE,
#                        "False" = FALSE
#                      ), selected = "FALSE"),
          br()

 ),
tabPanel("Model Options", icon = icon("list", lib = "font-awesome"),

         radioButtons("orthogonaloptions", strong("Orthogonal"),
                      c("True" = "TRUE",
                        "False" = "FALSE"
                      ), selected = "FALSE"),
         br(),
         p("If TRUE is selected the exogenous latent variables are assumed to be uncorrelated, by defualt lavaan sets this to false"),
         br()

),
        tabPanel("Standard Errors Options", icon = icon("cog", lib = "font-awesome"),

                 radioButtons("seoptions", strong("Method for Computing Standard Errors"),
                              c("Conventional Standard Errors" = "standard",
                                "First-order Derivatives" = "first.order",
                                "Conventional Robust" = "robust.sem",
                                "Bootstrap" = "bootstrap",
                                "None" = "none"
                              ), selected = "standard"),
                 numericInput("bootstrapoptions", label = "Number of bootstrap draws, if bootstrapping is used." , value = 1000),
                br(),
                p("Using bootstrap will take some awhile even when hosted locally"),
                br()
        )),

        tabPanel("About", icon = icon("users", lib = "font-awesome"),

                 strong('List of Packages Used'), br(),
                 code('library(shiny)'),br(),
                 code('library(shinyAce)'),br(),
                 code('library(psych)'),br(),
            code('library(lavaan)'),br(),



            br(),

strong('Author'),

HTML('<div style="clear: left;"><img src="http://kylehamilton.com/wp-content/uploads/2014/11/kyle80.jpg" alt="" style="float: left; margin-right:5px" /></div>'),
p(a("W. Kyle Hamilton - University of California, Merced", href="http://www.kylehamilton.com", target="_blank")),
            br(),
            br(),
br(),
br(),
strong('License'),

p("lavaan.shiny version 1.1"),
p(" Copyright 2016  W. Kyle Hamilton"),

p(" This program is free software you can redistribute it and or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation either version 3 of the License or
  at your option any later version."),

p("This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details."),

p("You should have received a copy of the GNU General Public License
  along with this program.  If not, see", a("http://www.gnu.org/licenses/gpl.html", href="http://www.gnu.org/licenses/gpl.html", target="_blank"),br()),


br(),

strong('Futher Infomation'),
p("If you would like to learn more about the GNU General Public License and what it means tl'dr legal has a simple explaination which can be found here", a("https://www.tldrlegal.com/l/gpl-3.0", href="https://www.tldrlegal.com/l/gpl-3.0", target="_blank"),br()),


            p(br())

            )

# ))
))
