/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import edu.emory.mathcs.utils.IOUtils;
import java.util.Random;

public class AccuracyCheckFloatFFT {
    private static int[] sizesPrimes = new int[]{997, 4999, 9973, 49999, 99991, 249989};
    private static int[] sizesPower2 = new int[]{8192, 16384, 32768, 65536, 131072, 262144};
    private static final int niters = 10;
    private static Random r;

    private AccuracyCheckFloatFFT() {
    }

    public static void checkAccuracyRealFFT_1D() {
        DenseFloatMatrix1D denseFloatMatrix1D;
        DenseFComplexMatrix1D denseFComplexMatrix1D;
        DenseFloatMatrix1D denseFloatMatrix1D2;
        int n;
        int n2;
        System.out.println("Checking accuracy of 1D real forward full FFT (prime sizes)...");
        double[][] dArray = new double[10][sizesPrimes.length];
        for (n2 = 0; n2 < sizesPrimes.length; ++n2) {
            r = new Random(0L);
            for (n = 0; n < 10; ++n) {
                denseFloatMatrix1D2 = new DenseFloatMatrix1D(sizesPrimes[n2]);
                AccuracyCheckFloatFFT.fillMatrix_1D(sizesPrimes[n2], denseFloatMatrix1D2.elements());
                denseFComplexMatrix1D = denseFloatMatrix1D2.getFft();
                denseFComplexMatrix1D.ifft(true);
                denseFloatMatrix1D = (DenseFloatMatrix1D)denseFComplexMatrix1D.getRealPart();
                dArray[n][n2] = AccuracyCheckFloatFFT.computeRMSE(denseFloatMatrix1D2.elements(), denseFloatMatrix1D.elements());
            }
        }
        IOUtils.writeToFileReal_2D("%g", dArray, "pc_rmse_primes_float.txt");
        System.out.println("Checking accuracy of 1D real forward full FFT (power2 sizes)...");
        dArray = new double[10][sizesPower2.length];
        for (n2 = 0; n2 < sizesPower2.length; ++n2) {
            r = new Random(0L);
            for (n = 0; n < 10; ++n) {
                denseFloatMatrix1D2 = new DenseFloatMatrix1D(sizesPower2[n2]);
                AccuracyCheckFloatFFT.fillMatrix_1D(sizesPower2[n2], denseFloatMatrix1D2.elements());
                denseFComplexMatrix1D = denseFloatMatrix1D2.getFft();
                denseFComplexMatrix1D.ifft(true);
                denseFloatMatrix1D = (DenseFloatMatrix1D)denseFComplexMatrix1D.getRealPart();
                dArray[n][n2] = AccuracyCheckFloatFFT.computeRMSE(denseFloatMatrix1D2.elements(), denseFloatMatrix1D.elements());
            }
        }
        IOUtils.writeToFileReal_2D("%g", dArray, "pc_rmse_power2_float.txt");
    }

    private static double computeRMSE(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = fArray[i] - fArray2[i];
            f += f2 * f2;
        }
        return Math.sqrt(f / (float)fArray.length);
    }

    public static void main(String[] stringArray) {
        AccuracyCheckFloatFFT.checkAccuracyRealFFT_1D();
        System.exit(0);
    }

    private static void fillMatrix_1D(int n, float[] fArray) {
        for (int i = 0; i < n; ++i) {
            fArray[i] = r.nextFloat();
        }
    }
}

