/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.Expansion;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class ExpansionModel
extends DemographicModel
implements Citable {
    Parameter N0Parameter = null;
    Parameter N1Parameter = null;
    Parameter growthRateParameter = null;
    Expansion expansion = null;
    boolean usingGrowthRate = true;
    public static Citation CITATION = new Citation(new Author[]{new Author("OG", "Pybus"), new Author("A", "Rambaut")}, "GENIE: estimating demographic history from molecular phylogenies", 2001, "Bioinformatics", 18, 1404, 1405);

    public ExpansionModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Units.Type type, boolean bl) {
        this("expansion", parameter, parameter2, parameter3, type, bl);
    }

    public ExpansionModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Units.Type type, boolean bl) {
        super(string);
        this.expansion = new Expansion(type);
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.N1Parameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(1.0, 0.0, 1));
        this.growthRateParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.usingGrowthRate = bl;
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        double d = this.N0Parameter.getParameterValue(0);
        double d2 = this.N1Parameter.getParameterValue(0);
        double d3 = this.growthRateParameter.getParameterValue(0);
        if (this.usingGrowthRate) {
            this.expansion.setGrowthRate(d3);
        } else {
            double d4 = d3;
            d3 = Math.log(2.0) / d4;
            this.expansion.setDoublingTime(d4);
        }
        this.expansion.setN0(d);
        this.expansion.setProportion(d2);
        return this.expansion;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Expansion Coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

