/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula;

import java.util.List;
import org.vikamine.kernel.formula.ParserElement;
import org.vikamine.kernel.formula.TypeConverter;
import org.vikamine.kernel.formula.Validator;
import org.vikamine.kernel.formula.exception.TypeMismatchException;
import org.vikamine.kernel.formula.exception.ValidateException;

public class DefaultValidator
implements Validator {
    private List converters;

    @Override
    public void validate(ParserElement pe, Class type) throws ValidateException {
        if (!this.isValid(pe, type)) {
            throw new TypeMismatchException("type mismatch. Expected: type, Real: " + pe.getType(), pe, type, pe.getType());
        }
        assert (pe.getChildren().size() == pe.getRequiredArgumentsCount()) : "Wrong number of arguments. Expected: " + pe.getRequiredArgumentsCount() + ", Real: " + pe.getChildren().size();
        int i = 0;
        for (ParserElement child : pe.getChildren()) {
            this.validate(child, pe.getRequiredArgumentTypes()[i]);
            ++i;
        }
    }

    private boolean isValid(ParserElement pe, Class type) {
        if (type == null || pe.getType() == type) {
            return true;
        }
        if (this.converters == null) {
            return false;
        }
        for (TypeConverter conv : this.converters) {
            if (!conv.canConvert(pe.getType(), type)) continue;
            conv.convert(pe, type);
            return true;
        }
        return false;
    }

    public List getConverters() {
        return this.converters;
    }

    public void setConverters(List converters) {
        this.converters = converters;
    }
}

