/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.kernel.common.util.disposable.Disposable;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.set.AbstractLargeSetSConstraint;
import choco.kernel.solver.variables.set.SetVar;
import gnu.trove.TIntIntHashMap;
import java.util.Arrays;

public final class SetNaryUnion
extends AbstractLargeSetSConstraint {
    protected SetVar[] setVars;
    protected SetVar unionSet;
    protected IStateInt[] occurCpt;
    protected int offset;
    protected static final int UNION_SET_INDEX = 0;
    protected final IEnvironment environment;

    public SetNaryUnion(SetVar[] vars, IEnvironment environment) {
        super(vars);
        this.unionSet = vars[0];
        this.setVars = Arrays.copyOfRange(vars, 1, vars.length);
        this.environment = environment;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 7;
    }

    @Override
    public void awake() throws ContradictionException {
        int[] values;
        TIntIntHashMap allValues = new TIntIntHashMap();
        for (SetVar v : this.setVars) {
            DisposableIntIterator it = v.getDomain().getEnveloppeIterator();
            while (it.hasNext()) {
                int val = it.next();
                if (allValues.containsKey(val)) {
                    allValues.put(val, allValues.get(val) + 1);
                    continue;
                }
                allValues.put(val, 1);
            }
            it.dispose();
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int v : values = allValues.keys()) {
            max = v > max ? v : max;
            min = v < min ? v : min;
        }
        this.occurCpt = new IStateInt[max - min + 1];
        this.offset = min;
        for (int v : values) {
            this.occurCpt[v - this.offset] = this.environment.makeInt(allValues.get(v));
        }
        this.propagate();
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        if (varIdx > 0) {
            this.unionSet.addToKernel(x, this, false);
        } else {
            this.instanciateIfLastOccurence(x);
        }
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        if (varIdx == 0) {
            for (int idx = 0; idx < this.setVars.length; ++idx) {
                this.setVars[idx].remFromEnveloppe(x, this, false);
            }
        } else {
            this.decOccurence(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        Disposable it = null;
        try {
            if (varIdx == 0) {
                it = this.unionSet.getDomain().getKernelIterator();
                while (it.hasNext()) {
                    int val = it.next();
                    this.instanciateIfLastOccurence(val);
                }
            } else {
                int val;
                it = ((SetVar[])this.vars)[varIdx].getDomain().getKernelIterator();
                while (it.hasNext()) {
                    val = it.next();
                    this.unionSet.addToKernel(val, this, false);
                }
                it.dispose();
                it = ((SetVar[])this.vars)[varIdx].getDomain().getEnveloppeIterator();
                while (it.hasNext()) {
                    val = it.next();
                    if (this.getNbOccurence(val) != 0) continue;
                    this.unionSet.remFromEnveloppe(val, this, false);
                }
            }
        }
        finally {
            it.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagate() throws ContradictionException {
        Disposable it = null;
        try {
            int val;
            for (int idx = 0; idx < this.setVars.length; ++idx) {
                it = this.setVars[idx].getDomain().getKernelIterator();
                while (it.hasNext()) {
                    int val2 = it.next();
                    this.unionSet.addToKernel(val2, this, false);
                }
                it.dispose();
            }
            it = this.unionSet.getDomain().getKernelIterator();
            while (it.hasNext()) {
                val = it.next();
                this.instanciateIfLastOccurence(val);
            }
            it.dispose();
            it = this.unionSet.getDomain().getEnveloppeIterator();
            while (it.hasNext()) {
                val = it.next();
                if (this.getNbOccurence(val) != 0) continue;
                this.unionSet.remFromEnveloppe(val, this, false);
            }
        }
        finally {
            it.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSatisfied() {
        Disposable it = null;
        try {
            for (int idx = 0; idx < this.setVars.length; ++idx) {
                it = this.setVars[idx].getDomain().getKernelIterator();
                while (it.hasNext()) {
                    int val = it.next();
                    if (this.unionSet.isInDomainKernel(val)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            it = this.unionSet.getDomain().getKernelIterator();
            while (it.hasNext()) {
                int val = it.next();
                boolean isInASet = false;
                for (int idx = 0; idx < this.setVars.length; ++idx) {
                    if (!this.setVars[idx].isInDomainKernel(val)) continue;
                    isInASet = true;
                    break;
                }
                if (isInASet) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            it.dispose();
        }
    }

    @Override
    public boolean isConsistent() {
        return this.isSatisfied();
    }

    private int getNbOccurence(int x) {
        if (x >= this.offset && x < this.offset + this.occurCpt.length && this.occurCpt[x - this.offset] != null) {
            return this.occurCpt[x - this.offset].get();
        }
        return 0;
    }

    private void decOccurence(int x) throws ContradictionException {
        this.occurCpt[x - this.offset].add(-1);
        this.instanciateIfLastOccurence(x);
    }

    private void instanciateIfLastOccurence(int x) throws ContradictionException {
        if (this.occurCpt[x - this.offset].get() <= 1 && this.unionSet.isInDomainKernel(x)) {
            if (this.occurCpt[x - this.offset].get() <= 0) {
                this.fail();
            }
            int removed = 0;
            for (int idx = 0; idx < this.setVars.length; ++idx) {
                if (!this.setVars[idx].isInDomainEnveloppe(x)) continue;
                ++removed;
                this.setVars[idx].addToKernel(x, this, false);
            }
            if (removed == 0) {
                this.fail();
            }
            assert (removed == 1);
        }
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("Union({");
        for (int i = 0; i < this.setVars.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            SetVar var = this.setVars[i];
            sb.append(var.pretty());
        }
        sb.append("}) = " + this.unionSet.pretty());
        return sb.toString();
    }

    @Override
    public String toString() {
        String autstring = "Union : ";
        for (int i = 0; i < ((SetVar[])this.vars).length; ++i) {
            autstring = autstring + ((SetVar[])this.vars)[i] + " ";
        }
        autstring = autstring + this.unionSet;
        return autstring;
    }
}

