/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.StationaryTransformation;
import ec.tstoolkit.arima.estimation.AbstractRegArimaModel;
import ec.tstoolkit.arima.estimation.ArmaKF;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.matrices.Matrix;

public class RegArimaModel<M extends IArimaModel>
extends AbstractRegArimaModel
implements Cloneable {
    private M m_arima;
    private M m_arma;

    public RegArimaModel() {
    }

    protected RegArimaModel(AbstractRegArimaModel m) {
        super(m, false);
    }

    public RegArimaModel(M arima) {
        this.m_arima = arima;
    }

    public RegArimaModel(M arima, DataBlock y) {
        super(y);
        this.m_arima = arima;
    }

    @Override
    protected void calstationarymodel() {
        StationaryTransformation st = this.m_arima.stationaryTransformation();
        this.m_ur = st.unitRoots;
        this.m_arma = (IArimaModel)st.stationaryModel;
    }

    @Override
    public RegArimaModel<M> clone() {
        return (RegArimaModel)super.clone();
    }

    public M getArima() {
        return this.m_arima;
    }

    public M getArma() {
        if (this.m_arma == null) {
            this.calstationarymodel();
        }
        return this.m_arma;
    }

    public ConcentratedLikelihood computeLikelihood() {
        ConcentratedLikelihood ll = new ConcentratedLikelihood();
        M stmodel = this.getArma();
        RegModel dregs = this.getDModel();
        ArmaKF kf = new ArmaKF((IArimaModel)stmodel);
        Matrix dvars = dregs.variables();
        if (dvars == null) {
            if (kf.process(dregs.getY(), ll)) {
                return ll;
            }
            return null;
        }
        SubArrayOfInt ao = null;
        int nm = this.getMissingsCount();
        if (nm > 0) {
            int[] o = new int[nm];
            int del = this.isMeanCorrection() ? 1 : 0;
            for (int i = 0; i < nm; ++i) {
                o[i] = del + i;
            }
            ao = SubArrayOfInt.create(o);
        }
        if (kf.process(dregs.getY(), ao, dvars.subMatrix(), ll)) {
            return ll;
        }
        return null;
    }

    public void setArima(M value) {
        this.m_arima = value;
        StationaryTransformation st = this.m_arima.stationaryTransformation();
        BackFilter ur = st.unitRoots;
        IArimaModel arma = (IArimaModel)st.stationaryModel;
        if (this.m_ur != null && !this.m_ur.equals(ur)) {
            this.m_dregs = null;
        }
        this.m_ur = ur;
        this.m_arma = arma;
    }
}

