/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.GammaGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class GammaAcceptanceRejectionGen
extends GammaGen {
    private RandomStream auxStream;
    private static final double q1 = 0.0416666664;
    private static final double q2 = 0.0208333723;
    private static final double q3 = 0.0079849875;
    private static final double q4 = 0.0015746717;
    private static final double q5 = -3.349403E-4;
    private static final double q6 = 3.340332E-4;
    private static final double q7 = 6.053049E-4;
    private static final double q8 = -4.701849E-4;
    private static final double q9 = 1.71032E-4;
    private static final double a1 = 0.333333333;
    private static final double a2 = -0.249999949;
    private static final double a3 = 0.199999867;
    private static final double a4 = -0.166677482;
    private static final double a5 = 0.142873973;
    private static final double a6 = -0.124385581;
    private static final double a7 = 0.11036831;
    private static final double a8 = -0.112750886;
    private static final double a9 = 0.104089866;
    private static final double e1 = 1.0;
    private static final double e2 = 0.499999994;
    private static final double e3 = 0.166666848;
    private static final double e4 = 0.041664508;
    private static final double e5 = 0.008345522;
    private static final double e6 = 0.001353826;
    private static final double e7 = 2.47453E-4;
    private int gen;
    private double alpha;
    private double beta;
    private double gamma;
    private static final int gs = 0;
    private static final int gd = 1;
    private double b;
    private double ss;
    private double s;
    private double d;
    private double r;
    private double q0;
    private double c;
    private double si;

    public GammaAcceptanceRejectionGen(RandomStream randomStream, GammaDist gammaDist) {
        this(randomStream, randomStream, gammaDist);
    }

    public GammaAcceptanceRejectionGen(RandomStream randomStream, RandomStream randomStream2, GammaDist gammaDist) {
        super(randomStream, gammaDist);
        this.auxStream = randomStream2;
        this.alpha = gammaDist.getAlpha();
        this.beta = 1.0 / gammaDist.getLambda();
        this.gamma = 0.0;
        this.init();
    }

    public RandomStream getAuxStream() {
        return this.auxStream;
    }

    public static double nextDouble(RandomStream randomStream, RandomStream randomStream2, double d, double d2) {
        int n = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        if (d < 1.0) {
            n = 0;
            d10 = 1.0 + 0.36788794412 * d;
        } else {
            n = 1;
            d4 = d - 0.5;
            d3 = Math.sqrt(d4);
            d5 = 5.656854249 - 12.0 * d3;
            d7 = 1.0 / d;
            d6 = ((((((((1.71032E-4 * d7 + -4.701849E-4) * d7 + 6.053049E-4) * d7 + 3.340332E-4) * d7 + -3.349403E-4) * d7 + 0.0015746717) * d7 + 0.0079849875) * d7 + 0.0208333723) * d7 + 0.0416666664) * d7;
            if (d > 3.686) {
                if (d > 13.022) {
                    d10 = 1.77;
                    d9 = 0.75;
                    d8 = 0.1515 / d3;
                } else {
                    d10 = 1.654 + 0.0076 * d4;
                    d9 = 1.68 / d3 + 0.275;
                    d8 = 0.062 / d3 + 0.024;
                }
            } else {
                d10 = 0.463 + d3 - 0.178 * d4;
                d9 = 1.235;
                d8 = 0.195 / d3 - 0.079 + 0.016 * d3;
            }
        }
        return GammaAcceptanceRejectionGen.acceptanceRejection(randomStream, randomStream2, d, 1.0 / d2, 0.0, n, d10, d3, d4, d5, d7, d6, d8, d9);
    }

    public double nextDouble() {
        return GammaAcceptanceRejectionGen.acceptanceRejection(this.stream, this.auxStream, this.alpha, this.beta, this.gamma, this.gen, this.b, this.s, this.ss, this.d, this.r, this.q0, this.c, this.si);
    }

    public static double nextDouble(RandomStream randomStream, double d, double d2) {
        return GammaAcceptanceRejectionGen.nextDouble(randomStream, randomStream, d, d2);
    }

    private static double acceptanceRejection(RandomStream randomStream, RandomStream randomStream2, double d, double d2, double d3, int n, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        double d12;
        block0 : switch (n) {
            case 0: {
                while (true) {
                    double d13 = d4 * randomStream.nextDouble();
                    randomStream = randomStream2;
                    if (d13 <= 1.0) {
                        d12 = Math.exp(Math.log(d13) / d);
                        if (!(Math.log(randomStream.nextDouble()) <= -d12)) continue;
                        break block0;
                    }
                    d12 = -Math.log((d4 - d13) / d);
                    if (Math.log(randomStream.nextDouble()) <= (d - 1.0) * Math.log(d12)) break;
                }
                break;
            }
            case 1: {
                double d14;
                double d15;
                double d16;
                double d17;
                double d18;
                double d19;
                double d20 = NormalDist.inverseF01(randomStream.nextDouble());
                randomStream = randomStream2;
                double d21 = d5 + 0.5 * d20;
                d12 = d21 * d21;
                if (d20 >= 0.0 || d7 * (d19 = randomStream.nextDouble()) <= d20 * d20 * d20) break;
                if (d21 > 0.0) {
                    d18 = d20 / (d5 + d5);
                    d17 = Math.abs(d18) > 0.25 ? d9 - d5 * d20 + 0.25 * d20 * d20 + (d6 + d6) * Math.log(1.0 + d18) : d9 + 0.5 * d20 * d20 * ((((((((0.104089866 * d18 + -0.112750886) * d18 + 0.11036831) * d18 + -0.124385581) * d18 + 0.142873973) * d18 + -0.166677482) * d18 + 0.199999867) * d18 + -0.249999949) * d18 + 0.333333333) * d18;
                    if (Math.log(1.0 - d19) <= d17) break;
                }
                do {
                    d16 = -Math.log(randomStream.nextDouble());
                    d19 = randomStream.nextDouble();
                } while ((d20 = d4 + d16 * d11 * (d15 = (d19 = d19 + d19 - 1.0) > 0.0 ? 1.0 : -1.0)) <= -0.71874483771719 || (d17 = Math.abs(d18 = d20 / (d5 + d5)) > 0.25 ? d9 - d5 * d20 + 0.25 * d20 * d20 + (d6 + d6) * Math.log(1.0 + d18) : d9 + 0.5 * d20 * d20 * ((((((((0.104089866 * d18 + -0.112750886) * d18 + 0.11036831) * d18 + -0.124385581) * d18 + 0.142873973) * d18 + -0.166677482) * d18 + 0.199999867) * d18 + -0.249999949) * d18 + 0.333333333) * d18) <= 0.0 || !(d10 * d19 * d15 <= (d14 = d17 > 0.5 ? Math.exp(d17) - 1.0 : ((((((2.47453E-4 * d17 + 0.001353826) * d17 + 0.008345522) * d17 + 0.041664508) * d17 + 0.166666848) * d17 + 0.499999994) * d17 + 1.0) * d17) * Math.exp(d16 - 0.5 * d20 * d20)));
                d21 = d5 + 0.5 * d20;
                d12 = d21 * d21;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return d3 + d2 * d12;
    }

    private void init() {
        if (this.alpha < 1.0) {
            this.gen = 0;
            this.b = 1.0 + 0.36788794412 * this.alpha;
        } else {
            this.gen = 1;
            this.ss = this.alpha - 0.5;
            this.s = Math.sqrt(this.ss);
            this.d = 5.656854249 - 12.0 * this.s;
            this.r = 1.0 / this.alpha;
            this.q0 = ((((((((1.71032E-4 * this.r + -4.701849E-4) * this.r + 6.053049E-4) * this.r + 3.340332E-4) * this.r + -3.349403E-4) * this.r + 0.0015746717) * this.r + 0.0079849875) * this.r + 0.0208333723) * this.r + 0.0416666664) * this.r;
            if (this.alpha > 3.686) {
                if (this.alpha > 13.022) {
                    this.b = 1.77;
                    this.si = 0.75;
                    this.c = 0.1515 / this.s;
                } else {
                    this.b = 1.654 + 0.0076 * this.ss;
                    this.si = 1.68 / this.s + 0.275;
                    this.c = 0.062 / this.s + 0.024;
                }
            } else {
                this.b = 0.463 + this.s - 0.178 * this.ss;
                this.si = 1.235;
                this.c = 0.195 / this.s - 0.079 + 0.016 * this.s;
            }
        }
    }
}

