/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.editor.FindReplaceDialog;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.IconButton;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.DocumentRenderer;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXP;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;

public class JGRHelp
extends TJFrame
implements ActionListener,
KeyListener,
MouseListener {
    private static final long serialVersionUID = 674422754541012924L;
    public static JGRHelp current = null;
    private static String index;
    private static String server;
    private static String searchString;
    private final String keyWord;
    private final JPanel topPanel = new JPanel();
    private final JTabbedPane tabArea = new JTabbedPane();
    private final JTextField inputKeyWord = new JTextField();
    private final JButton search = new JButton("Search");
    private final JPanel options = new JPanel(new FlowLayout(1));
    private final JCheckBox exactMatch = new JCheckBox("Exact Match", true);
    private final JCheckBox searchDesc = new JCheckBox("Help Page Titles", true);
    private final JCheckBox searchKeyWords = new JCheckBox("Keywords", false);
    private final JCheckBox searchAliases = new JCheckBox("Object Names", false);
    private final JCheckBox searchConcepts = new JCheckBox("Concepts", false);
    public JLabel link = new JLabel(" ");
    private HelpArea helpArea;
    private IconButton back;
    private IconButton forward;

    public JGRHelp() {
        this((String)null);
    }

    public JGRHelp(String location) {
        super("Help", false, 16);
        this.keyWord = null;
        while (!JGR.STARTED) {
        }
        String[] Menu = new String[]{"+", "File", "@PPrint", "print", "+", "Edit", "@CCopy", "copy", "-", "@RRun selection", "runselection", "@FFind", "search", "@GFind Next", "searchnext", "~Window", "~About", "0"};
        EzMenuSwing.getEzMenu(this, this, Menu);
        if (location != null) {
            int index1 = location.indexOf("127.0.0.1");
            if (index1 > 0) {
                int index2 = location.indexOf("/", index1 + "127.0.0.1".length());
                server = location.substring(0, index2);
            }
        } else {
            try {
                REXP port = JGR.timedEval("tools:::httpdPort");
                server = "http://127.0.0.1:" + port.asString();
            }
            catch (Exception port) {
                // empty catch block
            }
        }
        try {
            REXP minorVersion = JGR.timedEval("version$minor");
            REXP majorVersion = JGR.timedEval("version$major");
            searchString = Double.parseDouble(minorVersion.asString()) >= 14.0 || Double.parseDouble(majorVersion.asString()) >= 3.0 ? "pattern" : "name";
        }
        catch (Exception e) {
            searchString = "name";
        }
        index = server + "/doc/html/packages.html";
        this.search.setActionCommand("searchHelp");
        this.search.addActionListener(this);
        this.getRootPane().setDefaultButton(this.search);
        FontTracker.current.add(this.inputKeyWord);
        this.inputKeyWord.setMinimumSize(new Dimension(150, 25));
        this.inputKeyWord.setPreferredSize(new Dimension(300, 25));
        this.inputKeyWord.setMaximumSize(new Dimension(350, 25));
        this.inputKeyWord.setEditable(true);
        this.options.add(this.exactMatch);
        this.options.add(this.searchDesc);
        this.options.add(this.searchKeyWords);
        this.options.add(this.searchAliases);
        this.options.add(this.searchConcepts);
        JPanel top1 = new JPanel(new FlowLayout(0));
        top1.add(this.inputKeyWord);
        top1.add(this.search);
        top1.add(new Spacer(30));
        this.back = new IconButton("/icons/back.png", "Back", this, "back");
        top1.add(this.back);
        top1.add(new IconButton("/icons/home.png", "Home", this, "home"));
        this.forward = new IconButton("/icons/forward.png", "Forward", this, "forward");
        top1.add(this.forward);
        this.topPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.topPanel.add((Component)top1, gbc);
        gbc.gridy = 1;
        this.topPanel.add((Component)this.options, gbc);
        this.back.setEnabled(false);
        this.forward.setEnabled(false);
        this.link.setPreferredSize(new Dimension(200, 20));
        this.helpArea = new HelpArea(this.tabArea, this, null);
        this.helpArea.addKeyListener(this);
        this.tabArea.addTab(this.keyWord == null ? "packages" : this.keyWord, new CloseIcon(this.getClass().getResource("/icons/close.png")), this.helpArea);
        this.tabArea.addMouseListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.topPanel, "North");
        this.getContentPane().add((Component)this.tabArea, "Center");
        this.getContentPane().add((Component)this.link, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JGRHelp.this.exit();
            }
        });
        this.setMinimumSize(new Dimension(570, 600));
        this.setSize(new Dimension(600, Common.screenRes.height < 800 ? Common.screenRes.height - 50 : 700));
        this.setLocation(Common.screenRes.width - this.getSize().width - 50, 10);
        super.setVisible(true);
        this.inputKeyWord.requestFocus();
        current = this;
        if (location != null) {
            this.showURLInternal(location, null);
        }
    }

    public static void showURL(final String url) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (current == null) {
                    current = new JGRHelp(url);
                } else {
                    current.showURLInternal(url, null);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public static void searchHelp(String keyword) {
        if (current == null) {
            current = new JGRHelp();
            current.search(keyword);
        } else {
            current.search(keyword);
        }
    }

    public void showURLInternal(String location, String titleSearch) {
        if (location != null && !location.equals("")) {
            try {
                if (this.tabArea.getComponents().length > 0 && ((HelpArea)this.tabArea.getComponentAt((int)0)).helpPane.getText().indexOf("No matches for") >= 0) {
                    this.tabArea.remove(0);
                }
            }
            catch (Exception e) {
                new ErrorMsg(e);
            }
            String title = "Help";
            if (titleSearch != null) {
                title = "Result: " + titleSearch;
            } else if (location.indexOf("/doc/html/Search?") > 0) {
                title = "Seach Result ";
            } else {
                try {
                    title = location.toString().substring(location.toString().lastIndexOf("/") + 1);
                    title = title.substring(0, title.lastIndexOf(46));
                }
                catch (Exception e) {
                    title = location.toString();
                }
            }
            if (this.tabArea.getTabCount() == JGRPrefs.maxHelpTabs) {
                this.tabArea.remove(JGRPrefs.maxHelpTabs - 1);
            }
            this.tabArea.add((Component)new HelpArea(this.tabArea, this, location), 0);
            this.tabArea.setSelectedIndex(0);
            this.tabArea.setIconAt(0, new CloseIcon(current.getClass().getResource("/icons/close.png")));
            this.tabArea.setTitleAt(0, title);
        }
    }

    public void print() {
        DocumentRenderer docrender = new DocumentRenderer();
        docrender.print(((HelpArea)this.tabArea.getSelectedComponent()).helpPane);
    }

    private void back() {
        ((HelpArea)this.tabArea.getSelectedComponent()).back();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JGRHelp.this.helpArea.reposition();
            }
        });
    }

    private void home() {
        ((HelpArea)this.tabArea.getSelectedComponent()).goTo(index, true);
    }

    private void forward() {
        ((HelpArea)this.tabArea.getSelectedComponent()).forward();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JGRHelp.this.helpArea.reposition();
            }
        });
    }

    private void exit() {
        current = null;
        this.finalize();
        this.dispose();
    }

    public void search() {
        String keyword = this.inputKeyWord.getText().trim();
        if (keyword == null) {
            return;
        }
        this.search(keyword);
    }

    public void search(String keyword) {
        if (keyword == null) {
            return;
        }
        String url = server + "/doc/html/Search?" + searchString + "=" + keyword.trim();
        if (this.exactMatch.isSelected()) {
            url = url + "&exact=1";
        }
        if (this.searchDesc.isSelected()) {
            url = url + "&title=1";
        }
        if (this.searchKeyWords.isSelected()) {
            url = url + "keyword=1";
        }
        if (this.searchAliases.isSelected()) {
            url = url + "alias=1";
        }
        if (this.searchConcepts.isSelected()) {
            url = url + "concept=1";
        }
        this.showURLInternal(url, keyword.trim());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "back") {
            this.back();
        } else if (cmd == "copy") {
            ((HelpArea)this.tabArea.getSelectedComponent()).helpPane.copy();
        } else if (cmd == "exit") {
            this.exit();
        } else if (cmd == "forward") {
            this.forward();
        } else if (cmd == "home") {
            try {
                this.home();
            }
            catch (Exception ex) {
                new ErrorMsg(ex);
            }
        } else if (cmd == "print") {
            this.print();
        } else if (cmd == "runselection") {
            try {
                String s = ((HelpArea)this.tabArea.getSelectedComponent()).helpPane.getSelectedText().trim();
                if (s.length() > 0) {
                    JGR.MAINRCONSOLE.execute(s.trim(), true);
                }
            }
            catch (Exception exception) {}
        } else if (cmd == "selAll") {
            ((HelpArea)this.tabArea.getSelectedComponent()).helpPane.selectAll();
        } else if (cmd == "searchHelp") {
            this.search();
        } else if (cmd == "search") {
            FindReplaceDialog.findExt(this, ((HelpArea)this.tabArea.getSelectedComponent()).helpPane);
        } else if (cmd == "searchnext") {
            FindReplaceDialog.findNextExt(this, ((HelpArea)this.tabArea.getSelectedComponent()).helpPane);
        } else if (cmd == "tab_close") {
            this.tabArea.remove(this.tabArea.getSelectedIndex());
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        if (System.getProperty("os.name").indexOf("Mac") == -1) {
            this.getRootPane().setDefaultButton(this.search);
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 10 && ke.isControlDown() && System.getProperty("os.name").indexOf("Mac") == -1) {
            try {
                if (((JTextComponent)ke.getComponent()).getSelectedText().trim().length() > 0) {
                    this.getRootPane().setDefaultButton(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        String cmd;
        if ((ke.isMetaDown() || ke.isControlDown()) && ke.getKeyCode() == 10 && (cmd = ((JTextComponent)ke.getComponent()).getSelectedText().trim()).length() > 0) {
            JGR.MAINRCONSOLE.execute(cmd, true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int tabNumber = this.tabArea.getUI().tabForCoordinate(this.tabArea, e.getX(), e.getY());
        if (tabNumber < 0) {
            return;
        }
        Rectangle rect = ((CloseIcon)this.tabArea.getIconAt(tabNumber)).getBounds();
        if (rect.contains(e.getX(), e.getY())) {
            this.tabArea.remove(tabNumber);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class Spacer
    extends JPanel {
        private static final long serialVersionUID = -6276846968522042614L;

        public Spacer(int width) {
            this.setMinimumSize(new Dimension(width, 0));
            this.setMaximumSize(new Dimension(width, 0));
            this.setPreferredSize(new Dimension(width, 0));
        }
    }

    class CloseIcon
    extends ImageIcon {
        private static final long serialVersionUID = 7083118485073055561L;
        private int x;
        private int y;
        private int width;
        private int height;

        public CloseIcon(URL url) {
            super(url);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.x = x;
            this.y = y;
            this.width = this.getIconWidth();
            this.height = this.getIconHeight();
            super.paintIcon(c, g, x, y);
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }
    }

    public class HelpArea
    extends JScrollPane {
        private static final long serialVersionUID = -6175984770162069827L;
        private final Vector history = new Vector();
        private final Vector viewportLocationHistory = new Vector();
        public JEditorPane helpPane = new JEditorPane();
        private JGRHelp rhelp;
        private int currentURLIndex = -1;
        private JTabbedPane tabArea = null;

        public HelpArea(JTabbedPane parent, JGRHelp rhelp, String location) {
            this.rhelp = rhelp;
            this.tabArea = parent;
            FontTracker.current.add(this.helpPane);
            this.getViewport().add(this.helpPane);
            this.setVerticalScrollBarPolicy(22);
            this.helpPane.setEditable(false);
            this.helpPane.setContentType("text/html");
            this.helpPane.addKeyListener(rhelp);
            this.helpPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                        if (JGRHelp.this.link != null) {
                            JGRHelp.this.link.setText(e.getURL().toString());
                        }
                    } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                        if (JGRHelp.this.link != null) {
                            JGRHelp.this.link.setText(" ");
                        }
                    } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        HelpArea.this.goTo(e.getURL(), true);
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    HelpArea.this.setButtons();
                }
            });
            if (location == null) {
                this.goTo(index);
            } else {
                this.goTo(location);
            }
        }

        private void setButtons() {
            JGRHelp.this.back.setEnabled(this.currentURLIndex > 0);
            JGRHelp.this.forward.setEnabled(this.currentURLIndex + 1 < this.history.size());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updatePage(boolean href) {
            this.rhelp.setWorking(true);
            this.rhelp.back.setEnabled(this.currentURLIndex > 0);
            this.rhelp.forward.setEnabled(this.currentURLIndex + 1 < this.history.size());
            URL url = (URL)this.history.get(this.currentURLIndex);
            try {
                this.helpPane.setPage(url);
            }
            catch (IOException ex) {
                new ErrorMsg(ex);
                try {
                    this.history.remove(this.currentURLIndex);
                    this.viewportLocationHistory.remove(this.currentURLIndex);
                    --this.currentURLIndex;
                    this.rhelp.back.setEnabled(this.currentURLIndex > 0);
                    this.rhelp.forward.setEnabled(this.currentURLIndex + 1 < this.history.size());
                    url = (URL)this.history.get(this.currentURLIndex);
                }
                catch (Exception e) {
                    new ErrorMsg(e);
                    JOptionPane.showMessageDialog(this, ex.getMessage(), "URL Error", 0);
                }
            }
            catch (Exception e) {
                new ErrorMsg(e);
            }
            finally {
                if (href) {
                    try {
                        String title = url.toString().substring(url.toString().lastIndexOf("/") + 1);
                        title = title.substring(0, Math.max(0, title.lastIndexOf(46)));
                        int index = this.tabArea.getSelectedIndex();
                        if (index >= 0 && !title.matches("^[0-9][0-9].*") || title.startsWith("http")) {
                            this.tabArea.setTitleAt(index, title);
                        } else {
                            int i = url.toString().indexOf("htm");
                            title = url.toString().substring(0, i - 1);
                            title = title.substring(title.lastIndexOf("/") + 1);
                            if (index >= 0 && !title.matches("^[0-9][0-9].*") || title.startsWith("http")) {
                                this.tabArea.setTitleAt(index, title);
                            }
                        }
                        this.getViewport().setViewPosition((Point)this.viewportLocationHistory.get(this.currentURLIndex));
                    }
                    catch (Exception ex2) {
                        new ErrorMsg(ex2);
                    }
                }
                this.rhelp.setWorking(false);
            }
            this.getViewport().setViewPosition((Point)this.viewportLocationHistory.get(this.currentURLIndex));
        }

        private void back() {
            if (this.currentURLIndex + 2 < this.viewportLocationHistory.size()) {
                this.viewportLocationHistory.setElementAt(this.getViewport().getViewPosition(), this.currentURLIndex + 1);
            } else {
                this.viewportLocationHistory.add(this.getViewport().getViewPosition());
            }
            --this.currentURLIndex;
            this.updatePage(true);
        }

        private void forward() {
            this.viewportLocationHistory.setElementAt(this.getViewport().getViewPosition(), this.currentURLIndex + 1);
            ++this.currentURLIndex;
            this.updatePage(true);
        }

        public void reposition() {
            try {
                Thread.sleep(100L);
                this.getViewport().setViewPosition((Point)this.viewportLocationHistory.get(this.currentURLIndex + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void goTo(URL url) {
            this.goTo(url, false);
        }

        public void goTo(URL url, boolean href) {
            if (url != null) {
                final URL url1 = url;
                final boolean href1 = href;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        HelpArea.this.currentURLIndex++;
                        HelpArea.this.history.setSize(HelpArea.this.currentURLIndex);
                        HelpArea.this.history.add(url1);
                        HelpArea.this.viewportLocationHistory.setSize(HelpArea.this.currentURLIndex);
                        HelpArea.this.viewportLocationHistory.add(HelpArea.this.getViewport().getViewPosition());
                        HelpArea.this.updatePage(href1);
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        }

        public void goTo(String url) {
            this.goTo(url, false);
        }

        public void goTo(String url_l, boolean href) {
            URL url = null;
            try {
                url = new URL(url_l);
                this.goTo(url, href);
            }
            catch (MalformedURLException e) {
                new ErrorMsg(e);
                JOptionPane.showMessageDialog(null, e.getMessage(), "URL Error", 0);
                return;
            }
        }
    }
}

