/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.alignments;

import java.util.Random;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.alignments.ResampledAlignment;

public class JackknifedAlignment
extends ResampledAlignment {
    public JackknifedAlignment(Alignment srcAlignment, double percent) {
        this(srcAlignment, percent, new Random());
    }

    public JackknifedAlignment(Alignment srcAlignment, double percent, long seed) {
        this(srcAlignment, percent, new Random(seed));
    }

    public JackknifedAlignment(Alignment srcAlignment, double percent, Random r) {
        int nSites = srcAlignment.getSiteCount();
        int nNewSites = (int)Math.ceil((double)nSites * percent);
        int[] sites = new int[nSites];
        for (int n = 0; n < nSites; ++n) {
            sites[n] = n;
        }
        this.shuffle(sites, r);
        int[] newSites = new int[nNewSites];
        System.arraycopy(sites, 0, newSites, 0, nNewSites);
        this.init(srcAlignment, newSites);
    }

    private void shuffle(int[] array, Random random) {
        int l = array.length;
        for (int i = 0; i < l; ++i) {
            int index = random.nextInt(l - i) + i;
            int temp = array[index];
            array[index] = array[i];
            array[i] = temp;
        }
    }
}

