/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.substmodel.AbstractNucleotideModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class GTR
extends AbstractNucleotideModel
implements Citable {
    private Variable<Double> rateACValue = null;
    private Variable<Double> rateAGValue = null;
    private Variable<Double> rateATValue = null;
    private Variable<Double> rateCGValue = null;
    private Variable<Double> rateCTValue = null;
    private Variable<Double> rateGTValue = null;
    public static Citation CITATION = new Citation(new Author[]{new Author("S", "Tavar\u00e9")}, "Some probabilistic and statistical problems in the analysis of DNA sequences", 1985, "In: Miura R. M., editor. Lectures on mathematics in the life sciences.", 17, 57, 86);

    public GTR(Variable variable, Variable variable2, Variable variable3, Variable variable4, Variable variable5, Variable variable6, FrequencyModel frequencyModel) {
        super("gtrModel", frequencyModel);
        if (variable != null) {
            this.addVariable(variable);
            variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.rateACValue = variable;
        }
        if (variable2 != null) {
            this.addVariable(variable2);
            variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.rateAGValue = variable2;
        }
        if (variable3 != null) {
            this.addVariable(variable3);
            variable3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.rateATValue = variable3;
        }
        if (variable4 != null) {
            this.addVariable(variable4);
            variable4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.rateCGValue = variable4;
        }
        if (variable5 != null) {
            this.addVariable(variable5);
            variable5.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.rateCTValue = variable5;
        }
        if (variable6 != null) {
            this.addVariable(variable6);
            variable6.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
            this.rateGTValue = variable6;
        }
    }

    public void setAbsoluteRates(double[] dArray, int n) {
        for (int i = 0; i < this.relativeRates.length; ++i) {
            this.relativeRates[i] = dArray[i] / dArray[n];
        }
        this.updateMatrix = true;
        this.fireModelChanged();
    }

    public void setRelativeRates(double[] dArray) {
        System.arraycopy(dArray, 0, this.relativeRates, 0, this.relativeRates.length);
        this.updateMatrix = true;
        this.fireModelChanged();
    }

    @Override
    protected void setupRelativeRates() {
        if (this.rateACValue != null) {
            this.relativeRates[0] = this.rateACValue.getValue(0);
        }
        if (this.rateAGValue != null) {
            this.relativeRates[1] = this.rateAGValue.getValue(0);
        }
        if (this.rateATValue != null) {
            this.relativeRates[2] = this.rateATValue.getValue(0);
        }
        if (this.rateCGValue != null) {
            this.relativeRates[3] = this.rateCGValue.getValue(0);
        }
        if (this.rateCTValue != null) {
            this.relativeRates[4] = this.rateCTValue.getValue(0);
        }
        if (this.rateGTValue != null) {
            this.relativeRates[5] = this.rateGTValue.getValue(0);
        }
    }

    public String toXHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<em>GTR Model</em> Instantaneous Rate Matrix = <table><tr><td></td><td>A</td><td>C</td><td>G</td><td>T</td></tr>");
        stringBuffer.append("<tr><td>A</td><td></td><td>");
        stringBuffer.append(this.relativeRates[0]);
        stringBuffer.append("</td><td>");
        stringBuffer.append(this.relativeRates[1]);
        stringBuffer.append("</td><td>");
        stringBuffer.append(this.relativeRates[2]);
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td>C</td><td></td><td></td><td>");
        stringBuffer.append(this.relativeRates[3]);
        stringBuffer.append("</td><td>");
        stringBuffer.append(this.relativeRates[4]);
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td>G</td><td></td><td></td><td></td><td>");
        stringBuffer.append(this.relativeRates[5]);
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td>G</td><td></td><td></td><td></td><td></td></tr></table>");
        return stringBuffer.toString();
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "GTR nucleotide substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

