/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.shrinkage;

import dr.inference.distribution.IndependentInverseGammaDistributionModel;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.distributions.InverseGammaDistribution;

public class ShrinkageGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    IndependentInverseGammaDistributionModel localPrior;
    IndependentInverseGammaDistributionModel globalPrior;
    Parameter data;
    double pathParameter;
    final boolean usePathParameter = true;

    public ShrinkageGibbsOperator(double d, IndependentInverseGammaDistributionModel independentInverseGammaDistributionModel, IndependentInverseGammaDistributionModel independentInverseGammaDistributionModel2, Parameter parameter) {
        this.setWeight(d);
        this.localPrior = independentInverseGammaDistributionModel;
        this.globalPrior = independentInverseGammaDistributionModel2;
        this.data = parameter;
        this.pathParameter = 1.0;
    }

    public int getStepCount() {
        return 0;
    }

    @Override
    public String getOperatorName() {
        return "ShrinkageGibbsOperator";
    }

    @Override
    public double doOperation() {
        Parameter parameter = this.localPrior.getData();
        Parameter parameter2 = this.localPrior.getShape();
        Parameter parameter3 = this.localPrior.getScale();
        Parameter parameter4 = this.globalPrior.getData();
        Parameter parameter5 = this.globalPrior.getShape();
        Parameter parameter6 = this.globalPrior.getScale();
        for (int i = 0; i < parameter.getDimension(); ++i) {
            double d = parameter3.getParameterValue(i) + this.data.getParameterValue(i) * this.data.getParameterValue(i) / (2.0 * parameter4.getParameterValue(0));
            double d2 = InverseGammaDistribution.nextInverseGamma(parameter2.getParameterValue(i) + 0.5, d);
            parameter.setParameterValueQuietly(i, d2);
        }
        parameter.fireParameterChangedEvent();
        double d = (double)(parameter.getDimension() / 2) + parameter5.getParameterValue(0);
        double d3 = parameter6.getParameterValue(0);
        for (int i = 0; i < parameter.getDimension(); ++i) {
            d3 += 0.5 * (this.data.getParameterValue(i) * this.data.getParameterValue(i)) / parameter.getParameterValue(i);
        }
        double d4 = InverseGammaDistribution.nextInverseGamma(d, d3);
        parameter4.setParameterValue(0, d4);
        return 0.0;
    }
}

