/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.GeneralBoundsProvider;
import dr.inference.model.Parameter;

public interface GraphicalParameterBound
extends GeneralBoundsProvider {
    public Parameter getParameter();

    public int[] getConnectedParameterIndices(int var1);

    public double getFixedLowerBound(int var1);

    public double getFixedUpperBound(int var1);

    public static class FixedBound
    implements GraphicalParameterBound {
        private final Parameter parameter;
        private final Bounds<Double> bounds;

        public FixedBound(Parameter parameter) {
            this.parameter = parameter;
            this.bounds = parameter.getBounds();
        }

        @Override
        public Parameter getParameter() {
            return this.parameter;
        }

        @Override
        public int[] getConnectedParameterIndices(int n) {
            return null;
        }

        @Override
        public double getFixedLowerBound(int n) {
            return this.bounds.getLowerLimit(n);
        }

        @Override
        public double getFixedUpperBound(int n) {
            return this.bounds.getUpperLimit(n);
        }
    }
}

