/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.sliq;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.classifier.sliq.AttributeList;
import dmLab.classifier.sliq.ClassListEvent;
import dmLab.classifier.sliq.ClassProxyEvent;
import dmLab.classifier.sliq.SliqNode;
import dmLab.classifier.sliq.SliqTree;
import java.util.ArrayList;

final class ClassList {
    private ClassListEvent[] events;
    private int decAttrIndex;
    private int eventsNumber;
    private ArrayList<ClassProxyEvent> proxies;
    private int proxiesNumber;

    public ClassList(FArray trainArray) {
        this.decAttrIndex = trainArray.getDecAttrIdx();
        this.eventsNumber = ((Array)trainArray).rowsNumber();
        this.events = new ClassListEvent[this.eventsNumber];
        for (int i = 0; i < this.eventsNumber; ++i) {
            this.events[i] = new ClassListEvent();
            this.events[i].classIndex = i;
            this.events[i].classLabel = trainArray.readValue(this.decAttrIndex, i);
        }
        ClassList classList = this;
        classList.quickSort(0, classList.eventsNumber - 1);
        classList = this;
        this.proxies = new ArrayList();
        int n = 0;
        float f = classList.events[0].classLabel;
        classList.proxies.add(new ClassProxyEvent(f));
        classList.events[0].proxyIndex = 0;
        for (int i = 1; i < classList.eventsNumber; ++i) {
            if (classList.events[i].classLabel != f) {
                f = classList.events[i].classLabel;
                classList.proxies.add(new ClassProxyEvent(f));
            }
            classList.events[i].proxyIndex = ++n;
        }
        ClassListEvent[] classListEventArray = new ClassListEvent[classList.eventsNumber];
        for (int i = 0; i < classList.eventsNumber; ++i) {
            classListEventArray[classList.events[i].classIndex] = classList.events[i];
        }
        classList.events = classListEventArray;
        this.proxiesNumber = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    public final SliqNode getClassLeafRef(int classIndex) {
        void var1_1;
        return this.events[var1_1].classNodeRef;
    }

    /*
     * WARNING - void declaration
     */
    public final void setClassLeafRef(int classIndex, SliqNode leaf) {
        void var2_2;
        this.events[var1_1].classNodeRef = var2_2;
    }

    public final void initializeClassNodesRefs(SliqTree sliqTree) {
        for (int i = 0; i < this.eventsNumber; ++i) {
            SliqTree sliqTree2 = sliqTree;
            this.events[i].classNodeRef = sliqTree2.root$81bb75f;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void quickSort(int l, int r) {
        while (true) {
            void var3_3;
            int i = l;
            int j = r;
            ClassListEvent x = this.events[(l + r) / 2];
            while (true) {
                if (this.events[i].classLabel < x.classLabel) {
                    ++i;
                    continue;
                }
                while (this.events[j].classLabel > x.classLabel) {
                    --j;
                }
                if (i <= j) {
                    ClassListEvent w = this.events[i];
                    this.events[i] = this.events[j];
                    this.events[j] = w;
                    ++i;
                    --j;
                }
                if (i > j) break;
            }
            if (l < j) {
                this.quickSort(l, j);
            }
            if (i >= r) break;
            l = var3_3;
        }
    }

    public final int getProxiesNumber() {
        return this.proxiesNumber;
    }

    /*
     * WARNING - void declaration
     */
    public final float getClassProxy(int proxyIndex) {
        void var1_1;
        return this.proxies.get((int)var1_1).classLabel;
    }

    /*
     * WARNING - void declaration
     */
    public final SliqNode getAttrValueLeaf(AttributeList attributeList, int attrEventInedx) {
        void var2_2;
        void var1_1;
        return this.getClassLeafRef(var1_1.getAttrClassIndex((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getAttrValueLeafPurity(AttributeList attributeList, int attrEventInedx) {
        void var2_2;
        void var1_1;
        return this.events[var1_1.getAttrClassIndex((int)var2_2)].classNodeRef.getLeafIndicator();
    }

    public final void calcClassFrequencies$2f9c67c6() {
        for (int i = 0; i < this.eventsNumber; ++i) {
            if (this.events[i].classNodeRef.getLeafIndicator()) continue;
            int n = this.events[i].proxyIndex;
            this.events[i].classNodeRef.classFrequencies[n] = this.events[i].classNodeRef.classFrequencies[n] + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateToLEftAttrValueLeafNumHist(AttributeList attributeList, int attrEventIndex) {
        void var1_2;
        void var2_3;
        int classIndex = attributeList.getAttrClassIndex((int)var2_3);
        this.events[classIndex].classNodeRef.numericHistogram.updateToLEft(this.events[var1_2].proxyIndex);
    }

    /*
     * WARNING - void declaration
     */
    public final void incRightAttrValueLeafNomHist(AttributeList attributeList, int attrEventIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        int classIndex = attributeList.getAttrClassIndex(attrEventIndex);
        this.events[classIndex].classNodeRef.nominalHistogram.incRight(var1_1.getAttrProxyIndex((int)var2_2), this.events[var3_3].proxyIndex);
    }
}

