/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.x11;

import java.util.Arrays;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.toolkit.base.api.util.Validatable;
import jdplus.x13.base.api.x11.BiasCorrection;
import jdplus.x13.base.api.x11.CalendarSigmaOption;
import jdplus.x13.base.api.x11.SeasonalFilterOption;
import jdplus.x13.base.api.x11.SigmaVecOption;
import jdplus.x13.base.api.x11.X11Exception;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class X11Spec
implements Validatable<X11Spec> {
    public static final double DEFAULT_LOWER_SIGMA = 1.5;
    public static final double DEFAULT_UPPER_SIGMA = 2.5;
    public static final int DEFAULT_FORECAST_HORIZON = 0;
    public static final int DEFAULT_BACKCAST_HORIZON = 0;
    private static final SeasonalFilterOption[] MSR = new SeasonalFilterOption[]{SeasonalFilterOption.Msr};
    private final DecompositionMode mode;
    private final boolean seasonal;
    private final SeasonalFilterOption[] filters;
    private final double lowerSigma;
    private final double upperSigma;
    private final int hendersonFilterLength;
    private final int forecastHorizon;
    private final int backcastHorizon;
    private final CalendarSigmaOption calendarSigma;
    private final SigmaVecOption[] sigmaVec;
    private final boolean excludeForecast;
    private final BiasCorrection bias;
    public static final X11Spec DEFAULT_UNDEFINED = (X11Spec)X11Spec.builder().forecastHorizon(-1).mode(DecompositionMode.Undefined).build();
    public static final X11Spec DEFAULT = (X11Spec)X11Spec.builder().build();

    public static Builder builder() {
        return new Builder().filters(MSR).calendarSigma(CalendarSigmaOption.None).excludeForecast(false).bias(BiasCorrection.Ratio).hendersonFilterLength(0).forecastHorizon(0).backcastHorizon(0).seasonal(true).lowerSigma(1.5).upperSigma(2.5).mode(DecompositionMode.Multiplicative);
    }

    public boolean isDefault() {
        return this.equals(DEFAULT_UNDEFINED);
    }

    public X11Spec validate() throws IllegalArgumentException {
        if (this.upperSigma <= this.lowerSigma || this.lowerSigma <= 0.5) {
            throw new IllegalArgumentException("Invalid sigma options");
        }
        if (this.hendersonFilterLength < 0 || this.hendersonFilterLength > 101 || this.hendersonFilterLength != 0 && this.hendersonFilterLength % 2 == 0) {
            throw new IllegalArgumentException("Invalid henderson length");
        }
        if (!this.calendarSigma.equals((Object)CalendarSigmaOption.Select) && this.sigmaVec != null) {
            throw new X11Exception("Sigmavec mustn't be used without CalendarSigmaOption Select");
        }
        if (this.calendarSigma.equals((Object)CalendarSigmaOption.Select) && this.sigmaVec == null) {
            throw new X11Exception("SigmavecOptions not set for CalendarSigmaOption Select");
        }
        return this;
    }

    @Generated
    X11Spec(DecompositionMode mode, boolean seasonal, SeasonalFilterOption[] filters, double lowerSigma, double upperSigma, int hendersonFilterLength, int forecastHorizon, int backcastHorizon, CalendarSigmaOption calendarSigma, SigmaVecOption[] sigmaVec, boolean excludeForecast, BiasCorrection bias) {
        this.mode = mode;
        this.seasonal = seasonal;
        this.filters = filters;
        this.lowerSigma = lowerSigma;
        this.upperSigma = upperSigma;
        this.hendersonFilterLength = hendersonFilterLength;
        this.forecastHorizon = forecastHorizon;
        this.backcastHorizon = backcastHorizon;
        this.calendarSigma = calendarSigma;
        this.sigmaVec = sigmaVec;
        this.excludeForecast = excludeForecast;
        this.bias = bias;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().mode(this.mode).seasonal(this.seasonal).filters(this.filters).lowerSigma(this.lowerSigma).upperSigma(this.upperSigma).hendersonFilterLength(this.hendersonFilterLength).forecastHorizon(this.forecastHorizon).backcastHorizon(this.backcastHorizon).calendarSigma(this.calendarSigma).sigmaVec(this.sigmaVec).excludeForecast(this.excludeForecast).bias(this.bias);
    }

    @Generated
    public DecompositionMode getMode() {
        return this.mode;
    }

    @Generated
    public boolean isSeasonal() {
        return this.seasonal;
    }

    @Generated
    public SeasonalFilterOption[] getFilters() {
        return this.filters;
    }

    @Generated
    public double getLowerSigma() {
        return this.lowerSigma;
    }

    @Generated
    public double getUpperSigma() {
        return this.upperSigma;
    }

    @Generated
    public int getHendersonFilterLength() {
        return this.hendersonFilterLength;
    }

    @Generated
    public int getForecastHorizon() {
        return this.forecastHorizon;
    }

    @Generated
    public int getBackcastHorizon() {
        return this.backcastHorizon;
    }

    @Generated
    public CalendarSigmaOption getCalendarSigma() {
        return this.calendarSigma;
    }

    @Generated
    public SigmaVecOption[] getSigmaVec() {
        return this.sigmaVec;
    }

    @Generated
    public boolean isExcludeForecast() {
        return this.excludeForecast;
    }

    @Generated
    public BiasCorrection getBias() {
        return this.bias;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof X11Spec)) {
            return false;
        }
        X11Spec other = (X11Spec)o;
        if (this.isSeasonal() != other.isSeasonal()) {
            return false;
        }
        if (Double.compare(this.getLowerSigma(), other.getLowerSigma()) != 0) {
            return false;
        }
        if (Double.compare(this.getUpperSigma(), other.getUpperSigma()) != 0) {
            return false;
        }
        if (this.getHendersonFilterLength() != other.getHendersonFilterLength()) {
            return false;
        }
        if (this.getForecastHorizon() != other.getForecastHorizon()) {
            return false;
        }
        if (this.getBackcastHorizon() != other.getBackcastHorizon()) {
            return false;
        }
        if (this.isExcludeForecast() != other.isExcludeForecast()) {
            return false;
        }
        DecompositionMode this$mode = this.getMode();
        DecompositionMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getFilters(), (Object[])other.getFilters())) {
            return false;
        }
        CalendarSigmaOption this$calendarSigma = this.getCalendarSigma();
        CalendarSigmaOption other$calendarSigma = other.getCalendarSigma();
        if (this$calendarSigma == null ? other$calendarSigma != null : !((Object)((Object)this$calendarSigma)).equals((Object)other$calendarSigma)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getSigmaVec(), (Object[])other.getSigmaVec())) {
            return false;
        }
        BiasCorrection this$bias = this.getBias();
        BiasCorrection other$bias = other.getBias();
        return !(this$bias == null ? other$bias != null : !((Object)((Object)this$bias)).equals((Object)other$bias));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSeasonal() ? 79 : 97);
        long $lowerSigma = Double.doubleToLongBits(this.getLowerSigma());
        result = result * 59 + (int)($lowerSigma >>> 32 ^ $lowerSigma);
        long $upperSigma = Double.doubleToLongBits(this.getUpperSigma());
        result = result * 59 + (int)($upperSigma >>> 32 ^ $upperSigma);
        result = result * 59 + this.getHendersonFilterLength();
        result = result * 59 + this.getForecastHorizon();
        result = result * 59 + this.getBackcastHorizon();
        result = result * 59 + (this.isExcludeForecast() ? 79 : 97);
        DecompositionMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getFilters());
        CalendarSigmaOption $calendarSigma = this.getCalendarSigma();
        result = result * 59 + ($calendarSigma == null ? 43 : ((Object)((Object)$calendarSigma)).hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getSigmaVec());
        BiasCorrection $bias = this.getBias();
        result = result * 59 + ($bias == null ? 43 : ((Object)((Object)$bias)).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "X11Spec(mode=" + String.valueOf(this.getMode()) + ", seasonal=" + this.isSeasonal() + ", filters=" + Arrays.deepToString((Object[])this.getFilters()) + ", lowerSigma=" + this.getLowerSigma() + ", upperSigma=" + this.getUpperSigma() + ", hendersonFilterLength=" + this.getHendersonFilterLength() + ", forecastHorizon=" + this.getForecastHorizon() + ", backcastHorizon=" + this.getBackcastHorizon() + ", calendarSigma=" + String.valueOf((Object)this.getCalendarSigma()) + ", sigmaVec=" + Arrays.deepToString((Object[])this.getSigmaVec()) + ", excludeForecast=" + this.isExcludeForecast() + ", bias=" + String.valueOf((Object)this.getBias()) + ")";
    }

    public static class Builder
    implements Validatable.Builder<X11Spec> {
        @Generated
        private DecompositionMode mode;
        @Generated
        private boolean seasonal;
        @Generated
        private SeasonalFilterOption[] filters;
        @Generated
        private double lowerSigma;
        @Generated
        private double upperSigma;
        @Generated
        private int hendersonFilterLength;
        @Generated
        private int forecastHorizon;
        @Generated
        private int backcastHorizon;
        @Generated
        private CalendarSigmaOption calendarSigma;
        @Generated
        private SigmaVecOption[] sigmaVec;
        @Generated
        private boolean excludeForecast;
        @Generated
        private BiasCorrection bias;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder mode(DecompositionMode mode) {
            this.mode = mode;
            return this;
        }

        @Generated
        public @NonNull Builder seasonal(boolean seasonal) {
            this.seasonal = seasonal;
            return this;
        }

        @Generated
        public @NonNull Builder filters(SeasonalFilterOption[] filters) {
            this.filters = filters;
            return this;
        }

        @Generated
        public @NonNull Builder lowerSigma(double lowerSigma) {
            this.lowerSigma = lowerSigma;
            return this;
        }

        @Generated
        public @NonNull Builder upperSigma(double upperSigma) {
            this.upperSigma = upperSigma;
            return this;
        }

        @Generated
        public @NonNull Builder hendersonFilterLength(int hendersonFilterLength) {
            this.hendersonFilterLength = hendersonFilterLength;
            return this;
        }

        @Generated
        public @NonNull Builder forecastHorizon(int forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
            return this;
        }

        @Generated
        public @NonNull Builder backcastHorizon(int backcastHorizon) {
            this.backcastHorizon = backcastHorizon;
            return this;
        }

        @Generated
        public @NonNull Builder calendarSigma(CalendarSigmaOption calendarSigma) {
            this.calendarSigma = calendarSigma;
            return this;
        }

        @Generated
        public @NonNull Builder sigmaVec(SigmaVecOption[] sigmaVec) {
            this.sigmaVec = sigmaVec;
            return this;
        }

        @Generated
        public @NonNull Builder excludeForecast(boolean excludeForecast) {
            this.excludeForecast = excludeForecast;
            return this;
        }

        @Generated
        public @NonNull Builder bias(BiasCorrection bias) {
            this.bias = bias;
            return this;
        }

        @Generated
        public @NonNull X11Spec buildWithoutValidation() {
            return new X11Spec(this.mode, this.seasonal, this.filters, this.lowerSigma, this.upperSigma, this.hendersonFilterLength, this.forecastHorizon, this.backcastHorizon, this.calendarSigma, this.sigmaVec, this.excludeForecast, this.bias);
        }

        @Generated
        public @NonNull String toString() {
            return "X11Spec.Builder(mode=" + String.valueOf(this.mode) + ", seasonal=" + this.seasonal + ", filters=" + Arrays.deepToString((Object[])this.filters) + ", lowerSigma=" + this.lowerSigma + ", upperSigma=" + this.upperSigma + ", hendersonFilterLength=" + this.hendersonFilterLength + ", forecastHorizon=" + this.forecastHorizon + ", backcastHorizon=" + this.backcastHorizon + ", calendarSigma=" + String.valueOf((Object)this.calendarSigma) + ", sigmaVec=" + Arrays.deepToString((Object[])this.sigmaVec) + ", excludeForecast=" + this.excludeForecast + ", bias=" + String.valueOf((Object)this.bias) + ")";
        }
    }
}

