/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.x11;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import jdplus.x13.base.api.x11.X11;

public final class X11Loader {

    public static final class Processor {
        private final Iterable<X11.Processor> source = ServiceLoader.load(X11.Processor.class);
        private final AtomicReference<X11.Processor> resource = new AtomicReference<X11.Processor>(this.doLoad());
        private final Consumer<Iterable> cleaner = loader -> ((ServiceLoader)loader).reload();

        private X11.Processor doLoad() {
            return StreamSupport.stream(this.source.spliterator(), false).findFirst().orElseGet(() -> new X11.DefProcessor());
        }

        public X11.Processor get() {
            return this.resource.get();
        }

        public void set(X11.Processor newValue) {
            this.resource.set(Objects.requireNonNull(newValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() {
            Iterable<X11.Processor> iterable = this.source;
            synchronized (iterable) {
                this.cleaner.accept(this.source);
                this.set(this.doLoad());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Iterable<X11.Processor> iterable = this.source;
            synchronized (iterable) {
                this.set(this.doLoad());
            }
        }
    }
}

