/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import java.util.Arrays;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.LargeRelation;
import org.chocosolver.solver.constraints.extension.nary.PropLargeCSP;
import org.chocosolver.solver.constraints.extension.nary.RelationFactory;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;

@Explained(ignored=true, comment="Turned into clauses")
public class PropLargeGAC3rm
extends PropLargeCSP<LargeRelation> {
    private final int[] supports;
    private final int[] blocks;
    private final int size;
    private final int[] offsets;
    private final DisposableValueIterator[] seekIter;
    private final IntIterableBitSet vrms;

    private PropLargeGAC3rm(IntVar[] vs, LargeRelation relation) {
        super(vs, relation);
        int i;
        this.size = vs.length;
        this.blocks = new int[this.size];
        this.offsets = new int[this.size];
        int nbElt = 0;
        for (i = 0; i < this.size; ++i) {
            this.offsets[i] = vs[i].getLB();
            this.blocks[i] = nbElt;
            if (!((IntVar[])this.vars)[i].hasEnumeratedDomain()) {
                nbElt += 2;
                continue;
            }
            nbElt += ((IntVar[])this.vars)[i].getUB() - ((IntVar[])this.vars)[i].getLB() + 1;
        }
        this.supports = new int[nbElt * this.size];
        this.seekIter = new DisposableValueIterator[this.size];
        for (i = 0; i < this.size; ++i) {
            this.seekIter[i] = ((IntVar[])this.vars)[i].getValueIterator(true);
        }
        Arrays.fill(this.supports, Integer.MIN_VALUE);
        this.vrms = new IntIterableBitSet();
    }

    public PropLargeGAC3rm(IntVar[] vs, Tuples tuples) {
        this(vs, RelationFactory.makeLargeRelation(tuples, vs));
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        if ((evtmask & PropagatorEventType.FULL_PROPAGATION.getMask()) != 0) {
            for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
                this.initializeSupports(i);
            }
        }
        for (i = 0; i < this.size; ++i) {
            this.reviseVar(i);
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        for (int i = 0; i < this.size; ++i) {
            if (idxVarInProp == i) continue;
            this.reviseVar(i);
        }
        if (!((IntVar[])this.vars)[idxVarInProp].hasEnumeratedDomain()) {
            this.reviseVar(idxVarInProp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSupports(int indexVar) throws ContradictionException {
        if (((IntVar[])this.vars)[indexVar].hasEnumeratedDomain()) {
            DisposableValueIterator it = ((IntVar[])this.vars)[indexVar].getValueIterator(true);
            this.vrms.clear();
            this.vrms.setOffset(((IntVar[])this.vars)[indexVar].getLB());
            try {
                while (it.hasNext()) {
                    int val = it.next();
                    if (this.lastSupport(indexVar, val)[0] != Integer.MIN_VALUE) continue;
                    int[] currentSupport = this.seekNextSupport(indexVar, val);
                    if (currentSupport != null) {
                        this.setSupport(currentSupport);
                        continue;
                    }
                    this.vrms.add(val);
                }
                ((IntVar[])this.vars)[indexVar].removeValues(this.vrms, this);
            }
            finally {
                it.dispose();
            }
        } else {
            int[] currentSupport;
            int val;
            for (val = ((IntVar[])this.vars)[indexVar].getLB(); val <= ((IntVar[])this.vars)[indexVar].getUB(); ++val) {
                currentSupport = this.seekNextSupport(indexVar, val);
                if (currentSupport == null) continue;
                this.setBoundSupport(indexVar, 0, currentSupport);
                break;
            }
            ((IntVar[])this.vars)[indexVar].updateLowerBound(val, (ICause)this);
            for (val = ((IntVar[])this.vars)[indexVar].getUB(); val >= ((IntVar[])this.vars)[indexVar].getLB(); --val) {
                currentSupport = this.seekNextSupport(indexVar, val);
                if (currentSupport == null) continue;
                this.setBoundSupport(indexVar, 1, currentSupport);
                break;
            }
            ((IntVar[])this.vars)[indexVar].updateUpperBound(val, (ICause)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reviseVar(int indexVar) throws ContradictionException {
        if (((IntVar[])this.vars)[indexVar].hasEnumeratedDomain()) {
            DisposableValueIterator it = ((IntVar[])this.vars)[indexVar].getValueIterator(true);
            this.vrms.clear();
            this.vrms.setOffset(((IntVar[])this.vars)[indexVar].getLB());
            try {
                while (it.hasNext()) {
                    int val = it.next();
                    if (!this.isInvalid(this.lastSupport(indexVar, val))) continue;
                    int[] currentSupport = this.seekNextSupport(indexVar, val);
                    if (currentSupport != null) {
                        this.setSupport(currentSupport);
                        continue;
                    }
                    this.vrms.add(val);
                }
                ((IntVar[])this.vars)[indexVar].removeValues(this.vrms, this);
            }
            finally {
                it.dispose();
            }
        } else {
            int[] currentSupport;
            int val;
            int[] inf_supports = this.lastBoundSupport(indexVar, 0);
            if (((IntVar[])this.vars)[indexVar].getLB() != inf_supports[indexVar] || this.isInvalid(inf_supports)) {
                for (val = ((IntVar[])this.vars)[indexVar].getLB(); val <= ((IntVar[])this.vars)[indexVar].getUB(); ++val) {
                    currentSupport = this.seekNextSupport(indexVar, val);
                    if (currentSupport == null) continue;
                    this.setBoundSupport(indexVar, 0, currentSupport);
                    break;
                }
                ((IntVar[])this.vars)[indexVar].updateLowerBound(val, (ICause)this);
            }
            int[] sup_supports = this.lastBoundSupport(indexVar, 1);
            if (((IntVar[])this.vars)[indexVar].getUB() != sup_supports[indexVar] || this.isInvalid(sup_supports)) {
                for (val = ((IntVar[])this.vars)[indexVar].getUB(); val >= ((IntVar[])this.vars)[indexVar].getLB(); --val) {
                    currentSupport = this.seekNextSupport(indexVar, val);
                    if (currentSupport == null) continue;
                    this.setBoundSupport(indexVar, 1, currentSupport);
                    break;
                }
                ((IntVar[])this.vars)[indexVar].updateUpperBound(val, (ICause)this);
            }
        }
    }

    private void setSupport(int[] support) {
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (!((IntVar[])this.vars)[i].hasEnumeratedDomain()) continue;
            this.setOneSupport(i, support[i], support);
        }
    }

    private void setOneSupport(int indexVar, int value, int[] support) {
        System.arraycopy(support, 0, this.supports, (this.blocks[indexVar] + value - this.offsets[indexVar]) * this.size, ((IntVar[])this.vars).length);
    }

    private void setBoundSupport(int indexVar, int idxBound, int[] support) {
        System.arraycopy(support, 0, this.supports, (this.blocks[indexVar] + idxBound) * this.size, ((IntVar[])this.vars).length);
    }

    private int[] getUBport(int indexVar, int value) {
        int[] resultat = new int[this.size];
        System.arraycopy(this.supports, (this.blocks[indexVar] + value - this.offsets[indexVar]) * this.size, resultat, 0, this.size);
        return resultat;
    }

    private int[] getBoundSupport(int indexVar, int idxBound) {
        int[] resultat = new int[this.size];
        System.arraycopy(this.supports, (this.blocks[indexVar] + idxBound) * this.size, resultat, 0, this.size);
        return resultat;
    }

    private int[] lastSupport(int indexVar, int value) {
        return this.getUBport(indexVar, value);
    }

    private int[] lastBoundSupport(int indexVar, int idxBound) {
        return this.getBoundSupport(indexVar, idxBound);
    }

    private boolean isInvalid(int[] tuple) {
        for (int i = 0; i < this.size; ++i) {
            if (((IntVar[])this.vars)[i].contains(tuple[i])) continue;
            return true;
        }
        return false;
    }

    private int[] seekNextSupport(int indexVar, int val) {
        int[] currentSupport = new int[this.size];
        int k = 0;
        for (int i = 0; i < this.size; ++i) {
            this.seekIter[i].dispose();
            this.seekIter[i] = ((IntVar[])this.vars)[i].getValueIterator(true);
            currentSupport[i] = i != indexVar ? this.seekIter[i].next() : val;
        }
        if (this.relation.isConsistent(currentSupport)) {
            return currentSupport;
        }
        while (k < ((IntVar[])this.vars).length) {
            if (k == indexVar) {
                ++k;
            }
            if (k >= ((IntVar[])this.vars).length) continue;
            if (!this.seekIter[k].hasNext()) {
                this.seekIter[k].dispose();
                this.seekIter[k] = ((IntVar[])this.vars)[k].getValueIterator(true);
                currentSupport[k] = this.seekIter[k].next();
                ++k;
                continue;
            }
            currentSupport[k] = this.seekIter[k].next();
            if (this.relation.isConsistent(currentSupport)) {
                return currentSupport;
            }
            k = 0;
        }
        return null;
    }
}

