/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.global.scheduling;

import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.ModelException;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.solver.constraints.global.scheduling.IResourceParameters;

public final class ResourceParameters
implements IResourceParameters {
    private static final long serialVersionUID = 3665641934423408763L;
    private final String name;
    private final int nbReg;
    private final int nbOpt;
    private final int nbTot;
    private final boolean isHorizonDefined;

    public ResourceParameters(String name, TaskVariable[] tasks, IntegerVariable[] usages, IntegerVariable uppBound) {
        if (tasks == null || tasks.length == 0) {
            throw new ModelException("Empty resource ?");
        }
        this.nbTot = tasks.length;
        if (usages == null) {
            this.nbOpt = 0;
        } else {
            this.nbOpt = usages.length;
            if (this.nbOpt > this.nbTot) {
                throw new ModelException("Invalid resource dimensions.");
            }
            for (int i = 0; i < usages.length; ++i) {
                if (usages[i].isBoolean()) continue;
                throw new ModelException("Resource usage variable: " + usages[i].pretty() + " is not boolean.");
            }
        }
        this.nbReg = this.nbTot - this.nbOpt;
        this.name = name == null ? StringUtils.randomName() + "-RSC" : name;
        this.isHorizonDefined = uppBound != null;
    }

    public boolean isRegular() {
        return this.nbOpt == 0;
    }

    public boolean isAlternative() {
        return this.nbOpt > 0;
    }

    @Override
    public int getNbOptionalTasks() {
        return this.nbOpt;
    }

    @Override
    public int getNbRegularTasks() {
        return this.nbReg;
    }

    @Override
    public int getNbTasks() {
        return this.nbTot;
    }

    @Override
    public String getRscName() {
        return this.name;
    }

    public boolean isHorizonDefined() {
        return this.isHorizonDefined;
    }

    public String toString() {
        return this.name + "(" + this.nbReg + ", " + this.nbOpt + ")";
    }

    public final int getUsagesOffset() {
        return this.nbTot;
    }

    public final int getHeightsOffset() {
        return this.nbTot + this.nbOpt;
    }

    public final int getConsOffset() {
        return this.nbTot + this.nbOpt + this.nbTot;
    }

    public final int getCapaOffset() {
        return this.nbTot + this.nbOpt + this.nbTot + 1;
    }
}

