/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class GreaterOrEqualXY_C
extends AbstractBinIntSConstraint {
    protected final int cste;

    public GreaterOrEqualXY_C(IntDomainVar x0, IntDomainVar x1, int c) {
        super(x0, x1);
        this.cste = c;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    private final void updateInfV0() throws ContradictionException {
        this.v0.updateInf(this.cste - this.v1.getSup(), this, false);
    }

    private final void updateInfV1() throws ContradictionException {
        this.v1.updateInf(this.cste - this.v0.getSup(), this, false);
    }

    @Override
    public void propagate() throws ContradictionException {
        this.updateInfV0();
        this.updateInfV1();
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (this.v0.getInf() + this.v1.getInf() >= this.cste) {
            this.setEntailed();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == 0) {
            this.updateInfV1();
        } else assert (idx == 1);
        this.updateInfV0();
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            this.updateInfV1();
        } else {
            this.updateInfV0();
        }
        assert (this.v0.getInf() + this.v1.getInf() >= this.cste);
        this.setEntailed();
    }

    @Override
    public Boolean isEntailed() {
        if (this.v0.getSup() + this.v1.getSup() < this.cste) {
            return Boolean.FALSE;
        }
        if (this.v0.getInf() + this.v1.getInf() >= this.cste) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[0] + tuple[1] >= this.cste;
    }

    @Override
    public boolean isConsistent() {
        return this.v0.getInf() + this.v1.getSup() >= this.cste && this.v0.getSup() + this.v1.getInf() >= this.cste;
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        return (AbstractSConstraint)solver.lt(solver.plus((IntExp)this.v0, (IntExp)this.v1), this.cste);
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.v0).append(" + ").append(this.v1);
        sb.append(" >= ").append(this.cste);
        return sb.toString();
    }
}

