/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Defaults;
import weka.core.Drawable;
import weka.core.Environment;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.PluginManager;
import weka.core.SerializationHelper;
import weka.core.SerializedObject;
import weka.core.Settings;
import weka.core.Utils;
import weka.core.Version;
import weka.core.WekaPackageClassLoaderManager;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.AbstractPerspective;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.InstancesSummaryPanel;
import weka.gui.ListSelectorDialog;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PerspectiveInfo;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SetInstancesPanel;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.explorer.ClustererAssignmentsPlotInstances;
import weka.gui.explorer.ClustererPanelLaunchHandlerPlugin;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.hierarchyvisualizer.HierarchyVisualizer;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.VisualizePanel;
import weka.gui.visualize.plugins.TreeVisualizePlugin;

@PerspectiveInfo(ID="weka.gui.explorer.clustererpanel", title="Cluster", toolTipText="Cluster instances", iconPath="weka/gui/weka_icon_new_small.png")
public class ClustererPanel
extends AbstractPerspective
implements Explorer.CapabilitiesFilterChangeListener,
Explorer.ExplorerPanel,
Explorer.LogHandler {
    static final long serialVersionUID = -2474932792950820990L;
    protected Explorer m_Explorer = null;
    public static String MODEL_FILE_EXTENSION = ".model";
    protected GenericObjectEditor m_ClustererEditor = new GenericObjectEditor();
    protected PropertyPanel m_CLPanel = new PropertyPanel(this.m_ClustererEditor);
    protected JTextArea m_OutText = new JTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, this);
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected JRadioButton m_PercentBut = new JRadioButton("Percentage split");
    protected JRadioButton m_TrainBut = new JRadioButton("Use training set");
    protected JRadioButton m_TestSplitBut = new JRadioButton("Supplied test set");
    protected JRadioButton m_ClassesToClustersBut = new JRadioButton("Classes to clusters evaluation");
    protected JComboBox m_ClassCombo = new JComboBox();
    protected JLabel m_PercentLab = new JLabel("%", 4);
    protected JTextField m_PercentText = new JTextField("66");
    protected JButton m_SetTestBut = new JButton("Set...");
    protected JFrame m_SetTestFrame;
    protected JButton m_ignoreBut = new JButton("Ignore attributes");
    protected DefaultListModel m_ignoreKeyModel = new DefaultListModel();
    protected JList m_ignoreKeyList = new JList(this.m_ignoreKeyModel);
    ActionListener m_RadioListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ClustererPanel.this.updateRadioLinks();
        }
    };
    protected JButton m_StartBut = new JButton("Start");
    private final Dimension COMBO_SIZE;
    protected JButton m_StopBut;
    protected Instances m_Instances;
    protected Instances m_TestInstances;
    protected VisualizePanel m_CurrentVis;
    protected JCheckBox m_StorePredictionsBut;
    protected Thread m_RunThread;
    protected InstancesSummaryPanel m_Summary;
    protected FileFilter m_ModelFilter;
    protected JFileChooser m_FileChooser;
    protected boolean m_initialSettingsSet;

    public ClustererPanel() {
        this.COMBO_SIZE = new Dimension(250, this.m_StartBut.getPreferredSize().height);
        this.m_StopBut = new JButton("Stop");
        this.m_CurrentVis = null;
        this.m_StorePredictionsBut = new JCheckBox("Store clusters for visualization");
        this.m_ModelFilter = new ExtensionFileFilter(MODEL_FILE_EXTENSION, "Model object files");
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16) {
                    ClustererPanel.this.m_OutText.selectAll();
                }
            }
        });
        JPanel historyHolder = new JPanel(new BorderLayout());
        historyHolder.setBorder(BorderFactory.createTitledBorder("Result list (right-click for options)"));
        historyHolder.add((Component)this.m_History, "Center");
        this.m_ClustererEditor.setClassType(Clusterer.class);
        this.m_ClustererEditor.setValue(ExplorerDefaults.getClusterer());
        this.m_ClustererEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ClustererPanel.this.m_StartBut.setEnabled(true);
                Capabilities currentFilter = ClustererPanel.this.m_ClustererEditor.getCapabilitiesFilter();
                Clusterer clusterer = (Clusterer)ClustererPanel.this.m_ClustererEditor.getValue();
                Capabilities currentSchemeCapabilities = null;
                if (clusterer != null && currentFilter != null && clusterer instanceof CapabilitiesHandler && !(currentSchemeCapabilities = ((CapabilitiesHandler)((Object)clusterer)).getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
                    ClustererPanel.this.m_StartBut.setEnabled(false);
                }
                ClustererPanel.this.repaint();
            }
        });
        this.m_TrainBut.setToolTipText("Cluster the same set that the clusterer is trained on");
        this.m_PercentBut.setToolTipText("Train on a percentage of the data and cluster the remainder");
        this.m_TestSplitBut.setToolTipText("Cluster a user-specified dataset");
        this.m_ClassesToClustersBut.setToolTipText("Evaluate clusters with respect to a class");
        this.m_ClassCombo.setToolTipText("Select the class attribute for class based evaluation");
        this.m_StartBut.setToolTipText("Starts the clustering");
        this.m_StopBut.setToolTipText("Stops a running clusterer");
        this.m_StorePredictionsBut.setToolTipText("Store predictions in the result list for later visualization");
        this.m_ignoreBut.setToolTipText("Ignore attributes during clustering");
        this.m_FileChooser.setFileFilter(this.m_ModelFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_ClassCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_ClassCombo.setEnabled(false);
        this.m_PercentBut.setSelected(ExplorerDefaults.getClustererTestMode() == 2);
        this.m_TrainBut.setSelected(ExplorerDefaults.getClustererTestMode() == 3);
        this.m_TestSplitBut.setSelected(ExplorerDefaults.getClustererTestMode() == 4);
        this.m_ClassesToClustersBut.setSelected(ExplorerDefaults.getClustererTestMode() == 5);
        this.m_StorePredictionsBut.setSelected(ExplorerDefaults.getClustererStoreClustersForVis());
        this.updateRadioLinks();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_TrainBut);
        bg.add(this.m_PercentBut);
        bg.add(this.m_TestSplitBut);
        bg.add(this.m_ClassesToClustersBut);
        this.m_TrainBut.addActionListener(this.m_RadioListener);
        this.m_PercentBut.addActionListener(this.m_RadioListener);
        this.m_TestSplitBut.addActionListener(this.m_RadioListener);
        this.m_ClassesToClustersBut.addActionListener(this.m_RadioListener);
        this.m_SetTestBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClustererPanel.this.setTestSet();
            }
        });
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_ignoreBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean proceed = true;
                if (Explorer.m_Memory.memoryIsLow()) {
                    proceed = Explorer.m_Memory.showMemoryIsLow();
                }
                if (proceed) {
                    ClustererPanel.this.startClusterer();
                }
            }
        });
        this.m_StopBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClustererPanel.this.stopClusterer();
            }
        });
        this.m_ignoreBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClustererPanel.this.setIgnoreColumns();
            }
        });
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    int index = ClustererPanel.this.m_History.getList().locationToIndex(e.getPoint());
                    if (index != -1) {
                        List<String> selectedEls = ClustererPanel.this.m_History.getList().getSelectedValuesList();
                        ClustererPanel.this.visualizeClusterer(selectedEls, e.getX(), e.getY());
                    } else {
                        ClustererPanel.this.visualizeClusterer(null, e.getX(), e.getY());
                    }
                }
            }
        });
        this.m_ClassCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClustererPanel.this.updateCapabilitiesFilter(ClustererPanel.this.m_ClustererEditor.getCapabilitiesFilter());
            }
        });
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Clusterer"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_CLPanel, "North");
        JPanel p2 = new JPanel();
        GridBagLayout gbL = new GridBagLayout();
        p2.setLayout(gbL);
        p2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Cluster mode"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbL.setConstraints(this.m_TrainBut, gbC);
        p2.add(this.m_TrainBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbL.setConstraints(this.m_TestSplitBut, gbC);
        p2.add(this.m_TestSplitBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 1;
        gbC.gridwidth = 2;
        gbC.insets = new Insets(2, 10, 2, 0);
        gbL.setConstraints(this.m_SetTestBut, gbC);
        p2.add(this.m_SetTestBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbL.setConstraints(this.m_PercentBut, gbC);
        p2.add(this.m_PercentBut);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 2;
        gbC.gridx = 1;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(this.m_PercentLab, gbC);
        p2.add(this.m_PercentLab);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.fill = 2;
        gbC.gridy = 2;
        gbC.gridx = 2;
        gbC.weightx = 100.0;
        gbC.ipadx = 20;
        gbL.setConstraints(this.m_PercentText, gbC);
        p2.add(this.m_PercentText);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 3;
        gbC.gridx = 0;
        gbC.gridwidth = 2;
        gbL.setConstraints(this.m_ClassesToClustersBut, gbC);
        p2.add(this.m_ClassesToClustersBut);
        this.m_ClassCombo.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 4;
        gbC.gridx = 0;
        gbC.gridwidth = 2;
        gbL.setConstraints(this.m_ClassCombo, gbC);
        p2.add(this.m_ClassCombo);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 5;
        gbC.gridx = 0;
        gbC.gridwidth = 2;
        gbL.setConstraints(this.m_StorePredictionsBut, gbC);
        p2.add(this.m_StorePredictionsBut);
        List<String> pluginsVector = PluginManager.getPluginNamesOfTypeList(ClustererPanelLaunchHandlerPlugin.class.getName());
        JButton pluginBut = null;
        if (pluginsVector.size() == 1) {
            try {
                String className = pluginsVector.get(0);
                final ClustererPanelLaunchHandlerPlugin plugin = (ClustererPanelLaunchHandlerPlugin)WekaPackageClassLoaderManager.objectForName(className);
                if (plugin != null) {
                    plugin.setClustererPanel(this);
                    pluginBut = new JButton(plugin.getLaunchCommand());
                    pluginBut.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            plugin.launch();
                        }
                    });
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (pluginsVector.size() > 1) {
            int okPluginCount = 0;
            final PopupMenu pluginPopup = new PopupMenu();
            for (int i = 0; i < pluginsVector.size(); ++i) {
                String className = pluginsVector.get(i);
                try {
                    final ClustererPanelLaunchHandlerPlugin plugin = (ClustererPanelLaunchHandlerPlugin)WekaPackageClassLoaderManager.objectForName(className);
                    if (plugin == null) continue;
                    ++okPluginCount;
                    plugin.setClustererPanel(this);
                    MenuItem popI = new MenuItem(plugin.getLaunchCommand());
                    popI.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            plugin.launch();
                        }
                    });
                    pluginPopup.add(popI);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (okPluginCount > 0) {
                final JButton copyB = pluginBut = new JButton("Launchers...");
                copyB.add(pluginPopup);
                pluginBut.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        pluginPopup.show(copyB, 0, 0);
                    }
                });
            } else {
                pluginBut = null;
            }
        }
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(2, 1));
        JPanel ssButs = new JPanel();
        ssButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (pluginBut == null) {
            ssButs.setLayout(new GridLayout(1, 2, 5, 5));
        } else {
            ssButs.setLayout(new FlowLayout(0));
        }
        ssButs.add(this.m_StartBut);
        ssButs.add(this.m_StopBut);
        if (pluginBut != null) {
            ssButs.add(pluginBut);
        }
        JPanel ib = new JPanel();
        ib.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ib.setLayout(new GridLayout(1, 1, 5, 5));
        ib.add(this.m_ignoreBut);
        buttons.add(ib);
        buttons.add(ssButs);
        JPanel p3 = new JPanel();
        p3.setBorder(BorderFactory.createTitledBorder("Clusterer output"));
        p3.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(this.m_OutText);
        p3.add((Component)js, "Center");
        js.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport vp = (JViewport)e.getSource();
                int h = vp.getViewSize().height;
                if (h != this.lastHeight) {
                    this.lastHeight = h;
                    int x = h - vp.getExtentSize().height;
                    vp.setViewPosition(new Point(0, x));
                }
            }
        });
        JPanel mondo = new JPanel();
        gbL = new GridBagLayout();
        mondo.setLayout(gbL);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbL.setConstraints(p2, gbC);
        mondo.add(p2);
        gbC = new GridBagConstraints();
        gbC.anchor = 11;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbL.setConstraints(buttons, gbC);
        mondo.add(buttons);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbL.setConstraints(historyHolder, gbC);
        mondo.add(historyHolder);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 0;
        gbC.gridx = 1;
        gbC.gridheight = 3;
        gbC.weightx = 100.0;
        gbC.weighty = 100.0;
        gbL.setConstraints(p3, gbC);
        mondo.add(p3);
        this.setLayout(new BorderLayout());
        this.add((Component)p1, "North");
        this.add((Component)mondo, "Center");
    }

    protected void updateRadioLinks() {
        this.m_SetTestBut.setEnabled(this.m_TestSplitBut.isSelected());
        if (this.m_SetTestFrame != null && !this.m_TestSplitBut.isSelected()) {
            this.m_SetTestFrame.setVisible(false);
        }
        this.m_PercentText.setEnabled(this.m_PercentBut.isSelected());
        this.m_PercentLab.setEnabled(this.m_PercentBut.isSelected());
        this.m_ClassCombo.setEnabled(this.m_ClassesToClustersBut.isSelected());
        this.updateCapabilitiesFilter(this.m_ClustererEditor.getCapabilitiesFilter());
    }

    @Override
    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    @Override
    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        this.m_ignoreKeyModel.removeAllElements();
        String[] attribNames = new String[this.m_Instances.numAttributes()];
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            String name = this.m_Instances.attribute(i).name();
            this.m_ignoreKeyModel.addElement(name);
            String type = "(" + Attribute.typeToStringShort(this.m_Instances.attribute(i)) + ") ";
            String attnm = this.m_Instances.attribute(i).name();
            attribNames[i] = type + attnm;
        }
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
        this.m_ignoreBut.setEnabled(true);
        this.m_ClassCombo.setModel(new DefaultComboBoxModel<String>(attribNames));
        if (inst.classIndex() == -1) {
            this.m_ClassCombo.setSelectedIndex(attribNames.length - 1);
        } else {
            this.m_ClassCombo.setSelectedIndex(inst.classIndex());
        }
        this.updateRadioLinks();
    }

    protected void setTestSet() {
        if (this.m_SetTestFrame == null) {
            final SetInstancesPanel sp = new SetInstancesPanel();
            sp.setReadIncrementally(false);
            this.m_Summary = sp.getSummary();
            if (this.m_TestInstances != null) {
                sp.setInstances(this.m_TestInstances);
            }
            sp.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    ClustererPanel.this.m_TestInstances = sp.getInstances();
                    ClustererPanel.this.m_TestInstances.setClassIndex(-1);
                }
            });
            this.m_SetTestFrame = Utils.getWekaJFrame("Test Instances", this);
            sp.setParentFrame(this.m_SetTestFrame);
            this.m_SetTestFrame.getContentPane().setLayout(new BorderLayout());
            this.m_SetTestFrame.getContentPane().add((Component)sp, "Center");
            this.m_SetTestFrame.pack();
            this.m_SetTestFrame.setSize(400, 200);
        }
        this.m_SetTestFrame.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this));
        this.m_SetTestFrame.setVisible(true);
    }

    protected void startClusterer() {
        if (this.m_RunThread == null) {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(true);
            this.m_ignoreBut.setEnabled(false);
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ClustererPanel.this.m_CLPanel.addToHistory();
                    long trainTimeStart = 0L;
                    long trainTimeElapsed = 0L;
                    ClustererPanel.this.m_Log.statusMessage("Setting up...");
                    Instances inst = new Instances(ClustererPanel.this.m_Instances);
                    inst.setClassIndex(-1);
                    Instances userTest = null;
                    ClustererAssignmentsPlotInstances plotInstances = ExplorerDefaults.getClustererAssignmentsPlotInstances();
                    plotInstances.setClusterer((Clusterer)ClustererPanel.this.m_ClustererEditor.getValue());
                    if (ClustererPanel.this.m_TestInstances != null) {
                        userTest = new Instances(ClustererPanel.this.m_TestInstances);
                    }
                    boolean saveVis = ClustererPanel.this.m_StorePredictionsBut.isSelected();
                    String grph = null;
                    int[] ignoredAtts = null;
                    int testMode = 0;
                    int percent = 66;
                    Clusterer clusterer = (Clusterer)ClustererPanel.this.m_ClustererEditor.getValue();
                    Clusterer fullClusterer = null;
                    StringBuffer outBuff = new StringBuffer();
                    String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                    String cname = clusterer.getClass().getName();
                    name = cname.startsWith("weka.clusterers.") ? name + cname.substring("weka.clusterers.".length()) : name + cname;
                    String cmd = ClustererPanel.this.m_ClustererEditor.getValue().getClass().getName();
                    if (ClustererPanel.this.m_ClustererEditor.getValue() instanceof OptionHandler) {
                        cmd = cmd + " " + Utils.joinOptions(((OptionHandler)ClustererPanel.this.m_ClustererEditor.getValue()).getOptions());
                    }
                    try {
                        ClustererPanel.this.m_Log.logMessage("Started " + cname);
                        ClustererPanel.this.m_Log.logMessage("Command: " + cmd);
                        if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskStarted();
                        }
                        if (ClustererPanel.this.m_PercentBut.isSelected()) {
                            testMode = 2;
                            percent = Integer.parseInt(ClustererPanel.this.m_PercentText.getText());
                            if (percent <= 0 || percent >= 100) {
                                throw new Exception("Percentage must be between 0 and 100");
                            }
                        } else if (ClustererPanel.this.m_TrainBut.isSelected()) {
                            testMode = 3;
                        } else if (ClustererPanel.this.m_TestSplitBut.isSelected()) {
                            testMode = 4;
                            if (userTest == null) {
                                throw new Exception("No user test set has been opened");
                            }
                            if (!inst.equalHeaders(userTest)) {
                                throw new Exception("Train and test set are not compatible\n" + inst.equalHeadersMsg(userTest));
                            }
                        } else if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                            testMode = 5;
                        } else {
                            throw new Exception("Unknown test mode");
                        }
                        Instances trainInst = new Instances(inst);
                        if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                            trainInst.setClassIndex(ClustererPanel.this.m_ClassCombo.getSelectedIndex());
                            inst.setClassIndex(ClustererPanel.this.m_ClassCombo.getSelectedIndex());
                            if (inst.classAttribute().isNumeric()) {
                                throw new Exception("Class must be nominal for class based evaluation!");
                            }
                        }
                        if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                            trainInst = ClustererPanel.this.removeIgnoreCols(trainInst);
                        }
                        outBuff.append("=== Run information ===\n\n");
                        outBuff.append("Scheme:       " + cname);
                        if (clusterer instanceof OptionHandler) {
                            String[] o = ((OptionHandler)((Object)clusterer)).getOptions();
                            outBuff.append(" " + Utils.joinOptions(o));
                        }
                        outBuff.append("\n");
                        outBuff.append("Relation:     " + inst.relationName() + '\n');
                        outBuff.append("Instances:    " + inst.numInstances() + '\n');
                        outBuff.append("Attributes:   " + inst.numAttributes() + '\n');
                        if (inst.numAttributes() < 100) {
                            int i;
                            boolean[] selected = new boolean[inst.numAttributes()];
                            for (i = 0; i < inst.numAttributes(); ++i) {
                                selected[i] = true;
                            }
                            if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                                int[] indices = ClustererPanel.this.m_ignoreKeyList.getSelectedIndices();
                                for (int i2 = 0; i2 < indices.length; ++i2) {
                                    selected[indices[i2]] = false;
                                }
                            }
                            if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                selected[ClustererPanel.this.m_ClassCombo.getSelectedIndex()] = false;
                            }
                            for (i = 0; i < inst.numAttributes(); ++i) {
                                if (!selected[i]) continue;
                                outBuff.append("              " + inst.attribute(i).name() + '\n');
                            }
                            if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty() || ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                                outBuff.append("Ignored:\n");
                                for (i = 0; i < inst.numAttributes(); ++i) {
                                    if (selected[i]) continue;
                                    outBuff.append("              " + inst.attribute(i).name() + '\n');
                                }
                            }
                        } else {
                            outBuff.append("              [list of attributes omitted]\n");
                        }
                        if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                            ignoredAtts = ClustererPanel.this.m_ignoreKeyList.getSelectedIndices();
                        }
                        if (ClustererPanel.this.m_ClassesToClustersBut.isSelected()) {
                            if (ignoredAtts == null) {
                                ignoredAtts = new int[]{ClustererPanel.this.m_ClassCombo.getSelectedIndex()};
                            } else {
                                int[] newIgnoredAtts = new int[ignoredAtts.length + 1];
                                System.arraycopy(ignoredAtts, 0, newIgnoredAtts, 0, ignoredAtts.length);
                                newIgnoredAtts[ignoredAtts.length] = ClustererPanel.this.m_ClassCombo.getSelectedIndex();
                                ignoredAtts = newIgnoredAtts;
                            }
                        }
                        outBuff.append("Test mode:    ");
                        switch (testMode) {
                            case 3: {
                                outBuff.append("evaluate on training data\n");
                                break;
                            }
                            case 2: {
                                outBuff.append("split " + percent + "% train, remainder test\n");
                                break;
                            }
                            case 4: {
                                outBuff.append("user supplied test set: " + userTest.numInstances() + " instances\n");
                                break;
                            }
                            case 5: {
                                outBuff.append("Classes to clusters evaluation on training data");
                            }
                        }
                        outBuff.append("\n");
                        ClustererPanel.this.m_History.addResult(name, outBuff);
                        ClustererPanel.this.m_History.setSingle(name);
                        ClustererPanel.this.m_Log.statusMessage("Building model on training data...");
                        trainTimeStart = System.currentTimeMillis();
                        clusterer.buildClusterer(ClustererPanel.this.removeClass(trainInst));
                        trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
                        outBuff.append("\n=== Clustering model (full training set) ===\n\n");
                        outBuff.append(clusterer.toString() + '\n');
                        outBuff.append("\nTime taken to build model (full training data) : " + Utils.doubleToString((double)trainTimeElapsed / 1000.0, 2) + " seconds\n\n");
                        ClustererPanel.this.m_History.updateResult(name);
                        if (clusterer instanceof Drawable) {
                            try {
                                grph = ((Drawable)((Object)clusterer)).graph();
                            }
                            catch (Exception newIgnoredAtts) {
                                // empty catch block
                            }
                        }
                        SerializedObject so = new SerializedObject(clusterer);
                        fullClusterer = (Clusterer)so.getObject();
                        ClusterEvaluation eval = new ClusterEvaluation();
                        eval.setClusterer(clusterer);
                        switch (testMode) {
                            case 3: 
                            case 5: {
                                ClustererPanel.this.m_Log.statusMessage("Clustering training data...");
                                eval.evaluateClusterer(trainInst, "", false);
                                plotInstances.setInstances(inst);
                                plotInstances.setClusterEvaluation(eval);
                                outBuff.append("=== Model and evaluation on training set ===\n\n");
                                break;
                            }
                            case 2: {
                                ClustererPanel.this.m_Log.statusMessage("Randomizing instances...");
                                inst.randomize(new Random(1L));
                                trainInst.randomize(new Random(1L));
                                int trainSize = trainInst.numInstances() * percent / 100;
                                int testSize = trainInst.numInstances() - trainSize;
                                Instances train = new Instances(trainInst, 0, trainSize);
                                Instances test = new Instances(trainInst, trainSize, testSize);
                                Instances testVis = new Instances(inst, trainSize, testSize);
                                ClustererPanel.this.m_Log.statusMessage("Building model on training split...");
                                trainTimeStart = System.currentTimeMillis();
                                clusterer.buildClusterer(train);
                                trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
                                ClustererPanel.this.m_Log.statusMessage("Evaluating on test split...");
                                eval.evaluateClusterer(test, "", false);
                                plotInstances.setInstances(testVis);
                                plotInstances.setClusterEvaluation(eval);
                                outBuff.append("=== Model and evaluation on test split ===\n");
                                outBuff.append(clusterer.toString() + "\n");
                                outBuff.append("\nTime taken to build model (percentage split) : " + Utils.doubleToString((double)trainTimeElapsed / 1000.0, 2) + " seconds\n\n");
                                break;
                            }
                            case 4: {
                                ClustererPanel.this.m_Log.statusMessage("Evaluating on test data...");
                                Instances userTestT = new Instances(userTest);
                                if (!ClustererPanel.this.m_ignoreKeyList.isSelectionEmpty()) {
                                    userTestT = ClustererPanel.this.removeIgnoreCols(userTestT);
                                }
                                eval.evaluateClusterer(userTestT, "", false);
                                plotInstances.setInstances(userTest);
                                plotInstances.setClusterEvaluation(eval);
                                outBuff.append("=== Evaluation on test set ===\n");
                                break;
                            }
                            default: {
                                throw new Exception("Test mode not implemented");
                            }
                        }
                        outBuff.append(eval.clusterResultsToString());
                        outBuff.append("\n");
                        ClustererPanel.this.m_History.updateResult(name);
                        ClustererPanel.this.m_Log.logMessage("Finished " + cname);
                        ClustererPanel.this.m_Log.statusMessage("OK");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        ClustererPanel.this.m_Log.logMessage(ex.getMessage());
                        JOptionPane.showMessageDialog(ClustererPanel.this, "Problem evaluating clusterer:\n" + ex.getMessage(), "Evaluate clusterer", 0);
                        ClustererPanel.this.m_Log.statusMessage("Problem evaluating clusterer");
                    }
                    finally {
                        if (plotInstances != null && plotInstances.canPlot(true)) {
                            ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                            if (ClustererPanel.this.getMainApplication() != null) {
                                Settings settings = ClustererPanel.this.getMainApplication().getApplicationSettings();
                                ClustererPanel.this.m_CurrentVis.applySettings(settings, "weka.gui.workbench.visualizepanel");
                            }
                            ClustererPanel.this.m_CurrentVis.setName(name + " (" + inst.relationName() + ")");
                            ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                            try {
                                ClustererPanel.this.m_CurrentVis.addPlot(plotInstances.getPlotData(name));
                            }
                            catch (Exception ex) {
                                System.err.println(ex);
                            }
                            plotInstances.cleanUp();
                            ArrayList<Object> vv = new ArrayList<Object>();
                            vv.add(fullClusterer);
                            Instances trainHeader = new Instances(ClustererPanel.this.m_Instances, 0);
                            vv.add(trainHeader);
                            if (ignoredAtts != null) {
                                vv.add(ignoredAtts);
                            }
                            if (saveVis) {
                                vv.add(ClustererPanel.this.m_CurrentVis);
                                if (grph != null) {
                                    vv.add(grph);
                                }
                            }
                            ClustererPanel.this.m_History.addObject(name, vv);
                        }
                        if (this.isInterrupted()) {
                            ClustererPanel.this.m_Log.logMessage("Interrupted " + cname);
                            ClustererPanel.this.m_Log.statusMessage("See error log");
                        }
                        ClustererPanel.this.m_RunThread = null;
                        ClustererPanel.this.m_StartBut.setEnabled(true);
                        ClustererPanel.this.m_StopBut.setEnabled(false);
                        ClustererPanel.this.m_ignoreBut.setEnabled(true);
                        if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    private Instances removeClass(Instances inst) {
        Remove af = new Remove();
        Instances retI = null;
        try {
            if (inst.classIndex() < 0) {
                retI = inst;
            } else {
                af.setAttributeIndices("" + (inst.classIndex() + 1));
                af.setInvertSelection(false);
                af.setInputFormat(inst);
                retI = Filter.useFilter(inst, af);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retI;
    }

    private Instances removeIgnoreCols(Instances inst) {
        int classIndex;
        if (this.m_ClassesToClustersBut.isSelected() && this.m_ignoreKeyList.isSelectedIndex(classIndex = this.m_ClassCombo.getSelectedIndex())) {
            this.m_ignoreKeyList.removeSelectionInterval(classIndex, classIndex);
        }
        int[] selected = this.m_ignoreKeyList.getSelectedIndices();
        Remove af = new Remove();
        Instances retI = null;
        try {
            af.setAttributeIndicesArray(selected);
            af.setInvertSelection(false);
            af.setInputFormat(inst);
            retI = Filter.useFilter(inst, af);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retI;
    }

    private Instances removeIgnoreCols(Instances inst, int[] toIgnore) {
        Remove af = new Remove();
        Instances retI = null;
        try {
            af.setAttributeIndicesArray(toIgnore);
            af.setInvertSelection(false);
            af.setInputFormat(inst);
            retI = Filter.useFilter(inst, af);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retI;
    }

    protected void stopClusterer() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
            this.m_RunThread.stop();
        }
    }

    protected void visualizeTree(String graphString, String treeName) {
        final JFrame jf = Utils.getWekaJFrame("Weka Cluster Tree Visualizer: " + treeName, this);
        jf.getContentPane().setLayout(new BorderLayout());
        if (graphString.contains("digraph")) {
            TreeVisualizer tv = new TreeVisualizer(null, graphString, (NodePlace)new PlaceNode2());
            jf.getContentPane().add((Component)tv, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this));
            jf.setVisible(true);
            tv.fitToScreen();
        } else if (graphString.startsWith("Newick:")) {
            HierarchyVisualizer tv = new HierarchyVisualizer(graphString.substring(7));
            jf.getContentPane().add((Component)tv, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this));
            jf.setVisible(true);
            tv.fitToScreen();
        }
    }

    protected void visualizeClusterAssignments(VisualizePanel sp) {
        if (sp != null) {
            String plotName = sp.getName();
            final JFrame jf = Utils.getWekaJFrame("Weka Clusterer Visualize: " + plotName, this);
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this));
            jf.setVisible(true);
        }
    }

    protected void visualizeClusterer(List<String> names, int x, int y) {
        final List<String> selectedNames = names;
        JPopupMenu resultListMenu = new JPopupMenu();
        JMenuItem visMainBuffer = new JMenuItem("View in main window");
        if (selectedNames != null && selectedNames.size() == 1) {
            visMainBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.m_History.setSingle((String)selectedNames.get(0));
                }
            });
        } else {
            visMainBuffer.setEnabled(false);
        }
        resultListMenu.add(visMainBuffer);
        JMenuItem visSepBuffer = new JMenuItem("View in separate window");
        if (selectedNames != null && selectedNames.size() == 1) {
            visSepBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.m_History.openFrame((String)selectedNames.get(0));
                }
            });
        } else {
            visSepBuffer.setEnabled(false);
        }
        resultListMenu.add(visSepBuffer);
        JMenuItem saveOutput = new JMenuItem("Save result buffer");
        if (selectedNames != null && selectedNames.size() == 1) {
            saveOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.saveBuffer((String)selectedNames.get(0));
                }
            });
        } else {
            saveOutput.setEnabled(false);
        }
        resultListMenu.add(saveOutput);
        JMenuItem deleteOutput = new JMenuItem("Delete result buffer(s)");
        if (selectedNames != null) {
            deleteOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.m_History.removeResults(selectedNames);
                }
            });
        } else {
            deleteOutput.setEnabled(false);
        }
        resultListMenu.add(deleteOutput);
        resultListMenu.addSeparator();
        JMenuItem loadModel = new JMenuItem("Load model");
        loadModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClustererPanel.this.loadClusterer();
            }
        });
        resultListMenu.add(loadModel);
        ArrayList o = null;
        if (selectedNames != null && selectedNames.size() == 1) {
            o = (ArrayList)this.m_History.getNamedObject(selectedNames.get(0));
        }
        VisualizePanel temp_vp = null;
        String temp_grph = null;
        Clusterer temp_clusterer = null;
        Instances temp_trainHeader = null;
        int[] temp_ignoreAtts = null;
        if (o != null) {
            for (int i = 0; i < o.size(); ++i) {
                Object temp = o.get(i);
                if (temp instanceof Clusterer) {
                    temp_clusterer = (Clusterer)temp;
                    continue;
                }
                if (temp instanceof Instances) {
                    temp_trainHeader = (Instances)temp;
                    continue;
                }
                if (temp instanceof int[]) {
                    temp_ignoreAtts = (int[])temp;
                    continue;
                }
                if (temp instanceof VisualizePanel) {
                    temp_vp = (VisualizePanel)temp;
                    continue;
                }
                if (!(temp instanceof String)) continue;
                temp_grph = (String)temp;
            }
        }
        final VisualizePanel vp = temp_vp;
        final String grph = temp_grph;
        final Clusterer clusterer = temp_clusterer;
        final Instances trainHeader = temp_trainHeader;
        final int[] ignoreAtts = temp_ignoreAtts;
        JMenuItem saveModel = new JMenuItem("Save model");
        if (clusterer != null && selectedNames != null && selectedNames.size() == 1) {
            saveModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.saveClusterer((String)selectedNames.get(0), clusterer, trainHeader, ignoreAtts);
                }
            });
        } else {
            saveModel.setEnabled(false);
        }
        resultListMenu.add(saveModel);
        JMenuItem reEvaluate = new JMenuItem("Re-evaluate model on current test set");
        if (clusterer != null && this.m_TestInstances != null && selectedNames != null && selectedNames.size() == 1) {
            reEvaluate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.reevaluateModel((String)selectedNames.get(0), clusterer, trainHeader, ignoreAtts);
                }
            });
        } else {
            reEvaluate.setEnabled(false);
        }
        resultListMenu.add(reEvaluate);
        JMenuItem reApplyConfig = new JMenuItem("Re-apply this model's configuration");
        if (clusterer != null) {
            reApplyConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.m_ClustererEditor.setValue(clusterer);
                }
            });
        } else {
            reApplyConfig.setEnabled(false);
        }
        resultListMenu.add(reApplyConfig);
        resultListMenu.addSeparator();
        JMenuItem visClusts = new JMenuItem("Visualize cluster assignments");
        if (vp != null) {
            visClusts.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClustererPanel.this.visualizeClusterAssignments(vp);
                }
            });
        } else {
            visClusts.setEnabled(false);
        }
        resultListMenu.add(visClusts);
        JMenuItem visTree = new JMenuItem("Visualize tree");
        if (grph != null) {
            visTree.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String title = vp != null ? vp.getName() : (String)selectedNames.get(0);
                    ClustererPanel.this.visualizeTree(grph, title);
                }
            });
        } else {
            visTree.setEnabled(false);
        }
        resultListMenu.add(visTree);
        JMenu visPlugins = new JMenu("Plugins");
        boolean availablePlugins = false;
        if (grph != null) {
            List<String> pluginsVector = PluginManager.getPluginNamesOfTypeList(TreeVisualizePlugin.class.getName());
            for (int i = 0; i < pluginsVector.size(); ++i) {
                String className = pluginsVector.get(i);
                try {
                    TreeVisualizePlugin plugin = (TreeVisualizePlugin)WekaPackageClassLoaderManager.objectForName(className);
                    if (plugin == null) continue;
                    availablePlugins = true;
                    JMenuItem pluginMenuItem = plugin.getVisualizeMenuItem(grph, selectedNames.get(0));
                    Version version = new Version();
                    if (pluginMenuItem == null) continue;
                    if (version.compareTo(plugin.getMinVersion()) < 0) {
                        pluginMenuItem.setText(pluginMenuItem.getText() + " (weka outdated)");
                    }
                    if (version.compareTo(plugin.getMaxVersion()) >= 0) {
                        pluginMenuItem.setText(pluginMenuItem.getText() + " (plugin outdated)");
                    }
                    visPlugins.add(pluginMenuItem);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (availablePlugins) {
            resultListMenu.add(visPlugins);
        }
        resultListMenu.show(this.m_History.getList(), x, y);
    }

    protected void saveBuffer(String name) {
        StringBuffer sb = this.m_History.getNamedBuffer(name);
        if (sb != null && this.m_SaveOut.save(sb)) {
            this.m_Log.logMessage("Save successful.");
        }
    }

    private void setIgnoreColumns() {
        ListSelectorDialog jd = new ListSelectorDialog(SwingUtilities.getWindowAncestor(this), this.m_ignoreKeyList);
        int result = jd.showDialog();
        if (result != 0) {
            this.m_ignoreKeyList.clearSelection();
        }
        this.updateCapabilitiesFilter(this.m_ClustererEditor.getCapabilitiesFilter());
    }

    protected void saveClusterer(String name, Clusterer clusterer, Instances trainHeader, int[] ignoredAtts) {
        File sFile = null;
        boolean saveOK = true;
        int returnVal = this.m_FileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            sFile = this.m_FileChooser.getSelectedFile();
            if (!sFile.getName().toLowerCase().endsWith(MODEL_FILE_EXTENSION)) {
                sFile = new File(sFile.getParent(), sFile.getName() + MODEL_FILE_EXTENSION);
            }
            this.m_Log.statusMessage("Saving model to file...");
            try {
                OutputStream os = new FileOutputStream(sFile);
                if (sFile.getName().endsWith(".gz")) {
                    os = new GZIPOutputStream(os);
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(os);
                objectOutputStream.writeObject(clusterer);
                if (trainHeader != null) {
                    objectOutputStream.writeObject(trainHeader);
                }
                if (ignoredAtts != null) {
                    objectOutputStream.writeObject(ignoredAtts);
                }
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e, "Save Failed", 0);
                saveOK = false;
            }
            if (saveOK) {
                this.m_Log.logMessage("Saved model (" + name + ") to file '" + sFile.getName() + "'");
            }
            this.m_Log.statusMessage("OK");
        }
    }

    protected void loadClusterer() {
        int returnVal = this.m_FileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File selected = this.m_FileChooser.getSelectedFile();
            Clusterer clusterer = null;
            Instances trainHeader = null;
            int[] ignoredAtts = null;
            this.m_Log.statusMessage("Loading model from file...");
            try {
                InputStream is = new FileInputStream(selected);
                if (selected.getName().endsWith(".gz")) {
                    is = new GZIPInputStream(is);
                }
                ObjectInputStream objectInputStream = SerializationHelper.getObjectInputStream(is);
                clusterer = (Clusterer)objectInputStream.readObject();
                try {
                    trainHeader = (Instances)objectInputStream.readObject();
                    ignoredAtts = (int[])objectInputStream.readObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                objectInputStream.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e, "Load Failed", 0);
            }
            this.m_Log.statusMessage("OK");
            if (clusterer != null) {
                this.m_Log.logMessage("Loaded model from file '" + selected.getName() + "'");
                String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                String cname = clusterer.getClass().getName();
                if (cname.startsWith("weka.clusterers.")) {
                    cname = cname.substring("weka.clusterers.".length());
                }
                name = name + cname + " from file '" + selected.getName() + "'";
                StringBuffer outBuff = new StringBuffer();
                outBuff.append("=== Model information ===\n\n");
                outBuff.append("Filename:     " + selected.getName() + "\n");
                outBuff.append("Scheme:       " + clusterer.getClass().getName());
                if (clusterer instanceof OptionHandler) {
                    String[] o = ((OptionHandler)((Object)clusterer)).getOptions();
                    outBuff.append(" " + Utils.joinOptions(o));
                }
                outBuff.append("\n");
                if (trainHeader != null) {
                    outBuff.append("Relation:     " + trainHeader.relationName() + '\n');
                    outBuff.append("Attributes:   " + trainHeader.numAttributes() + '\n');
                    if (trainHeader.numAttributes() < 100) {
                        int i;
                        boolean[] selectedAtts = new boolean[trainHeader.numAttributes()];
                        for (i = 0; i < trainHeader.numAttributes(); ++i) {
                            selectedAtts[i] = true;
                        }
                        if (ignoredAtts != null) {
                            for (i = 0; i < ignoredAtts.length; ++i) {
                                selectedAtts[ignoredAtts[i]] = false;
                            }
                        }
                        for (i = 0; i < trainHeader.numAttributes(); ++i) {
                            if (!selectedAtts[i]) continue;
                            outBuff.append("              " + trainHeader.attribute(i).name() + '\n');
                        }
                        if (ignoredAtts != null) {
                            outBuff.append("Ignored:\n");
                            for (int ignoredAtt : ignoredAtts) {
                                outBuff.append("              " + trainHeader.attribute(ignoredAtt).name() + '\n');
                            }
                        }
                    } else {
                        outBuff.append("              [list of attributes omitted]\n");
                    }
                } else {
                    outBuff.append("\nTraining data unknown\n");
                }
                outBuff.append("\n=== Clustering model ===\n\n");
                outBuff.append(clusterer.toString() + "\n");
                this.m_History.addResult(name, outBuff);
                this.m_History.setSingle(name);
                ArrayList<Object> vv = new ArrayList<Object>();
                vv.add(clusterer);
                if (trainHeader != null) {
                    vv.add(trainHeader);
                }
                if (ignoredAtts != null) {
                    vv.add(ignoredAtts);
                }
                String grph = null;
                if (clusterer instanceof Drawable) {
                    try {
                        grph = ((Drawable)((Object)clusterer)).graph();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (grph != null) {
                    vv.add(grph);
                }
                this.m_History.addObject(name, vv);
            }
        }
    }

    protected void reevaluateModel(final String name, final Clusterer clusterer, final Instances trainHeader, final int[] ignoredAtts) {
        if (this.m_RunThread == null) {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(true);
            this.m_ignoreBut.setEnabled(false);
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ClustererPanel.this.m_Log.statusMessage("Setting up...");
                    StringBuffer outBuff = ClustererPanel.this.m_History.getNamedBuffer(name);
                    Instances userTest = null;
                    ClustererAssignmentsPlotInstances plotInstances = ExplorerDefaults.getClustererAssignmentsPlotInstances();
                    plotInstances.setClusterer(clusterer);
                    if (ClustererPanel.this.m_TestInstances != null) {
                        userTest = new Instances(ClustererPanel.this.m_TestInstances);
                    }
                    boolean saveVis = ClustererPanel.this.m_StorePredictionsBut.isSelected();
                    Object grph = null;
                    try {
                        if (userTest == null) {
                            throw new Exception("No user test set has been opened");
                        }
                        if (trainHeader != null && !trainHeader.equalHeaders(userTest)) {
                            throw new Exception("Train and test set are not compatible\n" + trainHeader.equalHeadersMsg(userTest));
                        }
                        ClustererPanel.this.m_Log.statusMessage("Evaluating on test data...");
                        ClustererPanel.this.m_Log.logMessage("Re-evaluating clusterer (" + name + ") on test set");
                        ClustererPanel.this.m_Log.logMessage("Started reevaluate model");
                        if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskStarted();
                        }
                        ClusterEvaluation eval = new ClusterEvaluation();
                        eval.setClusterer(clusterer);
                        Instances userTestT = new Instances(userTest);
                        if (ignoredAtts != null) {
                            userTestT = ClustererPanel.this.removeIgnoreCols(userTestT, ignoredAtts);
                        }
                        eval.evaluateClusterer(userTestT);
                        plotInstances.setClusterEvaluation(eval);
                        plotInstances.setInstances(userTest);
                        plotInstances.setUp();
                        outBuff.append("\n=== Re-evaluation on test set ===\n\n");
                        outBuff.append("User supplied test set\n");
                        outBuff.append("Relation:     " + userTest.relationName() + '\n');
                        outBuff.append("Instances:    " + userTest.numInstances() + '\n');
                        outBuff.append("Attributes:   " + userTest.numAttributes() + "\n\n");
                        if (trainHeader == null) {
                            outBuff.append("NOTE - if test set is not compatible then results are unpredictable\n\n");
                        }
                        outBuff.append(eval.clusterResultsToString());
                        outBuff.append("\n");
                        ClustererPanel.this.m_History.updateResult(name);
                        ClustererPanel.this.m_Log.logMessage("Finished re-evaluation");
                        ClustererPanel.this.m_Log.statusMessage("OK");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        ClustererPanel.this.m_Log.logMessage(ex.getMessage());
                        JOptionPane.showMessageDialog(ClustererPanel.this, "Problem evaluating clusterer:\n" + ex.getMessage(), "Evaluate clusterer", 0);
                        ClustererPanel.this.m_Log.statusMessage("Problem evaluating clusterer");
                    }
                    finally {
                        if (plotInstances != null) {
                            ClustererPanel.this.m_CurrentVis = new VisualizePanel();
                            if (ClustererPanel.this.getMainApplication() != null) {
                                Settings settings = ClustererPanel.this.getMainApplication().getApplicationSettings();
                                ClustererPanel.this.m_CurrentVis.applySettings(settings, "weka.gui.workbench.visualizepanel");
                            }
                            ClustererPanel.this.m_CurrentVis.setName(name + " (" + userTest.relationName() + ")");
                            ClustererPanel.this.m_CurrentVis.setLog(ClustererPanel.this.m_Log);
                            try {
                                ClustererPanel.this.m_CurrentVis.addPlot(plotInstances.getPlotData(name));
                            }
                            catch (Exception ex) {
                                System.err.println(ex);
                            }
                            ArrayList<Object> vv = new ArrayList<Object>();
                            vv.add(clusterer);
                            if (trainHeader != null) {
                                vv.add(trainHeader);
                            }
                            if (ignoredAtts != null) {
                                vv.add(ignoredAtts);
                            }
                            if (saveVis) {
                                vv.add(ClustererPanel.this.m_CurrentVis);
                                if (grph != null) {
                                    vv.add(grph);
                                }
                            }
                            ClustererPanel.this.m_History.addObject(name, vv);
                        }
                        if (this.isInterrupted()) {
                            ClustererPanel.this.m_Log.logMessage("Interrupted reevaluate model");
                            ClustererPanel.this.m_Log.statusMessage("See error log");
                        }
                        ClustererPanel.this.m_RunThread = null;
                        ClustererPanel.this.m_StartBut.setEnabled(true);
                        ClustererPanel.this.m_StopBut.setEnabled(false);
                        ClustererPanel.this.m_ignoreBut.setEnabled(true);
                        if (ClustererPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)ClustererPanel.this.m_Log)).taskFinished();
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected void updateCapabilitiesFilter(Capabilities filter) {
        Capabilities filterClass;
        if (filter == null) {
            this.m_ClustererEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        Instances tempInst = !ExplorerDefaults.getInitGenericObjectEditorFilter() ? new Instances(this.m_Instances, 0) : new Instances(this.m_Instances);
        tempInst.setClassIndex(-1);
        if (!this.m_ignoreKeyList.isSelectionEmpty()) {
            tempInst = this.removeIgnoreCols(tempInst);
        }
        if (this.m_ClassesToClustersBut.isSelected()) {
            String classSelection = this.m_ClassCombo.getSelectedItem().toString();
            classSelection = classSelection.substring(classSelection.indexOf(")") + 1).trim();
            int classIndex = tempInst.attribute(classSelection).index();
            Remove rm = new Remove();
            rm.setAttributeIndices("" + (classIndex + 1));
            try {
                rm.setInputFormat(tempInst);
                tempInst = Filter.useFilter(tempInst, rm);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            filterClass = Capabilities.forInstances(tempInst);
        }
        catch (Exception e) {
            filterClass = new Capabilities(null);
        }
        this.m_ClustererEditor.setCapabilitiesFilter(filterClass);
        this.m_StartBut.setEnabled(true);
        Capabilities currentFilter = this.m_ClustererEditor.getCapabilitiesFilter();
        Clusterer clusterer = (Clusterer)this.m_ClustererEditor.getValue();
        Capabilities currentSchemeCapabilities = null;
        if (clusterer != null && currentFilter != null && clusterer instanceof CapabilitiesHandler && !(currentSchemeCapabilities = ((CapabilitiesHandler)((Object)clusterer)).getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
            this.m_StartBut.setEnabled(false);
        }
    }

    @Override
    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent e) {
        if (e.getFilter() == null) {
            this.updateCapabilitiesFilter(null);
        } else {
            this.updateCapabilitiesFilter((Capabilities)e.getFilter().clone());
        }
    }

    @Override
    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    @Override
    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    @Override
    public String getTabTitle() {
        return "Cluster";
    }

    @Override
    public String getTabTitleToolTip() {
        return "Identify instance clusters";
    }

    @Override
    public boolean requiresLog() {
        return true;
    }

    @Override
    public boolean acceptsInstances() {
        return true;
    }

    @Override
    public Defaults getDefaultSettings() {
        return new ClustererPanelDefaults();
    }

    @Override
    public boolean okToBeActive() {
        return this.m_Instances != null;
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.m_isActive) {
            this.settingsChanged();
        }
    }

    @Override
    public void settingsChanged() {
        if (this.getMainApplication() != null) {
            if (!this.m_initialSettingsSet) {
                this.m_initialSettingsSet = true;
                Clusterer initialC = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), ClustererPanelDefaults.CLUSTERER_KEY, ClustererPanelDefaults.CLUSTERER, Environment.getSystemWide());
                this.m_ClustererEditor.setValue(initialC);
                TestMode iniitalTestMode = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), ClustererPanelDefaults.TEST_MODE_KEY, ClustererPanelDefaults.TEST_MODE, Environment.getSystemWide());
                this.m_TrainBut.setSelected(iniitalTestMode == TestMode.USE_TRAINING_SET);
                this.m_PercentBut.setSelected(iniitalTestMode == TestMode.PERCENTAGE_SPLIT);
                this.m_TestSplitBut.setSelected(iniitalTestMode == TestMode.SUPPLIED_TEST_SET);
                this.m_ClassesToClustersBut.setSelected(iniitalTestMode == TestMode.CLASSES_TO_CLUSTERS_EVAL);
                this.m_StorePredictionsBut.setSelected(this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), ClustererPanelDefaults.STORE_CLUSTERS_FOR_VIS_KEY, Boolean.valueOf(true), Environment.getSystemWide()));
            }
            Font outputFont = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), ClustererPanelDefaults.OUTPUT_FONT_KEY, ClustererPanelDefaults.OUTPUT_FONT, Environment.getSystemWide());
            this.m_OutText.setFont(outputFont);
            Color textColor = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), ClustererPanelDefaults.OUTPUT_TEXT_COLOR_KEY, ClustererPanelDefaults.OUTPUT_TEXT_COLOR, Environment.getSystemWide());
            this.m_OutText.setForeground(textColor);
            Color outputBackgroundColor = this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), ClustererPanelDefaults.OUTPUT_BACKGROUND_COLOR_KEY, ClustererPanelDefaults.OUTPUT_BACKGROUND_COLOR, Environment.getSystemWide());
            this.m_OutText.setBackground(outputBackgroundColor);
            this.m_History.setBackground(outputBackgroundColor);
        }
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Weka Explorer: Cluster");
            jf.getContentPane().setLayout(new BorderLayout());
            ClustererPanel sp = new ClustererPanel();
            jf.getContentPane().add((Component)sp, "Center");
            LogPanel lp = new LogPanel();
            sp.setLog(lp);
            jf.getContentPane().add((Component)lp, "South");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setVisible(true);
            if (args.length == 1) {
                System.err.println("Loading instances from " + args[0]);
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances(r);
                sp.setInstances(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        GenericObjectEditor.registerEditors();
    }

    protected static final class ClustererPanelDefaults
    extends Defaults {
        public static final String ID = "weka.gui.explorer.clustererpanel";
        protected static final Settings.SettingKey CLUSTERER_KEY = new Settings.SettingKey("weka.gui.explorer.clustererpanel.initialClusterer", "Initial clusterer", "On startup, set this clusterer as the default one");
        protected static final Clusterer CLUSTERER = new SimpleKMeans();
        protected static final Settings.SettingKey TEST_MODE_KEY = new Settings.SettingKey("weka.gui.explorer.clustererpanel.initialTestMode", "Default test mode", "");
        protected static final TestMode TEST_MODE = TestMode.USE_TRAINING_SET;
        protected static final Settings.SettingKey STORE_CLUSTERS_FOR_VIS_KEY = new Settings.SettingKey("weka.gui.explorer.clustererpanel.storeClusterersForVis", "Store clusters for visualization", "");
        protected static final boolean STORE_CLUSTERS_VIS = true;
        protected static final Settings.SettingKey OUTPUT_FONT_KEY = new Settings.SettingKey("weka.gui.explorer.clustererpanel.outputFont", "Font for text output", "Font to use in the output area");
        protected static final Font OUTPUT_FONT = new Font("Monospaced", 0, 12);
        protected static final Settings.SettingKey OUTPUT_TEXT_COLOR_KEY = new Settings.SettingKey("weka.gui.explorer.clustererpanel.outputFontColor", "Output text color", "Color of output text");
        protected static final Color OUTPUT_TEXT_COLOR = Color.black;
        protected static final Settings.SettingKey OUTPUT_BACKGROUND_COLOR_KEY = new Settings.SettingKey("weka.gui.explorer.clustererpanel.outputBackgroundColor", "Output background color", "Output background color");
        protected static final Color OUTPUT_BACKGROUND_COLOR = Color.white;
        private static final long serialVersionUID = 2708388782229179493L;

        public ClustererPanelDefaults() {
            super(ID);
            this.m_defaults.put(CLUSTERER_KEY, CLUSTERER);
            this.m_defaults.put(TEST_MODE_KEY, TEST_MODE);
            this.m_defaults.put(STORE_CLUSTERS_FOR_VIS_KEY, true);
            this.m_defaults.put(OUTPUT_FONT_KEY, OUTPUT_FONT);
            this.m_defaults.put(OUTPUT_TEXT_COLOR_KEY, OUTPUT_TEXT_COLOR);
            this.m_defaults.put(OUTPUT_BACKGROUND_COLOR_KEY, OUTPUT_BACKGROUND_COLOR);
        }
    }

    public static enum TestMode {
        PERCENTAGE_SPLIT,
        USE_TRAINING_SET,
        SUPPLIED_TEST_SET,
        CLASSES_TO_CLUSTERS_EVAL;

    }
}

