/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.ClientWatchManager;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.proto.AuthPacket;
import org.apache.zookeeper.proto.ConnectRequest;
import org.apache.zookeeper.proto.ConnectResponse;
import org.apache.zookeeper.proto.CreateResponse;
import org.apache.zookeeper.proto.ExistsResponse;
import org.apache.zookeeper.proto.GetACLResponse;
import org.apache.zookeeper.proto.GetChildren2Response;
import org.apache.zookeeper.proto.GetChildrenResponse;
import org.apache.zookeeper.proto.GetDataResponse;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.proto.SetACLResponse;
import org.apache.zookeeper.proto.SetDataResponse;
import org.apache.zookeeper.proto.SetWatches;
import org.apache.zookeeper.proto.WatcherEvent;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.zookeeper.server.ZooTrace;

public class ClientCnxn {
    private static final Logger LOG = Logger.getLogger(ClientCnxn.class);
    private static boolean disableAutoWatchReset = Boolean.getBoolean("zookeeper.disableAutoWatchReset");
    public static final int packetLen;
    private final ArrayList<InetSocketAddress> serverAddrs = new ArrayList();
    private final ArrayList<AuthData> authInfo = new ArrayList();
    private final LinkedList<Packet> pendingQueue = new LinkedList();
    private final LinkedList<Packet> outgoingQueue = new LinkedList();
    private int nextAddrToTry = 0;
    private int connectTimeout;
    private volatile int negotiatedSessionTimeout;
    private int readTimeout;
    private final int sessionTimeout;
    private final ZooKeeper zooKeeper;
    private final ClientWatchManager watcher;
    private long sessionId;
    private byte[] sessionPasswd = new byte[16];
    final String chrootPath;
    final SendThread sendThread;
    final EventThread eventThread;
    final Selector selector = Selector.open();
    volatile boolean closing = false;
    Object eventOfDeath = new Object();
    static final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    volatile long lastZxid;
    private int xid = 1;

    public long getSessionId() {
        return this.sessionId;
    }

    public byte[] getSessionPasswd() {
        return this.sessionPasswd;
    }

    public int getSessionTimeout() {
        return this.negotiatedSessionTimeout;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        SocketAddress local = this.getLocalSocketAddress();
        SocketAddress remote2 = this.getRemoteSocketAddress();
        sb.append("sessionid:0x").append(Long.toHexString(this.getSessionId())).append(" local:").append(local).append(" remoteserver:").append(remote2).append(" lastZxid:").append(this.lastZxid).append(" xid:").append(this.xid).append(" sent:").append(this.sendThread.sentCount).append(" recv:").append(this.sendThread.recvCount).append(" queuedpkts:").append(this.outgoingQueue.size()).append(" pendingresp:").append(this.pendingQueue.size()).append(" queuedevents:").append(this.eventThread.waitingEvents.size());
        return sb.toString();
    }

    SocketAddress getRemoteSocketAddress() {
        try {
            return ((SocketChannel)this.sendThread.sockKey.channel()).socket().getRemoteSocketAddress();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    SocketAddress getLocalSocketAddress() {
        try {
            return ((SocketChannel)this.sendThread.sockKey.channel()).socket().getLocalSocketAddress();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public ClientCnxn(String hosts, int sessionTimeout, ZooKeeper zooKeeper, ClientWatchManager watcher) throws IOException {
        this(hosts, sessionTimeout, zooKeeper, watcher, 0L, new byte[16]);
    }

    public ClientCnxn(String hosts, int sessionTimeout, ZooKeeper zooKeeper, ClientWatchManager watcher, long sessionId, byte[] sessionPasswd) throws IOException {
        String[] hostsList;
        this.zooKeeper = zooKeeper;
        this.watcher = watcher;
        this.sessionId = sessionId;
        this.sessionPasswd = sessionPasswd;
        int off = hosts.indexOf(47);
        if (off >= 0) {
            String chrootPath = hosts.substring(off);
            if (chrootPath.length() == 1) {
                this.chrootPath = null;
            } else {
                PathUtils.validatePath(chrootPath);
                this.chrootPath = chrootPath;
            }
            hosts = hosts.substring(0, off);
        } else {
            this.chrootPath = null;
        }
        for (String host : hostsList = hosts.split(",")) {
            InetAddress[] addrs;
            int port = 2181;
            int pidx = host.lastIndexOf(58);
            if (pidx >= 0) {
                if (pidx < host.length() - 1) {
                    port = Integer.parseInt(host.substring(pidx + 1));
                }
                host = host.substring(0, pidx);
            }
            for (InetAddress addr : addrs = InetAddress.getAllByName(host)) {
                this.serverAddrs.add(new InetSocketAddress(addr, port));
            }
        }
        this.sessionTimeout = sessionTimeout;
        this.connectTimeout = sessionTimeout / hostsList.length;
        this.readTimeout = sessionTimeout * 2 / 3;
        Collections.shuffle(this.serverAddrs);
        this.sendThread = new SendThread();
        this.eventThread = new EventThread();
    }

    public static boolean getDisableAutoResetWatch() {
        return disableAutoWatchReset;
    }

    public static void setDisableAutoResetWatch(boolean b) {
        disableAutoWatchReset = b;
    }

    public void start() {
        this.sendThread.start();
        this.eventThread.start();
    }

    private static String makeThreadName(String suffix) {
        String name = Thread.currentThread().getName().replaceAll("-EventThread", "");
        return name + suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishPacket(Packet p) {
        if (p.watchRegistration != null) {
            p.watchRegistration.register(p.replyHeader.getErr());
        }
        if (p.cb == null) {
            Packet packet = p;
            synchronized (packet) {
                p.finished = true;
                p.notifyAll();
            }
        } else {
            p.finished = true;
            this.eventThread.queuePacket(p);
        }
    }

    private void conLossPacket(Packet p) {
        if (p.replyHeader == null) {
            return;
        }
        switch (this.zooKeeper.state) {
            case AUTH_FAILED: {
                p.replyHeader.setErr(KeeperException.Code.AUTHFAILED.intValue());
                break;
            }
            case CLOSED: {
                p.replyHeader.setErr(KeeperException.Code.SESSIONEXPIRED.intValue());
                break;
            }
            default: {
                p.replyHeader.setErr(KeeperException.Code.CONNECTIONLOSS.intValue());
            }
        }
        this.finishPacket(p);
    }

    public void disconnect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disconnecting client for session: 0x" + Long.toHexString(this.getSessionId()));
        }
        this.sendThread.close();
        this.eventThread.queueEventOfDeath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing client for session: 0x" + Long.toHexString(this.getSessionId()));
        }
        try {
            RequestHeader h = new RequestHeader();
            h.setType(-11);
            this.submitRequest(h, null, null, null);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.disconnect();
        }
    }

    private synchronized int getXid() {
        return this.xid++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplyHeader submitRequest(RequestHeader h, Record request, Record response, ZooKeeper.WatchRegistration watchRegistration) throws InterruptedException {
        Packet packet;
        ReplyHeader r = new ReplyHeader();
        Packet packet2 = packet = this.queuePacket(h, r, request, response, null, null, null, null, watchRegistration);
        synchronized (packet2) {
            while (!packet.finished) {
                packet.wait();
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Packet queuePacket(RequestHeader h, ReplyHeader r, Record request, Record response, AsyncCallback cb, String clientPath, String serverPath, Object ctx, ZooKeeper.WatchRegistration watchRegistration) {
        Packet packet = null;
        Object object = this.outgoingQueue;
        synchronized (object) {
            if (h.getType() != 11 && h.getType() != 100) {
                h.setXid(this.getXid());
            }
            packet = new Packet(h, r, request, response, null, watchRegistration);
            packet.cb = cb;
            packet.ctx = ctx;
            packet.clientPath = clientPath;
            packet.serverPath = serverPath;
            if (!this.zooKeeper.state.isAlive() || this.closing) {
                this.conLossPacket(packet);
            } else {
                if (h.getType() == -11) {
                    this.closing = true;
                }
                this.outgoingQueue.add(packet);
            }
        }
        object = this.sendThread;
        synchronized (object) {
            this.selector.wakeup();
        }
        return packet;
    }

    public void addAuthInfo(String scheme, byte[] auth) {
        if (!this.zooKeeper.state.isAlive()) {
            return;
        }
        this.authInfo.add(new AuthData(scheme, auth));
        this.queuePacket(new RequestHeader(-4, 100), null, new AuthPacket(0, scheme, auth), null, null, null, null, null, null);
    }

    static /* synthetic */ byte[] access$1202(ClientCnxn x0, byte[] x1) {
        x0.sessionPasswd = x1;
        return x1;
    }

    static {
        if (LOG.isDebugEnabled()) {
            LOG.debug("zookeeper.disableAutoWatchReset is " + disableAutoWatchReset);
        }
        packetLen = Integer.getInteger("jute.maxbuffer", 0x400000);
        uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                LOG.error("from " + t.getName(), e);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SendThread
    extends Thread {
        SelectionKey sockKey;
        final ByteBuffer lenBuffer;
        ByteBuffer incomingBuffer;
        boolean initialized;
        private long lastPingSentNs;
        long sentCount;
        long recvCount;
        int lastConnectIndex;
        int currentConnectIndex;
        Random r;
        private static final String RETRY_CONN_MSG = ", closing socket connection and attempting reconnect";

        void readLength() throws IOException {
            int len = this.incomingBuffer.getInt();
            if (len < 0 || len >= packetLen) {
                throw new IOException("Packet len" + len + " is out of range!");
            }
            this.incomingBuffer = ByteBuffer.allocate(len);
        }

        void readConnectResult() throws IOException {
            ByteBufferInputStream bbis = new ByteBufferInputStream(this.incomingBuffer);
            BinaryInputArchive bbia = BinaryInputArchive.getArchive(bbis);
            ConnectResponse conRsp = new ConnectResponse();
            conRsp.deserialize(bbia, "connect");
            ClientCnxn.this.negotiatedSessionTimeout = conRsp.getTimeOut();
            if (ClientCnxn.this.negotiatedSessionTimeout <= 0) {
                ((ClientCnxn)ClientCnxn.this).zooKeeper.state = ZooKeeper.States.CLOSED;
                ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
                ClientCnxn.this.eventThread.queueEventOfDeath();
                throw new SessionExpiredException("Unable to reconnect to ZooKeeper service, session 0x" + Long.toHexString(ClientCnxn.this.sessionId) + " has expired");
            }
            ClientCnxn.this.readTimeout = ClientCnxn.this.negotiatedSessionTimeout * 2 / 3;
            ClientCnxn.this.connectTimeout = ClientCnxn.this.negotiatedSessionTimeout / ClientCnxn.this.serverAddrs.size();
            ClientCnxn.this.sessionId = conRsp.getSessionId();
            ClientCnxn.access$1202(ClientCnxn.this, conRsp.getPasswd());
            ((ClientCnxn)ClientCnxn.this).zooKeeper.state = ZooKeeper.States.CONNECTED;
            LOG.info("Session establishment complete on server " + ((SocketChannel)this.sockKey.channel()).socket().getRemoteSocketAddress() + ", sessionid = 0x" + Long.toHexString(ClientCnxn.this.sessionId) + ", negotiated timeout = " + ClientCnxn.this.negotiatedSessionTimeout);
            ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.SyncConnected, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readResponse() throws IOException {
            ByteBufferInputStream bbis = new ByteBufferInputStream(this.incomingBuffer);
            BinaryInputArchive bbia = BinaryInputArchive.getArchive(bbis);
            ReplyHeader replyHdr = new ReplyHeader();
            replyHdr.deserialize(bbia, "header");
            if (replyHdr.getXid() == -2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got ping response for sessionid: 0x" + Long.toHexString(ClientCnxn.this.sessionId) + " after " + (System.nanoTime() - this.lastPingSentNs) / 1000000L + "ms");
                }
                return;
            }
            if (replyHdr.getXid() == -4) {
                if (replyHdr.getErr() == KeeperException.Code.AUTHFAILED.intValue()) {
                    ((ClientCnxn)ClientCnxn.this).zooKeeper.state = ZooKeeper.States.AUTH_FAILED;
                    ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.AuthFailed, null));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got auth sessionid:0x" + Long.toHexString(ClientCnxn.this.sessionId));
                }
                return;
            }
            if (replyHdr.getXid() == -1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got notification sessionid:0x" + Long.toHexString(ClientCnxn.this.sessionId));
                }
                WatcherEvent event = new WatcherEvent();
                event.deserialize(bbia, "response");
                if (ClientCnxn.this.chrootPath != null) {
                    String serverPath = event.getPath();
                    if (serverPath.compareTo(ClientCnxn.this.chrootPath) == 0) {
                        event.setPath("/");
                    } else {
                        event.setPath(serverPath.substring(ClientCnxn.this.chrootPath.length()));
                    }
                }
                WatchedEvent we = new WatchedEvent(event);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got " + we + " for sessionid 0x" + Long.toHexString(ClientCnxn.this.sessionId));
                }
                ClientCnxn.this.eventThread.queueEvent(we);
                return;
            }
            if (ClientCnxn.this.pendingQueue.size() == 0) {
                throw new IOException("Nothing in the queue, but got " + replyHdr.getXid());
            }
            Packet packet = null;
            LinkedList linkedList = ClientCnxn.this.pendingQueue;
            synchronized (linkedList) {
                packet = (Packet)ClientCnxn.this.pendingQueue.remove();
            }
            try {
                if (packet.header.getXid() != replyHdr.getXid()) {
                    packet.replyHeader.setErr(KeeperException.Code.CONNECTIONLOSS.intValue());
                    throw new IOException("Xid out of order. Got " + replyHdr.getXid() + " expected " + packet.header.getXid());
                }
                packet.replyHeader.setXid(replyHdr.getXid());
                packet.replyHeader.setErr(replyHdr.getErr());
                packet.replyHeader.setZxid(replyHdr.getZxid());
                if (replyHdr.getZxid() > 0L) {
                    ClientCnxn.this.lastZxid = replyHdr.getZxid();
                }
                if (packet.response != null && replyHdr.getErr() == 0) {
                    packet.response.deserialize(bbia, "response");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reading reply sessionid:0x" + Long.toHexString(ClientCnxn.this.sessionId) + ", packet:: " + packet);
                }
            }
            finally {
                ClientCnxn.this.finishPacket(packet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean doIO() throws InterruptedException, IOException {
            boolean packetReceived = false;
            SocketChannel sock = (SocketChannel)this.sockKey.channel();
            if (sock == null) {
                throw new IOException("Socket is null!");
            }
            if (this.sockKey.isReadable()) {
                int rc = sock.read(this.incomingBuffer);
                if (rc < 0) {
                    throw new EndOfStreamException("Unable to read additional data from server sessionid 0x" + Long.toHexString(ClientCnxn.this.sessionId) + ", likely server has closed socket");
                }
                if (!this.incomingBuffer.hasRemaining()) {
                    this.incomingBuffer.flip();
                    if (this.incomingBuffer == this.lenBuffer) {
                        ++this.recvCount;
                        this.readLength();
                    } else if (!this.initialized) {
                        this.readConnectResult();
                        this.enableRead();
                        if (!ClientCnxn.this.outgoingQueue.isEmpty()) {
                            this.enableWrite();
                        }
                        this.lenBuffer.clear();
                        this.incomingBuffer = this.lenBuffer;
                        packetReceived = true;
                        this.initialized = true;
                    } else {
                        this.readResponse();
                        this.lenBuffer.clear();
                        this.incomingBuffer = this.lenBuffer;
                        packetReceived = true;
                    }
                }
            }
            if (this.sockKey.isWritable()) {
                LinkedList linkedList = ClientCnxn.this.outgoingQueue;
                synchronized (linkedList) {
                    if (!ClientCnxn.this.outgoingQueue.isEmpty()) {
                        ByteBuffer pbb = ((Packet)((ClientCnxn)ClientCnxn.this).outgoingQueue.getFirst()).bb;
                        sock.write(pbb);
                        if (!pbb.hasRemaining()) {
                            ++this.sentCount;
                            Packet p = (Packet)ClientCnxn.this.outgoingQueue.removeFirst();
                            if (p.header != null && p.header.getType() != 11 && p.header.getType() != 100) {
                                ClientCnxn.this.pendingQueue.add(p);
                            }
                        }
                    }
                }
            }
            if (ClientCnxn.this.outgoingQueue.isEmpty()) {
                this.disableWrite();
            } else {
                this.enableWrite();
            }
            return packetReceived;
        }

        private synchronized void enableWrite() {
            int i = this.sockKey.interestOps();
            if ((i & 4) == 0) {
                this.sockKey.interestOps(i | 4);
            }
        }

        private synchronized void disableWrite() {
            int i = this.sockKey.interestOps();
            if ((i & 4) != 0) {
                this.sockKey.interestOps(i & 0xFFFFFFFB);
            }
        }

        private synchronized void enableRead() {
            int i = this.sockKey.interestOps();
            if ((i & 1) == 0) {
                this.sockKey.interestOps(i | 1);
            }
        }

        private synchronized void disableRead() {
            int i = this.sockKey.interestOps();
            if ((i & 1) != 0) {
                this.sockKey.interestOps(i & 0xFFFFFFFE);
            }
        }

        SendThread() {
            super(ClientCnxn.makeThreadName("-SendThread()"));
            this.incomingBuffer = this.lenBuffer = ByteBuffer.allocateDirect(4);
            this.sentCount = 0L;
            this.recvCount = 0L;
            this.lastConnectIndex = -1;
            this.r = new Random(System.nanoTime());
            ((ClientCnxn)ClientCnxn.this).zooKeeper.state = ZooKeeper.States.CONNECTING;
            this.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void primeConnection(SelectionKey k) throws IOException {
            LOG.info("Socket connection established to " + ((SocketChannel)this.sockKey.channel()).socket().getRemoteSocketAddress() + ", initiating session");
            this.lastConnectIndex = this.currentConnectIndex;
            ConnectRequest conReq = new ConnectRequest(0, ClientCnxn.this.lastZxid, ClientCnxn.this.sessionTimeout, ClientCnxn.this.sessionId, ClientCnxn.this.sessionPasswd);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
            boa.writeInt(-1, "len");
            conReq.serialize(boa, "connect");
            baos.close();
            ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
            bb.putInt(bb.capacity() - 4);
            bb.rewind();
            Object object = ClientCnxn.this.outgoingQueue;
            synchronized (object) {
                if (!disableAutoWatchReset) {
                    List<String> dataWatches = ClientCnxn.this.zooKeeper.getDataWatches();
                    List<String> existWatches = ClientCnxn.this.zooKeeper.getExistWatches();
                    List<String> childWatches = ClientCnxn.this.zooKeeper.getChildWatches();
                    if (!(dataWatches.isEmpty() && existWatches.isEmpty() && childWatches.isEmpty())) {
                        SetWatches sw = new SetWatches(ClientCnxn.this.lastZxid, this.prependChroot(dataWatches), this.prependChroot(existWatches), this.prependChroot(childWatches));
                        RequestHeader h = new RequestHeader();
                        h.setType(101);
                        h.setXid(-8);
                        Packet packet = new Packet(h, new ReplyHeader(), sw, null, null, null);
                        ClientCnxn.this.outgoingQueue.addFirst(packet);
                    }
                }
                for (AuthData id : ClientCnxn.this.authInfo) {
                    ClientCnxn.this.outgoingQueue.addFirst(new Packet(new RequestHeader(-4, 100), null, new AuthPacket(0, id.scheme, id.data), null, null, null));
                }
                ClientCnxn.this.outgoingQueue.addFirst(new Packet(null, null, null, null, bb, null));
            }
            object = this;
            synchronized (object) {
                k.interestOps(5);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session establishment request sent on " + ((SocketChannel)this.sockKey.channel()).socket().getRemoteSocketAddress());
            }
        }

        private List<String> prependChroot(List<String> paths) {
            if (ClientCnxn.this.chrootPath != null && !paths.isEmpty()) {
                for (int i = 0; i < paths.size(); ++i) {
                    String clientPath = paths.get(i);
                    String serverPath = clientPath.length() == 1 ? ClientCnxn.this.chrootPath : ClientCnxn.this.chrootPath + clientPath;
                    paths.set(i, serverPath);
                }
            }
            return paths;
        }

        private void sendPing() {
            this.lastPingSentNs = System.nanoTime();
            RequestHeader h = new RequestHeader(-2, 11);
            ClientCnxn.this.queuePacket(h, null, null, null, null, null, null, null, null);
        }

        private void startConnect() throws IOException {
            if (this.lastConnectIndex == -1) {
                this.lastConnectIndex = 0;
            } else {
                try {
                    Thread.sleep(this.r.nextInt(1000));
                }
                catch (InterruptedException e1) {
                    LOG.warn("Unexpected exception", e1);
                }
                if (ClientCnxn.this.nextAddrToTry == this.lastConnectIndex) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Unexpected exception", e);
                    }
                }
            }
            ((ClientCnxn)ClientCnxn.this).zooKeeper.state = ZooKeeper.States.CONNECTING;
            this.currentConnectIndex = ClientCnxn.this.nextAddrToTry;
            InetSocketAddress addr = (InetSocketAddress)ClientCnxn.this.serverAddrs.get(ClientCnxn.this.nextAddrToTry);
            ClientCnxn.this.nextAddrToTry++;
            if (ClientCnxn.this.nextAddrToTry == ClientCnxn.this.serverAddrs.size()) {
                ClientCnxn.this.nextAddrToTry = 0;
            }
            LOG.info("Opening socket connection to server " + addr);
            SocketChannel sock = SocketChannel.open();
            sock.configureBlocking(false);
            sock.socket().setSoLinger(false, -1);
            sock.socket().setTcpNoDelay(true);
            this.setName(this.getName().replaceAll("\\(.*\\)", "(" + addr.getHostName() + ":" + addr.getPort() + ")"));
            try {
                this.sockKey = sock.register(ClientCnxn.this.selector, 8);
                boolean immediateConnect = sock.connect(addr);
                if (immediateConnect) {
                    this.primeConnection(this.sockKey);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to open socket to " + addr);
                sock.close();
                throw e;
            }
            this.initialized = false;
            this.lenBuffer.clear();
            this.incomingBuffer = this.lenBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long now;
            long lastHeard = now = System.currentTimeMillis();
            long lastSend = now;
            while (((ClientCnxn)ClientCnxn.this).zooKeeper.state.isAlive()) {
                try {
                    Set<SelectionKey> selected;
                    if (this.sockKey == null) {
                        if (ClientCnxn.this.closing) break;
                        this.startConnect();
                        lastSend = now;
                        lastHeard = now;
                    }
                    int idleRecv = (int)(now - lastHeard);
                    int idleSend = (int)(now - lastSend);
                    int to2 = ClientCnxn.this.readTimeout - idleRecv;
                    if (((ClientCnxn)ClientCnxn.this).zooKeeper.state != ZooKeeper.States.CONNECTED) {
                        to2 = ClientCnxn.this.connectTimeout - idleRecv;
                    }
                    if (to2 <= 0) {
                        throw new SessionTimeoutException("Client session timed out, have not heard from server in " + idleRecv + "ms" + " for sessionid 0x" + Long.toHexString(ClientCnxn.this.sessionId));
                    }
                    if (((ClientCnxn)ClientCnxn.this).zooKeeper.state == ZooKeeper.States.CONNECTED) {
                        int timeToNextPing = ClientCnxn.this.readTimeout / 2 - idleSend;
                        if (timeToNextPing <= 0) {
                            this.sendPing();
                            lastSend = now;
                            this.enableWrite();
                        } else if (timeToNextPing < to2) {
                            to2 = timeToNextPing;
                        }
                    }
                    ClientCnxn.this.selector.select(to2);
                    SendThread sendThread = this;
                    synchronized (sendThread) {
                        selected = ClientCnxn.this.selector.selectedKeys();
                    }
                    now = System.currentTimeMillis();
                    for (SelectionKey k : selected) {
                        SocketChannel sc = (SocketChannel)k.channel();
                        if ((k.readyOps() & 8) != 0) {
                            if (!sc.finishConnect()) continue;
                            lastHeard = now;
                            lastSend = now;
                            this.primeConnection(k);
                            continue;
                        }
                        if ((k.readyOps() & 5) == 0) continue;
                        if (ClientCnxn.this.outgoingQueue.size() > 0) {
                            lastSend = now;
                        }
                        if (!this.doIO()) continue;
                        lastHeard = now;
                    }
                    if (((ClientCnxn)ClientCnxn.this).zooKeeper.state == ZooKeeper.States.CONNECTED) {
                        if (ClientCnxn.this.outgoingQueue.size() > 0) {
                            this.enableWrite();
                        } else {
                            this.disableWrite();
                        }
                    }
                    selected.clear();
                }
                catch (Throwable e) {
                    if (ClientCnxn.this.closing) {
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("An exception was thrown while closing send thread for session 0x" + Long.toHexString(ClientCnxn.this.getSessionId()) + " : " + e.getMessage());
                        break;
                    }
                    if (e instanceof SessionExpiredException) {
                        LOG.info(e.getMessage() + ", closing socket connection");
                    } else if (e instanceof SessionTimeoutException) {
                        LOG.info(e.getMessage() + RETRY_CONN_MSG);
                    } else if (e instanceof EndOfStreamException) {
                        LOG.info(e.getMessage() + RETRY_CONN_MSG);
                    } else {
                        LOG.warn("Session 0x" + Long.toHexString(ClientCnxn.this.getSessionId()) + " for server " + ((SocketChannel)this.sockKey.channel()).socket().getRemoteSocketAddress() + ", unexpected error" + RETRY_CONN_MSG, e);
                    }
                    this.cleanup();
                    if (((ClientCnxn)ClientCnxn.this).zooKeeper.state.isAlive()) {
                        ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
                    }
                    lastHeard = now = System.currentTimeMillis();
                    lastSend = now;
                }
            }
            this.cleanup();
            try {
                ClientCnxn.this.selector.close();
            }
            catch (IOException e) {
                LOG.warn("Ignoring exception during selector close", e);
            }
            if (((ClientCnxn)ClientCnxn.this).zooKeeper.state.isAlive()) {
                ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
            }
            ZooTrace.logTraceMessage(LOG, ZooTrace.getTextTraceLevel(), "SendThread exitedloop.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup() {
            block23: {
                block22: {
                    if (this.sockKey != null) {
                        SocketChannel sock;
                        block21: {
                            block20: {
                                block19: {
                                    sock = (SocketChannel)this.sockKey.channel();
                                    this.sockKey.cancel();
                                    try {
                                        sock.socket().shutdownInput();
                                    }
                                    catch (IOException e) {
                                        if (!LOG.isDebugEnabled()) break block19;
                                        LOG.debug("Ignoring exception during shutdown input", e);
                                    }
                                }
                                try {
                                    sock.socket().shutdownOutput();
                                }
                                catch (IOException e) {
                                    if (!LOG.isDebugEnabled()) break block20;
                                    LOG.debug("Ignoring exception during shutdown output", e);
                                }
                            }
                            try {
                                sock.socket().close();
                            }
                            catch (IOException e) {
                                if (!LOG.isDebugEnabled()) break block21;
                                LOG.debug("Ignoring exception during socket close", e);
                            }
                        }
                        try {
                            sock.close();
                        }
                        catch (IOException e) {
                            if (!LOG.isDebugEnabled()) break block22;
                            LOG.debug("Ignoring exception during channel close", e);
                        }
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    if (!LOG.isDebugEnabled()) break block23;
                    LOG.debug("SendThread interrupted during sleep, ignoring");
                }
            }
            this.sockKey = null;
            LinkedList linkedList = ClientCnxn.this.pendingQueue;
            synchronized (linkedList) {
                for (Packet p : ClientCnxn.this.pendingQueue) {
                    ClientCnxn.this.conLossPacket(p);
                }
                ClientCnxn.this.pendingQueue.clear();
            }
            linkedList = ClientCnxn.this.outgoingQueue;
            synchronized (linkedList) {
                for (Packet p : ClientCnxn.this.outgoingQueue) {
                    ClientCnxn.this.conLossPacket(p);
                }
                ClientCnxn.this.outgoingQueue.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            SendThread sendThread = this;
            synchronized (sendThread) {
                ((ClientCnxn)ClientCnxn.this).zooKeeper.state = ZooKeeper.States.CLOSED;
                ClientCnxn.this.selector.wakeup();
            }
        }
    }

    private static class SessionExpiredException
    extends IOException {
        private static final long serialVersionUID = -1388816932076193249L;

        public SessionExpiredException(String msg) {
            super(msg);
        }
    }

    private static class SessionTimeoutException
    extends IOException {
        private static final long serialVersionUID = 824482094072071178L;

        public SessionTimeoutException(String msg) {
            super(msg);
        }
    }

    private static class EndOfStreamException
    extends IOException {
        private static final long serialVersionUID = -5438877188796231422L;

        public EndOfStreamException(String msg) {
            super(msg);
        }

        public String toString() {
            return "EndOfStreamException: " + this.getMessage();
        }
    }

    class EventThread
    extends Thread {
        private final LinkedBlockingQueue<Object> waitingEvents;
        private volatile Watcher.Event.KeeperState sessionState;
        private volatile boolean wasKilled;
        private volatile boolean isRunning;

        EventThread() {
            super(ClientCnxn.makeThreadName("-EventThread"));
            this.waitingEvents = new LinkedBlockingQueue();
            this.sessionState = Watcher.Event.KeeperState.Disconnected;
            this.wasKilled = false;
            this.isRunning = false;
            this.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            this.setDaemon(true);
        }

        public void queueEvent(WatchedEvent event) {
            if (event.getType() == Watcher.Event.EventType.None && this.sessionState == event.getState()) {
                return;
            }
            this.sessionState = event.getState();
            WatcherSetEventPair pair2 = new WatcherSetEventPair(ClientCnxn.this.watcher.materialize(event.getState(), event.getType(), event.getPath()), event);
            this.waitingEvents.add(pair2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queuePacket(Packet packet) {
            if (this.wasKilled) {
                LinkedBlockingQueue<Object> linkedBlockingQueue = this.waitingEvents;
                synchronized (linkedBlockingQueue) {
                    if (this.isRunning) {
                        this.waitingEvents.add(packet);
                    } else {
                        this.processEvent(packet);
                    }
                }
            } else {
                this.waitingEvents.add(packet);
            }
        }

        public void queueEventOfDeath() {
            this.waitingEvents.add(ClientCnxn.this.eventOfDeath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                this.isRunning = true;
                while (true) {
                    Object event;
                    if ((event = this.waitingEvents.take()) == ClientCnxn.this.eventOfDeath) {
                        this.wasKilled = true;
                    } else {
                        this.processEvent(event);
                    }
                    if (!this.wasKilled) continue;
                    LinkedBlockingQueue<Object> linkedBlockingQueue = this.waitingEvents;
                    synchronized (linkedBlockingQueue) {
                        if (this.waitingEvents.isEmpty()) {
                            this.isRunning = false;
                            break;
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.error("Event thread exiting due to interruption", e);
            }
            LOG.info("EventThread shut down");
        }

        private void processEvent(Object event) {
            try {
                if (event instanceof WatcherSetEventPair) {
                    WatcherSetEventPair pair2 = (WatcherSetEventPair)event;
                    for (Watcher watcher : pair2.watchers) {
                        try {
                            watcher.process(pair2.event);
                        }
                        catch (Throwable t) {
                            LOG.error("Error while calling watcher ", t);
                        }
                    }
                } else {
                    Packet p = (Packet)event;
                    int rc = 0;
                    String clientPath = p.clientPath;
                    if (p.replyHeader.getErr() != 0) {
                        rc = p.replyHeader.getErr();
                    }
                    if (p.cb == null) {
                        LOG.warn("Somehow a null cb got to EventThread!");
                    } else if (p.response instanceof ExistsResponse || p.response instanceof SetDataResponse || p.response instanceof SetACLResponse) {
                        AsyncCallback.StatCallback cb = (AsyncCallback.StatCallback)p.cb;
                        if (rc == 0) {
                            if (p.response instanceof ExistsResponse) {
                                cb.processResult(rc, clientPath, p.ctx, ((ExistsResponse)p.response).getStat());
                            } else if (p.response instanceof SetDataResponse) {
                                cb.processResult(rc, clientPath, p.ctx, ((SetDataResponse)p.response).getStat());
                            } else if (p.response instanceof SetACLResponse) {
                                cb.processResult(rc, clientPath, p.ctx, ((SetACLResponse)p.response).getStat());
                            }
                        } else {
                            cb.processResult(rc, clientPath, p.ctx, null);
                        }
                    } else if (p.response instanceof GetDataResponse) {
                        AsyncCallback.DataCallback cb = (AsyncCallback.DataCallback)p.cb;
                        GetDataResponse rsp = (GetDataResponse)p.response;
                        if (rc == 0) {
                            cb.processResult(rc, clientPath, p.ctx, rsp.getData(), rsp.getStat());
                        } else {
                            cb.processResult(rc, clientPath, p.ctx, null, null);
                        }
                    } else if (p.response instanceof GetACLResponse) {
                        AsyncCallback.ACLCallback cb = (AsyncCallback.ACLCallback)p.cb;
                        GetACLResponse rsp = (GetACLResponse)p.response;
                        if (rc == 0) {
                            cb.processResult(rc, clientPath, p.ctx, rsp.getAcl(), rsp.getStat());
                        } else {
                            cb.processResult(rc, clientPath, p.ctx, null, null);
                        }
                    } else if (p.response instanceof GetChildrenResponse) {
                        AsyncCallback.ChildrenCallback cb = (AsyncCallback.ChildrenCallback)p.cb;
                        GetChildrenResponse rsp = (GetChildrenResponse)p.response;
                        if (rc == 0) {
                            cb.processResult(rc, clientPath, p.ctx, rsp.getChildren());
                        } else {
                            cb.processResult(rc, clientPath, p.ctx, null);
                        }
                    } else if (p.response instanceof GetChildren2Response) {
                        AsyncCallback.Children2Callback cb = (AsyncCallback.Children2Callback)p.cb;
                        GetChildren2Response rsp = (GetChildren2Response)p.response;
                        if (rc == 0) {
                            cb.processResult(rc, clientPath, p.ctx, rsp.getChildren(), rsp.getStat());
                        } else {
                            cb.processResult(rc, clientPath, p.ctx, null, null);
                        }
                    } else if (p.response instanceof CreateResponse) {
                        AsyncCallback.StringCallback cb = (AsyncCallback.StringCallback)p.cb;
                        CreateResponse rsp = (CreateResponse)p.response;
                        if (rc == 0) {
                            cb.processResult(rc, clientPath, p.ctx, ClientCnxn.this.chrootPath == null ? rsp.getPath() : rsp.getPath().substring(ClientCnxn.this.chrootPath.length()));
                        } else {
                            cb.processResult(rc, clientPath, p.ctx, null);
                        }
                    } else if (p.cb instanceof AsyncCallback.VoidCallback) {
                        AsyncCallback.VoidCallback cb = (AsyncCallback.VoidCallback)p.cb;
                        cb.processResult(rc, clientPath, p.ctx);
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("Caught unexpected throwable", t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WatcherSetEventPair {
        private final Set<Watcher> watchers;
        private final WatchedEvent event;

        public WatcherSetEventPair(Set<Watcher> watchers, WatchedEvent event) {
            this.watchers = watchers;
            this.event = event;
        }
    }

    static class Packet {
        RequestHeader header;
        ByteBuffer bb;
        String clientPath;
        String serverPath;
        ReplyHeader replyHeader;
        Record request;
        Record response;
        boolean finished;
        AsyncCallback cb;
        Object ctx;
        ZooKeeper.WatchRegistration watchRegistration;

        Packet(RequestHeader header, ReplyHeader replyHeader, Record record, Record response, ByteBuffer bb, ZooKeeper.WatchRegistration watchRegistration) {
            this.header = header;
            this.replyHeader = replyHeader;
            this.request = record;
            this.response = response;
            if (bb != null) {
                this.bb = bb;
            } else {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
                    boa.writeInt(-1, "len");
                    header.serialize(boa, "header");
                    if (record != null) {
                        record.serialize(boa, "request");
                    }
                    baos.close();
                    this.bb = ByteBuffer.wrap(baos.toByteArray());
                    this.bb.putInt(this.bb.capacity() - 4);
                    this.bb.rewind();
                }
                catch (IOException e) {
                    LOG.warn("Ignoring unexpected exception", e);
                }
            }
            this.watchRegistration = watchRegistration;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("clientPath:" + this.clientPath);
            sb.append(" serverPath:" + this.serverPath);
            sb.append(" finished:" + this.finished);
            sb.append(" header:: " + this.header);
            sb.append(" replyHeader:: " + this.replyHeader);
            sb.append(" request:: " + this.request);
            sb.append(" response:: " + this.response);
            return sb.toString().replaceAll("\r*\n+", " ");
        }
    }

    static class AuthData {
        String scheme;
        byte[] data;

        AuthData(String scheme, byte[] data2) {
            this.scheme = scheme;
            this.data = data2;
        }
    }
}

