/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jdplus.toolkit.base.api.timeseries.StaticTsDataSupplier;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDataSupplier;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.api.timeseries.regression.TsDataSuppliers;

public class Dictionary {
    public static final String R = "r";
    public static final String RPREFIX = "r@";
    private final Map<String, TsData> dictionary = new LinkedHashMap<String, TsData>();

    public static Dictionary of(Map<String, TsData> rslt) {
        Dictionary dic = new Dictionary();
        dic.dictionary.putAll(rslt);
        return dic;
    }

    public void add(String name, TsData s) {
        this.dictionary.put(name, s);
    }

    public String[] names() {
        return this.dictionary.keySet().toArray(new String[this.dictionary.size()]);
    }

    public TsData get(String name) {
        return this.dictionary.get(name);
    }

    public Map<String, TsData> data() {
        return Collections.unmodifiableMap(this.dictionary);
    }

    public ModellingContext toContext() {
        ModellingContext context = new ModellingContext();
        if (!this.dictionary.isEmpty()) {
            TsDataSuppliers vars = new TsDataSuppliers();
            this.dictionary.forEach((n, s) -> vars.set(n, (Object)new StaticTsDataSupplier(s)));
            context.getTsVariableManagers().set(R, (Object)vars);
        }
        return context;
    }

    public static Dictionary fromContext(ModellingContext context) {
        Dictionary dic = new Dictionary();
        if (context == null) {
            return dic;
        }
        String[] vars = context.getTsVariableManagers().getNames();
        for (int i = 0; i < vars.length; ++i) {
            String[] names;
            TsDataSuppliers cur = context.getTsVariables(vars[i]);
            for (String name : names = cur.getNames()) {
                TsDataSupplier v = (TsDataSupplier)cur.get(name);
                TsData d = v.get();
                if (d == null) continue;
                if (vars[i].equals(R)) {
                    dic.add(name, d);
                    continue;
                }
                StringBuilder lname = new StringBuilder();
                lname.append(vars[i]).append('@').append(name);
                dic.add(lname.toString(), d);
            }
        }
        return dic;
    }
}

