/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.stats.DescriptiveStatistics;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class Kurtosis {
    private final DescriptiveStatistics stats;

    public Kurtosis(DoubleSeq data) {
        this.stats = DescriptiveStatistics.of(data);
    }

    public Kurtosis(DescriptiveStatistics stats) {
        this.stats = stats;
    }

    public StatisticalTest build() {
        int n = this.stats.getObservationsCount();
        Normal dist = new Normal(3.0, Math.sqrt(24.0 / (double)n));
        return TestsUtility.testOf(this.stats.getKurtosis(), dist, TestType.TwoSided);
    }
}

