/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IFunctionPoint;
import jdplus.toolkit.base.core.math.functions.PartialMapping;

public class PartialFunction
implements IFunction {
    private final PartialMapping mapping;
    private final IFunction fn;

    public PartialFunction(PartialMapping mapping, IFunction fn) {
        this.mapping = mapping;
        this.fn = fn;
    }

    @Override
    public IFunctionPoint evaluate(DoubleSeq parameters) {
        return new Point(parameters);
    }

    @Override
    public PartialMapping getDomain() {
        return this.mapping;
    }

    class Point
    implements IFunctionPoint {
        private final DoubleSeq pt;

        Point(DoubleSeq pt) {
            this.pt = pt;
        }

        @Override
        public IFunction getFunction() {
            return PartialFunction.this;
        }

        @Override
        public DoubleSeq getParameters() {
            return this.pt;
        }

        @Override
        public double getValue() {
            return PartialFunction.this.fn.evaluate(PartialFunction.this.mapping.convert(this.pt)).getValue();
        }
    }
}

