/*
 * Decompiled with CFR 0.152.
 */
package internal.text.base.api;

import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import jdplus.text.base.api.TxtBean;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.tsp.HasFilePaths;
import jdplus.toolkit.base.tsp.grid.GridDataType;
import jdplus.toolkit.base.tsp.grid.GridInput;
import jdplus.toolkit.base.tsp.grid.GridLayout;
import jdplus.toolkit.base.tsp.grid.GridReader;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.Resource;
import nbbrd.io.picocsv.Picocsv;
import nbbrd.io.text.TextParser;
import nbbrd.picocsv.Csv;

public final class TxtLoader {
    @NonNull
    public static TsCollection load(@NonNull TxtBean bean, @NonNull HasFilePaths paths) throws IOException {
        if (bean == null) {
            throw new NullPointerException("bean is marked non-null but is null");
        }
        if (paths == null) {
            throw new NullPointerException("paths is marked non-null but is null");
        }
        return (TsCollection)TxtLoader.getParser(bean).parseFile(paths.resolveFilePath(bean.getFile()), bean.getCharset());
    }

    @NonNull
    public static TextParser<TsCollection> getParser(@NonNull TxtBean bean) {
        if (bean == null) {
            throw new NullPointerException("bean is marked non-null but is null");
        }
        GridReader gridReader = TxtLoader.getGridReader(bean);
        Function<Csv.Reader, GridInput> gridInput = TxtLoader.getGridInput(bean);
        return Picocsv.Parser.builder(csv -> gridReader.read((GridInput)gridInput.apply(csv))).format(TxtLoader.getCsvFormat(bean)).options(TxtLoader.getCsvOptions(bean)).build();
    }

    private static GridReader getGridReader(TxtBean bean) {
        return GridReader.builder().format(bean.getFormat()).gathering(bean.getGathering()).layout(GridLayout.VERTICAL).namePattern("Column ${number}").build();
    }

    private static Function<Csv.Reader, GridInput> getGridInput(TxtBean bean) {
        return reader -> new TxtGridInput(bean.getFile().getName(), bean.getSkipLines(), (Csv.Reader)reader);
    }

    private static Csv.Format getCsvFormat(TxtBean bean) {
        Csv.Format.Builder result = Csv.Format.builder();
        switch (bean.getDelimiter()) {
            case TAB: {
                result.delimiter('\t');
                break;
            }
            case COMMA: {
                result.delimiter(',');
                break;
            }
            case SPACE: {
                result.delimiter(' ');
                break;
            }
            case SEMICOLON: {
                result.delimiter(';');
            }
        }
        switch (bean.getTextQualifier()) {
            case DOUBLE_QUOTE: {
                result.quote('\"');
                break;
            }
            case NONE: {
                result.quote('\u0000');
                break;
            }
            case QUOTE: {
                result.quote('\'');
            }
        }
        return result.build();
    }

    private static Csv.ReaderOptions getCsvOptions(TxtBean bean) {
        return Csv.ReaderOptions.builder().lenientSeparator(true).build();
    }

    @Generated
    private TxtLoader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class TxtGridInput
    implements GridInput {
        final String name;
        final int skipLines;
        final Csv.Reader reader;

        @NonNull
        public Set<GridDataType> getDataTypes() {
            return EnumSet.of(GridDataType.STRING);
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public GridInput.Stream open() throws IOException {
            try {
                TxtGridInput.skipLines(this.reader, this.skipLines);
            }
            catch (IOException ex) {
                Resource.ensureClosed((Throwable)ex, (Closeable)this.reader);
                throw ex;
            }
            return new TxtStream(this.reader);
        }

        private static boolean skipComments(Csv.Reader reader) throws IOException {
            while (reader.readLine()) {
                if (reader.isComment()) continue;
                return true;
            }
            return false;
        }

        private static void skipLines(Csv.Reader reader, int skipLines) throws IOException {
            for (int i = 0; i < skipLines; ++i) {
                if (reader.readLine()) continue;
                return;
            }
        }

        @Generated
        public TxtGridInput(String name, int skipLines, Csv.Reader reader) {
            this.name = name;
            this.skipLines = skipLines;
            this.reader = reader;
        }

        private static final class TxtStream
        implements GridInput.Stream {
            @NonNull
            private final Csv.Reader reader;

            public boolean readCell() throws IOException {
                return this.reader.readField();
            }

            public boolean readRow() throws IOException {
                return TxtGridInput.skipComments(this.reader);
            }

            @NonNull
            public Object getCell() {
                return this.reader.toString();
            }

            public void close() {
            }

            @Generated
            public TxtStream(@NonNull Csv.Reader reader) {
                if (reader == null) {
                    throw new NullPointerException("reader is marked non-null but is null");
                }
                this.reader = reader;
            }
        }
    }
}

