## -----------------------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
# library(multideploy)

## -----------------------------------------------------------------------------
# # Set GitHub PAT (or better, use .Renviron)
# Sys.setenv(GITHUB_PAT = askpass::askpass("What is your GitHub Personal Access Token (PAT) ?"))

## -----------------------------------------------------------------------------
# gitcreds::gitcreds_set()

## -----------------------------------------------------------------------------
# # List repositories for a user
# user_repos <- repos("username")
# 
# # List repositories for an organization
# org_repos <- repos("orgname", type = "public")
# 
# # Filter repositories by name pattern
# api_repos <- repos("orgname", filter_regex = "^api-")
# 
# # View the repositories
# head(api_repos)

## ----orgs---------------------------------------------------------------------
# my_orgs <- orgs()
# print(my_orgs)

## -----------------------------------------------------------------------------
# # Get content of a file
# workflow_file <- file_content("username/repo", ".github/workflows/ci.yml")
# 
# # View the content
# cat(workflow_file$content)

## -----------------------------------------------------------------------------
# # Update a file
# result <- file_update(
#   repo = "username/repo",
#   path = ".github/workflows/ci.yml",
#   content = "updated workflow content...",
#   message = "Update CI workflow"
# )

## -----------------------------------------------------------------------------
# # Get repositories
# repos <- repos("orgname", filter_regex = "^api-")
# 
# # Deploy a file to all repositories
# results <- file_deploy(
#   source_file = "templates/ci.yml",
#   target_path = ".github/workflows/ci.yml",
#   repos = repos,
#   commit_message = "Standardize CI workflow"
# )
# 
# # View deployment results
# print(results)

## -----------------------------------------------------------------------------
# # Create a mapping of files to deploy
# mapping <- file_mapping(
#   "templates/ci.yml" = ".github/workflows/ci.yml",
#   "templates/lint.R" = ".lintr",
#   "templates/codeowners" = ".github/CODEOWNERS"
# )
# 
# # Create pull requests with these changes
# pr_results <- pr_create(
#   repos = repos,
#   branch_name = "feature/standardize-configs",
#   title = "Standardize repository configurations",
#   body = "This PR updates CI workflows, linting settings, and CODEOWNERS file to match organization standards.",
#   file_mapping = mapping
# )
# 
# # View PR creation results
# print(pr_results)

## -----------------------------------------------------------------------------
# # Create mapping from a directory
# workflow_mapping <- file_mapping(
#   dir = "templates/workflows",
#   pattern = "\\.ya?ml$",
#   target_prefix = ".github/workflows/",
#   preserve_structure = TRUE
# )
# 
# # Use this mapping to create PRs
# pr_create(
#   repos = repos,
#   branch_name = "feature/update-workflows",
#   title = "Update all workflow files",
#   body = "Standardize all GitHub Actions workflow files",
#   file_mapping = workflow_mapping
# )

## -----------------------------------------------------------------------------
# # Preview file deployment without making changes
# dry_results <- file_deploy(
#   source_file = "templates/ci.yml",
#   target_path = ".github/workflows/ci.yml",
#   repos = repos,
#   dry_run = TRUE
# )
# 
# # View what would happen
# print(dry_results)

## ----targeting----------------------------------------------------------------
# # Get all organization repositories
# all_repos <- repos("orgname")
# 
# # Filter to only Java repositories
# r_repos <- all_repos[grepl("r", all_repos$name), ]
# 
# # Deploy R-specific configuration
# file_deploy(
#   source_file = "templates/R/.Rbuildignore",
#   target_path = ".Rbuildignore",
#   repos = r_repos
# )
# 
# # Filter to only Python repositories
# python_repos <- all_repos[grepl("python", all_repos$name), ]
# 
# # Deploy Python-specific configuration
# file_deploy(
#   source_file = "templates/python/pylintrc",
#   target_path = ".pylintrc",
#   repos = python_repos
# )

## -----------------------------------------------------------------------------
# library(multideploy)
# 
# # Get repositories
# api_repos <- repos("my-organization", filter_regex = "^api-")
# service_repos <- repos("my-organization", filter_regex = "^service-")
# all_repos <- rbind(api_repos, service_repos)
# 
# # Create file mappings
# workflow_mapping <- file_mapping(
#   dir = "templates/workflows",
#   pattern = "\\.ya?ml$",
#   target_prefix = ".github/workflows/",
#   preserve_structure = TRUE
# )
# 
# config_mapping <- file_mapping(
#   "templates/.lintr" = ".lintr",
#   "templates/.editorconfig" = ".editorconfig",
#   "templates/CONTRIBUTING.md" = "CONTRIBUTING.md"
# )
# 
# # Create PRs for workflow changes
# pr_create(
#   repos = all_repos,
#   branch_name = "chore/update-workflows",
#   title = "Update CI/CD workflows",
#   body = "Update workflows to organization standards",
#   file_mapping = workflow_mapping,
#   dry_run = FALSE
# )

## -----------------------------------------------------------------------------
# # Directly deploy config files
# for (local_file in names(config_mapping)) {
#   target_path <- config_mapping[[local_file]]
# 
#   file_deploy(
#     source_file = local_file,
#     target_path = target_path,
#     repos = all_repos,
#     commit_message = paste("Update", basename(target_path), "to organization standards"),
#     dry_run = FALSE
#   )
# }

