/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.widgets.DesktopPaneBG;
import org.af.commons.widgets.validate.RealTextField;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.power.HorizontalButtonPane;
import org.af.gMCP.gui.power.NCPRequestor;
import org.af.gMCP.gui.power.PDialog;

public class NCPCalculatorDialog
extends JDialog
implements ActionListener {
    JButton jbCalc = new JButton("Calculate");
    JButton jbReset = new JButton("Reset");
    JButton jbSaveClose = new JButton("Save and Close");
    JButton jbCancelClose = new JButton("Cancel and Close");
    JButton checkAll = new JButton("Check/Uncheck all");
    JButton jbHelp;
    List<RealTextField> mlV = new Vector<RealTextField>();
    List<RealTextField> mpV = new Vector<RealTextField>();
    List<RealTextField> ncpV = new Vector<RealTextField>();
    List<JCheckBox> saveV = new Vector<JCheckBox>();
    NCPRequestor ncpR;

    public NCPCalculatorDialog(PDialog pd, NCPRequestor ncpR) {
        super(pd, "NCP Calculator - Marginal Power", true);
        int i;
        int i2;
        this.ncpR = ncpR;
        this.setLocationRelativeTo(pd);
        Vector<Node> nodes = pd.parent.getGraphView().getNL().getNodes();
        String cols = "5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        for (int i3 = 0; i3 < Math.max(nodes.size(), 2); ++i3) {
            cols = cols + ", max(50dlu;pref), 5dlu";
        }
        this.getContentPane().setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        for (i2 = 0; i2 < nodes.size(); ++i2) {
            this.getContentPane().add((Component)new JLabel(nodes.get(i2).getName()), cc.xy(4 + 2 * i2, row));
        }
        this.getContentPane().add((Component)new JLabel("Marginal level"), cc.xy(2, row += 2));
        for (i2 = 0; i2 < nodes.size(); ++i2) {
            RealTextField ml = new RealTextField("", 0.0, 1.0);
            ml.setText("0.025");
            this.mlV.add(ml);
            this.getContentPane().add((Component)ml, cc.xy(4 + 2 * i2, row));
        }
        this.getContentPane().add((Component)new JLabel("Marginal power"), cc.xy(2, row += 2));
        for (i2 = 0; i2 < nodes.size(); ++i2) {
            RealTextField mp = new RealTextField("", 0.0, 1.0);
            this.mpV.add(mp);
            this.getContentPane().add((Component)mp, cc.xy(4 + 2 * i2, row));
        }
        this.getContentPane().add((Component)new JLabel("NCP"), cc.xy(2, row += 2));
        List<Double> oldNCP = ncpR.getOldNCP();
        for (i = 0; i < nodes.size(); ++i) {
            RealTextField ncp = new RealTextField("", Double.MIN_VALUE, Double.MAX_VALUE);
            Double d = oldNCP.get(i);
            ncp.setText(d == null ? "" : d.toString());
            this.ncpV.add(ncp);
            this.getContentPane().add((Component)ncp, cc.xy(4 + 2 * i, row));
        }
        this.getContentPane().add((Component)new JLabel("Save NCP settings"), cc.xy(2, row += 2));
        for (i = 0; i < nodes.size(); ++i) {
            JCheckBox save = new JCheckBox("");
            this.saveV.add(save);
            this.getContentPane().add((Component)save, cc.xy(4 + 2 * i, row));
        }
        this.getContentPane().add((Component)this.checkAll, cc.xy(4 + 2 * nodes.size(), row));
        row += 2;
        try {
            this.jbHelp = new JButton("Help", new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/questionmark.png"))));
        }
        catch (IOException e) {
            ErrorHandler.getInstance().makeErrDialog(e.getMessage(), (Object)e);
            this.jbHelp = new JButton("Help!");
        }
        HorizontalButtonPane bp = new HorizontalButtonPane(new JButton[]{this.jbHelp, this.jbCalc, this.jbReset, this.jbSaveClose, this.jbCancelClose}, false);
        bp.addActionListener(this);
        this.getContentPane().add((Component)bp, cc.xyw(2, row, 11));
        this.pack();
        this.setVisible(true);
    }

    public void setNCPS(List<Double> ncps) {
        for (int i = 0; i < ncps.size(); ++i) {
            Double d;
            this.ncpV.get(i).setText((d = ncps.get(i)) == null ? "" : d.toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jbSaveClose) {
            int n;
            boolean somethingSelected = false;
            for (JCheckBox jc : this.saveV) {
                if (!jc.isSelected()) continue;
                somethingSelected = true;
            }
            if (!somethingSelected && (n = JOptionPane.showConfirmDialog(this, "No NCP to save selected.\nDo you really want to close this window?", "No NCP selected", 0)) == 1) {
                return;
            }
            this.ncpR.setNCP(this.getNCPS());
            this.dispose();
        } else if (e.getSource() == this.jbCancelClose) {
            this.dispose();
        } else if (e.getSource() == this.jbReset) {
            for (JTextField jTextField : this.mlV) {
                jTextField.setText("");
            }
            for (JTextField jTextField : this.mpV) {
                jTextField.setText("");
            }
            this.setNCPS(this.ncpR.getOldNCP());
        } else if (e.getSource() != this.jbCalc) {
            if (e.getSource() == this.checkAll) {
                boolean somethingSelected = false;
                for (JCheckBox jc : this.saveV) {
                    if (!jc.isSelected()) continue;
                    somethingSelected = true;
                }
                for (JCheckBox jc : this.saveV) {
                    jc.setSelected(!somethingSelected);
                }
            } else if (e.getSource() == this.jbHelp) {
                // empty if block
            }
        }
    }

    private List<Double> getNCPS() {
        Vector<Double> ncps = new Vector<Double>();
        for (int i = 0; i < this.saveV.size(); ++i) {
            if (this.saveV.get(i).isSelected()) {
                Double d = null;
                try {
                    d = Double.parseDouble(this.ncpV.get(i).getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ncps.add(d);
                continue;
            }
            ncps.add(null);
        }
        return ncps;
    }
}

