/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.core.attributeclassobservers;

import moa.classifiers.core.attributeclassobservers.FIMTDDNumericAttributeClassObserver;
import moa.options.IntOption;

public class FIMTDDNumericAttributeClassLimitObserver
extends FIMTDDNumericAttributeClassObserver {
    private static final long serialVersionUID = 1L;
    protected int maxNodes;
    public IntOption maxNodesOption = new IntOption("maxNodesOption", 'z', "Maximum number of nodes", 50, 0, Integer.MAX_VALUE);
    protected int numNodes;

    public void observeAttributeClass(double attVal, double classVal, double weight) {
        if (!Double.isNaN(attVal)) {
            if (this.root == null) {
                this.maxNodes = this.maxNodesOption.getValue();
                this.root = new Node(attVal, classVal, weight);
            } else {
                this.root.insertValue(attVal, classVal, weight);
            }
        }
    }

    protected class Node
    extends FIMTDDNumericAttributeClassObserver.Node {
        private static final long serialVersionUID = -4484141636424708465L;
        protected Node root;

        public Node(double val, double label, double weight) {
            super(val, label, weight);
            this.root = null;
        }

        public void insertValue(double val, double label, double weight) {
            if (val == this.cut_point) {
                this.leftStatistics.addToValue(0, 1.0);
                this.leftStatistics.addToValue(1, label);
                this.leftStatistics.addToValue(2, label * label);
            } else if (val <= this.cut_point) {
                this.leftStatistics.addToValue(0, 1.0);
                this.leftStatistics.addToValue(1, label);
                this.leftStatistics.addToValue(2, label * label);
                if (this.left == null) {
                    if (FIMTDDNumericAttributeClassLimitObserver.this.numNodes < FIMTDDNumericAttributeClassLimitObserver.this.maxNodes) {
                        this.left = new Node(val, label, weight);
                        ++FIMTDDNumericAttributeClassLimitObserver.this.numNodes;
                    }
                } else {
                    this.left.insertValue(val, label, weight);
                }
            } else {
                this.rightStatistics.addToValue(0, 1.0);
                this.rightStatistics.addToValue(1, label);
                this.rightStatistics.addToValue(2, label * label);
                if (this.right == null) {
                    if (FIMTDDNumericAttributeClassLimitObserver.this.numNodes < FIMTDDNumericAttributeClassLimitObserver.this.maxNodes) {
                        this.right = new Node(val, label, weight);
                        ++FIMTDDNumericAttributeClassLimitObserver.this.numNodes;
                    }
                } else {
                    this.right.insertValue(val, label, weight);
                }
            }
        }
    }
}

