/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SelectedDenseColumnIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultFirst;
import cern.jet.math.tint.IntPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseColumnIntMatrix2D
extends IntMatrix2D {
    static final long serialVersionUID = 1L;
    protected int[] elements;

    public DenseColumnIntMatrix2D(int[][] nArray) {
        this(nArray.length, nArray.length == 0 ? 0 : nArray[0].length);
        this.assign(nArray);
    }

    public DenseColumnIntMatrix2D(int n, int n2) {
        this.setUp(n, n2, 0, 0, 1, n);
        this.elements = new int[n * n2];
    }

    public DenseColumnIntMatrix2D(int n, int n2, int[] nArray, int n3, int n4, int n5, int n6, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = nArray;
        this.isNoView = !bl;
    }

    public DenseColumnIntMatrix2D(MatrixVectorReader matrixVectorReader) throws IOException {
        block7: {
            int n;
            int[] nArray;
            int[] nArray2;
            int[] nArray3;
            int n2;
            MatrixInfo matrixInfo;
            block6: {
                matrixInfo = matrixVectorReader.hasInfo() ? matrixVectorReader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (matrixInfo.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (matrixInfo.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (matrixInfo.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize matrixSize = matrixVectorReader.readMatrixSize(matrixInfo);
                this.setUp(matrixSize.numRows(), matrixSize.numColumns());
                this.elements = new int[this.rows * this.columns];
                n2 = matrixSize.numEntries();
                nArray3 = new int[n2];
                nArray2 = new int[n2];
                nArray = new int[n2];
                matrixVectorReader.readCoordinate(nArray2, nArray3, nArray);
                for (n = 0; n < n2; ++n) {
                    this.setQuick(nArray2[n], nArray3[n], nArray[n]);
                }
                if (!matrixInfo.isSymmetric()) break block6;
                for (n = 0; n < n2; ++n) {
                    if (nArray2[n] == nArray3[n]) continue;
                    this.setQuick(nArray3[n], nArray2[n], nArray[n]);
                }
                break block7;
            }
            if (!matrixInfo.isSkewSymmetric()) break block7;
            for (n = 0; n < n2; ++n) {
                if (nArray2[n] == nArray3[n]) continue;
                this.setQuick(nArray3[n], nArray2[n], -nArray[n]);
            }
        }
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int n = (int)this.index(0, 0);
        int n2 = 0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n3 = Math.min(n3, this.columns);
            Future[] futureArray = new Future[n3];
            int n4 = this.columns / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = this.columns - i * n4;
                final int n6 = i == n3 - 1 ? 0 : n5 - n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n7 = intFunction.apply(DenseColumnIntMatrix2D.this.elements[n + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n5 - 1) * DenseColumnIntMatrix2D.this.columnStride]);
                        int n2 = 1;
                        int n3 = n5;
                        while (--n3 >= n6) {
                            int n4 = n + n3 * DenseColumnIntMatrix2D.this.columnStride;
                            int n52 = DenseColumnIntMatrix2D.this.rows - n2;
                            while (--n52 >= 0) {
                                n7 = intIntFunction.apply(n7, intFunction.apply(DenseColumnIntMatrix2D.this.elements[n52 * DenseColumnIntMatrix2D.this.rowStride + n4]));
                            }
                            n2 = 0;
                        }
                        return n7;
                    }
                });
            }
            n2 = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n2 = intFunction.apply(this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride]);
            int n7 = 1;
            int n8 = this.columns;
            while (--n8 >= 0) {
                int n9 = n + n8 * this.columnStride;
                int n10 = this.rows - n7;
                while (--n10 >= 0) {
                    n2 = intIntFunction.apply(n2, intFunction.apply(this.elements[n10 * this.rowStride + n9]));
                }
                n7 = 0;
            }
        }
        return n2;
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction, final IntProcedure intProcedure) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int n = (int)this.index(0, 0);
        int n2 = 0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n3 = Math.min(n3, this.columns);
            Future[] futureArray = new Future[n3];
            int n4 = this.columns / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = this.columns - i * n4;
                final int n6 = i == n3 - 1 ? 0 : n5 - n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n7 = DenseColumnIntMatrix2D.this.elements[n + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n5 - 1) * DenseColumnIntMatrix2D.this.columnStride];
                        int n2 = 0;
                        if (intProcedure.apply(n7)) {
                            n2 = intFunction.apply(n7);
                        }
                        int n3 = 1;
                        int n4 = n5;
                        while (--n4 >= n6) {
                            int n52 = n + n4 * DenseColumnIntMatrix2D.this.columnStride;
                            int n62 = DenseColumnIntMatrix2D.this.rows - n3;
                            while (--n62 >= 0) {
                                n7 = DenseColumnIntMatrix2D.this.elements[n62 * DenseColumnIntMatrix2D.this.rowStride + n52];
                                if (!intProcedure.apply(n7)) continue;
                                n2 = intIntFunction.apply(n2, intFunction.apply(n7));
                            }
                            n3 = 0;
                        }
                        return n2;
                    }
                });
            }
            n2 = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            int n7 = this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            if (intProcedure.apply(n7)) {
                n2 = intFunction.apply(n7);
            }
            int n8 = 1;
            int n9 = this.columns;
            while (--n9 >= 0) {
                int n10 = n + n9 * this.columnStride;
                int n11 = this.rows - n8;
                while (--n11 >= 0) {
                    n7 = this.elements[n11 * this.rowStride + n10];
                    if (!intProcedure.apply(n7)) continue;
                    n2 = intIntFunction.apply(n2, intFunction.apply(n7));
                }
                n8 = 0;
            }
        }
        return n2;
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int n = (int)this.index(0, 0);
        int n2 = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        int n3 = 0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n4 = Math.min(n4, this.columns);
            Future[] futureArray = new Future[n4];
            int n5 = n2 / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = n2 - i * n5;
                final int n7 = i == n4 - 1 ? 0 : n6 - n5;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n3 = intFunction.apply(DenseColumnIntMatrix2D.this.elements[n + nArray[n6 - 1] * DenseColumnIntMatrix2D.this.rowStride + nArray2[n6 - 1] * DenseColumnIntMatrix2D.this.columnStride]);
                        int n2 = n6 - 1;
                        while (--n2 >= n7) {
                            n3 = intIntFunction.apply(n3, intFunction.apply(DenseColumnIntMatrix2D.this.elements[n + nArray[n2] * DenseColumnIntMatrix2D.this.rowStride + nArray2[n2] * DenseColumnIntMatrix2D.this.columnStride]));
                        }
                        return n3;
                    }
                });
            }
            n3 = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n3 = intFunction.apply(this.elements[n + nArray[n2 - 1] * this.rowStride + nArray2[n2 - 1] * this.columnStride]);
            int n8 = n2 - 1;
            while (--n8 >= 0) {
                n3 = intIntFunction.apply(n3, intFunction.apply(this.elements[n + nArray[n8] * this.rowStride + nArray2[n8] * this.columnStride]));
            }
        }
        return n3;
    }

    public int aggregate(IntMatrix2D intMatrix2D, final IntIntFunction intIntFunction, final IntIntFunction intIntFunction2) {
        if (!(intMatrix2D instanceof DenseColumnIntMatrix2D)) {
            return super.aggregate(intMatrix2D, intIntFunction, intIntFunction2);
        }
        this.checkShape(intMatrix2D);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int n = (int)this.index(0, 0);
        final int n2 = (int)intMatrix2D.index(0, 0);
        final int n3 = intMatrix2D.rowStride();
        final int n4 = intMatrix2D.columnStride();
        final int[] nArray = (int[])intMatrix2D.elements();
        int n5 = 0;
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n6 = Math.min(n6, this.columns);
            Future[] futureArray = new Future[n6];
            int n7 = this.columns / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = this.columns - i * n7;
                final int n9 = i == n6 - 1 ? 0 : n8 - n7;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n7 = intIntFunction2.apply(DenseColumnIntMatrix2D.this.elements[n + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n8 - 1) * DenseColumnIntMatrix2D.this.columnStride], nArray[n2 + (DenseColumnIntMatrix2D.this.rows - 1) * n3 + (n8 - 1) * n4]);
                        int n22 = 1;
                        int n32 = n8;
                        while (--n32 >= n9) {
                            int n42 = n + n32 * DenseColumnIntMatrix2D.this.columnStride;
                            int n5 = n2 + n32 * n4;
                            int n6 = DenseColumnIntMatrix2D.this.rows - n22;
                            while (--n6 >= 0) {
                                n7 = intIntFunction.apply(n7, intIntFunction2.apply(DenseColumnIntMatrix2D.this.elements[n6 * DenseColumnIntMatrix2D.this.rowStride + n42], nArray[n6 * n3 + n5]));
                            }
                            n22 = 0;
                        }
                        return n7;
                    }
                });
            }
            n5 = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            int n10 = 1;
            n5 = intIntFunction2.apply(this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride], nArray[n2 + (this.rows - 1) * n3 + (this.columns - 1) * n4]);
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n + n11 * this.columnStride;
                int n13 = n2 + n11 * n4;
                int n14 = this.rows - n10;
                while (--n14 >= 0) {
                    n5 = intIntFunction.apply(n5, intIntFunction2.apply(this.elements[n14 * this.rowStride + n12], nArray[n14 * n3 + n13]));
                }
                n10 = 0;
            }
        }
        return n5;
    }

    public IntMatrix2D assign(final IntFunction intFunction) {
        int n;
        if (intFunction instanceof IntMult) {
            n = ((IntMult)intFunction).multiplicator;
            if (n == 1) {
                return this;
            }
            if (n == 0) {
                return this.assign(0);
            }
        }
        n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n10 = n + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n4 - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        if (intFunction instanceof IntMult) {
                            int n2 = ((IntMult)intFunction).multiplicator;
                            int n3 = n4;
                            while (--n3 >= n5) {
                                int n42 = n10;
                                int n52 = DenseColumnIntMatrix2D.this.rows;
                                while (--n52 >= 0) {
                                    int n6 = n42;
                                    DenseColumnIntMatrix2D.this.elements[n6] = DenseColumnIntMatrix2D.this.elements[n6] * n2;
                                    n42 -= DenseColumnIntMatrix2D.this.rowStride;
                                }
                                n10 -= DenseColumnIntMatrix2D.this.columnStride;
                            }
                        } else {
                            int n7 = n4;
                            while (--n7 >= n5) {
                                int n8 = n10;
                                int n9 = DenseColumnIntMatrix2D.this.rows;
                                while (--n9 >= 0) {
                                    DenseColumnIntMatrix2D.this.elements[n8] = intFunction.apply(DenseColumnIntMatrix2D.this.elements[n8]);
                                    n8 -= DenseColumnIntMatrix2D.this.rowStride;
                                }
                                n10 -= DenseColumnIntMatrix2D.this.columnStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            if (intFunction instanceof IntMult) {
                int n7 = ((IntMult)intFunction).multiplicator;
                int n8 = this.columns;
                while (--n8 >= 0) {
                    int n9 = n6;
                    int n10 = this.rows;
                    while (--n10 >= 0) {
                        int n11 = n9;
                        this.elements[n11] = this.elements[n11] * n7;
                        n9 -= this.rowStride;
                    }
                    n6 -= this.columnStride;
                }
            } else {
                int n12 = this.columns;
                while (--n12 >= 0) {
                    int n13 = n6;
                    int n14 = this.rows;
                    while (--n14 >= 0) {
                        this.elements[n13] = intFunction.apply(this.elements[n13]);
                        n13 -= this.rowStride;
                    }
                    n6 -= this.columnStride;
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final IntProcedure intProcedure, final IntFunction intFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n4 - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnIntMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                int n52 = DenseColumnIntMatrix2D.this.elements[n3];
                                if (intProcedure.apply(n52)) {
                                    DenseColumnIntMatrix2D.this.elements[n3] = intFunction.apply(n52);
                                }
                                n3 -= DenseColumnIntMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnIntMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    int n10 = this.elements[n8];
                    if (intProcedure.apply(n10)) {
                        this.elements[n8] = intFunction.apply(n10);
                    }
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public IntMatrix2D assign(final IntProcedure intProcedure, final int n) {
        final int n2 = (int)this.index(0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n3 = Math.min(n3, this.columns);
            Future[] futureArray = new Future[n3];
            int n4 = this.columns / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = this.columns - i * n4;
                final int n6 = i == n3 - 1 ? 0 : n5 - n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n7 = n2 + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n5 - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int n22 = n5;
                        while (--n22 >= n6) {
                            int n3 = n7;
                            int n4 = DenseColumnIntMatrix2D.this.rows;
                            while (--n4 >= 0) {
                                int n52 = DenseColumnIntMatrix2D.this.elements[n3];
                                if (intProcedure.apply(n52)) {
                                    DenseColumnIntMatrix2D.this.elements[n3] = n;
                                }
                                n3 -= DenseColumnIntMatrix2D.this.rowStride;
                            }
                            n7 -= DenseColumnIntMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n8 = this.columns;
            while (--n8 >= 0) {
                int n9 = n7;
                int n10 = this.rows;
                while (--n10 >= 0) {
                    int n11 = this.elements[n9];
                    if (intProcedure.apply(n11)) {
                        this.elements[n9] = n;
                    }
                    n9 -= this.rowStride;
                }
                n7 -= this.columnStride;
            }
        }
        return this;
    }

    public IntMatrix2D assign(final int n) {
        final int n2 = (int)this.index(0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n3 = Math.min(n3, this.columns);
            Future[] futureArray = new Future[n3];
            int n4 = this.columns / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = this.columns - i * n4;
                final int n6 = i == n3 - 1 ? 0 : n5 - n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n7 = n2 + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n5 - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int n22 = n5;
                        while (--n22 >= n6) {
                            int n3 = n7;
                            int n4 = DenseColumnIntMatrix2D.this.rows;
                            while (--n4 >= 0) {
                                DenseColumnIntMatrix2D.this.elements[n3] = n;
                                n3 -= DenseColumnIntMatrix2D.this.rowStride;
                            }
                            n7 -= DenseColumnIntMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n8 = this.columns;
            while (--n8 >= 0) {
                int n9 = n7;
                int n10 = this.rows;
                while (--n10 >= 0) {
                    this.elements[n9] = n;
                    n9 -= this.rowStride;
                }
                n7 -= this.columnStride;
            }
        }
        return this;
    }

    public IntMatrix2D assign(final int[] nArray) {
        if ((long)nArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + nArray.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(nArray, 0, this.elements, 0, nArray.length);
        } else {
            final int n2 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.columns);
                Future[] futureArray = new Future[n];
                int n3 = this.columns / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = this.columns - i * n3;
                    final int n5 = i == n - 1 ? 0 : n4 - n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n2 + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n4 - 1) * DenseColumnIntMatrix2D.this.columnStride;
                            int n22 = DenseColumnIntMatrix2D.this.rows - 1 + (n4 - 1) * DenseColumnIntMatrix2D.this.rows;
                            int n3 = n4;
                            while (--n3 >= n5) {
                                int n42 = n;
                                int n52 = DenseColumnIntMatrix2D.this.rows;
                                while (--n52 >= 0) {
                                    DenseColumnIntMatrix2D.this.elements[n42] = nArray[n22--];
                                    n42 -= DenseColumnIntMatrix2D.this.rowStride;
                                }
                                n -= DenseColumnIntMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int n7 = nArray.length - 1;
                int n8 = this.columns;
                while (--n8 >= 0) {
                    int n9 = n6;
                    int n10 = this.rows;
                    while (--n10 >= 0) {
                        this.elements[n9] = nArray[n7--];
                        n9 -= this.rowStride;
                    }
                    n6 -= this.columnStride;
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final int[][] nArray) {
        if (nArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + nArray.length + "columns()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n3 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + (n4 - 1) * DenseColumnIntMatrix2D.this.rowStride + (DenseColumnIntMatrix2D.this.columns - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int n22 = n4;
                        while (--n22 >= n5) {
                            int[] nArray2 = nArray[n22];
                            if (nArray2.length != DenseColumnIntMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: column=" + nArray2.length + "columns()=" + DenseColumnIntMatrix2D.this.columns());
                            }
                            int n3 = n;
                            int n42 = DenseColumnIntMatrix2D.this.columns;
                            while (--n42 >= 0) {
                                DenseColumnIntMatrix2D.this.elements[n3] = nArray2[n42];
                                n3 -= DenseColumnIntMatrix2D.this.columnStride;
                            }
                            n -= DenseColumnIntMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.rows;
            while (--n7 >= 0) {
                int[] nArray2 = nArray[n7];
                if (nArray2.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: column=" + nArray2.length + "columns()=" + this.columns());
                }
                int n8 = n6;
                int n9 = this.columns;
                while (--n9 >= 0) {
                    this.elements[n8] = nArray2[n9];
                    n8 -= this.columnStride;
                }
                n6 -= this.rowStride;
            }
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D) {
        if (!(intMatrix2D instanceof DenseColumnIntMatrix2D)) {
            super.assign(intMatrix2D);
            return this;
        }
        DenseColumnIntMatrix2D denseColumnIntMatrix2D = (DenseColumnIntMatrix2D)intMatrix2D;
        if (denseColumnIntMatrix2D == this) {
            return this;
        }
        this.checkShape(denseColumnIntMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseColumnIntMatrix2D.isNoView) {
            System.arraycopy(denseColumnIntMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseColumnIntMatrix2D)) {
            IntMatrix2D intMatrix2D2 = denseColumnIntMatrix2D.copy();
            if (!(intMatrix2D2 instanceof DenseColumnIntMatrix2D)) {
                super.assign(denseColumnIntMatrix2D);
                return this;
            }
            denseColumnIntMatrix2D = (DenseColumnIntMatrix2D)intMatrix2D2;
        }
        final int n2 = (int)denseColumnIntMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = denseColumnIntMatrix2D.columnStride;
        final int n5 = denseColumnIntMatrix2D.rowStride;
        final int[] nArray = denseColumnIntMatrix2D.elements;
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n6 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n7 - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int n22 = n2 + (DenseColumnIntMatrix2D.this.rows - 1) * n5 + (n7 - 1) * n4;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n;
                            int n52 = n22;
                            int n6 = DenseColumnIntMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                DenseColumnIntMatrix2D.this.elements[n42] = nArray[n52];
                                n42 -= DenseColumnIntMatrix2D.this.rowStride;
                                n52 -= n5;
                            }
                            n -= DenseColumnIntMatrix2D.this.columnStride;
                            n22 -= n4;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n2 + (this.rows - 1) * n5 + (this.columns - 1) * n4;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    this.elements[n12] = nArray[n13];
                    n12 -= this.rowStride;
                    n13 -= n5;
                }
                n9 -= this.columnStride;
                n10 -= n4;
            }
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D, final IntIntFunction intIntFunction) {
        int n;
        if (intIntFunction instanceof IntPlusMultSecond && (n = ((IntPlusMultSecond)intIntFunction).multiplicator) == 0) {
            return this;
        }
        if (intIntFunction instanceof IntPlusMultFirst && (n = ((IntPlusMultFirst)intIntFunction).multiplicator) == 0) {
            return this.assign(intMatrix2D);
        }
        if (!(intMatrix2D instanceof DenseColumnIntMatrix2D)) {
            super.assign(intMatrix2D, intIntFunction);
            return this;
        }
        DenseColumnIntMatrix2D denseColumnIntMatrix2D = (DenseColumnIntMatrix2D)intMatrix2D;
        this.checkShape(intMatrix2D);
        final int[] nArray = denseColumnIntMatrix2D.elements;
        final int n2 = (int)denseColumnIntMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = denseColumnIntMatrix2D.columnStride;
        final int n5 = denseColumnIntMatrix2D.rowStride;
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n6 = Math.min(n6, this.columns);
            Future[] futureArray = new Future[n6];
            int n7 = this.columns / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = this.columns - i * n7;
                final int n9 = i == n6 - 1 ? 0 : n8 - n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n8 - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int n210 = n2 + (DenseColumnIntMatrix2D.this.rows - 1) * n5 + (n8 - 1) * n4;
                        if (intIntFunction == IntFunctions.mult) {
                            int n310 = n8;
                            while (--n310 >= n9) {
                                int n47 = n;
                                int n52 = n210;
                                int n6 = DenseColumnIntMatrix2D.this.rows;
                                while (--n6 >= 0) {
                                    int n7 = n47;
                                    DenseColumnIntMatrix2D.this.elements[n7] = DenseColumnIntMatrix2D.this.elements[n7] * nArray[n52];
                                    n47 -= DenseColumnIntMatrix2D.this.rowStride;
                                    n52 -= n5;
                                }
                                n -= DenseColumnIntMatrix2D.this.columnStride;
                                n210 -= n4;
                            }
                        } else if (intIntFunction == IntFunctions.div) {
                            int n82 = n8;
                            while (--n82 >= n9) {
                                int n92 = n;
                                int n10 = n210;
                                int n11 = DenseColumnIntMatrix2D.this.rows;
                                while (--n11 >= 0) {
                                    int n12 = n92;
                                    DenseColumnIntMatrix2D.this.elements[n12] = DenseColumnIntMatrix2D.this.elements[n12] / nArray[n10];
                                    n92 -= DenseColumnIntMatrix2D.this.rowStride;
                                    n10 -= n5;
                                }
                                n -= DenseColumnIntMatrix2D.this.columnStride;
                                n210 -= n4;
                            }
                        } else if (intIntFunction instanceof IntPlusMultSecond) {
                            int n13 = ((IntPlusMultSecond)intIntFunction).multiplicator;
                            if (n13 == 1) {
                                int n14 = n8;
                                while (--n14 >= n9) {
                                    int n15 = n;
                                    int n16 = n210;
                                    int n17 = DenseColumnIntMatrix2D.this.rows;
                                    while (--n17 >= 0) {
                                        int n18 = n15;
                                        DenseColumnIntMatrix2D.this.elements[n18] = DenseColumnIntMatrix2D.this.elements[n18] + nArray[n16];
                                        n15 -= DenseColumnIntMatrix2D.this.rowStride;
                                        n16 -= n5;
                                    }
                                    n -= DenseColumnIntMatrix2D.this.columnStride;
                                    n210 -= n4;
                                }
                            } else if (n13 == -1) {
                                int n19 = n8;
                                while (--n19 >= n9) {
                                    int n20 = n;
                                    int n21 = n210;
                                    int n22 = DenseColumnIntMatrix2D.this.rows;
                                    while (--n22 >= 0) {
                                        int n23 = n20;
                                        DenseColumnIntMatrix2D.this.elements[n23] = DenseColumnIntMatrix2D.this.elements[n23] - nArray[n21];
                                        n20 -= DenseColumnIntMatrix2D.this.rowStride;
                                        n21 -= n5;
                                    }
                                    n -= DenseColumnIntMatrix2D.this.columnStride;
                                    n210 -= n4;
                                }
                            } else {
                                int n24 = n8;
                                while (--n24 >= n9) {
                                    int n25 = n;
                                    int n26 = n210;
                                    int n27 = DenseColumnIntMatrix2D.this.rows;
                                    while (--n27 >= 0) {
                                        int n28 = n25;
                                        DenseColumnIntMatrix2D.this.elements[n28] = DenseColumnIntMatrix2D.this.elements[n28] + n13 * nArray[n26];
                                        n25 -= DenseColumnIntMatrix2D.this.rowStride;
                                        n26 -= n5;
                                    }
                                    n -= DenseColumnIntMatrix2D.this.columnStride;
                                    n210 -= n4;
                                }
                            }
                        } else if (intIntFunction instanceof IntPlusMultFirst) {
                            int n29 = ((IntPlusMultFirst)intIntFunction).multiplicator;
                            if (n29 == 1) {
                                int n30 = n8;
                                while (--n30 >= n9) {
                                    int n31 = n;
                                    int n32 = n210;
                                    int n33 = DenseColumnIntMatrix2D.this.rows;
                                    while (--n33 >= 0) {
                                        int n34 = n31;
                                        DenseColumnIntMatrix2D.this.elements[n34] = DenseColumnIntMatrix2D.this.elements[n34] + nArray[n32];
                                        n31 -= DenseColumnIntMatrix2D.this.rowStride;
                                        n32 -= n5;
                                    }
                                    n -= DenseColumnIntMatrix2D.this.columnStride;
                                    n210 -= n4;
                                }
                            } else if (n29 == -1) {
                                int n35 = n8;
                                while (--n35 >= n9) {
                                    int n36 = n;
                                    int n37 = n210;
                                    int n38 = DenseColumnIntMatrix2D.this.rows;
                                    while (--n38 >= 0) {
                                        DenseColumnIntMatrix2D.this.elements[n36] = nArray[n37] - DenseColumnIntMatrix2D.this.elements[n36];
                                        n36 -= DenseColumnIntMatrix2D.this.rowStride;
                                        n37 -= n5;
                                    }
                                    n -= DenseColumnIntMatrix2D.this.columnStride;
                                    n210 -= n4;
                                }
                            } else {
                                int n39 = n8;
                                while (--n39 >= n9) {
                                    int n40 = n;
                                    int n41 = n210;
                                    int n42 = DenseColumnIntMatrix2D.this.rows;
                                    while (--n42 >= 0) {
                                        DenseColumnIntMatrix2D.this.elements[n40] = n29 * DenseColumnIntMatrix2D.this.elements[n40] + nArray[n41];
                                        n40 -= DenseColumnIntMatrix2D.this.rowStride;
                                        n41 -= n5;
                                    }
                                    n -= DenseColumnIntMatrix2D.this.columnStride;
                                    n210 -= n4;
                                }
                            }
                        } else {
                            int n43 = n8;
                            while (--n43 >= n9) {
                                int n44 = n;
                                int n45 = n210;
                                int n46 = DenseColumnIntMatrix2D.this.rows;
                                while (--n46 >= 0) {
                                    DenseColumnIntMatrix2D.this.elements[n44] = intIntFunction.apply(DenseColumnIntMatrix2D.this.elements[n44], nArray[n45]);
                                    n44 -= DenseColumnIntMatrix2D.this.rowStride;
                                    n45 -= n5;
                                }
                                n -= DenseColumnIntMatrix2D.this.columnStride;
                                n210 -= n4;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n11 = n2 + (this.rows - 1) * n5 + (this.columns - 1) * n4;
            if (intIntFunction == IntFunctions.mult) {
                int n12 = this.columns;
                while (--n12 >= 0) {
                    int n13 = n10;
                    int n14 = n11;
                    int n15 = this.rows;
                    while (--n15 >= 0) {
                        int n16 = n13;
                        this.elements[n16] = this.elements[n16] * nArray[n14];
                        n13 -= this.rowStride;
                        n14 -= n5;
                    }
                    n10 -= this.columnStride;
                    n11 -= n4;
                }
            } else if (intIntFunction == IntFunctions.div) {
                int n17 = this.columns;
                while (--n17 >= 0) {
                    int n18 = n10;
                    int n19 = n11;
                    int n20 = this.rows;
                    while (--n20 >= 0) {
                        int n21 = n18;
                        this.elements[n21] = this.elements[n21] / nArray[n19];
                        n18 -= this.rowStride;
                        n19 -= n5;
                    }
                    n10 -= this.columnStride;
                    n11 -= n4;
                }
            } else if (intIntFunction instanceof IntPlusMultSecond) {
                int n22 = ((IntPlusMultSecond)intIntFunction).multiplicator;
                if (n22 == 1) {
                    int n23 = this.columns;
                    while (--n23 >= 0) {
                        int n24 = n10;
                        int n25 = n11;
                        int n26 = this.rows;
                        while (--n26 >= 0) {
                            int n27 = n24;
                            this.elements[n27] = this.elements[n27] + nArray[n25];
                            n24 -= this.rowStride;
                            n25 -= n5;
                        }
                        n10 -= this.columnStride;
                        n11 -= n4;
                    }
                } else if (n22 == -1) {
                    int n28 = this.columns;
                    while (--n28 >= 0) {
                        int n29 = n10;
                        int n30 = n11;
                        int n31 = this.rows;
                        while (--n31 >= 0) {
                            int n32 = n29;
                            this.elements[n32] = this.elements[n32] - nArray[n30];
                            n29 -= this.rowStride;
                            n30 -= n5;
                        }
                        n10 -= this.columnStride;
                        n11 -= n4;
                    }
                } else {
                    int n33 = this.columns;
                    while (--n33 >= 0) {
                        int n34 = n10;
                        int n35 = n11;
                        int n36 = this.rows;
                        while (--n36 >= 0) {
                            int n37 = n34;
                            this.elements[n37] = this.elements[n37] + n22 * nArray[n35];
                            n34 -= this.rowStride;
                            n35 -= n5;
                        }
                        n10 -= this.columnStride;
                        n11 -= n4;
                    }
                }
            } else if (intIntFunction instanceof IntPlusMultFirst) {
                int n38 = ((IntPlusMultFirst)intIntFunction).multiplicator;
                if (n38 == 1) {
                    int n39 = this.columns;
                    while (--n39 >= 0) {
                        int n40 = n10;
                        int n41 = n11;
                        int n42 = this.rows;
                        while (--n42 >= 0) {
                            int n43 = n40;
                            this.elements[n43] = this.elements[n43] + nArray[n41];
                            n40 -= this.rowStride;
                            n41 -= n5;
                        }
                        n10 -= this.columnStride;
                        n11 -= n4;
                    }
                } else if (n38 == -1) {
                    int n44 = this.columns;
                    while (--n44 >= 0) {
                        int n45 = n10;
                        int n46 = n11;
                        int n47 = this.rows;
                        while (--n47 >= 0) {
                            this.elements[n45] = nArray[n46] - this.elements[n45];
                            n45 -= this.rowStride;
                            n46 -= n5;
                        }
                        n10 -= this.columnStride;
                        n11 -= n4;
                    }
                } else {
                    int n48 = this.columns;
                    while (--n48 >= 0) {
                        int n49 = n10;
                        int n50 = n11;
                        int n51 = this.rows;
                        while (--n51 >= 0) {
                            this.elements[n49] = n38 * this.elements[n49] + nArray[n50];
                            n49 -= this.rowStride;
                            n50 -= n5;
                        }
                        n10 -= this.columnStride;
                        n11 -= n4;
                    }
                }
            } else {
                int n52 = this.columns;
                while (--n52 >= 0) {
                    int n53 = n10;
                    int n54 = n11;
                    int n55 = this.rows;
                    while (--n55 >= 0) {
                        this.elements[n53] = intIntFunction.apply(this.elements[n53], nArray[n54]);
                        n53 -= this.rowStride;
                        n54 -= n5;
                    }
                    n10 -= this.columnStride;
                    n11 -= n4;
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D, final IntIntFunction intIntFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.checkShape(intMatrix2D);
        if (!(intMatrix2D instanceof DenseColumnIntMatrix2D)) {
            super.assign(intMatrix2D, intIntFunction);
            return this;
        }
        DenseColumnIntMatrix2D denseColumnIntMatrix2D = (DenseColumnIntMatrix2D)intMatrix2D;
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = denseColumnIntMatrix2D.elements();
        final int n2 = (int)denseColumnIntMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = denseColumnIntMatrix2D.columnStride();
        final int n5 = denseColumnIntMatrix2D.rowStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n6 = Math.min(n6, this.columns);
            Future[] futureArray = new Future[n6];
            int n7 = n / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = n - i * n7;
                final int n9 = i == n6 - 1 ? 0 : n8 - n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n8;
                        while (--n >= n9) {
                            int n22 = n3 + nArray[n] * DenseColumnIntMatrix2D.this.rowStride + nArray2[n] * DenseColumnIntMatrix2D.this.columnStride;
                            int n32 = n2 + nArray[n] * n5 + nArray2[n] * n4;
                            DenseColumnIntMatrix2D.this.elements[n22] = intIntFunction.apply(DenseColumnIntMatrix2D.this.elements[n22], nArray3[n32]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n;
            while (--n10 >= 0) {
                int n11 = n3 + nArray[n10] * this.rowStride + nArray2[n10] * this.columnStride;
                int n12 = n2 + nArray[n10] * n5 + nArray2[n10] * n4;
                this.elements[n11] = intIntFunction.apply(this.elements[n11], nArray3[n12]);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        final int n3 = (int)this.index(0, 0);
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n5 = this.columns / n2;
            for (n4 = 0; n4 < n2; ++n4) {
                final int n6 = this.columns - n4 * n5;
                final int n7 = n4 == n2 - 1 ? 0 : n6 - n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = n3 + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n6 - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int n32 = n6;
                        while (--n32 >= n7) {
                            int n4 = n2;
                            int n5 = DenseColumnIntMatrix2D.this.rows;
                            while (--n5 >= 0) {
                                if (DenseColumnIntMatrix2D.this.elements[n4] != 0) {
                                    ++n;
                                }
                                n4 -= DenseColumnIntMatrix2D.this.rowStride;
                            }
                            n2 -= DenseColumnIntMatrix2D.this.columnStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n2; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n2; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n9 = this.columns;
            while (--n9 >= 0) {
                int n10 = n8;
                int n11 = this.rows;
                while (--n11 >= 0) {
                    if (this.elements[n10] != 0) {
                        ++n;
                    }
                    n10 -= this.rowStride;
                }
                n8 -= this.columnStride;
            }
        }
        return n;
    }

    public int[] elements() {
        return this.elements;
    }

    public IntMatrix2D forEachNonZero(final IntIntIntFunction intIntIntFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n4 - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnIntMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                int n52 = DenseColumnIntMatrix2D.this.elements[n3];
                                if (n52 != 0) {
                                    DenseColumnIntMatrix2D.this.elements[n3] = intIntIntFunction.apply(n42, n2, n52);
                                }
                                n3 -= DenseColumnIntMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnIntMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    int n10 = this.elements[n8];
                    if (n10 != 0) {
                        this.elements[n8] = intIntIntFunction.apply(n9, n7, n10);
                    }
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public DenseIntMatrix2D getRowMajor() {
        DenseIntMatrix2D denseIntMatrix2D = new DenseIntMatrix2D(this.rows, this.columns);
        final int n = (int)denseIntMatrix2D.index(0, 0);
        final int n2 = denseIntMatrix2D.rowStride();
        final int n3 = denseIntMatrix2D.columnStride();
        final int[] nArray = denseIntMatrix2D.elements();
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n9 = n4 + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n7 - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int n22 = n + (DenseColumnIntMatrix2D.this.rows - 1) * n2 + (n7 - 1) * n3;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n9;
                            int n5 = n22;
                            int n6 = DenseColumnIntMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                nArray[n5] = DenseColumnIntMatrix2D.this.elements[n42];
                                n42 -= DenseColumnIntMatrix2D.this.rowStride;
                                n5 -= n2;
                            }
                            n9 -= DenseColumnIntMatrix2D.this.columnStride;
                            n22 -= n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n + (this.rows - 1) * n2 + (this.columns - 1) * n3;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    nArray[n13] = this.elements[n12];
                    n12 -= this.rowStride;
                    n13 -= n2;
                }
                n9 -= this.columnStride;
                n10 -= n3;
            }
        }
        return denseIntMatrix2D;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                int n3 = this.elements[n2];
                if (n3 < 0) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    intArrayList3.add(n3);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                int n3 = this.elements[n2];
                if (n3 != 0) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    intArrayList3.add(n3);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                int n3 = this.elements[n2];
                if (n3 > 0) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    intArrayList3.add(n3);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    public int getQuick(int n, int n2) {
        return this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride];
    }

    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public IntMatrix2D like(int n, int n2) {
        return new DenseColumnIntMatrix2D(n, n2);
    }

    public IntMatrix1D like1D(int n) {
        return new DenseIntMatrix1D(n);
    }

    public int[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        int n4 = 0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n6;
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int[][] nArray = new int[n5][3];
            int n7 = this.columns / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = this.columns - n6 * n7;
                final int n9 = n6 == n5 - 1 ? 0 : n8 - n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n = DenseColumnIntMatrix2D.this.elements[n3 + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n8 - 1) * DenseColumnIntMatrix2D.this.columnStride];
                        int n2 = DenseColumnIntMatrix2D.this.rows - 1;
                        int n32 = n8 - 1;
                        int n4 = 1;
                        int n5 = n8;
                        while (--n5 >= n9) {
                            int n6 = n3 + n5 * DenseColumnIntMatrix2D.this.columnStride;
                            int n7 = DenseColumnIntMatrix2D.this.rows - n4;
                            while (--n7 >= 0) {
                                int n82 = DenseColumnIntMatrix2D.this.elements[n7 * DenseColumnIntMatrix2D.this.rowStride + n6];
                                if (n >= n82) continue;
                                n = n82;
                                n2 = n7;
                                n32 = n5;
                            }
                            n4 = 0;
                        }
                        return new int[]{n, n2, n32};
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    nArray[n6] = (int[])futureArray[n6].get();
                }
                n4 = nArray[0][0];
                n = nArray[0][1];
                n2 = nArray[0][2];
                for (n6 = 1; n6 < n5; ++n6) {
                    if (n4 >= nArray[n6][0]) continue;
                    n4 = nArray[n6][0];
                    n = nArray[n6][1];
                    n2 = nArray[n6][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 = this.elements[n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            n = this.rows - 1;
            n2 = this.columns - 1;
            int n10 = 1;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n3 + n11 * this.columnStride;
                int n13 = this.rows - n10;
                while (--n13 >= 0) {
                    int n14 = this.elements[n13 * this.rowStride + n12];
                    if (n4 >= n14) continue;
                    n4 = n14;
                    n = n13;
                    n2 = n11;
                }
                n10 = 0;
            }
        }
        return new int[]{n4, n, n2};
    }

    public int[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        int n4 = 0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n6;
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int[][] nArray = new int[n5][3];
            int n7 = this.columns / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = this.columns - n6 * n7;
                final int n9 = n6 == n5 - 1 ? 0 : n8 - n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n = DenseColumnIntMatrix2D.this.elements[n3 + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n8 - 1) * DenseColumnIntMatrix2D.this.columnStride];
                        int n2 = DenseColumnIntMatrix2D.this.rows - 1;
                        int n32 = n8 - 1;
                        int n4 = 1;
                        int n5 = n8;
                        while (--n5 >= n9) {
                            int n6 = n3 + n5 * DenseColumnIntMatrix2D.this.columnStride;
                            int n7 = DenseColumnIntMatrix2D.this.rows - n4;
                            while (--n7 >= 0) {
                                int n82 = DenseColumnIntMatrix2D.this.elements[n7 * DenseColumnIntMatrix2D.this.rowStride + n6];
                                if (n <= n82) continue;
                                n = n82;
                                n2 = n7;
                                n32 = n5;
                            }
                            n4 = 0;
                        }
                        return new int[]{n, n2, n32};
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    nArray[n6] = (int[])futureArray[n6].get();
                }
                n4 = nArray[0][0];
                n = nArray[0][1];
                n2 = nArray[0][2];
                for (n6 = 1; n6 < n5; ++n6) {
                    if (n4 <= nArray[n6][0]) continue;
                    n4 = nArray[n6][0];
                    n = nArray[n6][1];
                    n2 = nArray[n6][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 = this.elements[n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            n = this.rows - 1;
            n2 = this.columns - 1;
            int n10 = 1;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n3 + n11 * this.columnStride;
                int n13 = this.rows - n10;
                while (--n13 >= 0) {
                    int n14 = this.elements[n13 * this.rowStride + n12];
                    if (n4 <= n14) continue;
                    n4 = n14;
                    n = n13;
                    n2 = n11;
                }
                n10 = 0;
            }
        }
        return new int[]{n4, n, n2};
    }

    public void setQuick(int n, int n2, int n3) {
        this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride] = n3;
    }

    public int[][] toArray() {
        final int[][] nArray = new int[this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n3 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n4 - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int n22 = n4;
                        while (--n22 >= n5) {
                            int n3 = n;
                            int n42 = DenseColumnIntMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                nArray[n42][n22] = DenseColumnIntMatrix2D.this.elements[n3];
                                n3 -= DenseColumnIntMatrix2D.this.rowStride;
                            }
                            n -= DenseColumnIntMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    nArray[n9][n7] = this.elements[n8];
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return nArray;
    }

    public IntMatrix1D vectorize() {
        int n = (int)this.size();
        DenseIntMatrix1D denseIntMatrix1D = new DenseIntMatrix1D(n);
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, ((IntMatrix1D)denseIntMatrix1D).elements(), 0, n);
        } else {
            final int n2 = (int)this.index(0, 0);
            final int n3 = (int)((AbstractMatrix1D)denseIntMatrix1D).index(0);
            final int n4 = denseIntMatrix1D.stride();
            final int[] nArray = (int[])((IntMatrix1D)denseIntMatrix1D).elements();
            int n5 = ConcurrencyUtils.getNumberOfThreads();
            if (n5 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n5 = Math.min(n5, this.columns);
                Future[] futureArray = new Future[n5];
                int n6 = this.columns / n5;
                for (int i = 0; i < n5; ++i) {
                    final int n7 = this.columns - i * n6;
                    final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                    final int n9 = n - i * n6 * this.rows;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n2 + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n7 - 1) * DenseColumnIntMatrix2D.this.columnStride;
                            int n22 = n3 + (n9 - 1) * n4;
                            int n32 = n7;
                            while (--n32 >= n8) {
                                int n42 = n;
                                int n5 = DenseColumnIntMatrix2D.this.rows;
                                while (--n5 >= 0) {
                                    nArray[n22] = DenseColumnIntMatrix2D.this.elements[n42];
                                    n42 -= DenseColumnIntMatrix2D.this.rowStride;
                                    n22 -= n4;
                                }
                                n -= DenseColumnIntMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n10 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int n11 = n3 + n - 1;
                int n12 = this.columns;
                while (--n12 >= 0) {
                    int n13 = n10;
                    int n14 = this.rows;
                    while (--n14 >= 0) {
                        nArray[n11] = this.elements[n13];
                        n13 -= this.rowStride;
                        --n11;
                    }
                    n10 -= this.columnStride;
                }
            }
        }
        return denseIntMatrix1D;
    }

    public int zSum() {
        int n = 0;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int n2 = (int)this.index(0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n3 = Math.min(n3, this.columns);
            Future[] futureArray = new Future[n3];
            int n5 = this.columns / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = this.columns - n4 * n5;
                final int n7 = n4 == n3 - 1 ? 0 : n6 - n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n22 = n2 + (DenseColumnIntMatrix2D.this.rows - 1) * DenseColumnIntMatrix2D.this.rowStride + (n6 - 1) * DenseColumnIntMatrix2D.this.columnStride;
                        int n3 = n6;
                        while (--n3 >= n7) {
                            int n4 = n22;
                            int n5 = DenseColumnIntMatrix2D.this.rows;
                            while (--n5 >= 0) {
                                n += DenseColumnIntMatrix2D.this.elements[n4];
                                n4 -= DenseColumnIntMatrix2D.this.rowStride;
                            }
                            n22 -= DenseColumnIntMatrix2D.this.columnStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    n += ((Integer)futureArray[n4].get()).intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n9 = this.columns;
            while (--n9 >= 0) {
                int n10 = n8;
                int n11 = this.rows;
                while (--n11 >= 0) {
                    n += this.elements[n10];
                    n10 -= this.rowStride;
                }
                n8 -= this.columnStride;
            }
        }
        return n;
    }

    protected boolean haveSharedCellsRaw(IntMatrix2D intMatrix2D) {
        if (intMatrix2D instanceof SelectedDenseColumnIntMatrix2D) {
            SelectedDenseColumnIntMatrix2D selectedDenseColumnIntMatrix2D = (SelectedDenseColumnIntMatrix2D)intMatrix2D;
            return this.elements == selectedDenseColumnIntMatrix2D.elements;
        }
        if (intMatrix2D instanceof DenseColumnIntMatrix2D) {
            DenseColumnIntMatrix2D denseColumnIntMatrix2D = (DenseColumnIntMatrix2D)intMatrix2D;
            return this.elements == denseColumnIntMatrix2D.elements;
        }
        return false;
    }

    protected IntMatrix1D like1D(int n, int n2, int n3) {
        return new DenseIntMatrix1D(n, this.elements, n2, n3, true);
    }

    protected IntMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseColumnIntMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

