/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.information;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.xml.information.XmlTsUnit;
import jdplus.toolkit.base.xml.legacy.IXmlConverter;

@XmlRootElement(name="tsData")
@XmlType(name="tsDataType")
public class XmlTsData
implements IXmlConverter<TsData> {
    static final String NAME = "tsDataType";
    static final String RNAME = "tsData";
    @XmlElement
    public Integer freq;
    @XmlElement
    public Integer firstYear;
    @XmlElement
    public Integer firstPeriod;
    @XmlElement
    public XmlTsUnit unit;
    @XmlElement
    public String start;
    @XmlElement(name="data")
    @XmlList
    public double[] data;
    @XmlAttribute
    public String name;

    @Override
    public void copy(TsData t) {
        TsPeriod tstart = t.getStart();
        int ifreq = tstart.getUnit().getAnnualFrequency();
        if (ifreq > 0) {
            this.freq = ifreq;
            this.firstYear = tstart.year();
            this.firstPeriod = this.freq != 1 ? Integer.valueOf(tstart.annualPosition() + 1) : null;
        } else {
            this.unit = new XmlTsUnit();
            this.unit.copy(tstart.getUnit());
            this.start = tstart.start().format(DateTimeFormatter.ISO_DATE_TIME);
        }
        if (!t.getValues().isEmpty()) {
            this.data = t.getValues().toArray();
        }
    }

    @Override
    public TsData create() {
        if (this.freq != null) {
            return XmlTsData.of(this.freq, this.firstYear, this.firstPeriod, this.data);
        }
        LocalDateTime tstart = LocalDateTime.parse(this.start, DateTimeFormatter.ISO_DATE_TIME);
        TsPeriod pstart = TsPeriod.of((TsUnit)this.unit.create(), (LocalDateTime)tstart);
        return TsData.ofInternal((TsPeriod)pstart, (double[])(this.data == null ? Doubles.EMPTYARRAY : this.data));
    }

    static TsData of(int freq, int year, int period, double[] data) {
        switch (freq) {
            case 1: {
                return TsData.ofInternal((TsPeriod)TsPeriod.yearly((int)year), (double[])data);
            }
            case 12: {
                return TsData.ofInternal((TsPeriod)TsPeriod.monthly((int)year, (int)period), (double[])data);
            }
        }
        int c = 12 / freq;
        TsPeriod pstart = TsPeriod.of((TsUnit)TsUnit.ofAnnualFrequency((int)freq), (LocalDate)LocalDate.of(year, (period - 1) * c + 1, 1));
        return TsData.ofInternal((TsPeriod)pstart, (double[])(data == null ? Doubles.EMPTYARRAY : data));
    }
}

