/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.set.AbstractLargeSetSConstraint;
import choco.kernel.solver.variables.set.SetVar;

public class SetValuePrecede
extends AbstractLargeSetSConstraint {
    int s;
    int t;
    int n;
    IStateInt alpha;
    IStateInt beta;
    IStateInt gamma;
    IEnvironment environment;

    public SetValuePrecede(int s, int t, SetVar[] svars, IEnvironment environment) {
        super(svars);
        this.s = s;
        this.t = t;
        this.n = ((SetVar[])this.vars).length;
        this.environment = environment;
    }

    private boolean checkKerEnv(SetVar v) {
        return !v.isInDomainEnveloppe(this.s) || v.isInDomainKernel(this.t);
    }

    private void initialize() throws ContradictionException {
        this.alpha = this.environment.makeInt(0);
        while (this.alpha.get() < this.n && this.checkKerEnv(((SetVar[])this.vars)[this.alpha.get()])) {
            this.updateVar(((SetVar[])this.vars)[this.alpha.get()]);
            this.alpha.add(1);
        }
        this.beta = this.environment.makeInt(this.alpha.get());
        this.gamma = this.environment.makeInt(this.alpha.get());
        if (this.alpha.get() < this.n) {
            do {
                this.gamma.add(1);
            } while (this.gamma.get() < this.n && (((SetVar[])this.vars)[this.gamma.get()].isInDomainEnveloppe(this.s) || !((SetVar[])this.vars)[this.gamma.get()].isInDomainKernel(this.t)));
            this.updateBeta();
        }
    }

    private void updateBeta() throws ContradictionException {
        do {
            this.beta.add(1);
        } while (this.beta.get() < this.n && this.checkKerEnv(((SetVar[])this.vars)[this.beta.get()]));
        if (this.beta.get() > this.gamma.get()) {
            ((SetVar[])this.vars)[this.alpha.get()].remFromEnveloppe(this.t, this, true);
            ((SetVar[])this.vars)[this.alpha.get()].addToKernel(this.s, this, true);
        }
    }

    private void updateVar(SetVar v) throws ContradictionException {
        if (!v.isInDomainEnveloppe(this.s)) {
            v.remFromEnveloppe(this.t, this, true);
        } else {
            v.addToKernel(this.s, this, true);
        }
    }

    private void propagate(int idx) throws ContradictionException {
        if (this.beta.get() <= this.gamma.get()) {
            SetVar var = ((SetVar[])this.vars)[idx];
            if (idx == this.alpha.get() && this.checkKerEnv(var)) {
                this.updateVar(var);
                this.alpha.add(1);
                while (this.alpha.get() < this.beta.get()) {
                    this.updateVar(((SetVar[])this.vars)[this.alpha.get()]);
                    this.alpha.add(1);
                }
                while (this.alpha.get() < this.n && this.checkKerEnv(((SetVar[])this.vars)[this.alpha.get()])) {
                    this.updateVar(((SetVar[])this.vars)[this.alpha.get()]);
                    this.alpha.add(1);
                }
                this.beta.set(this.alpha.get());
                if (this.alpha.get() < this.n) {
                    this.updateBeta();
                }
            } else if (idx == this.beta.get() && this.checkKerEnv(var)) {
                this.updateBeta();
            }
            this.checkGamma(idx);
        }
    }

    private void checkGamma(int idx) throws ContradictionException {
        if (this.beta.get() < this.gamma.get() && idx < this.gamma.get() && !((SetVar[])this.vars)[idx].isInDomainEnveloppe(this.s) && ((SetVar[])this.vars)[idx].isInDomainKernel(this.t)) {
            this.gamma.set(idx);
            if (this.beta.get() > idx) {
                ((SetVar[])this.vars)[this.alpha.get()].remFromEnveloppe(this.t, this, true);
                ((SetVar[])this.vars)[this.alpha.get()].addToKernel(this.s, this, true);
            }
        }
    }

    @Override
    public void awake() throws ContradictionException {
        this.initialize();
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            this.propagate(i);
        }
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        this.propagate(varIdx);
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        this.propagate(varIdx);
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        this.propagate(varIdx);
    }

    @Override
    public boolean isConsistent() {
        return this.isSatisfied();
    }

    @Override
    public boolean isSatisfied() {
        boolean check = ((SetVar[])this.vars)[0].isInDomainKernel(this.s) || !((SetVar[])this.vars)[0].isInDomainKernel(this.t);
        for (int j = 1; j < ((SetVar[])this.vars).length; ++j) {
            boolean tree = ((SetVar[])this.vars)[0].isInDomainKernel(this.s) && !((SetVar[])this.vars)[0].isInDomainKernel(this.t);
            for (int i = 0; i < j; ++i) {
                tree |= ((SetVar[])this.vars)[i].isInDomainKernel(this.s) && !((SetVar[])this.vars)[i].isInDomainKernel(this.t);
            }
            check &= ((SetVar[])this.vars)[j].isInDomainKernel(this.s) || !((SetVar[])this.vars)[j].isInDomainKernel(this.t) || tree;
        }
        return check;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValuePrecede(" + this.s + "," + this.t + ",{");
        for (int i = 0; i < ((SetVar[])this.vars).length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            SetVar var = ((SetVar[])this.vars)[i];
            sb.append(var.pretty());
        }
        sb.append("})");
        return sb.toString();
    }

    @Override
    public String toString() {
        String autstring = "ValuePrecede(" + this.s + "," + this.t + ",[ ";
        for (int i = 0; i < ((SetVar[])this.vars).length; ++i) {
            autstring = autstring + ((SetVar[])this.vars)[i] + "]";
        }
        return autstring;
    }
}

