/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Parameter;
import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceException;
import dr.math.MathUtils;
import dr.math.distributions.Distribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.Reference;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ParameterParser
extends AbstractXMLObjectParser {
    public static final String UPPER = "upper";
    public static final String LOWER = "lower";
    public static final String DIMENSION = "dimension";
    public static final String VALUE = "value";
    public static final String PARAMETER = "parameter";
    public static final String RANDOMIZE = "randomize";
    public static final String FILENAME = "fileName";
    public static final String BURNIN = "burnin";
    public static final String PARAMETERCOLUMN = "parameterColumn";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleArrayRule("value", true), AttributeRule.newIntegerRule("dimension", true), AttributeRule.newStringRule("fileName", true), AttributeRule.newStringRule("parameterColumn", true), AttributeRule.newIntegerRule("burnin", true), AttributeRule.newDoubleArrayRule("upper", true), AttributeRule.newDoubleArrayRule("lower", true), new ElementRule("randomize", new XMLSyntaxRule[]{new ElementRule(Distribution.class)}, true)};

    @Override
    public String getParserName() {
        return PARAMETER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        int n;
        int n2;
        Object object;
        double[] dArray = null;
        if (xMLObject.hasAttribute(DIMENSION)) {
            dArray = new double[xMLObject.getIntegerAttribute(DIMENSION)];
        }
        if (xMLObject.hasAttribute(FILENAME)) {
            int n3;
            int n4;
            object = xMLObject.getStringAttribute(FILENAME);
            File file = new File((String)object);
            object = file.getName();
            String string = file.getParent();
            if (!file.isAbsolute()) {
                string = System.getProperty("user.dir");
            }
            file = new File(string, (String)object);
            object = file.getAbsolutePath();
            String string2 = "";
            if (!xMLObject.hasAttribute(PARAMETERCOLUMN)) {
                throw new XMLParseException("when providing a file name you must provide a parameter column as well");
            }
            string2 = xMLObject.getStringAttribute(PARAMETERCOLUMN);
            int n5 = xMLObject.hasAttribute(BURNIN) ? xMLObject.getIntegerAttribute(BURNIN) : 0;
            LogFileTraces logFileTraces = new LogFileTraces((String)object, file);
            List<Double> list = null;
            try {
                logFileTraces.loadTraces();
                logFileTraces.setBurnIn(n5);
                n4 = -1;
                for (n3 = 0; n3 < logFileTraces.getTraceCount(); ++n3) {
                    String string3 = logFileTraces.getTraceName(n3);
                    if (!string3.trim().equals(string2)) continue;
                    n4 = n3;
                }
                if (n4 == -1) {
                    throw new XMLParseException("Column '" + string2 + "' can not be found for " + this.getParserName() + " element.");
                }
                list = logFileTraces.getValues(n4);
            }
            catch (TraceException traceException) {
                throw new XMLParseException(traceException.getMessage());
            }
            catch (IOException iOException) {
                throw new XMLParseException(iOException.getMessage());
            }
            dArray = new double[1];
            n3 = list.size();
            for (n4 = 0; n4 < n3; ++n4) {
                dArray[0] = dArray[0] + list.get(n4) / (double)n3;
            }
            System.out.println("Number of samples: " + list.size());
            System.out.println("Parameter mean: " + dArray[0]);
        } else if (xMLObject.hasAttribute(VALUE)) {
            if (dArray == null) {
                dArray = xMLObject.getDoubleArrayAttribute(VALUE);
            } else {
                object = xMLObject.getDoubleArrayAttribute(VALUE);
                if (((Object)object).length == dArray.length) {
                    System.arraycopy(object, 0, dArray, 0, ((Object)object).length);
                } else {
                    if (((Object)object).length != 1) throw new XMLParseException("value string must have 1 value or dimension values");
                    for (int i = 0; i < dArray.length; ++i) {
                        dArray[i] = (double)object[0];
                    }
                }
            }
        } else if (xMLObject.hasAttribute(DIMENSION)) {
            dArray = new double[xMLObject.getIntegerAttribute(DIMENSION)];
        } else {
            if (!xMLObject.hasChildNamed(RANDOMIZE)) {
                return new Parameter.Default(1);
            }
            dArray = new double[]{1.0};
        }
        double[] dArray2 = new double[dArray.length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray2[n2] = Double.POSITIVE_INFINITY;
        }
        double[] dArray3 = new double[dArray.length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray3[n2] = Double.NEGATIVE_INFINITY;
        }
        if (xMLObject.hasAttribute(UPPER)) {
            double[] dArray4 = xMLObject.getDoubleArrayAttribute(UPPER);
            if (dArray4.length == dArray2.length) {
                System.arraycopy(dArray4, 0, dArray2, 0, dArray4.length);
            } else {
                if (dArray4.length != 1) throw new XMLParseException("uppers string must have 1 value or dimension values");
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray2[i] = dArray4[0];
                }
            }
        }
        if (xMLObject.hasAttribute(LOWER)) {
            double[] dArray5 = xMLObject.getDoubleArrayAttribute(LOWER);
            if (dArray5.length == dArray3.length) {
                System.arraycopy(dArray5, 0, dArray3, 0, dArray5.length);
            } else {
                if (dArray5.length != 1) throw new XMLParseException("lowers string must have 1 value or dimension values");
                for (int i = 0; i < dArray3.length; ++i) {
                    dArray3[i] = dArray5[0];
                }
            }
        }
        if (dArray2.length != dArray.length) {
            throw new XMLParseException("value and upper limit strings have different dimension, in parameter");
        }
        if (dArray3.length != dArray.length) {
            throw new XMLParseException("value and lower limit strings have different dimension, in parameter");
        }
        for (n = 0; n < dArray.length; ++n) {
            if (!(dArray2[n] < dArray3[n])) continue;
            throw new XMLParseException("upper is lower than lower, in parameter");
        }
        if (xMLObject.hasChildNamed(RANDOMIZE)) {
            Distribution distribution = (Distribution)xMLObject.getChild(RANDOMIZE).getChild(Distribution.class);
            for (int i = 0; i < dArray.length; ++i) {
                do {
                    dArray[i] = distribution.quantile(MathUtils.nextDouble());
                } while (dArray[i] < dArray3[i] || dArray[i] > dArray2[i]);
            }
        } else {
            for (n = 0; n < dArray.length; ++n) {
                if (!(dArray2[n] < dArray[n])) continue;
                dArray[n] = dArray2[n];
            }
            for (n = 0; n < dArray.length; ++n) {
                if (!(dArray3[n] > dArray[n])) continue;
                dArray[n] = dArray3[n];
            }
        }
        Parameter.Default default_ = new Parameter.Default(dArray);
        default_.addBounds(new Parameter.DefaultBounds(dArray2, dArray3));
        return default_;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "A real-valued parameter of one or more dimensions.";
    }

    @Override
    public Class getReturnType() {
        return Parameter.class;
    }

    public static void replaceParameter(XMLObject xMLObject, Parameter parameter) throws XMLParseException {
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            XMLObject xMLObject2;
            if (!(xMLObject.getChild(i) instanceof Parameter)) continue;
            Object object = xMLObject.getRawChild(i);
            if (object instanceof Reference) {
                xMLObject2 = ((Reference)object).getReferenceObject();
            } else if (object instanceof XMLObject) {
                xMLObject2 = (XMLObject)object;
            } else {
                throw new XMLParseException("object reference not available");
            }
            if (xMLObject2.getChildCount() > 0) {
                throw new XMLParseException("No child elements allowed in parameter element.");
            }
            if (xMLObject2.hasAttribute("idref")) {
                throw new XMLParseException("References to " + xMLObject.getName() + " parameters are not allowed in treeModel.");
            }
            if (xMLObject2.hasAttribute(VALUE)) {
                throw new XMLParseException("Parameters in " + xMLObject.getName() + " have values set automatically.");
            }
            if (xMLObject2.hasAttribute(UPPER)) {
                throw new XMLParseException("Parameters in " + xMLObject.getName() + " have bounds set automatically.");
            }
            if (xMLObject2.hasAttribute(LOWER)) {
                throw new XMLParseException("Parameters in " + xMLObject.getName() + " have bounds set automatically.");
            }
            if (xMLObject2.hasAttribute("id")) {
                parameter.setId(xMLObject2.getStringAttribute("id"));
            }
            xMLObject2.setNativeObject(parameter);
            return;
        }
    }

    public static Parameter getOptionalParameter(XMLObject xMLObject, String string) {
        Parameter parameter = null;
        if (xMLObject.hasChildNamed(string)) {
            XMLObject xMLObject2 = xMLObject.getChild(string);
            parameter = (Parameter)xMLObject2.getChild(Parameter.class);
        }
        return parameter;
    }
}

