/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.hmc;

import dr.inference.distribution.AutoRegressiveNormalDistributionModel;
import dr.inference.distribution.CompoundSymmetryNormalDistributionModel;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;

public interface PrecisionMatrixVectorProductProvider {
    public double[] getProduct(Parameter var1);

    public double[] getMassVector();

    public double getTimeScale();

    public double getTimeScaleEigen();

    public static class Generic
    extends Base {
        private final MatrixParameterInterface matrix;

        public Generic(MatrixParameterInterface matrixParameterInterface, double d) {
            super(d);
            this.matrix = matrixParameterInterface;
        }

        @Override
        public double[] getProduct(Parameter parameter) {
            int n = this.matrix.getRowDimension();
            int n2 = this.matrix.getColumnDimension();
            assert (parameter.getDimension() == n2);
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                double d = 0.0;
                for (int j = 0; j < n2; ++j) {
                    d += this.matrix.getParameterValue(i, j) * parameter.getParameterValue(j);
                }
                dArray[i] = d;
            }
            return dArray;
        }

        @Override
        public double[] getMassVector() {
            int n = Math.min(this.matrix.getRowDimension(), this.matrix.getColumnDimension());
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.matrix.getParameterValue(i, i);
            }
            return dArray;
        }
    }

    public static class CompoundSymmetry
    extends Base {
        private final CompoundSymmetryNormalDistributionModel cs;

        public CompoundSymmetry(CompoundSymmetryNormalDistributionModel compoundSymmetryNormalDistributionModel, double d) {
            super(d);
            this.cs = compoundSymmetryNormalDistributionModel;
        }

        @Override
        public double[] getProduct(Parameter parameter) {
            return this.cs.getPrecisionVectorProduct(parameter.getParameterValues());
        }

        @Override
        public double[] getMassVector() {
            return this.cs.getDiagonal();
        }
    }

    public static class AutoRegressive
    extends Base {
        private final AutoRegressiveNormalDistributionModel ar;

        public AutoRegressive(AutoRegressiveNormalDistributionModel autoRegressiveNormalDistributionModel, double d) {
            super(d);
            this.ar = autoRegressiveNormalDistributionModel;
        }

        @Override
        public double[] getProduct(Parameter parameter) {
            return this.ar.getPrecisionVectorProduct(parameter.getParameterValues());
        }

        @Override
        public double[] getMassVector() {
            return this.ar.getDiagonal();
        }
    }

    public static abstract class Base
    implements PrecisionMatrixVectorProductProvider {
        private final double roughTimeGuess;

        private Base(double d) {
            this.roughTimeGuess = d;
        }

        @Override
        public double getTimeScale() {
            return this.roughTimeGuess;
        }

        @Override
        public double getTimeScaleEigen() {
            return 0.0;
        }
    }
}

