/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evolution.tree.Tree;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treedatalikelihood.discrete.MaskProvider;
import dr.evomodel.treedatalikelihood.discrete.NodeHeightTransform;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Parameter;
import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class RatioMasker
implements ModelListener,
MaskProvider {
    private final TreeModel tree;
    private final Parameter mask;
    private final NodeHeightTransform nodeHeightTransform;
    private final double ratioSamllValueThreshold;
    private final double heightDistanceThreshold;
    private boolean updatedByHeight;
    private boolean updatedByRatio;
    private final double traverseProbability;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        static final String RATIO_MASKER = "ratioMasker";
        static final String RATIO_THRESHOLD = "ratioThreshold";
        static final String HEIGHT_THRESHOLD = "heightThreshold";
        static final String MASK = "mask";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("mask", Parameter.class), new ElementRule(TreeModel.class), AttributeRule.newDoubleRule("ratioThreshold"), AttributeRule.newDoubleRule("heightThreshold"), new ElementRule(Transform.ComposeMultivariable.class)};

        @Override
        public String getParserName() {
            return RATIO_MASKER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getChild(MASK).getChild(Parameter.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            double d = xMLObject.getAttribute(RATIO_THRESHOLD, 0.0);
            double d2 = xMLObject.getAttribute(HEIGHT_THRESHOLD, 0.0);
            Transform.ComposeMultivariable composeMultivariable = (Transform.ComposeMultivariable)xMLObject.getChild(Transform.ComposeMultivariable.class);
            if (parameter.getDimension() == 1) {
                parameter.setDimension(composeMultivariable.getDimension());
            }
            return new RatioMasker(treeModel, parameter, (NodeHeightTransform)composeMultivariable.getInnerTransform(), d, d2);
        }

        @Override
        public String getParserDescription() {
            return "A utility to craft mask for filtering dimensions in the ratio space for nodeHeight transform";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return RatioMasker.class;
        }
    };

    public RatioMasker(TreeModel treeModel, Parameter parameter, NodeHeightTransform nodeHeightTransform, double d, double d2) {
        this(treeModel, parameter, nodeHeightTransform, d, d2, 0.0);
    }

    public RatioMasker(TreeModel treeModel, Parameter parameter, NodeHeightTransform nodeHeightTransform, double d, double d2, double d3) {
        this.tree = treeModel;
        this.mask = parameter;
        this.nodeHeightTransform = nodeHeightTransform;
        this.ratioSamllValueThreshold = d;
        this.heightDistanceThreshold = d2;
        this.traverseProbability = d3;
        treeModel.addModelListener(this);
        treeModel.addModelRestoreListener(this);
        this.dimensionCheck();
    }

    private void dimensionCheck() {
        if (this.nodeHeightTransform.getDimension() != this.mask.getDimension()) {
            throw new RuntimeException("Ratio and mask parameters should have same dimension.");
        }
    }

    @Override
    public void modelChangedEvent(Model model, Object object, int n) {
        this.updatedByRatio = false;
        this.updatedByHeight = false;
    }

    @Override
    public void modelRestored(Model model) {
        this.updatedByRatio = false;
        this.updatedByHeight = false;
    }

    @Override
    public Parameter getMask() {
        return this.mask;
    }

    @Override
    public void updateMask() {
        double[] dArray = this.updateMaskByHeight();
        double[] dArray2 = this.updateMaskByRatio();
        for (int i = 0; i < this.mask.getDimension(); ++i) {
            double d = dArray[i] == 0.0 || dArray2[i] == 0.0 ? 0.0 : 1.0;
            this.mask.setParameterValueQuietly(i, d);
        }
        this.mask.fireParameterChangedEvent();
    }

    private double[] updateMaskByHeight() {
        if (!this.updatedByHeight) {
            this.updatedByHeight = true;
            return this.nodeHeightTransform.getNodeHeightTransformDelegate().setMaskByHeightDifference(this.heightDistanceThreshold);
        }
        return this.mask.getParameterValues();
    }

    private double[] updateMaskByRatio() {
        if (!this.updatedByRatio) {
            this.updatedByRatio = true;
            return this.nodeHeightTransform.getNodeHeightTransformDelegate().setMaskByRatio(this.ratioSamllValueThreshold);
        }
        return this.mask.getParameterValues();
    }

    private static enum SubTreeMasker {
        NONE{

            @Override
            double[] getSubTreeMask(Tree tree, double d, boolean bl) {
                if (bl) {
                    return new double[tree.getInternalNodeCount()];
                }
                return new double[tree.getInternalNodeCount() - 1];
            }
        }
        ,
        TRAVERSE{

            @Override
            double[] getSubTreeMask(Tree tree, double d, boolean bl) {
                return new double[0];
            }
        };


        abstract double[] getSubTreeMask(Tree var1, double var2, boolean var4);
    }
}

