/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evomodel.continuous.MapDiffusionModel;
import dr.evomodel.continuous.TopographicalMap;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class RandomWalkOnMapOperator
extends AbstractAdaptableOperator {
    public static final String OPERATOR_NAME = "randomWalkOnMapOperator";
    public static final String WINDOW_SIZE = "windowSize";
    public static final String UPDATE_INDEX = "updateIndex";
    public static final String GRID_X_DIMENSION = "xGridDimension";
    public static final String GRID_Y_DIMENSION = "yGridDimension";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("windowSize"), AttributeRule.newDoubleRule("weight"), AttributeRule.newBooleanRule("autoOptimize", true), new ElementRule(MapDiffusionModel.class), new ElementRule(Parameter.class)};

        @Override
        public String getParserName() {
            return RandomWalkOnMapOperator.OPERATOR_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute(RandomWalkOnMapOperator.WINDOW_SIZE);
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            MapDiffusionModel mapDiffusionModel = (MapDiffusionModel)xMLObject.getChild(MapDiffusionModel.class);
            return new RandomWalkOnMapOperator(parameter, mapDiffusionModel, d2, d, adaptationMode);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a random walk operator on a given map.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private Parameter parameter = null;
    private double windowSize = 0.01;
    private TopographicalMap map;
    private MapDiffusionModel model;
    private int numberPoints;
    private int maxX;
    private int maxY;

    public RandomWalkOnMapOperator(Parameter parameter, MapDiffusionModel mapDiffusionModel, double d, double d2, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.parameter = parameter;
        this.model = mapDiffusionModel;
        this.map = mapDiffusionModel.getMap();
        this.windowSize = d;
        this.setWeight(d2);
        this.numberPoints = parameter.getDimension() / 2;
    }

    @Override
    public Parameter getParameter() {
        return this.parameter;
    }

    public final double getWindowSize() {
        return this.windowSize;
    }

    @Override
    public final double doOperation() {
        int n = MathUtils.nextInt(this.numberPoints) * 2;
        int n2 = 0;
        int n3 = 0;
        while (n2 == 0 && n3 == 0) {
            n2 = MathUtils.nextInt(3) - 1;
            n3 = MathUtils.nextInt(3) - 1;
        }
        int n4 = (int)this.parameter.getParameterValue(n) + n2;
        int n5 = (int)this.parameter.getParameterValue(n + 1) + n3;
        if (this.map != null && !this.map.isValidPoint(n4, n5)) {
            return Double.NEGATIVE_INFINITY;
        }
        this.parameter.setParameterValue(n, n4);
        this.parameter.setParameterValue(n + 1, n5);
        return 0.0;
    }

    @Override
    public final String getOperatorName() {
        return this.parameter.getParameterName();
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.windowSize);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.windowSize = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.windowSize;
    }

    @Override
    public String getAdaptableParameterName() {
        return WINDOW_SIZE;
    }

    public String toString() {
        return "randomWalkOnMapOperator(" + this.parameter.getParameterName() + ")";
    }
}

