/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.basta;

import dr.evomodel.coalescent.basta.BastaLikelihood;
import dr.evomodel.substmodel.SVSComplexSubstitutionModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Parameter;
import dr.xml.Reportable;

public class StructuredCoalescentLikelihoodGradient
implements GradientWrtParameterProvider,
ModelListener,
Reportable,
Loggable {
    private final BastaLikelihood structuredCoalescentLikelihood;
    private final SubstitutionModel substitutionModel;
    private final WrtParameter wrtParameter;

    public StructuredCoalescentLikelihoodGradient(BastaLikelihood bastaLikelihood, SubstitutionModel substitutionModel, WrtParameter wrtParameter) {
        this.structuredCoalescentLikelihood = bastaLikelihood;
        this.substitutionModel = substitutionModel;
        this.wrtParameter = wrtParameter;
    }

    @Override
    public Likelihood getLikelihood() {
        return this.structuredCoalescentLikelihood;
    }

    @Override
    public Parameter getParameter() {
        return this.wrtParameter.getParameter(this.structuredCoalescentLikelihood, this.substitutionModel);
    }

    @Override
    public int getDimension() {
        return this.getParameter().getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        return this.wrtParameter.getGradientLogDensity(this.structuredCoalescentLikelihood);
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[0];
    }

    @Override
    public void modelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public void modelRestored(Model model) {
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = GradientWrtParameterProvider.getReportAndCheckForError(this, 0.0, Double.POSITIVE_INFINITY, 0.1);
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static enum WrtParameter {
        MIGRATION_RATE("migrationRate"){

            @Override
            double[] getGradientLogDensity(BastaLikelihood bastaLikelihood) {
                return bastaLikelihood.getGradientLogDensity();
            }

            @Override
            Parameter getParameter(BastaLikelihood bastaLikelihood, SubstitutionModel substitutionModel) {
                assert (substitutionModel instanceof SVSComplexSubstitutionModel);
                SVSComplexSubstitutionModel sVSComplexSubstitutionModel = (SVSComplexSubstitutionModel)substitutionModel;
                return sVSComplexSubstitutionModel.getRatesParameter();
            }
        }
        ,
        POPULATION_SIZE("populationSize"){

            @Override
            double[] getGradientLogDensity(BastaLikelihood bastaLikelihood) {
                return bastaLikelihood.getPopSizeGradientLogDensity();
            }

            @Override
            Parameter getParameter(BastaLikelihood bastaLikelihood, SubstitutionModel substitutionModel) {
                return bastaLikelihood.getPopSizes();
            }
        };

        private final String name;

        private WrtParameter(String string2) {
            this.name = string2;
        }

        abstract double[] getGradientLogDensity(BastaLikelihood var1);

        abstract Parameter getParameter(BastaLikelihood var1, SubstitutionModel var2);

        public static WrtParameter factory(String string) {
            for (WrtParameter wrtParameter : WrtParameter.values()) {
                if (!string.equalsIgnoreCase(wrtParameter.name)) continue;
                return wrtParameter;
            }
            return null;
        }
    }
}

