/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evomodel.arg.ARGModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import dr.math.distributions.GammaDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ARGRatePrior
extends AbstractModelLikelihood {
    public static final String ARG_RATE_PRIOR = "argRatePrior";
    public static final String SIGMA = "sigma";
    private final ARGModel arg;
    private final Parameter logNormalSigma;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return ARGRatePrior.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return null;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getAttribute("id", "");
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            return new ARGRatePrior(string, aRGModel, parameter);
        }

        @Override
        public String getParserName() {
            return ARGRatePrior.ARG_RATE_PRIOR;
        }
    };

    public ARGRatePrior(String string, ARGModel aRGModel, Parameter parameter) {
        super(string);
        this.arg = aRGModel;
        this.logNormalSigma = parameter;
        this.addModel(aRGModel);
        this.addVariable(parameter);
    }

    public double[] generateValues() {
        double[] dArray = new double[this.arg.getNumberOfPartitions()];
        double d = this.logNormalSigma.getParameterValue(0);
        double d2 = 1.0 / d;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = MathUtils.nextGamma(d2, d2);
        }
        return dArray;
    }

    @Override
    public double getLogLikelihood() {
        return this.calculateLogLikelihood();
    }

    public double getAddHastingsRatio(double[] dArray) {
        return -this.calculateLogLikelihood(dArray);
    }

    private double calculateLogLikelihood(double[] dArray) {
        double d = 0.0;
        double d2 = this.logNormalSigma.getParameterValue(0);
        double d3 = 1.0 / d2;
        for (double d4 : dArray) {
            d += GammaDistribution.logPdf(d4, d3, d2);
        }
        return d;
    }

    private double calculateLogLikelihood() {
        double d = 0.0;
        int n = this.arg.getNodeCount();
        for (int i = 0; i < n; ++i) {
            ARGModel.Node node = (ARGModel.Node)this.arg.getNode(i);
            if (node.isRoot() || !node.isBifurcation()) continue;
            double[] dArray = node.rateParameter.getParameterValues();
            d += this.calculateLogLikelihood(dArray);
        }
        return d;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public String getId() {
        return super.getId();
    }

    @Override
    public void setId(String string) {
        super.setId(string);
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void storeState() {
    }
}

