/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.tsp.grid;

import java.time.LocalDateTime;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface InternalValueReader<T> {
    public @Nullable T read(@Nullable Object var1);

    @NonNull
    default public InternalValueReader<T> or(@NonNull InternalValueReader<T> fallback) {
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        return obj -> {
            T result = this.read(obj);
            return result != null ? result : fallback.read(obj);
        };
    }

    @NonNull
    public static <X> InternalValueReader<X> onStringParser(@NonNull Function<String, X> parser) {
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        return obj -> obj instanceof String ? parser.apply((String)obj) : null;
    }

    @NonNull
    public static InternalValueReader<LocalDateTime> onDateTime() {
        return CastReader.DATETIME;
    }

    @NonNull
    public static InternalValueReader<Number> onNumber() {
        return CastReader.NUMBER;
    }

    @NonNull
    public static InternalValueReader<String> onString() {
        return CastReader.STRING;
    }

    @NonNull
    public static <T> InternalValueReader<T> onNull() {
        return NullReader.INSTANCE;
    }

    public static final class CastReader<T>
    implements InternalValueReader<T> {
        private final Class<T> type;
        static final CastReader<LocalDateTime> DATETIME = new CastReader<LocalDateTime>(LocalDateTime.class);
        static final CastReader<Number> NUMBER = new CastReader<Number>(Number.class);
        static final CastReader<String> STRING = new CastReader<String>(String.class);

        @Override
        public T read(Object obj) {
            return (T)(this.type.isInstance(obj) ? obj : null);
        }

        @Override
        public InternalValueReader<T> or(InternalValueReader<T> fallback) {
            return fallback == NullReader.INSTANCE ? this : InternalValueReader.super.or(fallback);
        }

        @Generated
        public CastReader(Class<T> type) {
            this.type = type;
        }
    }

    public static enum NullReader implements InternalValueReader
    {
        INSTANCE;


        public Object read(Object obj) {
            return null;
        }

        public InternalValueReader or(InternalValueReader fallback) {
            return fallback;
        }
    }
}

