/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.sat;

import gnu.trove.list.TIntList;
import java.util.stream.IntStream;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.sat.Reason;

public class Clause
extends Reason {
    private final int[] literals_;
    private final boolean learnt;
    double activity;
    private final int id;

    public Clause(int[] ps, boolean learnt) {
        super(0);
        this.literals_ = ps.length <= 3 ? (int[])ps.clone() : Clause.reduceOs(ps);
        this.learnt = learnt;
        this.id = MiniSat.clauseCounter.get();
        MiniSat.clauseCounter.set(MiniSat.clauseCounter.get() + 1);
    }

    private static int[] reduceOs(int[] ps) {
        int nb0 = (int)IntStream.of(ps).filter(p -> p == 0).count();
        if (nb0 <= 1) {
            return ps;
        }
        int[] reduced = new int[ps.length - nb0 + 1];
        int j = 0;
        for (int i = 0; i < ps.length; ++i) {
            if (ps[i] != 0) {
                reduced[j++] = ps[i];
                continue;
            }
            if (j != 0) continue;
            reduced[j++] = 0;
        }
        return reduced;
    }

    Clause(int[] ps) {
        this(ps, false);
    }

    public Clause(TIntList ps, boolean learnt) {
        super(0);
        this.literals_ = ps.toArray();
        this.learnt = learnt;
        this.id = MiniSat.clauseCounter.get();
        MiniSat.clauseCounter.set(MiniSat.clauseCounter.get() + 1);
    }

    Clause(TIntList ps) {
        this(ps, false);
    }

    public static Clause undef() {
        return UNDEF;
    }

    @Override
    Clause getConflict() {
        return this;
    }

    public int size() {
        return this.literals_.length;
    }

    public boolean learnt() {
        return this.learnt;
    }

    public int _g(int i) {
        return this.literals_[i];
    }

    void _s(int pos, int l) {
        this.literals_[pos] = l;
    }

    public String toString() {
        StringBuilder st = new StringBuilder();
        st.append("T").append(Thread.currentThread().getId());
        st.append("~#").append(this.id).append(" Size:").append(this.literals_.length).append(" - ");
        if (this.literals_.length > 0) {
            st.append(this.literals_[0]).append(" ");
        }
        for (int i = 1; i < this.literals_.length; ++i) {
            st.append(" \u2228 ").append(this.literals_[i]);
        }
        return st.toString();
    }

    public String toString(MiniSat sat) {
        StringBuilder st = new StringBuilder();
        st.append("#").append(this.id).append(" Size:").append(this.literals_.length).append(" - ");
        if (this.literals_.length > 0) {
            st.append(sat.printLit(this.literals_[0]));
        }
        for (int i = 1; i < this.literals_.length; ++i) {
            st.append(" \u2228 ").append(sat.printLit(this.literals_[i]));
        }
        return st.toString();
    }
}

