/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.io;

public class ImportException
extends Exception {
    public ImportException() {
    }

    public ImportException(String message) {
        super(message);
    }

    public ImportException(String message, Throwable cause) {
        super(message, cause);
    }

    public String userMessage() {
        return this.getMessage();
    }

    public static class UnknownTaxonException
    extends ImportException {
        public UnknownTaxonException() {
        }

        public UnknownTaxonException(String message) {
            super(message);
        }
    }

    public static class DuplicateTaxaException
    extends ImportException {
        public DuplicateTaxaException() {
        }

        public DuplicateTaxaException(String message) {
            super(message);
        }
    }

    public static class TooFewTaxaException
    extends ImportException {
        public TooFewTaxaException() {
        }

        public TooFewTaxaException(String message) {
            super(message);
        }

        public String userMessage() {
            return "Number of taxa is less than expected: " + (this.getMessage() != null ? this.getMessage() : "");
        }
    }

    public static class ShortSequenceException
    extends ImportException {
        public ShortSequenceException() {
        }

        public ShortSequenceException(String message) {
            super(message);
        }

        public String userMessage() {
            return "Sequence is too short: " + this.getMessage();
        }
    }

    public static class MissingFieldException
    extends ImportException {
        public MissingFieldException() {
        }

        public MissingFieldException(String message) {
            super(message);
        }

        public String userMessage() {
            return "Unsupported value for field " + this.getMessage();
        }
    }

    public static class UnparsableDataException
    extends ImportException {
        public UnparsableDataException() {
        }

        public UnparsableDataException(String message) {
            super(message);
        }
    }

    public static class BadFormatException
    extends ImportException {
        public BadFormatException() {
        }

        public BadFormatException(String message) {
            super(message);
        }
    }

    public static class DuplicateFieldException
    extends ImportException {
        public DuplicateFieldException() {
        }

        public DuplicateFieldException(String message) {
            super(message);
        }
    }
}

