/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.sitemodel;

import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.SubstitutionModel;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class DirichletSiteModel
extends AbstractModel
implements SiteModel {
    public static final String SUBSTITUTION_MODEL = "substitutionModel";
    public static final String DIRICHLET_SITE_MODEL = "DirichletSiteModel";
    public static final String CATEGORIES = "categories";
    public static final String RATES = "rates";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("substitutionModel", new XMLSyntaxRule[]{new ElementRule(SubstitutionModel.class)}), new ElementRule("rates", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};

        @Override
        public String[] getParserNames() {
            return new String[]{this.getParserName(), "beast_" + this.getParserName()};
        }

        @Override
        public String getParserName() {
            return DirichletSiteModel.DIRICHLET_SITE_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            SubstitutionModel substitutionModel = (SubstitutionModel)xMLObject.getElementFirstChild(DirichletSiteModel.SUBSTITUTION_MODEL);
            String string = "";
            Parameter parameter = null;
            if (xMLObject.hasChildNamed(DirichletSiteModel.RATES)) {
                XMLObject xMLObject2 = xMLObject.getChild(DirichletSiteModel.RATES);
                parameter = (Parameter)xMLObject2.getChild(Parameter.class);
                string = string + "\n  with " + parameter.getDimension() + " categories.";
            }
            if (string.length() > 0) {
                Logger.getLogger("dr.evomodel").info("Creating site model: " + string);
            } else {
                Logger.getLogger("dr.evomodel").info("Creating site model.");
            }
            return new DirichletSiteModel(substitutionModel, parameter);
        }

        @Override
        public String getParserDescription() {
            return "A SiteModel that has Dirichlet distributed rates across sites";
        }

        @Override
        public Class getReturnType() {
            return DirichletSiteModel.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private SubstitutionModel substitutionModel = null;
    private Parameter ratesParameter;
    private boolean ratesKnown;
    private double[] categoryRates;
    private double[] categoryProportions;

    public DirichletSiteModel(SubstitutionModel substitutionModel, int n) {
        this(substitutionModel, new Parameter.Default(new double[n]));
    }

    public DirichletSiteModel(SubstitutionModel substitutionModel, Parameter parameter) {
        super(DIRICHLET_SITE_MODEL);
        this.substitutionModel = substitutionModel;
        this.addModel(substitutionModel);
        int n = parameter.getDimension();
        this.categoryRates = new double[n];
        this.categoryProportions = new double[n];
        this.ratesKnown = false;
        for (int i = 0; i < n; ++i) {
            parameter.setParameterValue(i, 1.0 / (double)n);
            this.categoryProportions[i] = 1.0 / (double)n;
        }
        this.ratesParameter = parameter;
        this.addVariable(this.ratesParameter);
        this.ratesParameter.addBounds(new Parameter.DefaultBounds(1.0, 0.0, parameter.getDimension()));
    }

    public Parameter getRatesParameter() {
        return this.ratesParameter;
    }

    @Override
    public boolean integrateAcrossCategories() {
        return true;
    }

    @Override
    public int getCategoryCount() {
        return this.categoryRates.length;
    }

    @Override
    public int getCategoryOfSite(int n) {
        throw new IllegalArgumentException("Integrating across categories");
    }

    @Override
    public double getRateForCategory(int n) {
        this.calculateCategoryRates();
        return this.categoryRates[n];
    }

    @Override
    public double[] getCategoryRates() {
        this.calculateCategoryRates();
        double[] dArray = new double[this.categoryRates.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.categoryRates[i];
        }
        return dArray;
    }

    public void getTransitionProbabilities(double d, double[] dArray) {
        this.substitutionModel.getTransitionProbabilities(d, dArray);
    }

    @Override
    public double getProportionForCategory(int n) {
        this.calculateCategoryRates();
        return this.categoryProportions[n];
    }

    @Override
    public double[] getCategoryProportions() {
        this.calculateCategoryRates();
        return this.categoryProportions;
    }

    private double get_substitution_scale() {
        double d = 0.0;
        for (int i = 0; i < this.categoryRates.length; ++i) {
            d += this.categoryProportions[i] * this.ratesParameter.getParameterValue(i);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateCategoryRates() {
        DirichletSiteModel dirichletSiteModel = this;
        synchronized (dirichletSiteModel) {
            if (this.ratesKnown) {
                return;
            }
        }
        double d = this.get_substitution_scale();
        double d2 = 1.0 / d;
        for (int i = 0; i < this.categoryRates.length; ++i) {
            this.categoryRates[i] = this.ratesParameter.getParameterValue(i) * d2;
        }
        this.ratesKnown = true;
    }

    @Override
    public FrequencyModel getFrequencyModel() {
        return this.substitutionModel.getFrequencyModel();
    }

    @Override
    public SubstitutionModel getSubstitutionModel() {
        return this.substitutionModel;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.listenerHelper.fireModelChanged(this, object, n);
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.ratesParameter) {
            this.ratesKnown = false;
        }
        this.listenerHelper.fireModelChanged(this, variable, n);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.ratesKnown = false;
    }

    @Override
    protected void acceptState() {
    }
}

