/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.distributions.MultivariateDistribution;
import dr.math.functionEval.GammaFunction;

public class NormalGammaDistribution
implements MultivariateDistribution {
    public final String TYPE = "normalGammaDistribution";
    private double mu;
    private double lambda;
    private double alpha;
    private double beta;

    public NormalGammaDistribution(double d, double d2, double d3, double d4) {
        this.mu = d;
        this.lambda = d2;
        this.alpha = d3;
        this.beta = d4;
    }

    public double pdf(double[] dArray) {
        return Math.pow(this.beta, this.alpha) * Math.sqrt(this.lambda) * Math.pow(dArray[1], this.alpha - 0.5) * Math.exp(-this.beta * dArray[1]) * Math.exp(-this.lambda * dArray[1] * Math.pow(dArray[0] - this.mu, 2.0) / 2.0) / (GammaFunction.gamma(this.alpha) * Math.sqrt(Math.PI * 2));
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.alpha * Math.log(this.beta) + 0.5 * Math.log(this.lambda) + (this.alpha - 0.5) * Math.log(dArray[1]) - this.beta * dArray[1] - this.lambda * dArray[1] * Math.pow(dArray[0] - this.mu, 2.0) / 2.0 - GammaFunction.logGamma(this.alpha) - 0.5 * Math.log(Math.PI * 2);
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double[] getMean() {
        return new double[]{this.mu, this.alpha / this.beta};
    }

    @Override
    public String getType() {
        return "normalGammaDistribution";
    }

    public double[] getParameters() {
        return new double[]{this.mu, this.lambda, this.alpha, this.beta};
    }
}

