/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.GradientProvider;
import dr.inference.model.HessianProvider;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.PriorPreconditioningProvider;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.GammaDistribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.GammaDistributionImpl;
import org.apache.commons.math.special.Gamma;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExpGammaDistributionModel
extends AbstractModel
implements ParametricDistributionModel,
GradientProvider,
HessianProvider,
PriorPreconditioningProvider {
    public static final String EXP_GAMMA_DISTRIBUTION_MODEL = "expGammaDistributionModel";
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return ExpGammaDistributionModel.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    private final Variable<Double> shape;
    private final Variable<Double> scale;

    public ExpGammaDistributionModel(Variable<Double> variable, Variable<Double> variable2) {
        super(EXP_GAMMA_DISTRIBUTION_MODEL);
        this.shape = variable;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.scale = variable2;
        this.addVariable(variable2);
        variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    @Override
    public double pdf(double d) {
        return Math.exp(d) * GammaDistribution.pdf(Math.exp(d), this.getShape(), this.getScale());
    }

    @Override
    public double logPdf(double d) {
        return d + GammaDistribution.logPdf(Math.exp(d), this.getShape(), this.getScale());
    }

    @Override
    public double cdf(double d) {
        return GammaDistribution.cdf(Math.exp(d), this.getShape(), this.getScale());
    }

    @Override
    public double quantile(double d) {
        try {
            return Math.log(new GammaDistributionImpl(this.getShape(), this.getScale()).inverseCumulativeProbability(d));
        }
        catch (MathException mathException) {
            return Double.NaN;
        }
    }

    @Override
    public double mean() {
        return Gamma.digamma(this.getShape()) + Math.log(this.getScale());
    }

    @Override
    public double variance() {
        return Gamma.trigamma(this.getShape());
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getStandardDeviation(int n) {
        return Math.sqrt(this.variance());
    }

    @Override
    public int getDimension() {
        return 1;
    }

    public double hessianGammaPdf(double d, double d2, double d3) {
        double d4 = Math.pow(d, d2 - 3.0) * Math.exp(-d / d3);
        return (d4 *= (d2 * d2 - 3.0 * d2 + 2.0) * d3 * d3 - 2.0 * (d2 - 1.0) * d3 * d + d * d) / (d3 * d3);
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        double d = this.getShape();
        double d2 = this.getScale();
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = Math.exp(dArray[i]);
            dArray2[i] = d - d3 / d2;
        }
        return dArray2;
    }

    @Override
    public double[] getDiagonalHessianLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        double d = this.getShape();
        double d2 = this.getScale();
        int n = 0;
        if (n < dArray.length) {
            throw new RuntimeException("Not yet implemented");
        }
        return dArray2;
    }

    @Override
    public double[][] getHessianLogDensity(Object object) {
        return HessianProvider.expandDiagonals(this.getDiagonalHessianLogDensity(object));
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }

    public double getShape() {
        return this.shape.getValue(0);
    }

    public double getScale() {
        return this.scale.getValue(0);
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

