/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.AbstractPolygon2D;
import dr.geo.Polygon2D;
import dr.geo.Reject;
import dr.geo.SpaceTime;
import dr.geo.SpaceTimeRejector;
import dr.geo.VisualizeBrownianBridge2D;
import dr.math.distributions.MultivariateNormalDistribution;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;

public class VisualizeKMLBrownianBridge
extends VisualizeBrownianBridge2D {
    List<AbstractPolygon2D> polygons;
    List<Reject> rejects = new ArrayList<Reject>();
    int MAX_DEPTH = 10;
    int MAX_TRIES = 20;
    int TRIALS = 3;
    Point2D brussels = new Point2D.Double(4.35, 50.85);
    Point2D amsterdam = new Point2D.Double(4.89, 52.37);
    Point2D berlin = new Point2D.Double(13.41, 52.52);
    Point2D rome = new Point2D.Double(12.48, 41.9);
    Point2D athens = new Point2D.Double(23.72, 37.98);
    Point2D paris = new Point2D.Double(2.35, 48.86);
    Point2D montepelier = new Point2D.Double(3.88, 43.61);
    Point2D munich = new Point2D.Double(11.58, 48.14);
    Point2D bern = new Point2D.Double(7.45, 46.95);
    Color[] depthColor = new Color[]{Color.red, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta};

    public VisualizeKMLBrownianBridge(String string) {
        int n;
        this.polygons = Polygon2D.readKMLFile(string);
        System.out.println("Read " + this.polygons.size() + " polygons");
        this.start = new SpaceTime[]{new SpaceTime(0.0, this.amsterdam), new SpaceTime(0.0, this.amsterdam), new SpaceTime(1.0, this.bern), new SpaceTime(1.0, this.bern)};
        this.end = new SpaceTime[]{new SpaceTime(2.0, this.montepelier), new SpaceTime(1.0, this.bern), new SpaceTime(2.0, this.rome), new SpaceTime(2.0, this.athens)};
        this.topLeft = new Point2D.Double(-5.0, 28.0);
        this.bottomRight = new Point2D.Double(25.0, 57.0);
        System.out.println("Converting polygons to shapes");
        this.shapes = new ArrayList();
        for (AbstractPolygon2D abstractPolygon2D : this.polygons) {
            this.shapes.add(abstractPolygon2D.getShape());
            System.out.print(".");
            System.out.flush();
        }
        System.out.println();
        this.rejector = new SpaceTimeRejector(){

            @Override
            public boolean reject(double d, double[] dArray) {
                double d2 = dArray[0];
                double d3 = dArray[1];
                for (Shape shape : VisualizeKMLBrownianBridge.this.shapes) {
                    if (!shape.contains(d2, d3)) continue;
                    VisualizeKMLBrownianBridge.this.rejects.add(new Reject(0, d, dArray));
                    return true;
                }
                return false;
            }

            @Override
            public void reset() {
                VisualizeKMLBrownianBridge.this.rejects.clear();
            }

            @Override
            public List<Reject> getRejects() {
                return VisualizeKMLBrownianBridge.this.rejects;
            }
        };
        this.mnd = new MultivariateNormalDistribution(new double[]{0.0}, new double[][]{{0.15, 0.0}, {0.0, 0.15}});
        this.shapeColor = Color.BLACK;
        for (n = 0; n < this.start.length; ++n) {
            if (!this.rejector.reject(this.start[n].time, this.start[n].space) && !this.rejector.reject(this.end[n].time, this.end[n].space)) continue;
            throw new RuntimeException("Start or end in water");
        }
        for (n = 0; n < this.depthColor.length; ++n) {
            this.depthColor[n] = new Color(this.depthColor[n].getRed(), this.depthColor[n].getGreen(), this.depthColor[n].getBlue(), 128);
        }
    }

    @Override
    public int getMaxDepth() {
        return this.MAX_DEPTH;
    }

    @Override
    public int getMaxTries() {
        return this.MAX_TRIES;
    }

    @Override
    public int getTrials() {
        return this.TRIALS;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        AffineTransform affineTransform = this.getFullTransform();
        for (Reject reject : this.rejects) {
            graphics.setColor(this.depthColor[0]);
            SpaceTime.paintDot(new SpaceTime(reject.getTime(), reject.getSpace()), 2.0, affineTransform, (Graphics2D)graphics);
        }
        this.rejector.reset();
    }

    @Override
    AffineTransform getTranslate() {
        return AffineTransform.getTranslateInstance(-this.topLeft.getX(), -this.bottomRight.getY());
    }

    @Override
    AffineTransform getScale() {
        return AffineTransform.getScaleInstance(this.scaleX, -this.scaleY);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Europe");
        jFrame.getContentPane().add("Center", new VisualizeKMLBrownianBridge(stringArray[0]));
        jFrame.setSize(900, 900);
        jFrame.setVisible(true);
    }
}

