/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.MutableTreeListener;
import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.MutableTaxonListListener;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeParameterModel;
import dr.inference.model.AbstractModel;
import dr.util.Attributable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.Keywordable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class TreeModel
extends AbstractModel
implements MutableTreeModel,
Keywordable,
Citable {
    private final boolean isVariable;
    private final List<String> keywords = new ArrayList<String>();
    private final List<TreeChangedEvent> treeChangedEvents = new ArrayList<TreeChangedEvent>();
    protected boolean inEdit = false;
    private String id = null;
    private Attributable.AttributeHelper treeAttributes = null;
    private Units.Type units = Units.Type.SUBSTITUTIONS;

    public TreeModel(String string, boolean bl) {
        super(string);
        this.isVariable = bl;
    }

    @Override
    public Units.Type getUnits() {
        return this.units;
    }

    @Override
    public void setUnits(Units.Type type) {
        this.units = type;
    }

    @Override
    public int getTaxonCount() {
        return this.getExternalNodeCount();
    }

    @Override
    public String getTaxonId(int n) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            return taxon.getId();
        }
        return null;
    }

    @Override
    public int getTaxonIndex(String string) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getTaxonId(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (this.getTaxon(i) != taxon) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    @Override
    public Iterator<Taxon> iterator() {
        return new Iterator<Taxon>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < TreeModel.this.getTaxonCount() - 1;
            }

            @Override
            public Taxon next() {
                ++this.index;
                return TreeModel.this.getTaxon(this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            return taxon.getAttribute(string);
        }
        return null;
    }

    @Override
    public int addTaxon(Taxon taxon) {
        throw new IllegalArgumentException("Cannot add taxon to a TreeModel");
    }

    @Override
    public boolean removeTaxon(Taxon taxon) {
        throw new IllegalArgumentException("Cannot add taxon to a TreeModel");
    }

    @Override
    public void setTaxonId(int n, String string) {
        throw new IllegalArgumentException("Cannot set taxon id in a TreeModel");
    }

    @Override
    public void setTaxonAttribute(int n, String string, Object object) {
        throw new IllegalArgumentException("Cannot set taxon attribute in a TreeModel");
    }

    @Override
    public void addMutableTreeListener(MutableTreeListener mutableTreeListener) {
    }

    @Override
    public void addMutableTaxonListListener(MutableTaxonListListener mutableTaxonListListener) {
    }

    public abstract NodeRef[] getNodes();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (this.treeAttributes == null) {
            this.treeAttributes = new Attributable.AttributeHelper();
        }
        this.treeAttributes.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        if (this.treeAttributes == null) {
            return null;
        }
        return this.treeAttributes.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.treeAttributes == null) {
            return null;
        }
        return this.treeAttributes.getAttributeNames();
    }

    public final String getNewick() {
        return TreeUtils.newick(this);
    }

    @Override
    public String toString() {
        return this.getNewick();
    }

    @Override
    public Tree getCopy() {
        throw new UnsupportedOperationException("please don't call this function");
    }

    @Override
    public void addKeyword(String string) {
        this.keywords.add(string);
    }

    @Override
    public List<String> getKeywords() {
        return this.keywords;
    }

    @Override
    public boolean hasNodeHeights() {
        return true;
    }

    @Override
    public boolean hasBranchLengths() {
        return true;
    }

    @Override
    public double getBranchLength(NodeRef nodeRef) {
        NodeRef nodeRef2 = this.getParent(nodeRef);
        if (nodeRef2 == null) {
            return 0.0;
        }
        return this.getNodeHeight(nodeRef2) - this.getNodeHeight(nodeRef);
    }

    public void pushTreeChangedEvent() {
        this.pushTreeChangedEvent(TreeChangedEvent.create());
    }

    public void pushTreeChangedEvent(NodeRef nodeRef) {
        this.pushTreeChangedEvent(TreeChangedEvent.create(nodeRef, false));
    }

    public void pushTreeChangedEvent(TreeChangedEvent treeChangedEvent) {
        if (!this.isVariable()) {
            throw new IllegalStateException("Attempting state change in fixed tree");
        }
        if (this.inEdit) {
            this.treeChangedEvents.add(treeChangedEvent);
        } else {
            this.listenerHelper.fireModelChanged(this, treeChangedEvent);
        }
    }

    public boolean inTreeEdit() {
        return this.inEdit;
    }

    public boolean isTipDateSampled() {
        return false;
    }

    @Override
    public boolean isVariable() {
        return this.isVariable;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Sampling tip dates model";
    }

    @Override
    public List<Citation> getCitations() {
        if (this.isTipDateSampled()) {
            return Arrays.asList(new Citation(new Author[]{new Author("B", "Shapiro"), new Author("SYW", "Ho"), new Author("AJ", "Drummond"), new Author("MA", "Suchard"), new Author("OG", "Pybus"), new Author("A", "Rambaut")}, "A Bayesian phylogenetic method to estimate unknown sequence ages", 2010, "Mol Biol Evol", 28, 879, 887, "10.1093/molbev/msq262"), new Citation(new Author[]{new Author("AJ", "Drummond")}, "PhD Thesis", 2002, "University of Auckland", ""));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean beginTreeEdit() {
        if (this.inEdit) {
            throw new RuntimeException("Already in edit transaction mode!");
        }
        this.inEdit = true;
        return false;
    }

    @Override
    public void endTreeEdit() {
        if (!this.inEdit) {
            throw new RuntimeException("Not in edit transaction mode!");
        }
        this.inEdit = false;
        assert (this.isTreeValid());
        for (TreeChangedEvent treeChangedEvent : this.treeChangedEvents) {
            this.listenerHelper.fireModelChanged(this, treeChangedEvent);
        }
        this.treeChangedEvents.clear();
    }

    public abstract void adoptTreeStructure(int[] var1, double[] var2, int[] var3, String[] var4);

    public void adoptTraitData(int[] nArray, ArrayList<TreeParameterModel> arrayList, double[][] dArray, String[] stringArray) {
        int[] nArray2 = this.createNodeMap(stringArray);
        int n = 0;
        for (TreeParameterModel treeParameterModel : arrayList) {
            int n2;
            for (n2 = 0; n2 < this.getRoot().getNumber(); ++n2) {
                if (n2 < this.getExternalNodeCount()) {
                    treeParameterModel.setNodeValue(this, this.getExternalNode(nArray2[n2]), dArray[n][n2]);
                    System.out.println("Setting external node " + this.getExternalNode(nArray2[n2]) + " to " + dArray[n][n2]);
                    continue;
                }
                treeParameterModel.setNodeValue(this, this.getNode(n2), dArray[n][n2]);
                System.out.println("Setting internal node " + this.getNode(n2) + " to " + dArray[n][n2]);
            }
            if (this.getRoot().getNumber() < nArray.length - 1) {
                treeParameterModel.setNodeValue(this, this.getNode(this.getRoot().getNumber() + 1), dArray[n][this.getNodeCount() - 1]);
            }
            for (n2 = this.getRoot().getNumber() + 2; n2 < nArray.length; ++n2) {
                treeParameterModel.setNodeValue(this, this.getNode(n2), dArray[n][n2 - 1]);
            }
            ++n;
        }
    }

    protected int[] createNodeMap(String[] stringArray) {
        System.out.println("Creating a node mapping:");
        int n = this.getExternalNodeCount();
        int[] nArray = new int[n];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!stringArray[i].equals(this.getNodeTaxon(this.getExternalNode(j)).getId())) continue;
                nArray[i] = j;
            }
        }
        return nArray;
    }

    public abstract boolean isTreeValid();

    public abstract void setNodeHeightQuietly(NodeRef var1, double var2);
}

