/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.speciation;

import dr.evolution.tree.NodeRef;
import dr.evolution.util.Taxon;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesNetworkModel;
import dr.evomodel.alloppnet.util.AlloppMisc;
import dr.evomodel.tree.TreeModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import jebl.util.FixedBitSet;

public class AlloppSpeciesBindings
extends AbstractModel
implements Loggable {
    private final GeneTreeInfo[] geneTreeInfos;
    private final ApSpInfo[] apspecies;
    private final Taxon[] taxa;
    private final Map<Taxon, Integer> taxon2index = new HashMap<Taxon, Integer>();
    private final int[][] spsq;
    private final int numberOfSpSeqs;
    private final double initialmingenenodeheight;

    public AlloppSpeciesBindings(ApSpInfo[] apSpInfoArray, TreeModel[] treeModelArray, double d, double[] dArray, boolean bl) {
        super("alloppspecies");
        int n;
        int n2;
        int n3;
        this.apspecies = apSpInfoArray;
        this.initialmingenenodeheight = d;
        int n4 = 0;
        for (int i = 0; i < apSpInfoArray.length; ++i) {
            n4 += apSpInfoArray[i].individuals.length;
        }
        Individual[] individualArray = new Individual[n4];
        n4 = 0;
        for (n3 = 0; n3 < apSpInfoArray.length; ++n3) {
            n2 = 0;
            while (n2 < apSpInfoArray[n3].individuals.length) {
                individualArray[n4] = apSpInfoArray[n3].individuals[n2];
                ++n2;
                ++n4;
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < individualArray.length; ++n2) {
            n3 += individualArray[n2].taxa.length;
        }
        this.taxa = new Taxon[n3];
        n3 = 0;
        for (n2 = 0; n2 < individualArray.length; ++n2) {
            n = 0;
            while (n < individualArray[n2].taxa.length) {
                this.taxa[n3] = individualArray[n2].taxa[n];
                ++n;
                ++n3;
            }
        }
        for (n2 = 0; n2 < this.taxa.length; ++n2) {
            this.taxon2index.put(this.taxa[n2], n2);
        }
        this.spsq = new int[apSpInfoArray.length][];
        n2 = 0;
        for (n = 0; n < apSpInfoArray.length; ++n) {
            this.spsq[n] = new int[apSpInfoArray[n].ploidylevel / 2];
            for (int i = 0; i < this.spsq[n].length; ++i) {
                this.spsq[n][i] = n2++;
            }
        }
        this.numberOfSpSeqs = n2;
        this.geneTreeInfos = new GeneTreeInfo[treeModelArray.length];
        for (n = 0; n < treeModelArray.length; ++n) {
            this.geneTreeInfos[n] = new GeneTreeInfo(treeModelArray[n], dArray[n], bl);
        }
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            NodeRef[] nodeRefArray;
            for (NodeRef nodeRef : nodeRefArray = geneTreeInfo.tree.getNodes()) {
                if (geneTreeInfo.tree.isExternal(nodeRef)) continue;
                double d2 = geneTreeInfo.tree.getNodeHeight(nodeRef);
                geneTreeInfo.tree.setNodeHeight(nodeRef, d + d2);
            }
        }
    }

    public AlloppSpeciesBindings(ApSpInfo[] apSpInfoArray, TreeModel[] treeModelArray, double d, double[] dArray) {
        this(apSpInfoArray, treeModelArray, d, dArray, true);
    }

    public AlloppSpeciesBindings(ApSpInfo[] apSpInfoArray) {
        this(apSpInfoArray, new TreeModel[0], 0.0, new double[0]);
    }

    public double initialMinGeneNodeHeight() {
        return this.initialmingenenodeheight;
    }

    public FixedBitSet speciesseqEmptyUnion() {
        FixedBitSet fixedBitSet = new FixedBitSet(this.numberOfSpSeqs());
        return fixedBitSet;
    }

    public FixedBitSet taxonseqToTipUnion(Taxon taxon, int n) {
        FixedBitSet fixedBitSet = this.speciesseqEmptyUnion();
        int n2 = this.apspeciesId2index(taxon.getId());
        int n3 = this.spandseq2spseqindex(n2, n);
        fixedBitSet.set(n3);
        return fixedBitSet;
    }

    public FixedBitSet spsqunion2spunion(FixedBitSet fixedBitSet) {
        FixedBitSet fixedBitSet2 = new FixedBitSet(this.apspecies.length);
        for (int i = 0; i < this.apspecies.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < this.spsq[i].length; ++j) {
                if (!fixedBitSet.contains(this.spsq[i][j])) continue;
                bl = true;
            }
            if (!bl) continue;
            fixedBitSet2.set(i);
        }
        return fixedBitSet2;
    }

    public int numberOfGeneTrees() {
        return this.geneTreeInfos.length;
    }

    public double maxGeneTreeHeight() {
        if (this.geneTreeInfos.length == 0) {
            return 999.0;
        }
        double d = 0.0;
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            double d2 = geneTreeInfo.tree.getNodeHeight(geneTreeInfo.tree.getRoot());
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public boolean geneTreeFitsInNetwork(int n, AlloppSpeciesNetworkModel alloppSpeciesNetworkModel) {
        return this.geneTreeInfos[n].fitsInNetwork(alloppSpeciesNetworkModel);
    }

    public double geneTreeLogLikelihood(int n, AlloppSpeciesNetworkModel alloppSpeciesNetworkModel) {
        return this.geneTreeInfos[n].treeLogLikelihood(alloppSpeciesNetworkModel);
    }

    public int numberOfSpecies() {
        return this.apspecies.length;
    }

    public String apspeciesName(int n) {
        return this.apspecies[n].name;
    }

    public Taxon[] SpeciesWithinPloidyLevel(int n) {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        for (int i = 0; i < this.apspecies.length; ++i) {
            if (this.apspecies[i].ploidylevel != n) continue;
            arrayList.add(new Taxon(this.apspecies[i].name));
        }
        Taxon[] taxonArray = new Taxon[arrayList.size()];
        arrayList.toArray(taxonArray);
        return taxonArray;
    }

    public int spandseq2spseqindex(int n, int n2) {
        return this.spsq[n][n2];
    }

    public int spseqindex2sp(int n) {
        return this.spseqindex2spandseq(n)[0];
    }

    public int spseqindex2seq(int n) {
        return this.spseqindex2spandseq(n)[1];
    }

    public int apspeciesId2index(String string) {
        int n = -1;
        for (int i = 0; i < this.apspecies.length; ++i) {
            if (this.apspecies[i].name.compareTo(string) != 0) continue;
            assert (n == -1);
            n = i;
        }
        if (n == -1) {
            System.out.println("BUG in apspeciesId2index");
        }
        assert (n != -1);
        return n;
    }

    public SpeciesIndivPair apspeciesId2speciesindiv(String string) {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.apspecies.length; ++i) {
            for (int j = 0; j < this.apspecies[i].individuals.length; ++j) {
                for (int k = 0; k < this.apspecies[i].individuals[j].taxa.length; ++k) {
                    Taxon taxon = this.apspecies[i].individuals[j].taxa[k];
                    if (taxon.getId().compareTo(string) != 0) continue;
                    n = i;
                    n2 = j;
                }
            }
        }
        assert (n != -1);
        SpeciesIndivPair speciesIndivPair = new SpeciesIndivPair(n, n2);
        return speciesIndivPair;
    }

    public int numberOfSpSeqs() {
        return this.numberOfSpSeqs;
    }

    int nLineages(int n) {
        int n2 = this.geneTreeInfos[0].lineagesCount[n];
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            assert (geneTreeInfo.lineagesCount[n] == n2);
        }
        return n2;
    }

    public double spseqUpperBound(FixedBitSet fixedBitSet, FixedBitSet fixedBitSet2) {
        double d = Double.MAX_VALUE;
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            d = Math.min(d, geneTreeInfo.spseqUpperBound(fixedBitSet, fixedBitSet2));
        }
        return d;
    }

    public void permuteOneSpeciesOneIndivForOneGene() {
        int n = MathUtils.nextInt(this.geneTreeInfos.length);
        this.geneTreeInfos[n].permuteOneSpeciesOneIndiv();
    }

    public void permuteSetOfIndivsForOneGene() {
        int n = MathUtils.nextInt(this.geneTreeInfos.length);
        this.geneTreeInfos[n].permuteSetOfIndivs();
    }

    public void flipAssignmentsForAllGenesOneSpecies(int n) {
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            geneTreeInfo.flipAssignmentsForSpecies(n);
        }
    }

    public String seqassignsAsText(int n) {
        return this.geneTreeInfos[n].seqassignsAsText();
    }

    public String genetreeAsText(int n) {
        String string = "Gene tree " + n + "                     height             union" + System.getProperty("line.separator");
        string = string + this.geneTreeInfos[n].genetreeAsText();
        return string;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            if (geneTreeInfo.tree != model) continue;
            geneTreeInfo.wasChanged();
            break;
        }
        this.fireModelChanged(object, n);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        assert (false);
    }

    @Override
    protected void storeState() {
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            geneTreeInfo.storeSequenceAssignments();
        }
    }

    @Override
    protected void restoreState() {
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            geneTreeInfo.restoreSequenceAssignments();
        }
    }

    @Override
    protected void acceptState() {
    }

    public void addModelListeners(ModelListener modelListener) {
        for (GeneTreeInfo geneTreeInfo : this.geneTreeInfos) {
            geneTreeInfo.tree.addModelListener(modelListener);
        }
        this.addModelListener(modelListener);
    }

    @Override
    public LogColumn[] getColumns() {
        int n = this.geneTreeInfos.length * this.taxa.length;
        LogColumn[] logColumnArray = new LogColumn[n];
        int n2 = 0;
        for (int i = 0; i < this.geneTreeInfos.length; ++i) {
            int n3 = 0;
            while (n3 < this.taxa.length) {
                GeneTreeInfo.SequenceAssignment sequenceAssignment = this.geneTreeInfos[i].getSeqassigns(n3);
                String string = "Gene" + i + "taxon" + n3;
                logColumnArray[n2] = new LogColumn.Default(string, sequenceAssignment);
                ++n3;
                ++n2;
            }
        }
        return logColumnArray;
    }

    private int[] spseqindex2spandseq(int n) {
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < this.spsq.length; ++i) {
            for (int j = 0; j < this.spsq[i].length; ++j) {
                if (this.spsq[i][j] != n) continue;
                assert (n2 == -1);
                assert (n3 == -1);
                n2 = i;
                n3 = j;
            }
        }
        assert (n2 != -1);
        assert (n3 != -1);
        int[] nArray = new int[]{n2, n3};
        return nArray;
    }

    public static class ApSpInfo
    extends Taxon {
        public final String name;
        public final int ploidylevel;
        final Individual[] individuals;

        public ApSpInfo(String string, int n, Individual[] individualArray) {
            super(string);
            this.name = string;
            this.individuals = individualArray;
            this.ploidylevel = n;
            if (individualArray != null) {
                int n2 = n / 2;
                for (int i = 0; i < individualArray.length; ++i) {
                    assert (individualArray[i].taxa.length == n2);
                }
            }
        }

        public Taxon taxonFromIndSeq(int n, int n2) {
            return this.individuals[n].taxa[n2];
        }
    }

    public static class Individual
    extends Taxon {
        public final String id;
        public final Taxon[] taxa;

        public Individual(String string, Taxon[] taxonArray) {
            super(string);
            this.id = string;
            this.taxa = taxonArray;
        }
    }

    private class GeneTreeInfo {
        private final TreeModel tree;
        private SequenceAssignment[] seqassigns;
        private SequenceAssignment[] oldseqassigns;
        private final int[] lineagesCount;
        private final double popFactor;

        GeneTreeInfo(TreeModel treeModel, double d, boolean bl) {
            int n;
            int n2;
            this.tree = treeModel;
            this.popFactor = d;
            this.seqassigns = new SequenceAssignment[AlloppSpeciesBindings.this.taxa.length];
            this.oldseqassigns = new SequenceAssignment[AlloppSpeciesBindings.this.taxa.length];
            for (n2 = 0; n2 < AlloppSpeciesBindings.this.apspecies.length; ++n2) {
                for (int i = 0; i < ((AlloppSpeciesBindings)AlloppSpeciesBindings.this).apspecies[n2].individuals.length; ++i) {
                    int n3;
                    int n4 = ((AlloppSpeciesBindings)AlloppSpeciesBindings.this).apspecies[n2].individuals[i].taxa.length;
                    int[] nArray = new int[n4];
                    for (n3 = 0; n3 < n4; ++n3) {
                        nArray[n3] = n3;
                    }
                    if (bl) {
                        MathUtils.permute(nArray);
                    }
                    for (n3 = 0; n3 < n4; ++n3) {
                        n = (Integer)AlloppSpeciesBindings.this.taxon2index.get(((AlloppSpeciesBindings)AlloppSpeciesBindings.this).apspecies[n2].individuals[i].taxa[n3]);
                        this.seqassigns[n] = new SequenceAssignment(n2, nArray[n3]);
                        this.oldseqassigns[n] = new SequenceAssignment(n2, nArray[n3]);
                    }
                }
            }
            this.lineagesCount = new int[AlloppSpeciesBindings.this.apspecies.length];
            Arrays.fill(this.lineagesCount, 0);
            for (n2 = 0; n2 < this.lineagesCount.length; ++n2) {
                for (Individual individual : ((AlloppSpeciesBindings)AlloppSpeciesBindings.this).apspecies[n2].individuals) {
                    n = 0;
                    for (Taxon taxon : individual.taxa) {
                        if (treeModel.getTaxonIndex(taxon) < 0) continue;
                        n = 1;
                    }
                    for (Taxon taxon : individual.taxa) {
                        assert ((treeModel.getTaxonIndex(taxon) >= 0 ? 1 : 0) == n);
                    }
                    assert (n != 0);
                    if (n == 0) continue;
                    int n5 = n2;
                    this.lineagesCount[n5] = this.lineagesCount[n5] + 1;
                }
            }
        }

        public String seqassignsAsText() {
            String string = "Sequence assignments" + System.getProperty("line.separator");
            for (int i = 0; i < this.seqassigns.length; ++i) {
                string = string + AlloppSpeciesBindings.this.taxa[i];
                string = string + ":";
                string = string + this.seqassigns[i].seqIndex;
                string = i + 1 < this.seqassigns.length && this.seqassigns[i].spIndex != this.seqassigns[i + 1].spIndex ? string + System.getProperty("line.separator") : string + "  ";
            }
            return string;
        }

        public String genetreeAsText() {
            GeneUnionTree geneUnionTree = new GeneUnionTree();
            return geneUnionTree.asText();
        }

        public boolean fitsInNetwork(AlloppSpeciesNetworkModel alloppSpeciesNetworkModel) {
            GeneUnionTree geneUnionTree = new GeneUnionTree();
            boolean bl = geneUnionTree.subtreeFitsInNetwork(geneUnionTree.getRoot(), alloppSpeciesNetworkModel);
            return bl;
        }

        public double treeLogLikelihood(AlloppSpeciesNetworkModel alloppSpeciesNetworkModel) {
            GeneUnionTree geneUnionTree = new GeneUnionTree();
            alloppSpeciesNetworkModel.clearCoalescences();
            geneUnionTree.subtreeRecordCoalescences(geneUnionTree.getRoot(), alloppSpeciesNetworkModel);
            alloppSpeciesNetworkModel.sortCoalescences();
            alloppSpeciesNetworkModel.recordLineageCounts();
            double d = alloppSpeciesNetworkModel.geneTreeInNetworkLogLikelihood();
            return d;
        }

        public void storeSequenceAssignments() {
            for (int i = 0; i < this.seqassigns.length; ++i) {
                this.oldseqassigns[i].seqIndex = this.seqassigns[i].seqIndex;
            }
        }

        public void restoreSequenceAssignments() {
            for (int i = 0; i < this.seqassigns.length; ++i) {
                this.seqassigns[i].seqIndex = this.oldseqassigns[i].seqIndex;
            }
        }

        public double spseqUpperBound(FixedBitSet fixedBitSet, FixedBitSet fixedBitSet2) {
            GeneUnionTree geneUnionTree = new GeneUnionTree();
            return this.subtreeSpseqUpperBound(geneUnionTree.getRoot(), fixedBitSet, fixedBitSet2, Double.MAX_VALUE);
        }

        public void permuteOneSpeciesOneIndiv() {
            int n = MathUtils.nextInt(AlloppSpeciesBindings.this.apspecies.length);
            int n2 = MathUtils.nextInt(((AlloppSpeciesBindings)AlloppSpeciesBindings.this).apspecies[n].individuals.length);
            this.flipOneAssignment(n, n2);
        }

        public void permuteSetOfIndivs() {
            int n = this.tree.getInternalNodeCount();
            int n2 = MathUtils.nextInt(n);
            NodeRef nodeRef = this.tree.getInternalNode(n2);
            HashSet<SpeciesIndivPair> hashSet = new HashSet<SpeciesIndivPair>();
            this.collectIndivsOfNode(nodeRef, hashSet);
            for (SpeciesIndivPair speciesIndivPair : hashSet) {
                this.flipOneAssignment(speciesIndivPair.spIndex, speciesIndivPair.ivIndex);
            }
        }

        public SequenceAssignment getSeqassigns(int n) {
            return this.seqassigns[n];
        }

        public void wasChanged() {
        }

        private void collectIndivsOfNode(NodeRef nodeRef, Set<SpeciesIndivPair> set) {
            if (this.tree.isExternal(nodeRef)) {
                SpeciesIndivPair speciesIndivPair = AlloppSpeciesBindings.this.apspeciesId2speciesindiv(this.tree.getNodeTaxon(nodeRef).getId());
                set.add(speciesIndivPair);
            } else {
                this.collectIndivsOfNode(this.tree.getChild(nodeRef, 0), set);
                this.collectIndivsOfNode(this.tree.getChild(nodeRef, 1), set);
            }
        }

        private double subtreeSpseqUpperBound(GeneUnionNode geneUnionNode, FixedBitSet fixedBitSet, FixedBitSet fixedBitSet2, double d) {
            if (geneUnionNode.child.length == 0) {
                return d;
            }
            for (GeneUnionNode object2 : geneUnionNode.child) {
                d = Math.min(d, this.subtreeSpseqUpperBound(object2, fixedBitSet, fixedBitSet2, d));
            }
            FixedBitSet fixedBitSet3 = geneUnionNode.child[0].union;
            int n = fixedBitSet3.intersectCardinality(fixedBitSet);
            int n2 = fixedBitSet3.intersectCardinality(fixedBitSet2);
            FixedBitSet fixedBitSet4 = geneUnionNode.child[1].union;
            int n3 = fixedBitSet4.intersectCardinality(fixedBitSet);
            int n4 = fixedBitSet4.intersectCardinality(fixedBitSet2);
            if (n > 0 && n4 > 0 || n3 > 0 && n2 > 0) {
                d = Math.min(d, geneUnionNode.height);
            }
            return d;
        }

        private void flipOneAssignment(int n, int n2) {
            if (((AlloppSpeciesBindings)AlloppSpeciesBindings.this).apspecies[n].individuals[n2].taxa.length == 2) {
                int n3 = (Integer)AlloppSpeciesBindings.this.taxon2index.get(((AlloppSpeciesBindings)AlloppSpeciesBindings.this).apspecies[n].individuals[n2].taxa[0]);
                this.seqassigns[n3].seqIndex = 1 - this.seqassigns[n3].seqIndex;
                n3 = (Integer)AlloppSpeciesBindings.this.taxon2index.get(((AlloppSpeciesBindings)AlloppSpeciesBindings.this).apspecies[n].individuals[n2].taxa[1]);
                this.seqassigns[n3].seqIndex = 1 - this.seqassigns[n3].seqIndex;
            }
        }

        private void flipAssignmentsForSpecies(int n) {
            for (int i = 0; i < ((AlloppSpeciesBindings)AlloppSpeciesBindings.this).apspecies[n].individuals.length; ++i) {
                this.flipOneAssignment(n, i);
            }
        }

        private class SequenceAssignment {
            public int spIndex;
            public int seqIndex;

            public SequenceAssignment(int n, int n2) {
                this.spIndex = n;
                this.seqIndex = n2;
            }

            public String toString() {
                String string = "" + this.seqIndex;
                return string;
            }
        }

        private class GeneUnionTree {
            private GeneUnionNode[] nodes;
            private int nextn;

            public GeneUnionTree() {
                this.nodes = new GeneUnionNode[GeneTreeInfo.this.tree.getNodeCount()];
                for (int i = 0; i < this.nodes.length; ++i) {
                    this.nodes[i] = new GeneUnionNode();
                }
                this.genetree2geneuniontree(GeneTreeInfo.this.tree.getRoot());
            }

            public GeneUnionNode getRoot() {
                return this.nodes[this.nodes.length - 1];
            }

            private boolean subtreeFitsInNetwork(GeneUnionNode geneUnionNode, AlloppSpeciesNetworkModel alloppSpeciesNetworkModel) {
                for (int i = 0; i < geneUnionNode.child.length; ++i) {
                    if (this.subtreeFitsInNetwork(geneUnionNode.child[i], alloppSpeciesNetworkModel)) continue;
                    return false;
                }
                return alloppSpeciesNetworkModel.coalescenceIsCompatible(geneUnionNode.height, geneUnionNode.union);
            }

            private void subtreeRecordCoalescences(GeneUnionNode geneUnionNode, AlloppSpeciesNetworkModel alloppSpeciesNetworkModel) {
                for (int i = 0; i < geneUnionNode.child.length; ++i) {
                    this.subtreeRecordCoalescences(geneUnionNode.child[i], alloppSpeciesNetworkModel);
                }
                if (geneUnionNode.child.length > 0) {
                    alloppSpeciesNetworkModel.recordCoalescence(geneUnionNode.height, geneUnionNode.union);
                }
            }

            private void genetree2geneuniontree(NodeRef nodeRef) {
                if (GeneTreeInfo.this.tree.isExternal(nodeRef)) {
                    GeneUnionNode.access$102(this.nodes[this.nextn], new GeneUnionNode[0]);
                    int n = (Integer)AlloppSpeciesBindings.this.taxon2index.get(GeneTreeInfo.this.tree.getNodeTaxon(nodeRef));
                    int n2 = AlloppSpeciesBindings.this.spsq[((GeneTreeInfo)GeneTreeInfo.this).seqassigns[n].spIndex][((GeneTreeInfo)GeneTreeInfo.this).seqassigns[n].seqIndex];
                    this.nodes[this.nextn].union.set(n2);
                    this.nodes[this.nextn].name = GeneTreeInfo.this.tree.getNodeTaxon(nodeRef).getId();
                } else {
                    this.genetree2geneuniontree(GeneTreeInfo.this.tree.getChild(nodeRef, 0));
                    int n = this.nextn - 1;
                    this.genetree2geneuniontree(GeneTreeInfo.this.tree.getChild(nodeRef, 1));
                    int n3 = this.nextn - 1;
                    GeneUnionNode.access$102(this.nodes[this.nextn], new GeneUnionNode[2]);
                    ((GeneUnionNode)this.nodes[this.nextn]).child[0] = this.nodes[n];
                    ((GeneUnionNode)this.nodes[this.nextn]).child[1] = this.nodes[n3];
                    this.nodes[this.nextn].union.union(this.nodes[n].union);
                    this.nodes[this.nextn].union.union(this.nodes[n3].union);
                }
                this.nodes[this.nextn].height = GeneTreeInfo.this.tree.getNodeHeight(nodeRef);
                ++this.nextn;
            }

            public String asText() {
                String string = "";
                Stack<Integer> stack = new Stack<Integer>();
                return this.subtreeAsText(this.getRoot(), string, stack, 0, "");
            }

            private String subtreeAsText(GeneUnionNode geneUnionNode, String string, Stack<Integer> stack, int n, String string2) {
                int n2;
                Integer[] integerArray = stack.toArray(new Integer[stack.size()]);
                StringBuffer stringBuffer = new StringBuffer();
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("  ");
                }
                for (n2 = 0; n2 < integerArray.length; ++n2) {
                    stringBuffer.replace(2 * integerArray[n2], 2 * integerArray[n2] + 1, "|");
                }
                if (string2.length() > 0) {
                    stringBuffer.replace(stringBuffer.length() - string2.length(), stringBuffer.length(), string2);
                }
                string = string + stringBuffer;
                string = string + geneUnionNode.asText(stringBuffer.length());
                string = string + System.getProperty("line.separator");
                String string3 = "";
                if (geneUnionNode.child.length > 0) {
                    stack.push(n);
                    string3 = string3 + this.subtreeAsText(geneUnionNode.child[0], "", stack, n + 1, "-");
                    stack.pop();
                    string3 = string3 + this.subtreeAsText(geneUnionNode.child[1], "", stack, n + 1, "`-");
                }
                return string + string3;
            }
        }

        private class GeneUnionNode {
            private GeneUnionNode[] child = new GeneUnionNode[0];
            private double height = 0.0;
            private FixedBitSet union;
            private String name;

            public GeneUnionNode() {
                this.union = new FixedBitSet(AlloppSpeciesBindings.this.numberOfSpSeqs());
                this.name = "";
            }

            public String asText(int n) {
                StringBuilder stringBuilder = new StringBuilder();
                Formatter formatter = new Formatter(stringBuilder, Locale.US);
                if (this.child.length == 0) {
                    formatter.format("%s ", this.name);
                } else {
                    formatter.format("%s ", "+");
                }
                while (stringBuilder.length() < 30 - n) {
                    formatter.format("%s", " ");
                }
                formatter.format("%s ", AlloppMisc.nonnegIn8Chars(this.height));
                formatter.format("%20s ", AlloppMisc.FixedBitSetasText(this.union));
                return stringBuilder.toString();
            }

            static /* synthetic */ GeneUnionNode[] access$102(GeneUnionNode geneUnionNode, GeneUnionNode[] geneUnionNodeArray) {
                geneUnionNode.child = geneUnionNodeArray;
                return geneUnionNodeArray;
            }
        }
    }

    private class SpeciesIndivPair {
        public int spIndex;
        public int ivIndex;

        public SpeciesIndivPair(int n, int n2) {
            this.spIndex = n;
            this.ivIndex = n2;
        }
    }
}

