/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;

public interface UnrootedTree {
    public int getNodeCount();

    public NodeRef getNode(int var1);

    public int getNeighbourCount(NodeRef var1);

    public boolean isExternal(NodeRef var1);

    public double getBranchLength(NodeRef var1, int var2);

    public void setBranchLength(NodeRef var1, int var2, double var3);

    public NodeRef getNeighbour(NodeRef var1, int var2);

    public void NNI(NodeRef var1, int var2, int var3, int var4);

    public static class Default
    implements UnrootedTree {
        private double[][] edges;
        private NodeRef[] nodeRef;
        private int nodeCount;

        public Default(Tree tree) {
            Object object;
            int n;
            if (tree.getChildCount(tree.getRoot()) == 3) {
                this.nodeCount = tree.getNodeCount();
                this.nodeRef = new NodeRef[this.nodeCount];
                for (n = 0; n < this.nodeCount; ++n) {
                    this.nodeRef[n] = new UnrootedNode(n);
                    object = tree.getNode(n);
                    if (tree.isRoot((NodeRef)object)) continue;
                    NodeRef nodeRef = tree.getParent((NodeRef)object);
                    this.addEdge(this.nodeRef[n], this.nodeRef[nodeRef.getNumber()], tree.getNodeHeight(nodeRef) - tree.getNodeHeight((NodeRef)object));
                }
            }
            if (tree.getChildCount(tree.getRoot()) == 2) {
                int n2;
                this.nodeCount = tree.getNodeCount() - 1;
                n = 0;
                object = new int[tree.getNodeCount()];
                for (n2 = 0; n2 < tree.getNodeCount(); ++n2) {
                    object[n2] = n++;
                    if (tree.isRoot(tree.getNode(n2))) continue;
                }
                this.nodeRef = new NodeRef[this.nodeCount];
                for (n2 = 0; n2 < tree.getNodeCount(); ++n2) {
                    NodeRef nodeRef = tree.getNode(n2);
                    if (tree.isRoot(nodeRef)) continue;
                    this.nodeRef[object[n2]] = new UnrootedNode(object[n2]);
                    NodeRef nodeRef2 = tree.getParent(nodeRef);
                    if (!tree.isRoot(nodeRef2)) {
                        this.addEdge(this.nodeRef[object[n2]], this.nodeRef[object[nodeRef2.getNumber()]], tree.getNodeHeight(nodeRef2) - tree.getNodeHeight(nodeRef));
                        continue;
                    }
                    NodeRef nodeRef3 = tree.getChild(tree.getRoot(), 0);
                    NodeRef nodeRef4 = tree.getChild(tree.getRoot(), 1);
                    double d = tree.getNodeHeight(tree.getRoot()) - tree.getNodeHeight(nodeRef3) + (tree.getNodeHeight(tree.getRoot()) - tree.getNodeHeight(nodeRef4));
                    this.addEdge(this.nodeRef[object[nodeRef3.getNumber()]], this.nodeRef[object[nodeRef4.getNumber()]], d);
                }
            }
        }

        public Default(int n) {
            int n2;
            this.nodeCount = n * 2 - 1;
            this.edges = new double[this.nodeCount][this.nodeCount];
            for (n2 = 0; n2 < this.nodeCount; ++n2) {
                for (int i = 0; i < this.nodeCount; ++i) {
                    this.edges[n2][i] = -1.0;
                }
            }
            this.nodeRef = new NodeRef[this.nodeCount];
            for (n2 = 0; n2 < this.nodeCount; ++n2) {
                this.nodeRef[n2] = new UnrootedNode(n2);
            }
        }

        @Override
        public int getNodeCount() {
            return this.nodeCount;
        }

        @Override
        public NodeRef getNode(int n) {
            return this.nodeRef[n];
        }

        @Override
        public int getNeighbourCount(NodeRef nodeRef) {
            int n = nodeRef.getNumber();
            int n2 = 0;
            for (int i = 0; i < this.nodeCount; ++i) {
                if (!(this.edges[i][n] >= 0.0)) continue;
                ++n2;
            }
            return n2;
        }

        @Override
        public boolean isExternal(NodeRef nodeRef) {
            return this.getNeighbourCount(nodeRef) == 1;
        }

        @Override
        public double getBranchLength(NodeRef nodeRef, int n) {
            int n2 = nodeRef.getNumber();
            int n3 = 0;
            for (int i = 0; i < this.nodeCount; ++i) {
                if (!(this.edges[i][n2] >= 0.0)) continue;
                if (n3 == n) {
                    return this.edges[i][n2];
                }
                ++n3;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void setBranchLength(NodeRef nodeRef, int n, double d) {
            int n2 = nodeRef.getNumber();
            int n3 = 0;
            for (int i = 0; i < this.nodeCount; ++i) {
                if (!(this.edges[i][n2] >= 0.0)) continue;
                if (n3 == n) {
                    this.edges[i][n2] = d;
                    this.edges[n2][i] = d;
                }
                ++n3;
            }
        }

        @Override
        public NodeRef getNeighbour(NodeRef nodeRef, int n) {
            int n2 = nodeRef.getNumber();
            int n3 = 0;
            for (int i = 0; i < this.nodeCount; ++i) {
                if (!(this.edges[i][n2] >= 0.0)) continue;
                if (n3 == n) {
                    return this.nodeRef[i];
                }
                ++n3;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void NNI(NodeRef nodeRef, int n, int n2, int n3) {
            if (n == n2) {
                throw new IllegalArgumentException();
            }
            NodeRef nodeRef2 = this.getNeighbour(nodeRef, n);
            NodeRef nodeRef3 = this.getNeighbour(nodeRef, n2);
            NodeRef nodeRef4 = this.getNeighbour(nodeRef2, n3);
            this.addEdge(nodeRef, nodeRef4, this.getBranchLength(nodeRef, n2));
            this.addEdge(nodeRef2, nodeRef3, this.getBranchLength(nodeRef2, n3));
            this.removeEdge(nodeRef, nodeRef3);
            this.removeEdge(nodeRef2, nodeRef4);
        }

        private void addEdge(NodeRef nodeRef, NodeRef nodeRef2, double d) {
            this.edges[nodeRef.getNumber()][nodeRef2.getNumber()] = d;
            this.edges[nodeRef2.getNumber()][nodeRef.getNumber()] = d;
        }

        private void removeEdge(NodeRef nodeRef, NodeRef nodeRef2) {
            this.edges[nodeRef.getNumber()][nodeRef2.getNumber()] = -1.0;
            this.edges[nodeRef2.getNumber()][nodeRef.getNumber()] = -1.0;
        }

        class UnrootedNode
        implements NodeRef {
            int number;

            public UnrootedNode(int n) {
                this.number = n;
            }

            @Override
            public int getNumber() {
                return this.number;
            }

            @Override
            public void setNumber(int n) {
                this.number = n;
            }
        }
    }
}

