## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(AlgeriAPIs)
library(ggplot2)
library(dplyr)

## ----algeria-gdp,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----


algeria_gdp <- head(get_algeria_gdp())

print(algeria_gdp)


## ----algeria-life-expectancy,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----

algeria_life_expectancy <- head(get_algeria_life_expectancy())

print(algeria_life_expectancy)


## ----algeria-population,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----

algeria_population <- head(get_algeria_population())

print(algeria_population)


## ----algeria-plot, message=FALSE, warning=FALSE, fig.width=7, fig.height=5----

# Simple line plot using only ggplot2 and dplyr
ggplot(internet_users_tbl_df, aes(x = Year)) +
  geom_line(aes(y = Algeria, color = "Algeria"), size = 1.2) +
  geom_line(aes(y = Maghreb_union, color = "Maghreb Union"), size = 1.2) +
  geom_line(aes(y = Arab_world, color = "Arab World"), size = 1.2) +
  geom_line(aes(y = European_Union, color = "European Union"), size = 1.2) +
  geom_line(aes(y = The_World, color = "The World"), size = 1.2) +
  labs(
    title = "Internet Users (% of Population) Over Time",
    subtitle = "Comparison between Algeria and other regions",
    x = "Year",
    y = "Internet Users (%)",
    color = "Region"
  ) +
  theme_minimal() +
  theme(
    plot.title = element_text(face = "bold", size = 16),
    plot.subtitle = element_text(size = 12),
    axis.title = element_text(size = 12),
    legend.position = "bottom"
  )



